/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.util.ArrayList;
import java.util.Iterator;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.exceptions.TableMismatchException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;

public class TableExprAsSubjoins
extends LogicSetExpression {
    protected final ArrayList supertables = new ArrayList();

    public TableExprAsSubjoins(QueryExpression qs, DatastoreContainerObject mainTable, DatastoreIdentifier mainRangeVar) {
        super(qs, mainTable, mainRangeVar);
    }

    public String referenceColumn(DatastoreField col) {
        this.assertNotFrozen();
        DatastoreContainerObject table = col.getDatastoreContainerObject();
        if (!table.equals(this.mainTable)) {
            if (!(this.mainTable instanceof DatastoreClass) || !(table instanceof DatastoreClass)) {
                throw new TableMismatchException(col, this.mainTable);
            }
            if (!this.supertables.contains(table)) {
                this.supertables.add(table);
            }
        }
        if (((Object)this.mainRangeVar).toString().length() > 0) {
            return col.applySelectFunction(this.mainRangeVar + "." + col.getIdentifier());
        }
        return col.applySelectFunction(((Object)col.getIdentifier()).toString());
    }

    public String toString() {
        if (this.sqlText == null) {
            StringBuffer sb = new StringBuffer();
            DatastoreIdentifier mainTableName = this.mainTable.getIdentifier();
            Iterator i = this.supertables.iterator();
            if (i.hasNext()) {
                sb.append('(').append(this.mainTable.toString());
                while (i.hasNext()) {
                    DatastoreClass supertable = (DatastoreClass)i.next();
                    sb.append(" INNER JOIN ").append(((Object)supertable).toString());
                    sb.append(" ON ");
                    for (int j = 0; j < ((DatastoreClass)this.mainTable).getIDMapping().getNumberOfDatastoreFields(); ++j) {
                        DatastoreIdentifier mainTableIDColumnName = ((DatastoreClass)this.mainTable).getIDMapping().getDataStoreMapping(j).getDatastoreField().getIdentifier();
                        if (j > 0) {
                            sb.append(" AND ");
                        }
                        sb.append(this.mainTable.toString()).append('.').append(mainTableIDColumnName);
                        sb.append(" = ");
                        sb.append(((Object)supertable).toString()).append('.').append(supertable.getIDMapping().getDataStoreMapping(j).getDatastoreField().getIdentifier());
                    }
                }
                sb.append(") ").append(this.mainRangeVar);
            } else {
                sb.append(this.mainTable.toString());
                if (!this.mainRangeVar.equals(mainTableName)) {
                    sb.append(' ').append(this.mainRangeVar);
                }
            }
            this.sqlText = sb.toString();
        }
        return this.sqlText;
    }
}

