/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.expression;

import java.util.ArrayList;
import java.util.Iterator;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FetchStatement;
import org.jpox.store.MappedStoreManager;
import org.jpox.store.exceptions.TableMismatchException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;

public class TableExprAsSubquery
extends LogicSetExpression {
    protected final ArrayList columns = new ArrayList();
    protected boolean multipleTablesReferenced = false;

    public TableExprAsSubquery(QueryExpression qs, DatastoreContainerObject mainTable, DatastoreIdentifier mainRangeVar) {
        super(qs, mainTable, mainRangeVar);
    }

    public String referenceColumn(DatastoreField col) {
        this.assertNotFrozen();
        DatastoreContainerObject table = col.getDatastoreContainerObject();
        if (!table.equals(this.mainTable)) {
            if (!(this.mainTable instanceof DatastoreClass) || !(table instanceof DatastoreClass)) {
                throw new TableMismatchException(col, this.mainTable);
            }
            this.multipleTablesReferenced = true;
        }
        if (!this.columns.contains(col)) {
            this.columns.add(col);
        }
        if (((Object)this.mainRangeVar).toString().length() > 0) {
            return col.applySelectFunction(this.mainRangeVar + "." + col.getIdentifier());
        }
        return col.applySelectFunction(((Object)col.getIdentifier()).toString());
    }

    public String toString() {
        if (this.sqlText == null) {
            StringBuffer sb = new StringBuffer();
            DatastoreIdentifier mainTableName = this.mainTable.getIdentifier();
            if (!this.multipleTablesReferenced) {
                sb.append(this.mainTable.toString());
                if (!this.mainRangeVar.equals(mainTableName)) {
                    sb.append(' ').append(this.mainRangeVar);
                }
            } else {
                FetchStatement subQuery = ((MappedStoreManager)this.storeMgr).getFetchStatement(this.mainTable);
                Iterator i = this.columns.iterator();
                while (i.hasNext()) {
                    subQuery.select((DatastoreField)i.next());
                }
                sb.append('(').append(subQuery.toString(false)).append(") ").append(this.mainRangeVar);
            }
            this.sqlText = sb.toString();
        }
        return this.sqlText;
    }
}

