/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.fieldmanager;

import org.jpox.FetchPlan;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.state.FetchPlanState;
import org.jpox.store.fieldmanager.AbstractFieldManager;
import org.jpox.store.fieldmanager.SingleValueFieldManager;

public abstract class AbstractFetchFieldManager
extends AbstractFieldManager {
    protected final StateManager sm;
    protected final boolean[] secondClassMutableFields;
    protected FetchPlan.FetchPlanForClass fpClass;
    protected final FetchPlanState state;

    public AbstractFetchFieldManager(StateManager sm, boolean[] secondClassMutableFields, FetchPlan.FetchPlanForClass fpClass, FetchPlanState state) {
        this.sm = sm;
        this.secondClassMutableFields = secondClassMutableFields;
        this.fpClass = fpClass;
        this.state = state;
    }

    public Object fetchObjectField(int fieldNumber) throws EndOfFetchPlanGraphException {
        AbstractMemberMetaData fmd = this.fpClass.getAbstractClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        boolean requiresFCOFetching = MetaDataUtils.getInstance().storesFCO(fmd, this.sm.getObjectManager().getClassLoaderResolver());
        int maxFetchDepth = this.fpClass.getFetchPlan().getMaxFetchDepth();
        int currentFetchDepth = this.state.getCurrentFetchDepth();
        if (requiresFCOFetching) {
            if (currentFetchDepth > 0 && maxFetchDepth > 0 && currentFetchDepth == maxFetchDepth) {
                return this.endOfGraphOperation(fieldNumber);
            }
            int maxRecursiveDepth = this.fpClass.getMaxRecursionDepthForFieldInCurrentFetchPlan(fieldNumber);
            if (maxRecursiveDepth > 0 && this.state.getObjectDepthForType(fmd.getFullFieldName()) >= maxRecursiveDepth) {
                return this.endOfGraphOperation(fieldNumber);
            }
            this.state.addFieldName(fmd.getFullFieldName());
            Object result = this.internalFetchObjectField(fieldNumber);
            this.state.removeLatestFieldName();
            return result;
        }
        return this.internalFetchObjectField(fieldNumber);
    }

    protected abstract Object internalFetchObjectField(int var1);

    protected abstract Object endOfGraphOperation(int var1);

    public boolean fetchBooleanField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchBooleanField(fieldNumber);
    }

    public byte fetchByteField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchByteField(fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchCharField(fieldNumber);
    }

    public double fetchDoubleField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchDoubleField(fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchFloatField(fieldNumber);
    }

    public int fetchIntField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchIntField(fieldNumber);
    }

    public long fetchLongField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchLongField(fieldNumber);
    }

    public short fetchShortField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchShortField(fieldNumber);
    }

    public String fetchStringField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        return sfv.fetchStringField(fieldNumber);
    }

    public static class EndOfFetchPlanGraphException
    extends RuntimeException {
    }
}

