/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.fieldmanager;

import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOContainer;
import org.jpox.sco.SCOUtils;
import org.jpox.store.fieldmanager.AbstractFieldManager;
import org.jpox.store.fieldmanager.SingleValueFieldManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class AttachFieldManager
extends AbstractFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private final StateManager smAttached;
    private final boolean[] secondClassMutableFields;
    private final boolean[] dirtyFields;
    private final boolean persistent;
    private final boolean cascadeAttach;

    public AttachFieldManager(StateManager smAttached, boolean[] secondClassMutableFields, boolean[] dirtyFields, boolean persistent, boolean cascadeAttach) {
        this.smAttached = smAttached;
        this.secondClassMutableFields = secondClassMutableFields;
        this.dirtyFields = dirtyFields;
        this.persistent = persistent;
        this.cascadeAttach = cascadeAttach;
    }

    public void storeObjectField(int fieldNumber, Object value) {
        ApiAdapter api = this.smAttached.getObjectManager().getApiAdapter();
        if (value == null) {
            Object oldValue = null;
            AbstractClassMetaData cmd = this.smAttached.getClassMetaData();
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (fmd.isDependent()) {
                try {
                    this.smAttached.loadFieldFromDatastore(fieldNumber);
                }
                catch (Exception e) {
                    // empty catch block
                }
                oldValue = this.smAttached.provideField(fieldNumber);
            }
            if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.smAttached.replaceField(fieldNumber, null, true);
                this.smAttached.makeDirty(fieldNumber);
            }
            if (fmd.isDependent() && !fmd.isEmbedded() && oldValue != null && value == null && api.isPersistable(oldValue)) {
                this.smAttached.flush();
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("StateManager.DeleteDependentNulledField", oldValue, fmd.getFullFieldName()));
                this.smAttached.getObjectManager().deleteObjectInternal(oldValue);
            }
        } else if (this.secondClassMutableFields[fieldNumber]) {
            AbstractMemberMetaData fmd = this.smAttached.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            if (fmd.isSerialized()) {
                this.smAttached.replaceField(fieldNumber, value, true);
                this.smAttached.makeDirty(fieldNumber);
            } else {
                SCO sco;
                Object oldValue = this.smAttached.provideField(fieldNumber);
                if (oldValue == null || oldValue != null && !(oldValue instanceof SCO)) {
                    if (JPOXLogger.JDO.isDebugEnabled()) {
                        JPOXLogger.JDO.debug(LOCALISER.msg("StateManager.ReplacingSCO", fmd.getFullFieldName()));
                    }
                    if ((sco = SCOUtils.newSCOInstance(this.smAttached, fmd, fmd.getType(), null, null, false, false, false)) instanceof SCOContainer) {
                        ((SCOContainer)sco).load();
                    }
                    this.smAttached.replaceField(fieldNumber, sco, true);
                } else {
                    sco = (SCO)oldValue;
                }
                if (this.cascadeAttach) {
                    sco.attachCopy(value);
                }
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.smAttached.makeDirty(fieldNumber);
                }
            }
        } else if (api.isPersistable(value)) {
            if (this.cascadeAttach) {
                AbstractMemberMetaData fmd = this.smAttached.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                boolean sco = fmd.getEmbeddedMetaData() != null || fmd.isSerialized() || fmd.isEmbedded();
                Object pcObj = this.smAttached.getObjectManager().attachObjectCopy(value, sco);
                this.smAttached.replaceField(fieldNumber, pcObj, true);
                if (this.dirtyFields[fieldNumber] || !this.persistent) {
                    this.smAttached.makeDirty(fieldNumber);
                } else if (sco && value != null && this.smAttached.getObjectManager().getApiAdapter().isDirty(value)) {
                    this.smAttached.makeDirty(fieldNumber);
                }
            } else if (this.dirtyFields[fieldNumber] || !this.persistent) {
                this.smAttached.makeDirty(fieldNumber);
            }
        } else if (this.dirtyFields[fieldNumber] || !this.persistent) {
            this.smAttached.replaceField(fieldNumber, value, true);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeBooleanField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeByteField(int fieldNumber, byte value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeByteField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeCharField(int fieldNumber, char value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeCharField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeDoubleField(int fieldNumber, double value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeDoubleField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeFloatField(int fieldNumber, float value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeFloatField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeIntField(int fieldNumber, int value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeIntField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeLongField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeShortField(int fieldNumber, short value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeShortField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }

    public void storeStringField(int fieldNumber, String value) {
        if (this.dirtyFields[fieldNumber] || !this.persistent) {
            SingleValueFieldManager sfv = new SingleValueFieldManager();
            sfv.storeStringField(fieldNumber, value);
            this.smAttached.replaceFields(new int[]{fieldNumber}, sfv);
            this.smAttached.makeDirty(fieldNumber);
        }
    }
}

