/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.fieldmanager;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import org.jpox.FetchPlan;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOUtils;
import org.jpox.state.DetachState;
import org.jpox.state.FetchPlanState;
import org.jpox.store.fieldmanager.AbstractFetchFieldManager;
import org.jpox.store.fieldmanager.SingleValueFieldManager;

public class DetachFieldManager
extends AbstractFetchFieldManager {
    boolean copy = true;

    public DetachFieldManager(StateManager sm, boolean[] secondClassMutableFields, FetchPlan.FetchPlanForClass fpClass, FetchPlanState state, boolean copy) {
        super(sm, secondClassMutableFields, fpClass, state);
        this.copy = copy;
    }

    protected Object processPersistable(Object pc) {
        if (pc == null) {
            return null;
        }
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        if (!api.isPersistable(pc)) {
            return pc;
        }
        if (!api.isDetached(pc) && api.isPersistent(pc)) {
            if (this.copy) {
                return this.sm.getObjectManager().detachObjectCopy(pc, this.state);
            }
            this.sm.getObjectManager().detachObject(pc, this.state);
        }
        return pc;
    }

    protected Object internalFetchObjectField(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        if (value == null) {
            return null;
        }
        AbstractMemberMetaData fmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (api.isPersistable(value)) {
            return this.processPersistable(value);
        }
        if (value instanceof Collection || value instanceof Map) {
            if (!(value instanceof SCO)) {
                value = this.sm.getSCOWrapperForField(fieldNumber, value, false, false, true);
            }
            SCO sco = (SCO)value;
            if (this.copy) {
                return sco.detachCopy(this.state);
            }
            if (sco instanceof Collection) {
                SCOUtils.detachForCollection(this.sm, ((Collection)((Object)sco)).toArray(), this.state);
                sco.unsetOwner();
            } else if (sco instanceof Map) {
                SCOUtils.detachForMap(this.sm, ((Map)((Object)sco)).entrySet(), this.state);
                sco.unsetOwner();
            }
            return sco;
        }
        if (value instanceof Object[]) {
            if (!api.isPersistable(fmd.getType().getComponentType())) {
                return value;
            }
            Object[] arrValue = (Object[])value;
            Object[] arrDetached = (Object[])Array.newInstance(fmd.getType().getComponentType(), arrValue.length);
            for (int j = 0; j < arrValue.length; ++j) {
                arrDetached[j] = this.processPersistable(arrValue[j]);
            }
            return arrDetached;
        }
        if (this.secondClassMutableFields[fieldNumber]) {
            SCO sco = value instanceof SCO ? (SCO)value : (SCO)this.sm.getSCOWrapperForField(fieldNumber, value, false, false, true);
            if (this.copy) {
                return sco.detachCopy(this.state);
            }
            return sco;
        }
        return value;
    }

    protected Object endOfGraphOperation(int fieldNumber) {
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        this.sm.provideFields(new int[]{fieldNumber}, sfv);
        Object value = sfv.fetchObjectField(fieldNumber);
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        if (api.isPersistable(value)) {
            Object detached = null;
            if (this.copy) {
                detached = ((DetachState)this.state).getDetachedCopyObject(value);
            }
            if (detached != null) {
                return detached;
            }
            if (!this.copy && this.sm.getObjectManager().getApiAdapter().isDetached(value)) {
                return value;
            }
        }
        throw new AbstractFetchFieldManager.EndOfFetchPlanGraphException();
    }
}

