/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.fieldmanager;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.sco.SCO;
import org.jpox.store.fieldmanager.AbstractFieldManager;

public class PersistFieldManager
extends AbstractFieldManager {
    private final StateManager sm;
    private final boolean replaceSCOsWithWrappers;

    public PersistFieldManager(StateManager sm, boolean replaceSCOsWithWrappers) {
        this.sm = sm;
        this.replaceSCOsWithWrappers = replaceSCOsWithWrappers;
    }

    protected void processPersistable(Object pc) {
        ApiAdapter adapter = this.sm.getObjectManager().getApiAdapter();
        if (!adapter.isPersistent(pc) || adapter.isPersistent(pc) && adapter.isDeleted(pc)) {
            this.sm.getObjectManager().persistObjectInternal(pc, null);
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        block13: {
            boolean[] secondClassMutableFieldFlags;
            if (value == null) break block13;
            AbstractMemberMetaData fmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            boolean persistCascade = fmd.isCascadePersist();
            ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
            if (this.replaceSCOsWithWrappers && (secondClassMutableFieldFlags = this.sm.getClassMetaData().getSCOMutableMemberFlags())[fieldNumber] && !(value instanceof SCO)) {
                this.sm.getSCOWrapperForField(fieldNumber, value, false, true, true);
            }
            if (persistCascade) {
                if (api.isPersistable(value)) {
                    this.processPersistable(value);
                } else if (value instanceof Collection) {
                    Collection coll = (Collection)value;
                    Iterator iter = coll.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (!api.isPersistable(element)) continue;
                        this.processPersistable(element);
                    }
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    Set keys = map.keySet();
                    Iterator<Object> iter = keys.iterator();
                    while (iter.hasNext()) {
                        Object mapKey = iter.next();
                        if (!api.isPersistable(mapKey)) continue;
                        this.processPersistable(mapKey);
                    }
                    Collection values = map.values();
                    iter = values.iterator();
                    while (iter.hasNext()) {
                        Object mapValue = iter.next();
                        if (!api.isPersistable(mapValue)) continue;
                        this.processPersistable(mapValue);
                    }
                } else if (value instanceof Object[]) {
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        Object element = array[i];
                        if (!api.isPersistable(element)) continue;
                        this.processPersistable(element);
                    }
                }
            }
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }
}

