/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.fieldmanager;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.store.fieldmanager.AbstractFieldManager;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class ReachabilityFieldManager
extends AbstractFieldManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.Localisation");
    private final StateManager sm;
    private Set reachables = null;

    public ReachabilityFieldManager(StateManager sm, Set reachables) {
        this.sm = sm;
        this.reachables = reachables;
    }

    protected void processPersistable(Object obj, AbstractMemberMetaData fmd) {
        ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
        StateManager sm = this.sm.getObjectManager().findStateManager(obj);
        if (sm != null) {
            sm.runReachability(this.reachables);
        } else if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.FailedToFindStateManager", api.getIdForObject(obj), fmd.getFullFieldName()));
        }
    }

    public void storeObjectField(int fieldNumber, Object value) {
        AbstractMemberMetaData fmd = this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        if (value != null) {
            boolean persistCascade = fmd.isCascadePersist();
            ApiAdapter api = this.sm.getObjectManager().getApiAdapter();
            if (persistCascade) {
                if (api.isPersistable(value)) {
                    if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                        JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingPCField", fmd.getFullFieldName()));
                    }
                    this.processPersistable(value, fmd);
                } else if (value instanceof Collection) {
                    if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                        JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingSCOContainer", fmd.getFullFieldName()));
                    }
                    Collection coll = (Collection)value;
                    Iterator iter = coll.iterator();
                    while (iter.hasNext()) {
                        Object element = iter.next();
                        if (!api.isPersistable(element)) continue;
                        this.processPersistable(element, fmd);
                    }
                } else if (value instanceof Map) {
                    Map map = (Map)value;
                    if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                        JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingSCOContainer", fmd.getFullFieldName()));
                    }
                    Set keys = map.keySet();
                    Iterator<Object> iter = keys.iterator();
                    while (iter.hasNext()) {
                        Object mapKey = iter.next();
                        if (!api.isPersistable(mapKey)) continue;
                        this.processPersistable(mapKey, fmd);
                    }
                    Collection values = map.values();
                    iter = values.iterator();
                    while (iter.hasNext()) {
                        Object mapValue = iter.next();
                        if (!api.isPersistable(mapValue)) continue;
                        this.processPersistable(mapValue, fmd);
                    }
                } else if (value instanceof Object[]) {
                    if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                        JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingArrayField", fmd.getFullFieldName()));
                    }
                    Object[] array = (Object[])value;
                    for (int i = 0; i < array.length; ++i) {
                        Object element = array[i];
                        if (!api.isPersistable(element)) continue;
                        this.processPersistable(element, fmd);
                    }
                }
            }
        } else if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.Commit.ProcessingNullField", fmd.getFullFieldName()));
        }
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
    }

    public void storeByteField(int fieldNumber, byte value) {
    }

    public void storeCharField(int fieldNumber, char value) {
    }

    public void storeDoubleField(int fieldNumber, double value) {
    }

    public void storeFloatField(int fieldNumber, float value) {
    }

    public void storeIntField(int fieldNumber, int value) {
    }

    public void storeLongField(int fieldNumber, long value) {
    }

    public void storeShortField(int fieldNumber, short value) {
    }

    public void storeStringField(int fieldNumber, String value) {
    }
}

