/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ContainerMetaData;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOUtils;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreObject;
import org.jpox.store.MappedStoreManager;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NoDatastoreMappingException;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.scostore.Store;

public abstract class AbstractContainerMapping
extends SingleFieldMapping {
    protected String fieldName;
    protected StoreManager storeMgr;
    protected DatastoreObject contentsTable;
    protected Store contentsStore;
    protected Class instantiatedType;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$ArrayList;

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.fieldName = fmd.getName();
        this.storeMgr = this.datastoreContainer.getStoreManager();
        ContainerMetaData conmd = fmd.getContainer();
        if (conmd == null) {
            throw new JPOXUserException(LOCALISER.msg("ContainerMapping.ContainerMetaDataError", fmd.getFullFieldName()));
        }
        if (!this.containerIsStoredInSingleColumn()) {
            this.contentsTable = ((MappedStoreManager)this.storeMgr).newJoinDatastoreContainerObject(fmd, clr);
        }
        this.contentsStore = null;
    }

    protected void prepareDatastoreMapping() {
        if (this.containerIsStoredInSingleColumn()) {
            super.prepareDatastoreMapping();
        }
    }

    public String getJavaTypeForDatastoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return ClassNameConstants.JAVA_IO_SERIALIZABLE;
        }
        return super.getJavaTypeForDatastoreMapping(index);
    }

    public void setObject(ObjectManager om, Object preparedStatement, int[] exprIndex, Object value) {
        if (this.fmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new JPOXException(this.failureMessage("setObject")).setFatal();
        }
        StateManager[] sms = null;
        ApiAdapter api = om.getApiAdapter();
        if (value != null) {
            HashSet<StateManager> smsColl = null;
            if (value instanceof Collection) {
                Iterator elementsIter = ((Collection)value).iterator();
                while (elementsIter.hasNext()) {
                    StateManager sm;
                    Object elem = elementsIter.next();
                    if (!api.isPersistable(elem) || (sm = om.findStateManager(elem)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet<StateManager>();
                    }
                    smsColl.add(sm);
                }
            } else if (value instanceof Map) {
                Iterator entriesIter = ((Map)value).entrySet().iterator();
                while (entriesIter.hasNext()) {
                    StateManager sm;
                    Map.Entry entry = entriesIter.next();
                    Object key = entry.getKey();
                    Object val = entry.getValue();
                    if (api.isPersistable(key) && (sm = om.findStateManager(key)) != null) {
                        if (smsColl == null) {
                            smsColl = new HashSet();
                        }
                        smsColl.add(sm);
                    }
                    if (!api.isPersistable(val) || (sm = om.findStateManager(val)) == null) continue;
                    if (smsColl == null) {
                        smsColl = new HashSet();
                    }
                    smsColl.add(sm);
                }
            }
            if (smsColl != null) {
                sms = smsColl.toArray(new StateManager[smsColl.size()]);
            }
        }
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].setStoringPC();
            }
        }
        this.getDataStoreMapping(0).setObject(preparedStatement, exprIndex[0], value);
        if (sms != null) {
            for (int i = 0; i < sms.length; ++i) {
                sms[i].unsetStoringPC();
            }
        }
    }

    public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
        if (this.fmd == null || !this.containerIsStoredInSingleColumn()) {
            throw new JPOXException(this.failureMessage("getObject")).setFatal();
        }
        return this.getDataStoreMapping(0).getObject(resultSet, exprIndex[0]);
    }

    public DatastoreContainerObject getDatastoreContainer() {
        if (this.containerIsStoredInSingleColumn()) {
            return this.datastoreContainer;
        }
        return null;
    }

    public int getNumberOfDatastoreFields() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getNumberOfDatastoreFields();
        }
        return 0;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDataStoreMapping(index);
        }
        throw new NoDatastoreMappingException(this.fieldName);
    }

    public DatastoreMapping[] getDataStoreMappings() {
        if (this.containerIsStoredInSingleColumn()) {
            return super.getDataStoreMappings();
        }
        throw new NoDatastoreMappingException(this.fieldName);
    }

    protected boolean containerIsStoredInSingleColumn() {
        return this.fmd != null && this.fmd.isSerialized();
    }

    public boolean includeInFetchStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInUpdateStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public boolean includeInInsertStatement() {
        return this.containerIsStoredInSingleColumn();
    }

    public int hashCode() {
        return this.fmd == null || this.storeMgr == null ? super.hashCode() : this.fmd.hashCode() ^ this.storeMgr.hashCode();
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return null;
    }

    protected SCO replaceFieldWithWrapper(StateManager ownerSM, Object value, boolean forInsert, boolean forUpdate) {
        Class declaredType = ownerSM.getObjectManager().getClassLoaderResolver().classForName(this.getType());
        SCO sco = SCOUtils.newSCOInstance(ownerSM, this.fmd, declaredType, this.instantiatedType, value, forInsert, forUpdate, true);
        return sco;
    }

    public void postFetch(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.instantiatedType == null) {
            if (value == null) {
                if (this.fmd.getOrderMetaData() != null && this.fmd.getType() == (class$java$util$Collection == null ? (class$java$util$Collection = AbstractContainerMapping.class$("java.util.Collection")) : class$java$util$Collection)) {
                    this.instantiatedType = class$java$util$ArrayList == null ? (class$java$util$ArrayList = AbstractContainerMapping.class$("java.util.ArrayList")) : class$java$util$ArrayList;
                }
            } else {
                this.instantiatedType = value.getClass();
            }
        }
        this.replaceFieldWithWrapper(sm, null, false, false);
    }

    public void setInstantiatedType(Class type) {
        this.instantiatedType = type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

