/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.lang.reflect.Array;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.sco.SCOUtils;
import org.jpox.store.MappedStoreManager;
import org.jpox.store.exceptions.ReachableObjectNotCascadedException;
import org.jpox.store.expression.ArrayExpression;
import org.jpox.store.expression.ArrayLiteral;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AbstractContainerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.scostore.ArrayStore;
import org.jpox.util.JPOXLogger;

public class ArrayMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    private static Byte mappingSampleValue = new Byte("0");

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ArrayMapping sm = (ArrayMapping)obj;
        return this.fmd.equals(sm.fmd) && this.storeMgr.equals(sm.storeMgr);
    }

    public Class getJavaType() {
        if (this.fmd != null) {
            return this.fmd.getType();
        }
        return null;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return mappingSampleValue;
    }

    public synchronized ArrayStore getBackingStore(ClassLoaderResolver clr) {
        if (this.containerIsStoredInSingleColumn()) {
            return null;
        }
        if (this.contentsStore == null) {
            this.contentsStore = ((MappedStoreManager)this.storeMgr).getBackingStoreForArray(this.fmd, this.contentsTable, clr);
        }
        return (ArrayStore)this.contentsStore;
    }

    protected boolean containerIsStoredInSingleColumn() {
        if (super.containerIsStoredInSingleColumn()) {
            return true;
        }
        return this.fmd != null && this.fmd.hasArray() && this.fmd.getJoinMetaData() == null && MetaDataUtils.getInstance().arrayStorableAsByteArrayInSingleColumn(this.fmd);
    }

    public void postInsert(StateManager sm) {
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value);
            return;
        }
        if (value == null) {
            return;
        }
        if (!this.fmd.isCascadePersist()) {
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.NotRunForFieldOnInsert", this.fmd.getFullFieldName()));
            }
            if (!this.fmd.getType().getComponentType().isPrimitive()) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    if (sm.getObjectManager().getApiAdapter().isDetached(array[i]) || sm.getObjectManager().getApiAdapter().isPersistent(array[i])) continue;
                    throw new ReachableObjectNotCascadedException(this.fmd.getFullFieldName(), array[i]);
                }
            }
        } else {
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.PersistingField", this.fmd.getFullFieldName()));
            }
            this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).set(sm, value);
        }
    }

    public void postFetch(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        List elements = this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).getArray(sm);
        if (elements != null) {
            boolean primitiveArray = this.fmd.getType().getComponentType().isPrimitive();
            Object array = Array.newInstance(this.fmd.getType().getComponentType(), elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                Object element = elements.get(i);
                if (primitiveArray) {
                    if (element instanceof Boolean) {
                        Array.setBoolean(array, i, (Boolean)element);
                        continue;
                    }
                    if (element instanceof Byte) {
                        Array.setByte(array, i, (Byte)element);
                        continue;
                    }
                    if (element instanceof Character) {
                        Array.setChar(array, i, ((Character)element).charValue());
                        continue;
                    }
                    if (element instanceof Double) {
                        Array.setDouble(array, i, (Double)element);
                        continue;
                    }
                    if (element instanceof Float) {
                        Array.setFloat(array, i, ((Float)element).floatValue());
                        continue;
                    }
                    if (element instanceof Integer) {
                        Array.setInt(array, i, (Integer)element);
                        continue;
                    }
                    if (element instanceof Long) {
                        Array.setLong(array, i, (Long)element);
                        continue;
                    }
                    if (!(element instanceof Short)) continue;
                    Array.setShort(array, i, (Short)element);
                    continue;
                }
                Array.set(array, i, element);
            }
            if (elements.size() == 0) {
                sm.replaceField(this.fmd.getAbsoluteFieldNumber(), null, true);
            } else {
                sm.replaceField(this.fmd.getAbsoluteFieldNumber(), array, true);
            }
        } else {
            sm.replaceField(this.fmd.getAbsoluteFieldNumber(), null, true);
        }
    }

    public void postUpdate(StateManager sm) {
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value);
            return;
        }
        if (value == null) {
            this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).clear(sm);
            return;
        }
        if (!this.fmd.isCascadeUpdate()) {
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.NotRunForFieldOnUpdate", this.fmd.getFullFieldName()));
            }
            return;
        }
        if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.UpdatingField", this.fmd.getFullFieldName()));
        }
        this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).clear(sm);
        this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).set(sm, value);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.isLoaded(sm.getObject(), this.fmd.getAbsoluteFieldNumber());
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).clear(sm);
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JPOXUserException(LOCALISER.msg("ArrayMapping.QueryInvalidIfSingleColumn", this.fmd.getFullFieldName())).setFatal();
        }
        return new ArrayLiteral(qs, (JavaTypeMapping)this, value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JPOXUserException(LOCALISER.msg("ArrayMapping.QueryInvalidIfSingleColumn", this.fmd.getFullFieldName())).setFatal();
        }
        return new ArrayExpression(qs, this.datastoreContainer.getIDMapping(), te, this.getBackingStore(qs.getClassLoaderResolver()), this.fieldName);
    }
}

