/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.mapping.EmbeddedMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;

public class EmbeddedPCMapping
extends EmbeddedMapping
implements MappingCallbacks {
    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        this.initialize(dba, fmd, container, clr, fmd.getEmbeddedMetaData(), fmd.getTypeName(), 1);
    }

    public void postFetch(StateManager sm) {
        if (this.fmd.getAbsoluteFieldNumber() < 0) {
            return;
        }
        StateManager thisSM = this.getStateManagerForEmbeddedObject(sm);
        if (thisSM == null) {
            return;
        }
        for (int i = 0; i < this.getNumberOfJavaTypeMappings(); ++i) {
            JavaTypeMapping m = this.getJavaTypeMapping(i);
            if (!(m instanceof MappingCallbacks)) continue;
            ((MappingCallbacks)((Object)m)).postFetch(thisSM);
        }
    }

    public void postInsert(StateManager sm) {
        if (this.fmd.getAbsoluteFieldNumber() < 0) {
            return;
        }
        StateManager thisSM = this.getStateManagerForEmbeddedObject(sm);
        if (thisSM == null) {
            return;
        }
        for (int i = 0; i < this.getNumberOfJavaTypeMappings(); ++i) {
            JavaTypeMapping m = this.getJavaTypeMapping(i);
            if (!(m instanceof MappingCallbacks)) continue;
            ((MappingCallbacks)((Object)m)).postInsert(thisSM);
        }
    }

    public void postUpdate(StateManager sm) {
        if (this.fmd.getAbsoluteFieldNumber() < 0) {
            return;
        }
        StateManager thisSM = this.getStateManagerForEmbeddedObject(sm);
        if (thisSM == null) {
            return;
        }
        for (int i = 0; i < this.getNumberOfJavaTypeMappings(); ++i) {
            JavaTypeMapping m = this.getJavaTypeMapping(i);
            if (!(m instanceof MappingCallbacks)) continue;
            ((MappingCallbacks)((Object)m)).postUpdate(thisSM);
        }
    }

    public void preDelete(StateManager sm) {
        if (this.fmd.getAbsoluteFieldNumber() < 0) {
            return;
        }
        StateManager thisSM = this.getStateManagerForEmbeddedObject(sm);
        if (thisSM == null) {
            return;
        }
        for (int i = 0; i < this.getNumberOfJavaTypeMappings(); ++i) {
            JavaTypeMapping m = this.getJavaTypeMapping(i);
            if (!(m instanceof MappingCallbacks)) continue;
            ((MappingCallbacks)((Object)m)).preDelete(thisSM);
        }
    }

    private StateManager getStateManagerForEmbeddedObject(StateManager ownerSM) {
        Object value = ownerSM.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null) {
            return null;
        }
        StateManager thisSM = ownerSM.getObjectManager().findStateManager(value);
        if (thisSM == null) {
            thisSM = StateManagerFactory.newStateManagerForEmbedded(ownerSM.getObjectManager(), value, false);
            thisSM.addEmbeddedOwner(ownerSM, this.fmd.getAbsoluteFieldNumber());
            thisSM.setPcObjectType(this.objectType);
        }
        return thisSM;
    }
}

