/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.sco.Map;
import org.jpox.sco.SCO;
import org.jpox.sco.SCOContainer;
import org.jpox.sco.SCOMap;
import org.jpox.sco.SCOUtils;
import org.jpox.store.MappedStoreManager;
import org.jpox.store.exceptions.ReachableObjectNotCascadedException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.MapExpression;
import org.jpox.store.expression.MapLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AbstractContainerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.scostore.MapStore;
import org.jpox.util.JPOXLogger;

public class MapMapping
extends AbstractContainerMapping
implements MappingCallbacks {
    static /* synthetic */ Class class$org$jpox$sco$Map;

    public synchronized MapStore getBackingStore(ClassLoaderResolver clr) {
        if (this.containerIsStoredInSingleColumn()) {
            return null;
        }
        if (this.contentsStore == null) {
            this.contentsStore = ((MappedStoreManager)this.storeMgr).getBackingStoreForMap(this.fmd, this.contentsTable, clr);
        }
        return (MapStore)this.contentsStore;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MapMapping sm = (MapMapping)obj;
        return this.fmd.equals(sm.fmd) && this.storeMgr.equals(sm.storeMgr);
    }

    public Class getJavaType() {
        return class$org$jpox$sco$Map == null ? (class$org$jpox$sco$Map = MapMapping.class$("org.jpox.sco.Map")) : class$org$jpox$sco$Map;
    }

    public void postInsert(StateManager sm) {
        java.util.Map value = (java.util.Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value.keySet());
                SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (!this.fmd.isCascadePersist()) {
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.NotRunForFieldOnInsert", this.fmd.getFullFieldName()));
            }
            ApiAdapter api = sm.getObjectManager().getApiAdapter();
            Set entries = value.entrySet();
            Iterator iter = entries.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (api.isPersistable(entry.getKey()) && !api.isPersistent(entry.getKey()) && !api.isDetached(entry.getKey())) {
                    throw new ReachableObjectNotCascadedException(this.fmd.getFullFieldName(), entry.getKey());
                }
                if (!api.isPersistable(entry.getValue()) || api.isPersistent(entry.getValue()) || api.isDetached(entry.getValue())) continue;
                throw new ReachableObjectNotCascadedException(this.fmd.getFullFieldName(), entry.getValue());
            }
        } else {
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.PersistingField", this.fmd.getFullFieldName()));
            }
            this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).putAll(sm, value);
            this.replaceFieldWithWrapper(sm, null, false, false);
        }
    }

    public void postUpdate(StateManager sm) {
        java.util.Map value = (java.util.Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (this.containerIsStoredInSingleColumn()) {
            if (value != null) {
                SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value.keySet());
                SCOUtils.validateObjectsForWriting(sm.getObjectManager(), value.values());
            }
            return;
        }
        if (value == null) {
            this.replaceFieldWithWrapper(sm, null, false, false);
            return;
        }
        if (value instanceof SCOContainer) {
            SCOContainer sco = (SCOContainer)((Object)value);
            if (sm.getObject() == sco.getOwner() && this.fieldName.equals(sco.getFieldName())) {
                sco.flush();
                return;
            }
            if (sco.getOwner() != null) {
                throw new JPOXException("Owned second-class object was somehow assigned to a field other than its owner's").setFatal();
            }
        }
        if (!this.fmd.isCascadeUpdate()) {
            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.NotRunForFieldOnUpdate", this.fmd.getFullFieldName()));
            }
            return;
        }
        if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.UpdatingField", this.fmd.getFullFieldName()));
        }
        this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).clear(sm);
        this.getBackingStore(sm.getObjectManager().getClassLoaderResolver()).putAll(sm, value);
        this.replaceFieldWithWrapper(sm, null, false, false);
    }

    public void preDelete(StateManager sm) {
        if (this.containerIsStoredInSingleColumn()) {
            return;
        }
        sm.isLoaded(sm.getObject(), this.fmd.getAbsoluteFieldNumber());
        java.util.Map value = (java.util.Map)sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null || value.isEmpty()) {
            return;
        }
        if (!(value instanceof SCO)) {
            value = (Map)sm.getSCOWrapperForField(this.fmd.getAbsoluteFieldNumber(), value, false, false, true);
        }
        value.clear();
        ((SCOMap)((Object)value)).flush();
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JPOXUserException(LOCALISER.msg("ContainerMapping.QueryInvalidIfSerialised", this.fmd.getFullFieldName())).setFatal();
        }
        return new MapLiteral(qs, (JavaTypeMapping)this, (java.util.Map)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.containerIsStoredInSingleColumn()) {
            throw new JPOXUserException(LOCALISER.msg("ContainerMapping.QueryInvalidIfSerialised", this.fmd.getFullFieldName())).setFatal();
        }
        return new MapExpression(qs, this.datastoreContainer.getIDMapping(), te, this.getBackingStore(qs.getClassLoaderResolver()), this.fieldName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

