/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.identity.OID;
import org.jpox.identity.OIDFactory;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.MetaDataManager;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.util.JPOXLogger;

public abstract class MultiMapping
extends JavaTypeMapping {
    protected JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    private int numberOfDatastoreFields = 0;

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    public int getNumberOfDatastoreFields() {
        if (this.numberOfDatastoreFields == 0) {
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                this.numberOfDatastoreFields += this.javaTypeMappings[i].getNumberOfDatastoreFields();
            }
        }
        return this.numberOfDatastoreFields;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreFields();
            for (int j = 0; j < numberDatastoreMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getDataStoreMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new JPOXException("Invalid index " + index + " for DataStoreMapping.").setFatal();
    }

    public void setObject(ObjectManager om, Object ps, int[] pos, Object value) {
        this.setObject(om, ps, pos, value, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObject(ObjectManager om, Object ps, int[] pos, Object value, StateManager ownerSM, int ownerFieldNumber) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        ApiAdapter api = om.getApiAdapter();
        int n = 0;
        boolean foundClassAssignableFromValue = false;
        NotYetFlushedException notYetFlushed = null;
        if (value != null && !om.isInserting(value)) {
            Object id = api.getIdForObject(value);
            boolean requiresPersisting = false;
            if (om.getApiAdapter().isDetached(value) && ownerSM != null) {
                requiresPersisting = true;
            } else if (id == null) {
                requiresPersisting = true;
            } else {
                ObjectManager valueOM = ObjectManagerHelper.getObjectManager(value);
                if (valueOM != null && om != valueOM) {
                    throw new JPOXUserException(LOCALISER.msg("Mapping.FieldNotAssignableIsFromAnotherPM"), id);
                }
            }
            if (requiresPersisting) {
                Object pcNew = om.persistObjectInternal(value, null);
                om.flush(false);
                id = api.getIdForObject(pcNew);
                if (om.getApiAdapter().isDetached(value) && ownerSM != null) {
                    ownerSM.replaceField(ownerFieldNumber, pcNew, true);
                    int relationType = this.fmd.getRelationType(clr);
                    if (relationType == 2) {
                        StateManager relatedSM = om.findStateManager(pcNew);
                        AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(clr);
                        relatedSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), ownerSM.getObject(), true);
                    } else if (relationType == 6 && JPOXLogger.PERSISTENCE.isInfoEnabled()) {
                        JPOXLogger.PERSISTENCE.info("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional - should really update the reference in the relation. Not yet supported");
                    }
                }
            }
            if (this.getNumberOfDatastoreFields() <= 0) {
                return;
            }
        }
        Class type = null;
        StateManager sm = null;
        if (value != null) {
            sm = om.findStateManager(value);
        }
        try {
            MetaDataManager mmgr;
            boolean isPersistentInterface;
            if (pos == null) {
                return;
            }
            if (sm != null) {
                sm.setStoringPC();
            }
            boolean bl = isPersistentInterface = (mmgr = om.getStoreManager().getMetaDataManager()).getMetaDataForInterface(clr.classForName(this.getType()), clr) != null;
            if (isPersistentInterface) {
                type = clr.classForName(this.getType());
            } else if (this.fmd != null && this.fmd.getFieldTypes() != null && this.fmd.getFieldTypes().length == 1) {
                boolean bl2 = isPersistentInterface = mmgr.getMetaDataForInterface(clr.classForName(this.fmd.getFieldTypes()[0]), clr) != null;
                if (isPersistentInterface) {
                    type = clr.classForName(this.fmd.getFieldTypes()[0]);
                }
            }
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                if (n >= pos.length) {
                    n = 0;
                }
                int[] posMapping = this.javaTypeMappings[i].getReferenceMapping() != null ? new int[this.javaTypeMappings[i].getReferenceMapping().getNumberOfDatastoreFields()] : new int[this.javaTypeMappings[i].getNumberOfDatastoreFields()];
                for (int j = 0; j < posMapping.length; ++j) {
                    posMapping[j] = pos[n++];
                }
                try {
                    if (!isPersistentInterface) {
                        type = clr.classForName(this.javaTypeMappings[i].getType());
                    }
                    if (value != null && type.isAssignableFrom(value.getClass())) {
                        foundClassAssignableFromValue = true;
                        this.javaTypeMappings[i].setObject(om, ps, posMapping, value);
                        continue;
                    }
                    this.javaTypeMappings[i].setObject(om, ps, posMapping, null);
                    continue;
                }
                catch (NotYetFlushedException e) {
                    notYetFlushed = e;
                }
            }
            if (notYetFlushed != null) {
                throw notYetFlushed;
            }
        }
        finally {
            if (sm != null) {
                sm.unsetStoringPC();
            }
        }
        if (value != null && !foundClassAssignableFromValue) {
            throw new ClassCastException(LOCALISER.msg("ReferenceMapping.NotValidImplementation", this.fmd != null ? this.fmd.getFullFieldName() : "", type.getName(), value.getClass().getName()));
        }
    }

    public Object getObject(ObjectManager om, Object rs, int[] pos) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            if (n >= pos.length) {
                n = 0;
            }
            int[] posMapping = this.javaTypeMappings[i].getReferenceMapping() != null ? new int[this.javaTypeMappings[i].getReferenceMapping().getNumberOfDatastoreFields()] : new int[this.javaTypeMappings[i].getNumberOfDatastoreFields()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = pos[n++];
            }
            Object value = null;
            try {
                value = this.javaTypeMappings[i].getObject(om, rs, posMapping);
            }
            catch (NullValueException e) {
            }
            catch (JPOXObjectNotFoundException onfe) {
                // empty catch block
            }
            if (value == null) continue;
            if (value instanceof OID) {
                String className = this.javaTypeMappings[i].getReferenceMapping() != null ? this.javaTypeMappings[i].getReferenceMapping().getDataStoreMapping(0).getDatastoreField().getStoredJavaType() : this.javaTypeMappings[i].getDataStoreMapping(0).getDatastoreField().getStoredJavaType();
                value = OIDFactory.getInstance(om, className, ((OID)value).getKeyValue());
                return om.findObject(value, false, true, null);
            }
            if (!om.getClassLoaderResolver().classForName(this.getType()).isAssignableFrom(value.getClass())) continue;
            return value;
        }
        return null;
    }
}

