/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.api.ApiAdapter;
import org.jpox.identity.OID;
import org.jpox.identity.OIDFactory;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.ObjectLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SimpleDatastoreRepresentation;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.util.JPOXLogger;

public class OIDMapping
extends SingleFieldMapping
implements SimpleDatastoreRepresentation {
    static /* synthetic */ Class class$org$jpox$identity$OID;

    public void setObject(ObjectManager om, Object ps, int[] param, Object value) {
        if (value == null) {
            this.getDataStoreMapping(0).setObject(ps, param[0], null);
        } else {
            OID oid;
            ApiAdapter api = om.getApiAdapter();
            if (api.isPersistable(value)) {
                oid = (OID)api.getIdForObject(value);
                if (oid == null) {
                    if (om.isInserting(value)) {
                        this.getDataStoreMapping(0).setObject(ps, param[0], null);
                        throw new NotYetFlushedException(value);
                    }
                    om.persistObjectInternal(value, null);
                    om.flush(false);
                }
                oid = (OID)api.getIdForObject(value);
            } else {
                oid = (OID)value;
            }
            try {
                this.getDataStoreMapping(0).setObject(ps, param[0], oid.getKeyValue());
            }
            catch (Exception e) {
                this.getDataStoreMapping(0).setObject(ps, param[0], oid.getKeyValue().toString());
            }
        }
    }

    public Object getObject(ObjectManager om, Object rs, int[] param) {
        Object value;
        if (this.getNumberOfDatastoreFields() > 0) {
            value = this.getDataStoreMapping(0).getObject(rs, param[0]);
        } else {
            if (this.referenceMapping != null) {
                return this.referenceMapping.getObject(om, rs, param);
            }
            Class fieldType = this.fmd.getType();
            JavaTypeMapping referenceMapping = om.getStoreManager().getDatastoreClass(fieldType.getName(), om.getClassLoaderResolver()).getIDMapping();
            value = referenceMapping.getDataStoreMapping(0).getObject(rs, param[0]);
        }
        if (value != null) {
            value = OIDFactory.getInstance(om, this.getType(), value);
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("OIDMapping.GetObject", value));
            }
        } else {
            JPOXLogger.PERSISTENCE.warn(LOCALISER.msg("OIDMapping.GetObjectError"));
        }
        return value;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        return "NO SAMPLE AVAILABLE";
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, this.getType());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        ObjectExpression expr = new ObjectExpression(qs, this, te);
        return expr;
    }

    public Class getJavaType() {
        return class$org$jpox$identity$OID == null ? (class$org$jpox$identity$OID = OIDMapping.class$("org.jpox.identity.OID")) : class$org$jpox$identity$OID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

