/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import javax.jdo.JDOObjectNotFoundException;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.FetchPlan;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.identity.OID;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.MetaDataManager;
import org.jpox.sco.SCOCollection;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreElementContainer;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.FieldValues;
import org.jpox.store.MappedStoreManager;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.exceptions.ReachableObjectNotCascadedException;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.ObjectExpression;
import org.jpox.store.expression.ObjectLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AppIDObjectIdFieldConsumer;
import org.jpox.store.mapping.CorrespondentColumnsMapper;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MappingManager;
import org.jpox.store.mapping.OIDMapping;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class PersistenceCapableMapping
extends OIDMapping
implements MappingCallbacks {
    protected JavaTypeMapping[] javaTypeMappings = new JavaTypeMapping[0];
    private AbstractClassMetaData cmd;
    private int numberOfDatastoreFields = 0;

    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.prepareDatastoreMapping(clr);
    }

    public void addJavaTypeMapping(JavaTypeMapping mapping) {
        if (mapping == null) {
            throw new JPOXException("mapping argument in PersistenceCapableMapping.addJavaTypeMapping is null").setFatal();
        }
        JavaTypeMapping[] jtm = this.javaTypeMappings;
        this.javaTypeMappings = new JavaTypeMapping[jtm.length + 1];
        System.arraycopy(jtm, 0, this.javaTypeMappings, 0, jtm.length);
        this.javaTypeMappings[jtm.length] = mapping;
    }

    protected void prepareDatastoreMapping() {
    }

    protected void prepareDatastoreMapping(ClassLoaderResolver clr) {
        MappedStoreManager storeMgr = this.datastoreContainer.getStoreManager();
        AbstractClassMetaData refCmd = storeMgr.getMetaDataManager().getMetaDataForClass(this.fmd.getType(), clr);
        JavaTypeMapping referenceMapping = null;
        if (refCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
            AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(refCmd, clr);
            if (cmds != null && cmds.length > 0) {
                if (cmds.length > 1) {
                    JPOXLogger.PERSISTENCE.warn("Field " + this.fmd.getFullFieldName() + " represents either a 1-1 relation, " + "or a N-1 relation where the other end uses \"subclass-table\" inheritance strategy and more " + "than 1 subclasses with a table. This is not fully supported by JPOX");
                }
            } else {
                return;
            }
            referenceMapping = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIDMapping();
        } else {
            referenceMapping = storeMgr.getDatastoreClass(this.fmd.getType().getName(), clr).getIDMapping();
        }
        CorrespondentColumnsMapper correspondentColumnsMapping = new CorrespondentColumnsMapper(this.fmd, referenceMapping, true);
        int relationType = this.fmd.getRelationType(clr);
        boolean createDatastoreMappings = true;
        if (relationType == 6) {
            AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(clr);
            createDatastoreMappings = relatedMmds[0].getJoinMetaData() == null;
        } else if (relationType == 2) {
            createDatastoreMappings = this.fmd.getMappedBy() == null;
        }
        for (int i = 0; i < referenceMapping.getNumberOfDatastoreFields(); ++i) {
            DatastoreMapping refDatastoreMapping = referenceMapping.getDataStoreMapping(i);
            JavaTypeMapping mapping = this.dba.getMapping(refDatastoreMapping.getJavaTypeMapping().getJavaType(), storeMgr);
            this.addJavaTypeMapping(mapping);
            if (createDatastoreMappings) {
                ColumnMetaData colmd = correspondentColumnsMapping.getColumnMetaDataByIdentifier(refDatastoreMapping.getDatastoreField().getIdentifier());
                if (colmd == null) {
                    throw new JPOXUserException(LOCALISER.msg("PersistenceCapableMapping.PrimaryKeyColumnNotMapped", refDatastoreMapping.getDatastoreField().getIdentifier(), this.toString())).setFatal();
                }
                MappingManager mmgr = this.datastoreContainer.getStoreManager().getMappingManager();
                DatastoreField col = mmgr.createDatastoreField(this.fmd, this.datastoreContainer, mapping, colmd, refDatastoreMapping.getDatastoreField(), clr);
                DatastoreMapping datastoreMapping = mmgr.createDatastoreMapping(mapping, storeMgr, col, refDatastoreMapping.getJavaTypeMapping().getJavaTypeForDatastoreMapping(i));
                this.addDataStoreMapping(datastoreMapping);
                continue;
            }
            mapping.setReferenceMapping(referenceMapping);
        }
    }

    public JavaTypeMapping[] getJavaTypeMapping() {
        return this.javaTypeMappings;
    }

    public int getNumberOfDatastoreFields() {
        if (this.numberOfDatastoreFields == 0) {
            for (int i = 0; i < this.javaTypeMappings.length; ++i) {
                this.numberOfDatastoreFields += this.javaTypeMappings[i].getNumberOfDatastoreFields();
            }
        }
        return this.numberOfDatastoreFields;
    }

    public DatastoreMapping getDataStoreMapping(int index) {
        int currentIndex = 0;
        int numberJavaMappings = this.javaTypeMappings.length;
        for (int i = 0; i < numberJavaMappings; ++i) {
            int numberDatastoreMappings = this.javaTypeMappings[i].getNumberOfDatastoreFields();
            for (int j = 0; j < numberDatastoreMappings; ++j) {
                if (currentIndex == index) {
                    return this.javaTypeMappings[i].getDataStoreMapping(j);
                }
                ++currentIndex;
            }
        }
        throw new JPOXException("Invalid index " + index + " for DataStoreMapping.").setFatal();
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value) {
        this.setObject(om, ps, param, value, null, -1);
    }

    public void setObject(ObjectManager om, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        if (value == null) {
            this.setObjectAsNull(om, ps, param);
        } else {
            this.setObjectAsValue(om, ps, param, value, ownerSM, ownerFieldNumber);
        }
    }

    private void setObjectAsNull(ObjectManager om, Object ps, int[] param) {
        int n = 0;
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (mapping.getNumberOfDatastoreFields() <= 0) continue;
            int[] posMapping = new int[mapping.getNumberOfDatastoreFields()];
            for (int j = 0; j < posMapping.length; ++j) {
                posMapping[j] = param[n++];
            }
            mapping.setObject(om, ps, posMapping, null);
        }
    }

    private boolean hasDatastoreAttributedPrimaryKeyValues(MetaDataManager mdm, StoreManager srm, ClassLoaderResolver clr) {
        AbstractClassMetaData acmd;
        boolean hasDatastoreAttributedPrimaryKeyValues = false;
        if (this.fmd != null && (acmd = mdm.getMetaDataForClass(this.fmd.getType(), clr)).getIdentityType() == IdentityType.APPLICATION) {
            for (int i = 0; i < acmd.getPKMemberPositions().length; ++i) {
                IdentityStrategy strategy = acmd.getMetaDataForManagedMemberAtAbsolutePosition(acmd.getPKMemberPositions()[i]).getValueStrategy();
                if (strategy == null) continue;
                hasDatastoreAttributedPrimaryKeyValues |= srm.isStrategyDatastoreAttributed(strategy, false);
            }
        }
        return hasDatastoreAttributedPrimaryKeyValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setObjectAsValue(ObjectManager om, Object ps, int[] param, Object value, StateManager ownerSM, int ownerFieldNumber) {
        block41: {
            ApiAdapter api = om.getApiAdapter();
            if (!api.isPersistable(value)) {
                throw new JPOXException(LOCALISER.msg("Mapping.ObjectIsNotPersistenceCapable", value.getClass(), value)).setFatal();
            }
            StateManager sm = om.findStateManager(value);
            try {
                ClassLoaderResolver clr = om.getClassLoaderResolver();
                boolean hasDatastoreAttributedPrimaryKeyValues = this.hasDatastoreAttributedPrimaryKeyValues(om.getMetaDataManager(), om.getStoreManager(), clr);
                boolean inserted = false;
                if (ownerFieldNumber >= 0) {
                    inserted = om.isInserted(value, ownerFieldNumber);
                }
                if (sm != null) {
                    if (om.getApiAdapter().isDetached(value) && sm.getReferencedPC() != null && ownerSM != null && this.fmd != null) {
                        ownerSM.replaceField(ownerFieldNumber, sm.getReferencedPC(), true);
                    }
                    if (sm.isWaitingToBeFlushedToDatastore()) {
                        sm.flush();
                    }
                }
                if (inserted || !om.isInserting(value) || !hasDatastoreAttributedPrimaryKeyValues && this.fmd != null && this.fmd.isPrimaryKey()) {
                    Object id = api.getIdForObject(value);
                    boolean requiresPersisting = false;
                    if (om.getApiAdapter().isDetached(value) && ownerSM != null) {
                        if (ownerSM.isInserting()) {
                            if (!om.getOMFContext().getPersistenceConfiguration().getAttachSameDatastore() && om.getObjectFromCache(api.getIdForObject(value)) == null) {
                                try {
                                    Object obj = om.findObject(api.getIdForObject(value), true, false, value.getClass().getName());
                                    if (obj != null) {
                                        StateManager objSM = om.findStateManager(obj);
                                        if (objSM != null) {
                                            om.evictFromTransaction(objSM);
                                        }
                                        om.removeObjectFromCache(value, api.getIdForObject(value), true, true);
                                    }
                                }
                                catch (JPOXObjectNotFoundException onfe) {
                                    requiresPersisting = true;
                                }
                            }
                        } else {
                            requiresPersisting = true;
                        }
                    } else if (id == null) {
                        requiresPersisting = true;
                    } else {
                        ObjectManager pcPM = ObjectManagerHelper.getObjectManager(value);
                        if (pcPM != null && om != pcPM) {
                            throw new JPOXUserException(LOCALISER.msg("Mapping.FieldNotAssignableIsFromAnotherPM"), id);
                        }
                    }
                    if (requiresPersisting) {
                        if (this.fmd != null && !this.fmd.isCascadePersist() && !om.getApiAdapter().isDetached(value)) {
                            if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                                JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.NotRunForFieldOnInsert", this.fmd.getFullFieldName()));
                            }
                            throw new ReachableObjectNotCascadedException(this.fmd.getFullFieldName(), value);
                        }
                        if (JPOXLogger.REACHABILITY.isDebugEnabled()) {
                            JPOXLogger.REACHABILITY.debug(LOCALISER.msg("Reachability.PersistingField", this.fmd != null ? this.fmd.getFullFieldName() : null));
                        }
                        try {
                            Object pcNew = om.persistObjectInternal(value, null);
                            if (hasDatastoreAttributedPrimaryKeyValues) {
                                om.flush(false);
                            }
                            id = api.getIdForObject(pcNew);
                            if (om.getApiAdapter().isDetached(value) && ownerSM != null) {
                                ownerSM.replaceField(ownerFieldNumber, pcNew, true);
                                int relationType = this.fmd.getRelationType(clr);
                                if (relationType == 6) {
                                    if (JPOXLogger.PERSISTENCE.isInfoEnabled()) {
                                        JPOXLogger.PERSISTENCE.info("PCMapping.setObject : object " + ownerSM.getInternalObjectId() + " has field " + ownerFieldNumber + " that is 1-N bidirectional." + " Have just attached the N side so should really update the reference in the 1 side collection" + " to refer to this attached object. Not yet implemented");
                                    }
                                } else if (relationType == 2) {
                                    AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(clr);
                                    StateManager relatedSM = om.findStateManager(pcNew);
                                    relatedSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), ownerSM.getObject(), true);
                                }
                            }
                        }
                        catch (NotYetFlushedException e) {
                            this.setObjectAsNull(om, ps, param);
                            throw new NotYetFlushedException(value);
                        }
                    }
                    if (sm != null) {
                        sm.setStoringPC();
                    }
                    if (this.getNumberOfDatastoreFields() > 0) {
                        if (id instanceof OID) {
                            super.setObject(om, ps, param, id);
                        } else {
                            ((PersistenceCapable)value).jdoCopyKeyFieldsFromObjectId((PersistenceCapable.ObjectIdFieldConsumer)new AppIDObjectIdFieldConsumer(param, om, ps, this.javaTypeMappings), id);
                        }
                    }
                    break block41;
                }
                if (sm != null) {
                    sm.setStoringPC();
                }
                if (this.getNumberOfDatastoreFields() > 0) {
                    this.setObjectAsNull(om, ps, param);
                    throw new NotYetFlushedException(value);
                }
            }
            finally {
                if (sm != null) {
                    sm.unsetStoringPC();
                }
            }
        }
    }

    public Object getObject(ObjectManager om, Object rs, int[] param) {
        try {
            if (((ResultSet)rs).getObject(param[0]) == null) {
                return null;
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(e.getMessage(), e);
        }
        if (this.cmd == null) {
            this.cmd = om.getMetaDataManager().getMetaDataForClass(this.getType(), om.getClassLoaderResolver());
        }
        if (this.cmd.getIdentityType() == IdentityType.DATASTORE) {
            return this.getObjectForDatastoreIdentity(om, rs, param, this.cmd);
        }
        if (this.cmd.getIdentityType() == IdentityType.APPLICATION) {
            return this.getObjectForApplicationIdentity(om, rs, param, this.cmd);
        }
        return null;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, this.getType());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        if (this.getNumberOfDatastoreFields() > 0) {
            return new ObjectExpression(qs, this, te);
        }
        ClassLoaderResolver clr = qs.getClassLoaderResolver();
        MappedStoreManager srm = (MappedStoreManager)qs.getStoreManager();
        int relationType = this.fmd.getRelationType(clr);
        if (relationType == 2) {
            DatastoreClass targetTable = srm.getDatastoreClass(this.fmd.getTypeName(), clr);
            AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(clr);
            JavaTypeMapping refMapping = targetTable.getFieldMapping(relatedMmds[0]);
            JavaTypeMapping selectMapping = targetTable.getIDMapping();
            DatastoreIdentifier targetTableIdentifier = srm.getIdentifierFactory().newIdentifier(0, "RELATED" + this.fmd.getAbsoluteFieldNumber());
            LogicSetExpression targetTe = qs.newTableExpression(targetTable, targetTableIdentifier);
            return new ObjectExpression(qs, this, te, refMapping, targetTe, selectMapping);
        }
        if (relationType == 6) {
            AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(clr);
            if (this.fmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                DatastoreContainerObject targetTable = srm.getDatastoreContainerObject(relatedMmds[0]);
                JavaTypeMapping refMapping = null;
                JavaTypeMapping selectMapping = null;
                DatastoreElementContainer elementTable = (DatastoreElementContainer)targetTable;
                refMapping = elementTable.getElementMapping();
                selectMapping = elementTable.getOwnerMapping();
                DatastoreIdentifier targetTableIdentifier = srm.getIdentifierFactory().newIdentifier(0, "JOINTABLE" + this.fmd.getAbsoluteFieldNumber());
                LogicSetExpression targetTe = qs.newTableExpression(targetTable, targetTableIdentifier);
                return new ObjectExpression(qs, this, te, refMapping, targetTe, selectMapping);
            }
        }
        return null;
    }

    private Object getObjectForDatastoreIdentity(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd) {
        Object oid = super.getObject(om, rs, param);
        ApiAdapter api = om.getApiAdapter();
        if (api.isPersistable(oid)) {
            return oid;
        }
        return oid == null ? null : om.findObject(oid, false, true, null);
    }

    private Object createSingleFieldIdentity(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass, Class pcClass) {
        int paramNumber = param[0];
        try {
            Object idObj = ((ResultSet)rs).getObject(paramNumber);
            if (idObj == null) {
                throw new JPOXException(LOCALISER.msg("PersistenceCapableMapping.CantCreateSingleFieldIdentityWithNull")).setFatal();
            }
            Class keyType = om.getApiAdapter().getKeyTypeForSingleFieldIdentityType(objectIdClass);
            idObj = ClassUtils.convertValue(idObj, keyType);
            return om.getApiAdapter().getNewSingleFieldIdentity(objectIdClass, pcClass, idObj);
        }
        catch (Exception e) {
            JPOXLogger.PERSISTENCE.error(LOCALISER.msg("PersistenceCapableMapping.CantCreateAID", cmd.getObjectidClass(), e));
            return null;
        }
    }

    private Object createObjectIdInstanceReflection(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd, Class objectIdClass) {
        Object fieldValue = null;
        try {
            Object id = objectIdClass.newInstance();
            int paramIndex = 0;
            for (int i = 0; i < cmd.getPKMemberPositions().length; ++i) {
                AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
                Field field = objectIdClass.getField(fmd.getName());
                JavaTypeMapping m = om.getStoreManager().getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver()).getFieldMapping(fmd);
                for (int j = 0; j < m.getNumberOfDatastoreFields(); ++j) {
                    Object obj;
                    if ((obj = ((ResultSet)rs).getObject(param[paramIndex++])) instanceof BigDecimal) {
                        BigDecimal bigDecimal = (BigDecimal)obj;
                        Class keyType = om.getApiAdapter().getKeyTypeForSingleFieldIdentityType(field.getType());
                        obj = ClassUtils.convertValue(bigDecimal, keyType);
                        if (!bigDecimal.subtract(new BigDecimal("" + obj)).equals(new BigDecimal("0"))) {
                            throw new JPOXException("Cannot convert retrieved BigInteger value to field of object id class!").setFatal();
                        }
                    }
                    fieldValue = obj;
                }
                field.set(id, fieldValue);
            }
            return id;
        }
        catch (Exception e) {
            JPOXLogger.PERSISTENCE.error(LOCALISER.msg("PersistenceCapableMapping.CantCreateAIDWithReflection", cmd.getObjectidClass(), this.fmd == null ? null : this.fmd.getName(), fieldValue, e));
            return null;
        }
    }

    private Object getObjectForAbstractClass(ObjectManager om, Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class objectIdClass = clr.classForName(cmd.getObjectidClass());
        Class pcClass = clr.classForName(cmd.getFullClassName());
        Object id = cmd.usesSingleFieldIdentityClass() ? this.createSingleFieldIdentity(om, rs, param, cmd, objectIdClass, pcClass) : this.createObjectIdInstanceReflection(om, rs, param, cmd, objectIdClass);
        return om.findObject(id, false, true, null);
    }

    private Object getObjectForApplicationIdentity(ObjectManager om, final Object rs, int[] param, AbstractClassMetaData cmd) {
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        if (((ClassMetaData)cmd).isAbstractPersistenceCapable() && cmd.getObjectidClass() != null) {
            return this.getObjectForAbstractClass(om, rs, param, cmd);
        }
        int totalFieldCount = cmd.getNoOfManagedMembers() + cmd.getNoOfInheritedManagedMembers();
        final StatementExpressionIndex[] statementExpressionIndex = new StatementExpressionIndex[totalFieldCount];
        int paramIndex = 0;
        DatastoreClass datastoreClass = om.getStoreManager().getDatastoreClass(cmd.getFullClassName(), clr);
        final int[] pkFieldNumbers = cmd.getPKMemberPositions();
        for (int i = 0; i < pkFieldNumbers.length; ++i) {
            AbstractMemberMetaData fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(pkFieldNumbers[i]);
            JavaTypeMapping m = datastoreClass.getFieldMapping(fmd);
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()] = new StatementExpressionIndex();
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setMapping(m);
            int[] expressionsIndex = new int[m.getNumberOfDatastoreFields()];
            for (int j = 0; j < expressionsIndex.length; ++j) {
                expressionsIndex[j] = param[paramIndex++];
            }
            statementExpressionIndex[fmd.getAbsoluteFieldNumber()].setExpressionIndex(expressionsIndex);
        }
        final MappedStoreManager storeMgr = (MappedStoreManager)om.getStoreManager();
        return om.findObjectUsingAID(clr.classForName(cmd.getFullClassName()), new FieldValues(){

            public void fetchFields(StateManager sm) {
                sm.replaceFields(pkFieldNumbers, storeMgr.getFieldManagerForResultProcessing(sm, rs, statementExpressionIndex));
            }

            public void fetchNonLoadedFields(StateManager sm) {
                sm.replaceNonLoadedFields(pkFieldNumbers, storeMgr.getFieldManagerForResultProcessing(sm, rs, statementExpressionIndex));
            }

            public FetchPlan getFetchPlanForLoading() {
                return null;
            }
        }, false, true);
    }

    public void postFetch(StateManager sm) {
    }

    public void postInsert(StateManager sm) {
        Object pc = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(clr);
        int relationType = this.fmd.getRelationType(clr);
        if (pc != null) {
            boolean contained;
            Collection relatedColl;
            StateManager otherSM;
            if (relationType == 2) {
                AbstractMemberMetaData relatedMmd;
                StateManager otherSM2 = sm.getObjectManager().findStateManager(pc);
                Object relatedValue = otherSM2.provideField((relatedMmd = this.fmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc)).getAbsoluteFieldNumber());
                if (relatedValue == null) {
                    if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                        JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("Mapping.ManagedRelations.OneToOneUpdate", StringUtils.toJVMIDString(sm.getObject()), this.fmd.getFullFieldName(), StringUtils.toJVMIDString(pc), relatedMmd.getFullFieldName()));
                    }
                    otherSM2.replaceField(relatedMmd.getAbsoluteFieldNumber(), sm.getObject(), false);
                } else if (relatedValue != sm.getObject()) {
                    throw new JPOXUserException(LOCALISER.msg("Mapping.ManagedRelations.OneToOneInconsistent", StringUtils.toJVMIDString(sm.getObject()), this.fmd.getFullFieldName(), StringUtils.toJVMIDString(pc), StringUtils.toJVMIDString(relatedValue)));
                }
            } else if (relationType == 6 && relatedMmds[0].hasCollection() && (otherSM = sm.getObjectManager().findStateManager(pc)) != null && (relatedColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber())) != null && !(relatedColl instanceof SCOCollection) && !(contained = relatedColl.contains(sm.getObject()))) {
                JPOXLogger.PERSISTENCE.info(LOCALISER.msg("Mapping.ManagedRelations.OneToManyElementNotInCollection", StringUtils.toJVMIDString(sm.getObject()), this.fmd.getFullFieldName(), StringUtils.toJVMIDString(pc), relatedMmds[0].getFullFieldName()));
            }
        }
    }

    public void postUpdate(StateManager sm) {
        AbstractMemberMetaData relatedMmd;
        Object relatedValue;
        StateManager otherSM;
        Object pc = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        int relationType = this.fmd.getRelationType(clr);
        if (pc != null && relationType == 2 && (otherSM = sm.getObjectManager().findStateManager(pc)) != null && (relatedValue = otherSM.provideField((relatedMmd = this.fmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc)).getAbsoluteFieldNumber())) == null) {
            if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("Mapping.ManagedRelations.OneToOneUpdate", StringUtils.toJVMIDString(sm.getObject()), this.fmd.getFullFieldName(), StringUtils.toJVMIDString(pc), relatedMmd.getFullFieldName()));
            }
            otherSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), sm.getObject(), false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preDelete(StateManager sm) {
        int fieldNumber = this.fmd.getAbsoluteFieldNumber();
        try {
            sm.isLoaded(sm.getObject(), fieldNumber);
        }
        catch (JDOObjectNotFoundException onfe) {
            return;
        }
        Object pc = sm.provideField(fieldNumber);
        if (pc == null) {
            return;
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        AbstractMemberMetaData[] relatedMmds = this.fmd.getRelatedMemberMetaData(clr);
        boolean dependent = this.fmd.isDependent();
        boolean hasFK = false;
        if (!dependent) {
            if (this.fmd.getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (relatedMmds != null && relatedMmds[0].getForeignKeyMetaData() != null) {
                hasFK = true;
            }
            if (sm.getObjectManager().getOMFContext().getPersistenceConfiguration().getDeletionPolicy().equals("JDO2")) {
                hasFK = false;
            }
        }
        int relationType = this.fmd.getRelationType(clr);
        if (pc == null) return;
        if (relationType == 1 || relationType == 2 && this.fmd.getMappedBy() == null) {
            if (dependent) {
                if (this.isNullable()) {
                    sm.replaceField(fieldNumber, null, true);
                    sm.getStoreManager().updateObject(sm, new int[]{fieldNumber});
                }
                if (sm.getObjectManager().getApiAdapter().isDeleted(pc)) return;
                sm.getObjectManager().deleteObjectInternal(pc);
                return;
            } else {
                StateManager otherSM;
                AbstractMemberMetaData relatedMmd = this.fmd.getRelatedMemberMetaDataForObject(clr, sm.getObject(), pc);
                if (relatedMmd == null || (otherSM = sm.getObjectManager().findStateManager(pc)) == null) return;
                if (JPOXLogger.PERSISTENCE.isDebugEnabled()) {
                    JPOXLogger.PERSISTENCE.debug(LOCALISER.msg("Mapping.ManagedRelations.OneToOneDeleteNulling", StringUtils.toJVMIDString(pc), relatedMmd.getFullFieldName(), StringUtils.toJVMIDString(sm.getObject())));
                }
                otherSM.replaceField(relatedMmd.getAbsoluteFieldNumber(), null, true);
            }
            return;
        } else if (relationType == 2 && this.fmd.getMappedBy() != null) {
            DatastoreClass relatedTable = sm.getStoreManager().getDatastoreClass(relatedMmds[0].getClassName(), clr);
            JavaTypeMapping relatedMapping = relatedTable.getFieldMapping(relatedMmds[0]);
            boolean isNullable = relatedMapping.isNullable();
            StateManager otherSM = sm.getObjectManager().findStateManager(pc);
            if (dependent) {
                if (isNullable) {
                    otherSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), null, true);
                    otherSM.getStoreManager().updateObject(otherSM, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
                }
                sm.getObjectManager().deleteObjectInternal(pc);
                return;
            } else {
                if (hasFK || !this.isNullable()) return;
                otherSM.replaceField(relatedMmds[0].getAbsoluteFieldNumber(), null, true);
                otherSM.getStoreManager().updateObject(otherSM, new int[]{relatedMmds[0].getAbsoluteFieldNumber()});
            }
            return;
        } else {
            if (relationType != 6) return;
            StateManager otherSM = sm.getObjectManager().findStateManager(pc);
            if (relatedMmds[0].getJoinMetaData() == null) {
                if (otherSM.isDeleting()) return;
                if (dependent) {
                    if (this.isNullable()) {
                        sm.replaceField(fieldNumber, null, true);
                        sm.getStoreManager().updateObject(sm, new int[]{fieldNumber});
                    }
                    if (sm.getObjectManager().getApiAdapter().isDeleted(pc)) return;
                    sm.getObjectManager().deleteObjectInternal(pc);
                    return;
                } else {
                    if (relatedMmds[0].hasCollection()) {
                        Collection otherColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                        if (otherColl == null) return;
                    }
                    if (!relatedMmds[0].hasMap()) return;
                }
                return;
            } else if (dependent) {
                sm.getObjectManager().deleteObjectInternal(pc);
                return;
            } else if (relatedMmds[0].hasCollection()) {
                Collection otherColl = (Collection)otherSM.provideField(relatedMmds[0].getAbsoluteFieldNumber());
                if (otherColl == null) return;
                otherColl.remove(sm.getObject());
                return;
            } else if (!relatedMmds[0].hasMap()) return;
        }
    }
}

