/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.mapping;

import org.jpox.ClassLoaderResolver;
import org.jpox.StateManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.InterfaceMetaData;
import org.jpox.metadata.MetaDataUtils;
import org.jpox.store.DatastoreAdapter;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.MappedStoreManager;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.ObjectLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ReferenceExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.mapping.MultiMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.util.JPOXLogger;

public abstract class ReferenceMapping
extends MultiMapping
implements MappingCallbacks {
    public void initialize(DatastoreAdapter dba, AbstractMemberMetaData fmd, DatastoreContainerObject container, ClassLoaderResolver clr) {
        super.initialize(dba, fmd, container, clr);
        this.createColumns(this.datastoreContainer, fmd, clr);
    }

    protected void createColumns(DatastoreContainerObject datastoreContainer, AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        if (fmd.getMappedBy() == null) {
            datastoreContainer.getStoreManager().createDatastoreColumnsForReferenceField(this, datastoreContainer, fmd, clr, fmd.isEmbedded() || fmd.getElementMetaData() != null);
        } else {
            MappedStoreManager storeMgr = datastoreContainer.getStoreManager();
            InterfaceMetaData refCmd = storeMgr.getMetaDataManager().getMetaDataForInterface(fmd.getType(), clr);
            JavaTypeMapping referenceMapping = null;
            if (refCmd != null && refCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                AbstractClassMetaData[] cmds = storeMgr.getClassesManagingTableForClass(refCmd, clr);
                if (cmds != null && cmds.length > 0) {
                    if (cmds.length > 1) {
                        JPOXLogger.PERSISTENCE.warn("Field " + fmd.getFullFieldName() + " represents either a 1-1 relation, or a N-1 relation " + "where the other end uses \"subclass-table\" inheritance strategy and more than 1 subclasses with a table. " + "This is not fully supported by JPOX");
                    }
                } else {
                    return;
                }
                referenceMapping = storeMgr.getDatastoreClass(cmds[0].getFullClassName(), clr).getIDMapping();
            } else {
                String[] implTypes = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(fmd, 2, clr);
                for (int j = 0; j < implTypes.length; ++j) {
                    referenceMapping = storeMgr.getDatastoreClass(implTypes[j], clr).getIDMapping();
                    JavaTypeMapping mapping = this.dba.getMapping(clr.classForName(implTypes[j]), storeMgr);
                    mapping.setReferenceMapping(referenceMapping);
                    this.addJavaTypeMapping(mapping);
                }
            }
        }
    }

    public Class getJavaType() {
        return null;
    }

    public Object getSampleValue(ClassLoaderResolver clr) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value) {
        ObjectLiteral expr = new ObjectLiteral(qs, this, value, value.getClass().getName());
        return expr;
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
        ReferenceExpression expr = new ReferenceExpression(qs, this, te);
        return expr;
    }

    public void postFetch(StateManager sm) {
    }

    public void postInsert(StateManager sm) {
    }

    public void postUpdate(StateManager sm) {
    }

    public void preDelete(StateManager sm) {
        boolean isDependentElement = this.fmd.isDependent();
        if (!isDependentElement) {
            return;
        }
        for (int i = 0; i < this.javaTypeMappings.length; ++i) {
            JavaTypeMapping mapping = this.javaTypeMappings[i];
            if (!(mapping instanceof PersistenceCapableMapping)) continue;
            int fieldNumber = this.getFieldMetaData().getAbsoluteFieldNumber();
            sm.isLoaded(sm.getObject(), fieldNumber);
            Object pc = sm.provideField(fieldNumber);
            if (pc == null) continue;
            sm.replaceField(fieldNumber, null, true);
            sm.getStoreManager().updateObject(sm, new int[]{fieldNumber});
            sm.getObjectManager().deleteObjectInternal(pc);
        }
    }
}

