/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.query;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jdo.spi.PersistenceCapable;
import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.ClassNotResolvedException;
import org.jpox.exceptions.JPOXUnsupportedOptionException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.Extension;
import org.jpox.plugin.PluginManager;
import org.jpox.store.Extent;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.query.JDOQLResultSetMetaData;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.util.JPOXLogger;

public abstract class AbstractJPQLQuery
extends Query {
    public static final String[] SINGLE_STRING_KEYWORDS = new String[]{"SELECT", "UPDATE", "DELETE", "UNIQUE", "FROM", "WHERE", "GROUP BY", "HAVING", "ORDER BY"};
    protected ScalarExpression[] candidateExprs = null;
    protected transient Extent candidateExtent = null;
    protected transient Collection candidateCollection = null;
    protected transient Queryable candidates = null;
    protected transient String from = null;
    protected transient AbstractClassMetaData candidateCmd = null;
    protected transient QueryExpression queryStmt = null;
    protected transient ResultObjectFactory rof = null;
    protected transient boolean distinct = false;
    protected transient JDOQLResultSetMetaData resultMetaData;
    protected transient Map aliases = new HashMap();
    protected transient String candidateAlias = "this";
    protected static transient Map userDefinedScalarExpressions = new Hashtable();
    String singleString = null;
    protected static Map compiledCache = new HashMap();
    static /* synthetic */ Class class$org$jpox$ObjectManagerFactoryImpl;

    public AbstractJPQLQuery(ObjectManager om) {
        super(om);
        this.registerScalarExpressions(om.getOMFContext().getPluginManager(), om.getClassLoaderResolver());
    }

    public static void registerScalarExpression(Class literal, Class scalarExpressionClass, String name) {
        userDefinedScalarExpressions.put(name == null ? literal.getName() : name, scalarExpressionClass);
    }

    protected void registerScalarExpressions(PluginManager pluginMgr, ClassLoaderResolver clr) {
        if (userDefinedScalarExpressions.isEmpty()) {
            Extension[] ex = pluginMgr.getExtensionPoint("org.jpox.store_expression_scalarexpression").getExtensions();
            for (int i = 0; i < ex.length; ++i) {
                ConfigurationElement[] confElm = ex[i].getConfigurationElements();
                for (int c = 0; c < confElm.length; ++c) {
                    AbstractJPQLQuery.registerScalarExpression(confElm[c].getAttribute("literal-class") == null ? null : clr.classForName(confElm[c].getAttribute("literal-class"), (class$org$jpox$ObjectManagerFactoryImpl == null ? AbstractJPQLQuery.class$("org.jpox.ObjectManagerFactoryImpl") : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader()), clr.classForName(confElm[c].getAttribute("scalar-expression-class"), (class$org$jpox$ObjectManagerFactoryImpl == null ? AbstractJPQLQuery.class$("org.jpox.ObjectManagerFactoryImpl") : class$org$jpox$ObjectManagerFactoryImpl).getClassLoader()), confElm[c].getAttribute("name"));
                }
            }
        }
    }

    public void setCandidates(Extent pcs) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (pcs == null) {
            JPOXLogger.QUERY.warn(LOCALISER.msg("Candidates.ExtentCantBeNull"));
            return;
        }
        if (!(pcs instanceof Queryable)) {
            throw new JPOXUnsupportedOptionException(LOCALISER.msg("JDOQL.ExtentNotQueryableError", pcs.getClass().getName()));
        }
        this.setSubclasses(pcs.hasSubclasses());
        this.setClass(pcs.getCandidateClass());
        this.candidateExtent = pcs;
        this.candidateCollection = null;
    }

    public void setFrom(String from) {
        this.discardCompiled();
        this.assertIsModifiable();
        this.from = from;
    }

    public void setCandidates(Collection pcs) {
        this.discardCompiled();
        this.assertIsModifiable();
        if (pcs == null) {
            JPOXLogger.QUERY.warn(LOCALISER.msg("Candidates.CollectionCantBeNull"));
            return;
        }
        this.candidateExtent = null;
        this.candidateCollection = pcs;
    }

    protected String getSingleStringQuery() {
        if (this.singleString != null) {
            return this.singleString;
        }
        StringBuffer str = new StringBuffer("SELECT ");
        if (this.unique) {
            str.append("UNIQUE ");
        }
        if (this.result != null) {
            str.append(this.result + " ");
        }
        if (this.resultClassName != null) {
            str.append("INTO " + this.resultClassName + " ");
        }
        if (this.candidateClassName != null) {
            str.append("FROM " + this.candidateClassName + " ");
        }
        if (!this.subclasses) {
            str.append("EXCLUDE SUBCLASSES ");
        }
        if (this.filter != null) {
            str.append("WHERE " + this.filter + " ");
        }
        if (this.variables != null) {
            str.append("VARIABLES " + this.variables + " ");
        }
        if (this.parameters != null) {
            str.append("PARAMETERS " + this.parameters + " ");
        }
        if (this.imports != null) {
            str.append(this.imports + " ");
        }
        if (this.grouping != null) {
            str.append("GROUP BY " + this.grouping + " ");
        }
        if (this.ordering != null) {
            str.append("ORDER BY " + this.ordering + " ");
        }
        if (this.range != null) {
            str.append("RANGE " + this.range);
        } else if (this.fromInclNo > 0L || this.toExclNo != Long.MAX_VALUE) {
            str.append("RANGE " + this.fromInclNo + "," + this.toExclNo);
        }
        this.singleString = str.toString().trim();
        return this.singleString;
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.singleString = null;
        this.queryStmt = null;
        this.rof = null;
    }

    protected long performDeletePersistentAll(Map parameters) {
        boolean requiresUnique = this.unique;
        if (this.unique) {
            this.unique = false;
        }
        Collection results = this.performExecute(parameters);
        int number = 0;
        if (results == null) {
            number = 0;
        } else {
            number = results.size();
            if (requiresUnique && number > 1) {
                throw new JPOXUserException(LOCALISER.msg("Query.DeletePersistent.UniqueSpecifiedButMultipleResults"));
            }
            Iterator resultsIter = results.iterator();
            while (resultsIter.hasNext()) {
                PersistenceCapable pc = (PersistenceCapable)resultsIter.next();
                StateManager sm = this.om.findStateManager(pc);
                sm.flush();
            }
            this.om.deleteObjects(results);
            ((QueryResult)results).close();
        }
        return number;
    }

    public JDOQLResultSetMetaData getResultSetMetaData() {
        if (this.resultMetaData == null) {
            throw new JPOXUserException("You must compile the query before calling this method.");
        }
        return this.resultMetaData;
    }

    public Class resolveClassDeclaration(String classDecl) {
        AbstractClassMetaData acmd = this.getStoreManager().getMetaDataManager().getMetaDataForEntityName(classDecl);
        if (acmd != null) {
            classDecl = acmd.getFullClassName();
        }
        try {
            return this.parsedImports.resolveClassDeclaration(classDecl, this.om.getClassLoaderResolver(), this.getCandidateLoader());
        }
        catch (ClassNotResolvedException e) {
            throw new JPOXUserException(LOCALISER.msg("Query.ClassNameNotFoundError", classDecl));
        }
    }

    public String toString() {
        return this.getSingleStringQuery();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ExecutedCompileCache {
        private final QueryExpression queryStmt;
        private final String singleStringQuery;
        private final Queryable candidates;
        private final List parameterNames;

        public ExecutedCompileCache(QueryExpression queryStmt, String singleStringQuery, Queryable candidates, List parameterNames) {
            this.queryStmt = queryStmt;
            this.singleStringQuery = singleStringQuery;
            this.candidates = candidates;
            this.parameterNames = parameterNames;
        }

        public QueryExpression getQueryExpression() {
            return this.queryStmt;
        }

        public Queryable getCandidates() {
            return this.candidates;
        }

        public List getParameterNames() {
            return this.parameterNames;
        }

        public int hashCode() {
            return this.singleStringQuery.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ExecutedCompileCache)) {
                return false;
            }
            ExecutedCompileCache cached = (ExecutedCompileCache)obj;
            return cached.queryStmt.equals(this.queryStmt) && cached.singleStringQuery.equals(this.singleStringQuery);
        }
    }
}

