/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.query;

import java.util.StringTokenizer;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.query.AbstractJDOQLQuery;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class JDOQLSingleStringParser {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    private AbstractJDOQLQuery query;
    private String queryString;
    int keywordPosition = -1;

    public JDOQLSingleStringParser(AbstractJDOQLQuery query, String queryString) {
        JPOXLogger.QUERY.debug(LOCALISER.msg("JDOQL.SingleString.Query", queryString));
        this.query = query;
        this.queryString = queryString;
    }

    public void parse() {
        new Compiler(new Parser(this.queryString)).compile();
    }

    private boolean isKeyword(String token) {
        for (int i = 0; i < AbstractJDOQLQuery.SINGLE_STRING_KEYWORDS.length; ++i) {
            if (!token.equals(AbstractJDOQLQuery.SINGLE_STRING_KEYWORDS[i]) && !token.equals(AbstractJDOQLQuery.SINGLE_STRING_KEYWORDS_LOWERCASE[i])) continue;
            return true;
        }
        return token.equals("IMPORT") || token.equals("import");
    }

    private class Parser {
        final String[] tokens;
        final String[] keywords;
        int pos = -1;

        public Parser(String str) {
            StringTokenizer tokenizer = new StringTokenizer(str);
            this.tokens = new String[tokenizer.countTokens()];
            this.keywords = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.tokens[i] = tokenizer.nextToken();
                if (JDOQLSingleStringParser.this.isKeyword(this.tokens[i])) {
                    this.keywords[i] = this.tokens[i];
                }
                ++i;
            }
        }

        public String parseContent() {
            String content = "";
            while (this.pos < this.tokens.length - 1) {
                ++this.pos;
                if (JDOQLSingleStringParser.this.isKeyword(this.tokens[this.pos])) {
                    --this.pos;
                    break;
                }
                if (content.length() == 0) {
                    content = this.tokens[this.pos];
                    continue;
                }
                content = content + " " + this.tokens[this.pos];
            }
            return content;
        }

        public boolean parseKeyword(String keyword) {
            if (this.pos < this.tokens.length - 1) {
                ++this.pos;
                if (this.keywords[this.pos] != null && this.keywords[this.pos].equals(keyword)) {
                    return true;
                }
                --this.pos;
            }
            return false;
        }

        public String parseKeyword() {
            if (this.pos < this.tokens.length - 1) {
                ++this.pos;
                if (this.keywords[this.pos] != null) {
                    return this.keywords[this.pos];
                }
                --this.pos;
            }
            return null;
        }
    }

    private class Compiler {
        Parser tokenizer;

        Compiler(Parser tokenizer) {
            this.tokenizer = tokenizer;
        }

        private void compile() {
            this.compileSelect();
            String keyword = this.tokenizer.parseKeyword();
            if (keyword != null && JDOQLSingleStringParser.this.isKeyword(keyword)) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.QueryContainsOutOfOrderKeyword", keyword));
            }
        }

        private void compileSelect() {
            if (!this.tokenizer.parseKeyword("SELECT") && !this.tokenizer.parseKeyword("select")) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.NoSelectStart"));
            }
            if (this.tokenizer.parseKeyword("UNIQUE") || this.tokenizer.parseKeyword("unique")) {
                this.compileUnique();
            }
            this.compileResult();
            if (this.tokenizer.parseKeyword("INTO") || this.tokenizer.parseKeyword("into")) {
                this.compileInto();
            }
            if (this.tokenizer.parseKeyword("FROM") || this.tokenizer.parseKeyword("from")) {
                this.compileFrom();
            }
            if (this.tokenizer.parseKeyword("WHERE") || this.tokenizer.parseKeyword("where")) {
                this.compileWhere();
            }
            if (this.tokenizer.parseKeyword("VARIABLES") || this.tokenizer.parseKeyword("variables")) {
                this.compileVariables();
            }
            if (this.tokenizer.parseKeyword("PARAMETERS") || this.tokenizer.parseKeyword("parameters")) {
                this.compileParameters();
            }
            if (this.tokenizer.parseKeyword("import")) {
                this.compileImport();
            }
            if (this.tokenizer.parseKeyword("GROUP") || this.tokenizer.parseKeyword("group")) {
                this.compileGroup();
            }
            if (this.tokenizer.parseKeyword("ORDER") || this.tokenizer.parseKeyword("order")) {
                this.compileOrder();
            }
            if (this.tokenizer.parseKeyword("RANGE") || this.tokenizer.parseKeyword("range")) {
                this.compileRange();
            }
        }

        private void compileUnique() {
            JDOQLSingleStringParser.this.query.setUnique(true);
        }

        private void compileResult() {
            String content = this.tokenizer.parseContent();
            if (content.length() > 0) {
                JDOQLSingleStringParser.this.query.setResult(content);
            }
        }

        private void compileInto() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithoutValue", "INTO", "<result class>"));
            }
            JDOQLSingleStringParser.this.query.setResultClassName(content);
        }

        private void compileFrom() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithoutValue", "FROM", "<candidate class>"));
            }
            if (content.indexOf(32) > 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithIllegalValue", "FROM", content));
            }
            JDOQLSingleStringParser.this.query.setCandidateClassName(content);
            if (this.tokenizer.parseKeyword("EXCLUDE") || this.tokenizer.parseKeyword("exclude")) {
                if (!this.tokenizer.parseKeyword("SUBCLASSES") && !this.tokenizer.parseKeyword("subclasses")) {
                    throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.ExpectedKeywordAfter", "SUBCLASSES", "EXCLUDE"));
                }
                content = this.tokenizer.parseContent();
                if (content.length() > 0) {
                    throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithIllegalValue", "EXCLUDE SUBCLASSES", content));
                }
                JDOQLSingleStringParser.this.query.setSubclasses(false);
            }
        }

        private void compileWhere() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithoutValue", "WHERE", "<filter>"));
            }
            JDOQLSingleStringParser.this.query.setFilter(content);
        }

        private void compileVariables() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithoutValue", "VARIABLES", "<variable declarations>"));
            }
            JDOQLSingleStringParser.this.query.declareVariables(content);
        }

        private void compileParameters() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithoutValue", "PARAMETERS", "<parameter declarations>"));
            }
            JDOQLSingleStringParser.this.query.declareParameters(content);
        }

        private void compileImport() {
            String content = "import " + this.tokenizer.parseContent();
            while (this.tokenizer.parseKeyword("import")) {
                content = content + "import " + this.tokenizer.parseContent();
            }
            JDOQLSingleStringParser.this.query.declareImports(content);
        }

        private void compileGroup() {
            String content = this.tokenizer.parseContent();
            if (!this.tokenizer.parseKeyword("BY") && !this.tokenizer.parseKeyword("by")) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.ExpectedKeywordAfter", "BY", "GROUP"));
            }
            content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithoutValue", "GROUP BY", "<grouping>"));
            }
            JDOQLSingleStringParser.this.query.setGrouping(content);
        }

        private void compileOrder() {
            String content = this.tokenizer.parseContent();
            if (!this.tokenizer.parseKeyword("BY") && !this.tokenizer.parseKeyword("by")) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.ExpectedKeywordAfter", "BY", "ORDER"));
            }
            content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithoutValue", "ORDER BY", "<ordering>"));
            }
            JDOQLSingleStringParser.this.query.setOrdering(content);
        }

        private void compileRange() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JDOQL.SingleString.KeywordWithoutValue", "RANGE", "<range>"));
            }
            JDOQLSingleStringParser.this.query.setRange(content);
        }
    }
}

