/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.query;

import java.util.StringTokenizer;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.query.AbstractJPQLQuery;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class JPQLSingleStringParser {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.Localisation");
    private AbstractJPQLQuery query;
    private String queryString;
    int keywordPosition = -1;

    public JPQLSingleStringParser(AbstractJPQLQuery query, String queryString) {
        JPOXLogger.QUERY.debug(LOCALISER.msg("JPQL.SingleString.Query", queryString));
        this.query = query;
        this.queryString = queryString;
    }

    public void parse() {
        new Compiler(new Parser(this.queryString)).compile();
    }

    private boolean isKeyword(String token) {
        for (int i = 0; i < AbstractJPQLQuery.SINGLE_STRING_KEYWORDS.length; ++i) {
            if (!token.equalsIgnoreCase(AbstractJPQLQuery.SINGLE_STRING_KEYWORDS[i])) continue;
            return true;
        }
        return false;
    }

    private class Parser {
        final String[] tokens;
        final String[] keywords;
        int pos = -1;

        public Parser(String str) {
            StringTokenizer tokenizer = new StringTokenizer(str);
            this.tokens = new String[tokenizer.countTokens()];
            this.keywords = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                this.tokens[i++] = tokenizer.nextToken();
            }
            for (i = 0; i < this.tokens.length; ++i) {
                if (JPQLSingleStringParser.this.isKeyword(this.tokens[i])) {
                    this.keywords[i] = this.tokens[i];
                    continue;
                }
                if (i >= this.tokens.length - 1 || !JPQLSingleStringParser.this.isKeyword(this.tokens[i] + ' ' + this.tokens[i + 1])) continue;
                this.keywords[i] = this.tokens[i];
                this.keywords[++i] = this.tokens[i];
            }
        }

        public String parseContent() {
            String content = "";
            while (this.pos < this.tokens.length - 1) {
                ++this.pos;
                if (JPQLSingleStringParser.this.isKeyword(this.tokens[this.pos])) {
                    --this.pos;
                    break;
                }
                if (this.pos < this.tokens.length - 1 && JPQLSingleStringParser.this.isKeyword(this.tokens[this.pos] + ' ' + this.tokens[this.pos + 1])) {
                    --this.pos;
                    break;
                }
                if (content.length() == 0) {
                    content = this.tokens[this.pos];
                    continue;
                }
                content = content + " " + this.tokens[this.pos];
            }
            return content;
        }

        public boolean parseKeyword(String keyword) {
            if (this.pos < this.tokens.length - 1) {
                ++this.pos;
                if (this.keywords[this.pos] != null) {
                    if (this.keywords[this.pos].equals(keyword)) {
                        return true;
                    }
                    if (keyword.indexOf(32) > -1 && this.pos < this.keywords.length - 1 && (this.keywords[this.pos] + ' ' + this.keywords[this.pos + 1]).equals(keyword)) {
                        ++this.pos;
                        return true;
                    }
                }
                --this.pos;
            }
            return false;
        }

        public boolean parseKeywordIgnoreCase(String keyword) {
            if (this.pos < this.tokens.length - 1) {
                ++this.pos;
                if (this.keywords[this.pos] != null) {
                    if (this.keywords[this.pos].equalsIgnoreCase(keyword)) {
                        return true;
                    }
                    if (keyword.indexOf(32) > -1 && (this.keywords[this.pos] + ' ' + this.keywords[this.pos + 1]).equalsIgnoreCase(keyword)) {
                        ++this.pos;
                        return true;
                    }
                }
                --this.pos;
            }
            return false;
        }

        public String parseKeyword() {
            if (this.pos < this.tokens.length - 1) {
                ++this.pos;
                if (this.keywords[this.pos] != null) {
                    return this.keywords[this.pos];
                }
                --this.pos;
            }
            return null;
        }
    }

    private class Compiler {
        Parser tokenizer;

        Compiler(Parser tokenizer) {
            this.tokenizer = tokenizer;
        }

        private void compile() {
            this.compileSelect();
            String keyword = this.tokenizer.parseKeyword();
            if (keyword != null && JPQLSingleStringParser.this.isKeyword(keyword)) {
                throw new JPOXUserException(LOCALISER.msg("JPQL.SingleString.QueryContainsOutOfOrderKeyword", keyword));
            }
        }

        private void compileSelect() {
            if (!this.tokenizer.parseKeywordIgnoreCase("SELECT")) {
                throw new JPOXUserException(LOCALISER.msg("JPQL.SingleString.NoSelectStart"));
            }
            this.compileResult();
            if (this.tokenizer.parseKeywordIgnoreCase("FROM")) {
                this.compileFrom();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("WHERE")) {
                this.compileWhere();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("GROUP BY")) {
                this.compileGroup();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("HAVING")) {
                this.compileHaving();
            }
            if (this.tokenizer.parseKeywordIgnoreCase("ORDER BY")) {
                this.compileOrder();
            }
        }

        private void compileResult() {
            String content = this.tokenizer.parseContent();
            if (content.length() > 0) {
                JPQLSingleStringParser.this.query.setResult(content);
            }
        }

        private void compileFrom() {
            String content = this.tokenizer.parseContent();
            if (content.length() > 0) {
                JPQLSingleStringParser.this.query.setFrom(content);
            }
        }

        private void compileWhere() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JPQL.SingleString.KeywordWithoutValue", "WHERE", "<filter>"));
            }
            JPQLSingleStringParser.this.query.setFilter(content);
        }

        private void compileGroup() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JPQL.SingleString.KeywordWithoutValue", "GROUP BY", "<grouping>"));
            }
            JPQLSingleStringParser.this.query.setGrouping(content);
        }

        private void compileHaving() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JPQL.SingleString.KeywordWithoutValue", "HAVING", "<having>"));
            }
            JPQLSingleStringParser.this.query.setHaving(content);
        }

        private void compileOrder() {
            String content = this.tokenizer.parseContent();
            if (content.length() == 0) {
                throw new JPOXUserException(LOCALISER.msg("JPQL.SingleString.KeywordWithoutValue", "ORDER BY", "<ordering>"));
            }
            JPQLSingleStringParser.this.query.setOrdering(content);
        }
    }
}

