/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jpox.ConnectionFactory;
import org.jpox.ManagedConnection;
import org.jpox.OMFContext;
import org.jpox.ObjectManager;
import org.jpox.PersistenceConfiguration;
import org.jpox.exceptions.ConnectionFactoryNotFoundException;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.exceptions.UnsupportedConnectionFactoryException;
import org.jpox.store.rdbms.ConnectionProviderPriorityList;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.datasource.JPOXDataSourceFactory;
import org.jpox.transaction.TransactionUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.StringUtils;

public class ConnectionFactoryImpl
implements ConnectionFactory {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    Object[] dsTx;
    Object[] dsNonTx;
    OMFContext omfContext;

    public ConnectionFactoryImpl(OMFContext omfContext) {
        this.omfContext = omfContext;
        PersistenceConfiguration config = omfContext.getPersistenceConfiguration();
        this.initDataSourceTx(config);
        this.initDataSourceNonTx(config);
    }

    private void initDataSourceTx(PersistenceConfiguration config) {
        if (config.getConnectionFactory() != null) {
            if (!(config.getConnectionFactory() instanceof DataSource) && !(config.getConnectionFactory() instanceof XADataSource)) {
                throw new UnsupportedConnectionFactoryException(config.getConnectionFactory());
            }
            this.dsTx = new DataSource[1];
            this.dsTx[0] = config.getConnectionFactory();
        } else if (config.getConnectionFactoryName() != null) {
            String[] connectionFactoryNames = StringUtils.split(config.getConnectionFactoryName(), ",");
            this.dsTx = new DataSource[connectionFactoryNames.length];
            for (int i = 0; i < connectionFactoryNames.length; ++i) {
                this.dsTx[i] = this.lookupDataSource(connectionFactoryNames[i]);
            }
        } else {
            this.dsTx = new DataSource[1];
            String poolingType = config.getConnectionPoolingType();
            if (poolingType == null || poolingType.equalsIgnoreCase("None")) {
                poolingType = "default";
            }
            try {
                JPOXDataSourceFactory dataSourceFactory = (JPOXDataSourceFactory)this.omfContext.getPluginManager().createExecutableExtension("org.jpox.datasource", "name", poolingType, "class-name", null, null);
                if (dataSourceFactory == null) {
                    throw new JPOXUserException(LOCALISER_RDBMS.msg("DataSource.ConnectionPoolPluginNotFound", poolingType)).setFatal();
                }
                this.dsTx[0] = dataSourceFactory.makePooledDataSource(config.getConnectionDriverName(), config.getConnectionURL(), config.getConnectionUserName(), config.getConnectionPassword(), config.getConnectionPoolingConfigurationFile(), this.omfContext.getClassLoaderResolver(null));
            }
            catch (ClassNotFoundException cnfe) {
                throw new JPOXUserException(LOCALISER_RDBMS.msg("DataSource.ConnectionPoolPluginNotFound", poolingType), cnfe).setFatal();
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)e;
                    throw new JPOXException(LOCALISER_RDBMS.msg("DataSource.ConnectionPoolPluginError", poolingType, ite.getTargetException().getMessage()), ite.getTargetException()).setFatal();
                }
                throw new JPOXException(LOCALISER_RDBMS.msg("DataSource.ConnectionPoolPluginError", poolingType, e.getMessage()), e).setFatal();
            }
        }
    }

    private void initDataSourceNonTx(PersistenceConfiguration config) {
        if (config.getConnectionFactory2() != null) {
            if (!(config.getConnectionFactory2() instanceof DataSource) && !(config.getConnectionFactory2() instanceof XADataSource)) {
                throw new UnsupportedConnectionFactoryException(config.getConnectionFactory2());
            }
            this.dsNonTx = new DataSource[1];
            this.dsNonTx[0] = config.getConnectionFactory2();
        } else if (config.getConnectionFactory2Name() != null) {
            String[] connectionFactoryNames = StringUtils.split(config.getConnectionFactory2Name(), ",");
            this.dsNonTx = new DataSource[connectionFactoryNames.length];
            for (int i = 0; i < connectionFactoryNames.length; ++i) {
                this.dsNonTx[i] = this.lookupDataSource(connectionFactoryNames[i]);
            }
        } else if (config.getConnectionURL() != null) {
            this.dsNonTx = new DataSource[1];
            String poolingType = config.getConnectionPoolingType();
            if (poolingType == null || poolingType.equalsIgnoreCase("None")) {
                poolingType = "default";
            }
            try {
                JPOXDataSourceFactory dataSourceFactory = (JPOXDataSourceFactory)this.omfContext.getPluginManager().createExecutableExtension("org.jpox.datasource", "name", poolingType, "class-name", null, null);
                if (dataSourceFactory == null) {
                    throw new JPOXUserException(LOCALISER_RDBMS.msg("DataSource.ConnectionPoolPluginNotFound", poolingType)).setFatal();
                }
                this.dsNonTx[0] = dataSourceFactory.makePooledDataSource(config.getConnectionDriverName(), config.getConnectionURL(), config.getConnectionUserName(), config.getConnectionPassword(), config.getConnectionPoolingConfigurationFile(), this.omfContext.getClassLoaderResolver(null));
            }
            catch (ClassNotFoundException cnfe) {
                throw new JPOXUserException(LOCALISER_RDBMS.msg("DataSource.ConnectionPoolPluginNotFound", poolingType), cnfe).setFatal();
            }
            catch (Exception e) {
                if (e instanceof InvocationTargetException) {
                    InvocationTargetException ite = (InvocationTargetException)e;
                    throw new JPOXException(LOCALISER_RDBMS.msg("DataSource.ConnectionPoolPluginError", poolingType, ite.getTargetException().getMessage()), ite.getTargetException()).setFatal();
                }
                throw new JPOXException(LOCALISER_RDBMS.msg("DataSource.ConnectionPoolPluginError", poolingType, e.getMessage()), e).setFatal();
            }
        } else {
            this.dsNonTx = this.dsTx;
        }
    }

    public ManagedConnection getConnection(ObjectManager om, Map options) {
        HashMap<String, String> addedOptions = new HashMap<String, String>();
        if (options != null) {
            addedOptions.putAll(options);
        }
        addedOptions.put("resource-type", this.omfContext.getPersistenceConfiguration().getConnectionResourceType());
        return this.omfContext.getConnectionManager().allocateConnection(this, om, addedOptions);
    }

    public ManagedConnection createManagedConnection(Map transactionOptions) {
        return new ManagedConnectionImpl(transactionOptions);
    }

    private Object lookupDataSource(String name) {
        Object obj;
        try {
            obj = new InitialContext().lookup(name);
        }
        catch (NamingException e) {
            throw new ConnectionFactoryNotFoundException(name, e);
        }
        if (!(obj instanceof DataSource) && !(obj instanceof XADataSource)) {
            throw new UnsupportedConnectionFactoryException(obj);
        }
        return obj;
    }

    class EmulatedXAResource
    implements XAResource {
        Connection conn;

        EmulatedXAResource(Connection conn) {
            this.conn = conn;
        }

        public void commit(Xid arg0, boolean arg1) throws XAException {
            try {
                this.conn.commit();
            }
            catch (SQLException e) {
                new XAException(e.toString());
            }
        }

        public void end(Xid arg0, int arg1) throws XAException {
        }

        public void forget(Xid arg0) throws XAException {
        }

        public int getTransactionTimeout() throws XAException {
            return 0;
        }

        public boolean isSameRM(XAResource arg0) throws XAException {
            return arg0 instanceof EmulatedXAResource && this.conn.equals(((EmulatedXAResource)arg0).conn);
        }

        public int prepare(Xid arg0) throws XAException {
            return 0;
        }

        public Xid[] recover(int arg0) throws XAException {
            throw new XAException("Unsupported operation");
        }

        public void rollback(Xid arg0) throws XAException {
            try {
                this.conn.rollback();
            }
            catch (SQLException e) {
                new XAException(StringUtils.getStringFromStackTrace(e));
            }
        }

        public boolean setTransactionTimeout(int arg0) throws XAException {
            return false;
        }

        public void start(Xid arg0, int arg1) throws XAException {
        }
    }

    class ManagedConnectionImpl
    implements ManagedConnection {
        Object conn;
        boolean transactional = false;
        int isolation;

        ManagedConnectionImpl(Map transactionOptions) {
            this.isolation = transactionOptions != null && transactionOptions.get("transaction.isolation") != null ? ((Number)transactionOptions.get("transaction.isolation")).intValue() : ConnectionFactoryImpl.this.omfContext.getPersistenceConfiguration().getTransactionIsolation();
        }

        public void release() {
            if (!this.transactional) {
                this.close();
            }
        }

        public XAResource getXAResource() {
            if (this.getConnection() instanceof Connection) {
                return new EmulatedXAResource((Connection)this.getConnection());
            }
            try {
                return ((XAConnection)this.getConnection()).getXAResource();
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(e.getMessage(), e);
            }
        }

        public Object getConnection() {
            if (this.conn == null) {
                Connection cnx;
                block20: {
                    cnx = null;
                    try {
                        if (ConnectionFactoryImpl.this.omfContext.getStoreManager() != null && ConnectionFactoryImpl.this.omfContext.getStoreManager().getDatastoreAdapter() != null) {
                            RDBMSAdapter rdba = (RDBMSAdapter)ConnectionFactoryImpl.this.omfContext.getStoreManager().getDatastoreAdapter();
                            int actualIsolationLevel = this.isolation;
                            if (rdba.getRequiredTransactionIsolationLevel() >= 0) {
                                actualIsolationLevel = rdba.getRequiredTransactionIsolationLevel();
                            }
                            DataSource[] ds = (DataSource[])(this.transactional ? ConnectionFactoryImpl.this.dsTx : ConnectionFactoryImpl.this.dsNonTx);
                            cnx = new ConnectionProviderPriorityList().getConnection(ds);
                            boolean succeeded = false;
                            try {
                                if (actualIsolationLevel == 0) {
                                    if (!cnx.getAutoCommit()) {
                                        cnx.setAutoCommit(true);
                                    }
                                } else {
                                    if (cnx.getAutoCommit()) {
                                        cnx.setAutoCommit(false);
                                    }
                                    if (rdba.supportsTransactionIsolationLevel(actualIsolationLevel)) {
                                        cnx.setTransactionIsolation(actualIsolationLevel);
                                    } else {
                                        JPOXLogger.RDBMS.warn(LOCALISER_RDBMS.msg("RDBMS.Adapter.TransactionIsolationUnsupported", actualIsolationLevel));
                                    }
                                }
                                succeeded = true;
                                if (JPOXLogger.RDBMS.isDebugEnabled()) {
                                    JPOXLogger.RDBMS.debug(LOCALISER_RDBMS.msg("RDBMS.Connection.OpenedForIsolationLevel", cnx.toString(), TransactionUtils.getNameForTransactionIsolationLevel(actualIsolationLevel)));
                                }
                                if (actualIsolationLevel != this.isolation && this.isolation == 0 && !cnx.getAutoCommit()) {
                                    cnx.setAutoCommit(true);
                                }
                                break block20;
                            }
                            catch (SQLException e) {
                                throw new JPOXDataStoreException(e.getMessage(), e);
                            }
                            finally {
                                if (!succeeded && !cnx.isClosed()) {
                                    cnx.close();
                                }
                            }
                        }
                        cnx = ((DataSource)ConnectionFactoryImpl.this.dsTx[0]).getConnection();
                        if (JPOXLogger.RDBMS.isDebugEnabled()) {
                            JPOXLogger.RDBMS.debug(LOCALISER_RDBMS.msg("RDBMS.Connection.Opened", cnx.toString()));
                        }
                    }
                    catch (SQLException e) {
                        throw new JPOXDataStoreException(e.getMessage(), e);
                    }
                }
                this.conn = cnx;
            }
            return this.conn;
        }

        public void close() {
            if (this.getConnection() instanceof Connection) {
                try {
                    Connection conn;
                    if (!(this.transactional || (conn = (Connection)this.getConnection()).isClosed() || conn.getAutoCommit())) {
                        JPOXLogger.RDBMS.debug(LOCALISER_RDBMS.msg("RDBMS.Connection.NonElistedToTransactionCommitted", conn.toString()));
                        ((Connection)this.getConnection()).commit();
                    }
                    if (JPOXLogger.RDBMS.isDebugEnabled()) {
                        JPOXLogger.RDBMS.debug(LOCALISER_RDBMS.msg("RDBMS.Connection.Closed", this.conn.toString()));
                    }
                    ((Connection)this.getConnection()).close();
                }
                catch (SQLException e) {
                    throw new JPOXDataStoreException(e.getMessage(), e);
                }
            }
            try {
                if (!this.transactional && !((XAConnection)this.getConnection()).getConnection().getAutoCommit()) {
                    ((XAConnection)this.getConnection()).getConnection().commit();
                }
                ((XAConnection)this.getConnection()).getConnection().close();
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(e.getMessage(), e);
            }
        }

        public void setTransactional() {
            this.transactional = true;
        }
    }
}

