/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.jpox.ClassLoaderResolver;
import org.jpox.ConnectionFactory;
import org.jpox.ConnectionFactoryRegistry;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerFactoryImpl;
import org.jpox.PersistenceConfiguration;
import org.jpox.StateManager;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.exceptions.NoPersistenceInformationException;
import org.jpox.identity.OID;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.ClassPersistenceModifier;
import org.jpox.metadata.ExtensionMetaData;
import org.jpox.metadata.IdentityStrategy;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.InheritanceMetaData;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.metadata.MapMetaData;
import org.jpox.metadata.SequenceMetaData;
import org.jpox.metadata.TableGeneratorMetaData;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.DatastoreObject;
import org.jpox.store.Extent;
import org.jpox.store.FetchStatement;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.JPOXConnection;
import org.jpox.store.JPOXSequence;
import org.jpox.store.MappedStoreManager;
import org.jpox.store.SCOID;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreData;
import org.jpox.store.TableStoreData;
import org.jpox.store.exceptions.NoExtentException;
import org.jpox.store.fieldmanager.FieldManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.poid.PoidConnectionProvider;
import org.jpox.store.poid.PoidGenerator;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.ConnectionFactoryImpl;
import org.jpox.store.rdbms.ConnectionProvider;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.store.rdbms.JDOConnectionImpl;
import org.jpox.store.rdbms.JDOSequenceImpl;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.RDBMSStoreData;
import org.jpox.store.rdbms.RDBMSStoreHelper;
import org.jpox.store.rdbms.RequestIdentifier;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.adapter.RDBMSAdapterFactory;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.TableInfo;
import org.jpox.store.rdbms.extent.ClassTableExtent;
import org.jpox.store.rdbms.extent.ClassViewExtent;
import org.jpox.store.rdbms.fieldmanager.ResultSetGetter;
import org.jpox.store.rdbms.poid.AbstractRDBMSPoidGenerator;
import org.jpox.store.rdbms.request.DeleteRequest;
import org.jpox.store.rdbms.request.FetchRequest;
import org.jpox.store.rdbms.request.InsertRequest;
import org.jpox.store.rdbms.request.LocateRequest;
import org.jpox.store.rdbms.request.UpdateRequest;
import org.jpox.store.rdbms.scostore.AbstractArrayStore;
import org.jpox.store.rdbms.scostore.AbstractCollectionStore;
import org.jpox.store.rdbms.scostore.AbstractMapStore;
import org.jpox.store.rdbms.scostore.FKArrayStore;
import org.jpox.store.rdbms.scostore.FKListStore;
import org.jpox.store.rdbms.scostore.FKMapStore;
import org.jpox.store.rdbms.scostore.FKSetStore;
import org.jpox.store.rdbms.scostore.JoinArrayStore;
import org.jpox.store.rdbms.scostore.JoinListStore;
import org.jpox.store.rdbms.scostore.JoinMapStore;
import org.jpox.store.rdbms.scostore.JoinSetStore;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.store.rdbms.table.AbstractTable;
import org.jpox.store.rdbms.table.ArrayTable;
import org.jpox.store.rdbms.table.ClassTable;
import org.jpox.store.rdbms.table.ClassView;
import org.jpox.store.rdbms.table.CollectionTable;
import org.jpox.store.rdbms.table.ColumnCreator;
import org.jpox.store.rdbms.table.JoinTable;
import org.jpox.store.rdbms.table.MapTable;
import org.jpox.store.rdbms.table.ProbeTable;
import org.jpox.store.rdbms.table.Table;
import org.jpox.store.rdbms.table.TableImpl;
import org.jpox.store.rdbms.table.ViewImpl;
import org.jpox.store.scostore.ArrayStore;
import org.jpox.store.scostore.CollectionStore;
import org.jpox.store.scostore.MapStore;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;
import org.jpox.util.MacroString;
import org.jpox.util.SoftValueMap;
import org.jpox.util.StringUtils;
import org.jpox.util.TypeConversionHelper;

public class RDBMSManager
extends MappedStoreManager {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    private static final int COLUMN_INFO_EXPIRATION_MS = 300000;
    private String catalogName = null;
    private String schemaName = null;
    private Map columnInfoByTableName = new HashMap();
    private Map columnInfoByColumnName = new HashMap();
    private long columnInfoReadTimestamp = -1L;
    private Map requestsByID = Collections.synchronizedMap(new SoftValueMap());
    private ConnectionProvider connProvider;
    private SQLController sqlController = null;
    private ClassAdder classAdder = null;
    static /* synthetic */ Class class$org$jpox$store$DatastoreAdapter;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jpox$exceptions$JPOXException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDBMSManager(ClassLoaderResolver clr, ObjectManagerFactoryImpl omf) {
        super(clr, omf);
        try {
            this.connProvider = (ConnectionProvider)omf.getOMFContext().getPluginManager().createExecutableExtension("org.jpox.store_connectionprovider", "name", omf.getPersistenceConfiguration().getConnectionProviderName(), "class-name", null, null);
            if (this.connProvider == null) {
                throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.Manager.ConnectionProviderUnavailable", omf.getPersistenceConfiguration().getConnectionProviderName())).setFatal();
            }
            this.connProvider.setFailOnError(omf.getPersistenceConfiguration().getConnectionProviderFailOnError());
        }
        catch (Exception e) {
            throw new JPOXException(LOCALISER.msg("RDBMS.Manager.ConnectionProviderError", omf.getPersistenceConfiguration().getConnectionProviderName(), e.getMessage()), e).setFatal();
        }
        try {
            ManagedConnection mc = this.getConnection();
            Connection conn = (Connection)mc.getConnection();
            if (conn == null) {
                throw new JPOXDataStoreException(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionUnknownError"));
            }
            try {
                this.dba = RDBMSAdapterFactory.getInstance().getDatastoreAdapter(clr, conn, omf.getPersistenceConfiguration().getDatastoreAdapterClassName(), omf.getOMFContext().getPluginManager());
                this.dba.loadDatastoreMapping(omf.getOMFContext().getPluginManager(), clr);
                if (omf.getPersistenceConfiguration().getCatalog() != null && !((RDBMSAdapter)this.dba).supportsCatalogsInTableDefinitions()) {
                    JPOXLogger.RDBMS.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.DefaultCatalogNameUnusable", omf.getPersistenceConfiguration().getCatalog()));
                }
                if (omf.getPersistenceConfiguration().getSchema() != null && !((RDBMSAdapter)this.dba).supportsSchemasInTableDefinitions()) {
                    JPOXLogger.RDBMS.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.DefaultSchemaNameUnusable", omf.getPersistenceConfiguration().getSchema()));
                }
                this.initialiseIdentifierFactory(omf);
                this.sqlController = new SQLController(((RDBMSAdapter)this.dba).supportsStatementBatching(), omf.getPersistenceConfiguration().getStatementBatchLimit(), omf.getPersistenceConfiguration().getQueryTimeout());
                String autoStartMechanism = omf.getPersistenceConfiguration().getAutoStartMechanism();
                if (autoStartMechanism == null) {
                    autoStartMechanism = "SchemaTableOld";
                }
                this.initialiseSchema(autoStartMechanism, omf.getPersistenceConfiguration().getAutoStartMechanismMode(), conn, clr);
            }
            finally {
                mc.close();
            }
        }
        catch (JPOXException jpex) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseInitialisationError"), jpex);
            throw jpex.setFatal();
        }
        catch (Exception e1) {
            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseInitialisationError") + ' ' + LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseInitialisationAdvice") + ' ' + LOCALISER_RDBMS.msg("RDBMS.Exception", e1);
            JPOXLogger.RDBMS_SCHEMA.error(msg, e1);
            throw new JPOXUserException(msg, e1).setFatal();
        }
        finally {
            this.logConfiguration();
        }
    }

    protected void logConfiguration() {
        if (JPOXLogger.RDBMS.isDebugEnabled()) {
            PersistenceConfiguration omfConfig = this.getOMFContext().getPersistenceConfiguration();
            JPOXLogger.RDBMS.debug("======================= Datastore =========================");
            JPOXLogger.RDBMS.debug("StoreManager : " + this.getClass().getName());
            JPOXLogger.RDBMS.debug("AutoStart : mechanism=" + this.autoStartMechanism + ", mode=" + omfConfig.getAutoStartMechanismMode() + (omfConfig.getAutoStartClassNames() != null ? ", classes=" + omfConfig.getAutoStartClassNames() : ""));
            JPOXLogger.RDBMS.debug("Connection Pooling : " + omfConfig.getConnectionPoolingType());
            if (this.identifierFactory != null) {
                JPOXLogger.RDBMS.debug("Datastore Identifiers : factory=\"" + omfConfig.getIdentifierFactory() + "\"" + " case=" + this.identifierFactory.getNameOfIdentifierCase() + (omfConfig.getCatalog() != null ? " catalog=" + omfConfig.getCatalog() : "") + (omfConfig.getSchema() != null ? " schema=" + omfConfig.getSchema() : ""));
            }
            JPOXLogger.RDBMS.debug("Datastore : " + (omfConfig.getReadOnlyDatastore() ? "read-only" : "read-write") + (omfConfig.getFixedDatastore() ? ", fixed" : "") + (omfConfig.getUseUpdateLock() ? ", useUpdateLock" : "") + (omfConfig.getCheckExistTablesOrViews() ? ", checkTableViewExistence" : "") + ", rdbmsConstraintCreateMode=" + omfConfig.getRDBMSConstraintCreateMode() + ", initialiseColumnInfo=" + omfConfig.getInitializeColumnInfo());
            StringBuffer autoCreateOptions = null;
            if (omfConfig.getAutoCreateTables() || omfConfig.getAutoCreateColumns() || omfConfig.getAutoCreateConstraints()) {
                autoCreateOptions = new StringBuffer();
                boolean first = true;
                if (omfConfig.getAutoCreateTables()) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Tables");
                    first = false;
                }
                if (omfConfig.getAutoCreateColumns()) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Columns");
                    first = false;
                }
                if (omfConfig.getAutoCreateConstraints()) {
                    if (!first) {
                        autoCreateOptions.append(",");
                    }
                    autoCreateOptions.append("Constraints");
                    first = false;
                }
            }
            StringBuffer validateOptions = null;
            if (omfConfig.getValidateTables() || omfConfig.getValidateColumns() || omfConfig.getValidateConstraints()) {
                validateOptions = new StringBuffer();
                boolean first = true;
                if (omfConfig.getValidateTables()) {
                    validateOptions.append("Tables");
                    first = false;
                }
                if (omfConfig.getValidateColumns()) {
                    if (!first) {
                        validateOptions.append(",");
                    }
                    validateOptions.append("Columns");
                    first = false;
                }
                if (omfConfig.getValidateConstraints()) {
                    if (!first) {
                        validateOptions.append(",");
                    }
                    validateOptions.append("Constraints");
                    first = false;
                }
            }
            JPOXLogger.RDBMS.debug("Schema Control : AutoCreate(" + (autoCreateOptions != null ? autoCreateOptions.toString() : "None") + ")" + ", Validate(" + (validateOptions != null ? validateOptions.toString() : "None") + ")");
            JPOXLogger.RDBMS.debug("Statement Batching : max-batch-size=" + (omfConfig.getStatementBatchLimit() == -1 ? "UNLIMITED" : "" + omfConfig.getStatementBatchLimit()));
            Object[] queryLanguages = this.getOMFContext().getPluginManager().getAttributeValuesForExtension("org.jpox.store_query_query", "datastore", "jdbc", "name");
            JPOXLogger.RDBMS.debug("Query Languages : " + StringUtils.objectArrayToString(queryLanguages));
            JPOXLogger.RDBMS.debug("Queries : Timeout=" + omfConfig.getQueryTimeout());
            JPOXLogger.RDBMS.debug("Queries : Fetching size=" + omfConfig.getQueryFetchSize() + ", direction=" + omfConfig.getQueryFetchDirection());
            JPOXLogger.RDBMS.debug("Queries : ResultSet type=" + omfConfig.getQueryResultSetType() + ", concurrency=" + omfConfig.getQueryResultSetConcurrency());
            if (this.dba != null) {
                ((RDBMSAdapter)this.dba).logConfiguration();
            }
            JPOXLogger.RDBMS.debug("===========================================================");
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return new ConnectionFactoryImpl(this.omfContext);
    }

    protected void initialiseIdentifierFactory(ObjectManagerFactoryImpl omf) {
        String idFactoryName = omf.getPersistenceConfiguration().getIdentifierFactory();
        String idFactoryClassName = this.omfContext.getPluginManager().getAttributeValueForExtension("org.jpox.store_identifierfactory", "name", idFactoryName, "class-name");
        if (idFactoryClassName == null) {
            throw new JPOXUserException(LOCALISER.msg("IdentifierFactory.FactoryNotFound", idFactoryName)).setFatal();
        }
        try {
            Class<?> cls = Class.forName(idFactoryClassName);
            Class[] argTypes = new Class[]{class$org$jpox$store$DatastoreAdapter == null ? (class$org$jpox$store$DatastoreAdapter = RDBMSManager.class$("org.jpox.store.DatastoreAdapter")) : class$org$jpox$store$DatastoreAdapter, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = RDBMSManager.class$("java.lang.String")) : class$java$lang$String};
            Object[] args = new Object[]{this.dba, omf.getPersistenceConfiguration().getCatalog(), omf.getPersistenceConfiguration().getSchema(), omf.getPersistenceConfiguration().getIdentifierCase(), omf.getPersistenceConfiguration().getIdentifierWordSeparator(), omf.getPersistenceConfiguration().getIdentifierTablePrefix(), omf.getPersistenceConfiguration().getIdentifierTableSuffix()};
            this.identifierFactory = (IdentifierFactory)ClassUtils.newInstance(cls, argTypes, args);
        }
        catch (ClassNotFoundException cnfe) {
            throw new JPOXUserException(LOCALISER.msg("IdentifierFactory.FactoryClassNotFound", idFactoryName, idFactoryClassName), cnfe).setFatal();
        }
        catch (Exception e) {
            JPOXLogger.PERSISTENCE.error(e);
            throw new JPOXException(LOCALISER.msg("IdentifierFactory.FactoryError", idFactoryClassName), e).setFatal();
        }
    }

    public void close() {
        super.close();
        this.requestsByID.clear();
        this.columnInfoByTableName.clear();
        this.columnInfoByColumnName.clear();
        this.classAdder = null;
    }

    public boolean supportsQueryLanguage(String language) {
        if (language == null) {
            return false;
        }
        String name = this.getOMFContext().getPluginManager().getAttributeValueForExtension("org.jpox.store_query_query", new String[]{"name", "datastore"}, new String[]{language, "jdbc"}, "name");
        return name != null;
    }

    public JPOXSequence getJPOXSequence(ObjectManager om, SequenceMetaData seqmd) {
        return new JDOSequenceImpl(om, this, seqmd);
    }

    public JPOXConnection getJPOXConnection(final ObjectManager om) {
        final boolean enlisted = om.getTransaction().isActive();
        ConnectionFactory cf = null;
        cf = enlisted ? this.getOMFContext().getConnectionFactoryRegistry().lookupConnectionFactory("rdbms/tx") : this.getOMFContext().getConnectionFactoryRegistry().lookupConnectionFactory("rdbms/nontx");
        final ManagedConnection mc = cf.getConnection(enlisted ? om : null, null);
        this.getOMFContext().getConnectionManager().lockConnection(om);
        return new JDOConnectionImpl(mc.getConnection(), new Runnable(){

            public void run() {
                RDBMSManager.this.getOMFContext().getConnectionManager().unlockConnection(om);
                if (!enlisted) {
                    try {
                        ((Connection)mc.getConnection()).close();
                    }
                    catch (SQLException sqle) {
                        throw new JPOXDataStoreException(sqle.getMessage());
                    }
                }
            }
        });
    }

    public SQLController getSQLController() {
        return this.sqlController;
    }

    public void flush(ObjectManager om) {
        ManagedConnection mconn = this.getConnection(om);
        try {
            Connection conn = (Connection)mconn.getConnection();
            this.sqlController.processStatementsForConnection(conn);
        }
        catch (SQLException sqe) {
            throw new JPOXDataStoreException("Exception thrown flushing changes to datastore", sqe);
        }
    }

    public ManagedConnection getConnection() throws SQLException {
        ConnectionFactoryRegistry registry = this.getOMFContext().getConnectionFactoryRegistry();
        ConnectionFactory connFactory = registry.lookupConnectionFactory("rdbms/tx");
        return connFactory.getConnection(null, null);
    }

    public ManagedConnection getConnection(ObjectManager om) {
        ConnectionFactoryRegistry registry = om.getOMFContext().getConnectionFactoryRegistry();
        ConnectionFactory connFactory = registry.lookupConnectionFactory("rdbms/tx");
        return connFactory.getConnection(om, null);
    }

    public ManagedConnection getConnection(int isolation_level) throws SQLException {
        ConnectionFactoryRegistry registry = this.omfContext.getConnectionFactoryRegistry();
        ConnectionFactory connFactory = registry.lookupConnectionFactory("rdbms/nontx");
        HashMap<String, Integer> options = new HashMap<String, Integer>();
        options.put("transaction.isolation", new Integer(isolation_level));
        return connFactory.getConnection(null, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseSchema(String auto_start_mechanism, String auto_start_mechanism_mode, Connection conn, ClassLoaderResolver clr) throws Exception {
        block18: {
            RDBMSAdapter rdba = (RDBMSAdapter)this.dba;
            if (this.omfContext.getPersistenceConfiguration().getCatalog() != null && rdba.supportsCatalogsInTableDefinitions() || this.omfContext.getPersistenceConfiguration().getSchema() != null && rdba.supportsSchemasInTableDefinitions()) {
                this.catalogName = this.omfContext.getPersistenceConfiguration().getCatalog();
                this.schemaName = this.omfContext.getPersistenceConfiguration().getSchema();
            } else {
                try {
                    try {
                        this.catalogName = rdba.getCatalogName(conn);
                        this.schemaName = rdba.getSchemaName(conn);
                    }
                    catch (UnsupportedOperationException e) {
                        if (this.readOnlyDatastore || this.fixedDatastore) break block18;
                        ProbeTable pt = new ProbeTable(this);
                        pt.initialize(clr);
                        pt.create(conn);
                        try {
                            String[] schema_details = pt.findSchemaDetails(conn);
                            if (schema_details != null) {
                                this.catalogName = schema_details[0];
                                this.schemaName = schema_details[1];
                            }
                        }
                        finally {
                            pt.drop(conn);
                        }
                    }
                }
                catch (SQLException e) {
                    String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError") + ' ' + LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseInitialisationAdvice") + ' ' + e.toString();
                    JPOXLogger.RDBMS_SCHEMA.warn(msg);
                }
            }
        }
        if (!this.readOnlyDatastore) {
            this.dba.initialiseDatastore(conn);
        }
        if ((this.readOnlyDatastore || this.fixedDatastore) && auto_start_mechanism.equals("SchemaTable")) {
            auto_start_mechanism = "None";
        }
        if (JPOXLogger.RDBMS_SCHEMA.isInfoEnabled()) {
            JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataInitialise", this.catalogName, this.schemaName, auto_start_mechanism));
        }
        this.initialiseAutoStart(auto_start_mechanism, auto_start_mechanism_mode, clr);
        if (JPOXLogger.RDBMS_SCHEMA.isInfoEnabled()) {
            if (this.readOnlyDatastore) {
                JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataInitialisedReadOnly", this.catalogName, this.schemaName, "" + this.storeDataMgr.size()));
            } else if (this.fixedDatastore) {
                JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataInitialisedFixed", this.catalogName, this.schemaName, "" + this.storeDataMgr.size()));
            } else {
                JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataInitialised", this.catalogName, this.schemaName, "" + this.storeDataMgr.size()));
            }
        }
    }

    private void clearSchemaData() {
        this.deregisterAllStoreData();
        this.columnInfoByTableName.clear();
        this.columnInfoReadTimestamp = -1L;
        this.requestsByID.clear();
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void addClasses(String[] classNames, ClassLoaderResolver clr) {
        this.addClasses(classNames, clr, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClasses(String[] classNames, ClassLoaderResolver clr, Writer writer, boolean completeDdl) {
        if (writer != null) {
            AbstractTable.setDdlWriter(writer);
        }
        AbstractTable.setCompleteDdl(completeDdl);
        RDBMSManager rDBMSManager = this;
        synchronized (rDBMSManager) {
            if (this.classAdder != null) {
                this.classAdder.addClasses(classNames, clr);
                return;
            }
        }
        if (classNames != null && classNames.length > 0) {
            new ClassAdder(classNames, writer).execute(clr);
        }
    }

    public void removeAllClasses(ClassLoaderResolver clr) {
        MgmtTransaction mtx = new MgmtTransaction(2){

            public String toString() {
                return LOCALISER_RDBMS.msg("RDBMS.Manager.RemoveAllClassesFromSchema", RDBMSManager.this.catalogName, RDBMSManager.this.schemaName);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void run(ClassLoaderResolver clr) throws SQLException {
                RDBMSManager rDBMSManager = RDBMSManager.this;
                synchronized (rDBMSManager) {
                    boolean success = true;
                    try {
                        JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.RemoveAllClassesFromSchema", RDBMSManager.this.catalogName, RDBMSManager.this.schemaName));
                        HashMap<DatastoreIdentifier, DatastoreContainerObject> baseTablesByName = new HashMap<DatastoreIdentifier, DatastoreContainerObject>();
                        HashMap<DatastoreIdentifier, DatastoreContainerObject> viewsByName = new HashMap<DatastoreIdentifier, DatastoreContainerObject>();
                        Iterator i = RDBMSManager.this.storeDataMgr.getManagedStoreData().iterator();
                        while (i.hasNext()) {
                            RDBMSStoreData data = (RDBMSStoreData)i.next();
                            if (JPOXLogger.RDBMS_SCHEMA.isInfoEnabled()) {
                                JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.RemoveClass", data.getName()));
                            }
                            if (!data.hasTable()) continue;
                            if (data.mapsToView()) {
                                viewsByName.put(data.getDatastoreIdentifier(), data.getDatastoreContainerObject());
                                continue;
                            }
                            baseTablesByName.put(data.getDatastoreIdentifier(), data.getDatastoreContainerObject());
                        }
                        Iterator viewsIter = viewsByName.values().iterator();
                        while (viewsIter.hasNext()) {
                            ((ViewImpl)viewsIter.next()).drop(this.getCurrentConnection());
                        }
                        Iterator tablesIter = baseTablesByName.values().iterator();
                        while (tablesIter.hasNext()) {
                            ((TableImpl)tablesIter.next()).dropConstraints(this.getCurrentConnection());
                        }
                        tablesIter = baseTablesByName.values().iterator();
                        while (tablesIter.hasNext()) {
                            ((TableImpl)tablesIter.next()).drop(this.getCurrentConnection());
                        }
                    }
                    catch (Exception e) {
                        success = false;
                        String errorMsg = LOCALISER_RDBMS.msg("RDBMS.Manager.RemoveClassesExceptionError", e);
                        JPOXLogger.RDBMS_SCHEMA.error(errorMsg);
                        throw new JPOXUserException(errorMsg, e);
                    }
                    finally {
                        if (success) {
                            RDBMSManager.this.clearSchemaData();
                        }
                    }
                }
            }
        };
        mtx.execute(clr);
    }

    public FetchStatement getFetchStatement(DatastoreContainerObject table) {
        return new RDBMSFetchStatement(table);
    }

    public FieldManager getFieldManagerForResultProcessing(StateManager sm, Object rs, StatementExpressionIndex[] stmtExprIndx) {
        return new ResultSetGetter(sm, (ResultSet)rs, stmtExprIndx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized DatastoreContainerObject newJoinDatastoreContainerObject(AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        AbstractMemberMetaData[] relatedMmds;
        if (fmd.getJoinMetaData() == null && ((relatedMmds = fmd.getRelatedMemberMetaData(clr)) == null || relatedMmds[0].getJoinMetaData() == null)) {
            Class element_class;
            if (fmd.hasCollection()) {
                element_class = clr.classForName(fmd.getCollection().getElementType());
            } else if (fmd.hasMap()) {
                MapMetaData mmd = (MapMetaData)fmd.getContainer();
                if (fmd.getValueMetaData() != null && fmd.getValueMetaData().getMappedBy() != null) {
                    element_class = clr.classForName(mmd.getKeyType());
                } else {
                    if (fmd.getKeyMetaData() == null || fmd.getKeyMetaData().getMappedBy() == null) throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.MapWithoutJoinWithoutMappedBy", fmd.getFullFieldName()));
                    element_class = clr.classForName(mmd.getValueType());
                }
            } else {
                if (!fmd.hasArray()) return null;
                element_class = clr.classForName(fmd.getTypeName()).getComponentType();
            }
            if (this.getMetaDataManager().getMetaDataForClass(element_class, clr) != null) {
                return null;
            }
            if (!this.getOMFContext().getTypeManager().isReferenceType(element_class)) throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.NonPersistenceCapableCollectionElementNeedsJoin", fmd.getFullFieldName(), fmd.toString()));
            return null;
        }
        DatastoreContainerObject joinTable = this.getDatastoreContainerObject(fmd);
        if (joinTable != null) {
            return joinTable;
        }
        if (this.classAdder == null) {
            throw new IllegalStateException(LOCALISER_RDBMS.msg("RDBMS.Manager.JoinTableCreationError"));
        }
        if (fmd.getType().isArray()) {
            return this.classAdder.addJoinTableForContainer(fmd, clr, 3);
        }
        if (!this.getOMFContext().getTypeManager().isSCOMap(fmd.getType())) return this.classAdder.addJoinTableForContainer(fmd, clr, 1);
        return this.classAdder.addJoinTableForContainer(fmd, clr, 2);
    }

    public CollectionStore getBackingStoreForCollection(AbstractMemberMetaData fmd, DatastoreObject datastoreTable, ClassLoaderResolver clr, boolean instantiated, boolean listBased) {
        AbstractCollectionStore store = null;
        store = !instantiated ? (datastoreTable == null ? (this.getOMFContext().getTypeManager().isSCOList(fmd.getType()) ? new FKListStore(fmd, this, clr) : new FKSetStore(fmd, this, clr)) : (this.getOMFContext().getTypeManager().isSCOList(fmd.getType()) ? new JoinListStore(fmd, (CollectionTable)datastoreTable, clr) : new JoinSetStore(fmd, (CollectionTable)datastoreTable, clr))) : (datastoreTable == null ? (listBased ? new FKListStore(fmd, this, clr) : new FKSetStore(fmd, this, clr)) : (listBased ? new JoinListStore(fmd, (CollectionTable)datastoreTable, clr) : new JoinSetStore(fmd, (CollectionTable)datastoreTable, clr)));
        return store;
    }

    public MapStore getBackingStoreForMap(AbstractMemberMetaData fmd, DatastoreObject datastoreTable, ClassLoaderResolver clr) {
        AbstractMapStore store = null;
        store = datastoreTable == null ? new FKMapStore(fmd, this, clr) : new JoinMapStore((MapTable)datastoreTable, clr);
        return store;
    }

    public ArrayStore getBackingStoreForArray(AbstractMemberMetaData fmd, DatastoreObject datastoreTable, ClassLoaderResolver clr) {
        AbstractArrayStore store = null;
        store = datastoreTable != null ? new JoinArrayStore((ArrayTable)datastoreTable, clr) : new FKArrayStore(fmd, this, clr);
        return store;
    }

    public String getClassNameForObjectID(Object id, ClassLoaderResolver clr, ObjectManager om) {
        RDBMSStoreData data;
        AbstractCollection subclasses;
        if (id instanceof SCOID) {
            return ((SCOID)id).getSCOClass();
        }
        ArrayList<StoreData> classTree = new ArrayList<StoreData>();
        String targetClassName = null;
        AbstractClassMetaData cmd = null;
        ApiAdapter api = this.getApiAdapter();
        if (id instanceof OID) {
            OID oid = (OID)id;
            cmd = this.getMetaDataManager().getMetaDataForClass(oid.getPcClass(), clr);
            if (cmd.getDiscriminatorStrategy() == null) {
                subclasses = new ArrayList(this.getSubClassesForClass(oid.getPcClass(), true, clr));
                if (subclasses.size() < 1) {
                    JPOXLogger.PERSISTENCE.debug("1) Id \"" + id + "\" has been determined to be the id of class " + oid.getPcClass());
                    return oid.getPcClass();
                }
                targetClassName = oid.getPcClass();
            }
        } else if (api.isSingleFieldIdentity(id)) {
            targetClassName = api.getTargetClassForSingleFieldIdentity(id).getName();
            cmd = this.getMetaDataManager().getMetaDataForClass(targetClassName, clr);
            if (cmd.getIdentityType() != IdentityType.APPLICATION || !cmd.getObjectidClass().equals(id.getClass().getName())) {
                throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.IDAssignedToIncorrectClass", id, cmd.getFullClassName()));
            }
            if (cmd.getDiscriminatorStrategy() != null) {
                targetClassName = null;
            }
        } else {
            Collection c = this.storeDataMgr.getByPrimaryKeyClass(id.getClass().getName());
            if (c != null) {
                Iterator iter = c.iterator();
                while (iter.hasNext()) {
                    RDBMSStoreData store_data = (RDBMSStoreData)iter.next();
                    if (!store_data.hasTable()) continue;
                    classTree.add(store_data);
                }
            }
        }
        if (targetClassName != null && (data = (RDBMSStoreData)this.storeDataMgr.get(targetClassName)) != null) {
            if (data.hasTable()) {
                classTree.add(data);
            }
            subclasses = this.getSubClassesForClass(targetClassName, true, clr);
            Iterator subclassesIter = ((HashSet)subclasses).iterator();
            while (subclassesIter.hasNext()) {
                String subclassName = (String)subclassesIter.next();
                RDBMSStoreData subclassData = (RDBMSStoreData)this.storeDataMgr.get(subclassName);
                if (!subclassData.hasTable()) continue;
                classTree.add(subclassData);
            }
        }
        if (classTree.size() == 0 && (cmd == null || cmd.getDiscriminatorStrategy() == null)) {
            JPOXLogger.PERSISTENCE.debug("2) Id \"" + id + "\" has not determined to the class");
            return null;
        }
        if (classTree.size() == 1 && ((cmd = this.getMetaDataManager().getMetaDataForClass(((RDBMSStoreData)classTree.get(0)).getName(), clr)) == null || cmd.getDiscriminatorStrategy() == null)) {
            JPOXLogger.PERSISTENCE.debug("3) Id \"" + id + "\" has been determined to be the id of class " + ((RDBMSStoreData)classTree.get(0)).getName());
            return ((RDBMSStoreData)classTree.get(0)).getName();
        }
        if (om != null) {
            String className = null;
            if (cmd != null && cmd.getDiscriminatorStrategy() != null) {
                DatastoreClass primaryTable = om.getStoreManager().getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver());
                if (primaryTable != null) {
                    classTree.add(this.storeDataMgr.get(cmd.getFullClassName()));
                    HashSet subclasses2 = this.getSubClassesForClass(cmd.getFullClassName(), true, clr);
                    Iterator subclassesIter = subclasses2.iterator();
                    while (subclassesIter.hasNext()) {
                        String subclassName = (String)subclassesIter.next();
                        RDBMSStoreData subclassData = (RDBMSStoreData)this.storeDataMgr.get(subclassName);
                        if (!subclassData.hasTable()) continue;
                        classTree.add(subclassData);
                    }
                    className = RDBMSStoreHelper.getClassNameForIdKeyUsingDiscriminator(om, this, id, classTree);
                    if (className != null) {
                        JPOXLogger.PERSISTENCE.debug("4) Id \"" + id + "\" has been determined to be the id of class " + className);
                        return className;
                    }
                    return null;
                }
            } else {
                className = RDBMSStoreHelper.getClassNameForIdKeyUsingUnion(om, this, id, classTree);
            }
            if (className != null) {
                JPOXLogger.PERSISTENCE.debug("6) Id \"" + id + "\" has been determined to be the id of class " + className);
                return className;
            }
            if (id instanceof OID) {
                JPOXLogger.PERSISTENCE.debug("7) Id \"" + id + "\" has been determined to be the id of class " + ((OID)id).getPcClass());
                return ((OID)id).getPcClass();
            }
        } else {
            JPOXLogger.PERSISTENCE.debug("8) Id \"" + id + "\" has been determined to be the id of class " + ((RDBMSStoreData)classTree.get(0)).getName());
            return ((RDBMSStoreData)classTree.get(0)).getName();
        }
        return null;
    }

    public Extent getExtent(ObjectManager om, Class c, boolean subclasses) {
        AbstractClassMetaData cmd = this.getMetaDataManager().getMetaDataForClass(c, om.getClassLoaderResolver());
        if (!cmd.isRequiresExtent()) {
            throw new NoExtentException(c.getName());
        }
        DatastoreClass t = this.getDatastoreClass(cmd.getFullClassName(), om.getClassLoaderResolver());
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
            HashSet subclassNames;
            HashSet<DatastoreClass> candidateTables = new HashSet<DatastoreClass>();
            if (t != null) {
                candidateTables.add(t);
            }
            if (subclasses && (subclassNames = this.getSubClassesForClass(cmd.getFullClassName(), subclasses, om.getClassLoaderResolver())) != null) {
                Iterator subclassIter = subclassNames.iterator();
                while (subclassIter.hasNext()) {
                    String subclassName = (String)subclassIter.next();
                    DatastoreClass tbl = this.getDatastoreClass(subclassName, om.getClassLoaderResolver());
                    if (tbl == null) continue;
                    candidateTables.add(tbl);
                }
            }
            return new ClassTableExtent(om, candidateTables.toArray(new DatastoreClass[candidateTables.size()]), c, subclasses, cmd);
        }
        if (t instanceof ClassView) {
            return new ClassViewExtent(om, t, c, subclasses, cmd);
        }
        if (t instanceof ClassTable) {
            return new ClassTableExtent(om, t, c, subclasses, cmd);
        }
        AbstractClassMetaData[] cmds = this.getClassesManagingTableForClass(cmd, om.getClassLoaderResolver());
        if (cmds != null) {
            DatastoreClass[] tables = new DatastoreClass[cmds.length];
            for (int i = 0; i < cmds.length; ++i) {
                tables[i] = this.getDatastoreClass(cmds[i].getFullClassName(), om.getClassLoaderResolver());
            }
            return new ClassTableExtent(om, tables, c, subclasses, cmd);
        }
        throw new JPOXUserException("Attempt to create an Extent for class " + c.getName() + " which has MetaData, yet no table was found! This should be impossible");
    }

    public synchronized Object getStrategyValue(final ObjectManager om, DatastoreClass table, AbstractClassMetaData cmd, int absoluteFieldNumber) {
        PoidGenerator generator;
        ConfigurationElement elem;
        if (this.storeDataMgr.size() == 0) {
            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.SchemaDataUninitialisedForSchema", this.catalogName, this.schemaName);
            JPOXLogger.RDBMS_SCHEMA.error(msg);
            throw new JPOXException(msg).setFatal();
        }
        AbstractMemberMetaData fmd = null;
        String fieldName = null;
        IdentityStrategy strategy = null;
        String sequence = null;
        String valueGeneratorName = null;
        TableGeneratorMetaData valueGeneratorMetaData = null;
        SequenceMetaData sequenceMetaData = null;
        ExtensionMetaData[] extensions = null;
        if (absoluteFieldNumber >= 0) {
            fmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber);
            fieldName = fmd.getFullFieldName();
            strategy = fmd.getValueStrategy();
            sequence = fmd.getSequence();
            extensions = fmd.getExtensions();
            valueGeneratorName = fmd.getValueGeneratorName();
        } else {
            fieldName = cmd.getFullClassName() + " (datastore id)";
            strategy = cmd.getIdentityMetaData().getValueStrategy();
            sequence = cmd.getIdentityMetaData().getSequence();
            extensions = cmd.getIdentityMetaData().getExtensions();
            valueGeneratorName = cmd.getIdentityMetaData().getValueGeneratorName();
        }
        if (valueGeneratorName != null) {
            if (strategy == IdentityStrategy.INCREMENT ? (valueGeneratorMetaData = this.getMetaDataManager().getMetaDataForTableGenerator(om.getClassLoaderResolver(), valueGeneratorName)) == null : strategy == IdentityStrategy.SEQUENCE && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(om.getClassLoaderResolver(), valueGeneratorName)) == null) {
                throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.TableGeneratorNotFound", fieldName, valueGeneratorName));
            }
        } else if (strategy == IdentityStrategy.SEQUENCE && sequence != null && (sequenceMetaData = this.getMetaDataManager().getMetaDataForSequence(om.getClassLoaderResolver(), sequence)) == null) {
            JPOXLogger.RDBMS.warn("Field " + fieldName + " has been specified to use sequence " + sequence + " but there is no <sequence> specified in the MetaData. " + "Falling back to use a sequence in the datastore with this name directly.");
        }
        if (strategy == null || strategy == IdentityStrategy.IDENTITY) {
            throw new JPOXException("RDBMSManager.getStrategyValue called for invalid strategy \"" + strategy + "\"").setFatal();
        }
        String generatorNameKeyInManager = null;
        String poidGeneratorClassName = null;
        String strategyName = strategy.toString();
        if (strategy.equals(IdentityStrategy.CUSTOM)) {
            strategyName = strategy.getCustomName();
        }
        if ((elem = this.omfContext.getPluginManager().getConfigurationElementForExtension("org.jpox.store_valuegenerator", new String[]{"name", "datastore"}, new String[]{strategyName, "jdbc"})) != null) {
            poidGeneratorClassName = elem.getAttribute("class-name");
            if (elem.getAttribute("unique") != null && elem.getAttribute("unique").equalsIgnoreCase("true")) {
                generatorNameKeyInManager = poidGeneratorClassName;
            }
        }
        if (generatorNameKeyInManager == null) {
            generatorNameKeyInManager = valueGeneratorMetaData != null ? valueGeneratorMetaData.getName() : (sequenceMetaData != null ? sequenceMetaData.getName() : (absoluteFieldNumber >= 0 ? fmd.getFullFieldName() : cmd.getFullClassName()));
        }
        if ((generator = this.poidManager.getPoidGenerator(generatorNameKeyInManager)) == null) {
            DatastoreClass tbl = this.getDatastoreClass(cmd.getBaseAbstractClassMetaData().getFullClassName(), om.getClassLoaderResolver());
            if (tbl == null) {
                tbl = table;
            }
            JavaTypeMapping m = null;
            if (fmd != null) {
                m = tbl.getFieldMapping(fmd);
                if (m == null) {
                    m = table.getFieldMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber));
                    tbl = table;
                }
            } else {
                m = tbl.getIDMapping();
            }
            StringBuffer columnsName = new StringBuffer();
            for (int i = 0; i < m.getNumberOfDatastoreFields(); ++i) {
                if (i > 0) {
                    columnsName.append(",");
                }
                columnsName.append(((Object)m.getDataStoreMapping(i).getDatastoreField().getIdentifier()).toString());
            }
            Properties properties = new Properties();
            properties.setProperty("class-name", cmd.getFullClassName());
            properties.put("root-class-name", cmd.getBaseAbstractClassMetaData().getFullClassName());
            if (cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber) != null) {
                properties.setProperty("field-name", cmd.getMetaDataForManagedMemberAtAbsolutePosition(absoluteFieldNumber).getFullFieldName());
            }
            if (cmd.getCatalog() != null) {
                properties.setProperty("catalog-name", cmd.getCatalog());
            }
            if (cmd.getSchema() != null) {
                properties.setProperty("schema-name", cmd.getSchema());
            }
            properties.setProperty("table-name", ((Object)tbl.getIdentifier()).toString());
            properties.setProperty("column-name", columnsName.toString());
            if (sequence != null) {
                properties.setProperty("sequence-name", sequence);
            }
            if (strategy == IdentityStrategy.NATIVE) {
                poidGeneratorClassName = ((RDBMSAdapter)this.dba).supportsSequences() && sequence != null ? "org.jpox.store.rdbms.poid.SequencePoidGenerator" : "org.jpox.store.rdbms.poid.TablePoidGenerator";
            }
            if (extensions != null) {
                for (int i = 0; i < extensions.length; ++i) {
                    properties.put(extensions[i].getKey(), extensions[i].getValue());
                }
            }
            if (strategy == IdentityStrategy.INCREMENT && valueGeneratorMetaData != null) {
                properties.put("key-initial-value", "" + valueGeneratorMetaData.getInitialValue());
                properties.put("key-cache-size", "" + valueGeneratorMetaData.getAllocationSize());
                if (valueGeneratorMetaData.getTableName() != null) {
                    properties.put("sequence-table-name", valueGeneratorMetaData.getTableName());
                }
                if (valueGeneratorMetaData.getCatalogName() != null) {
                    properties.put("sequence-catalog-name", valueGeneratorMetaData.getCatalogName());
                }
                if (valueGeneratorMetaData.getSchemaName() != null) {
                    properties.put("sequence-schema-name", valueGeneratorMetaData.getSchemaName());
                }
                if (valueGeneratorMetaData.getPKColumnName() != null) {
                    properties.put("sequence-name-column-name", valueGeneratorMetaData.getPKColumnName());
                }
                if (valueGeneratorMetaData.getPKColumnName() != null) {
                    properties.put("sequence-nextval-column-name", valueGeneratorMetaData.getValueColumnName());
                }
                if (valueGeneratorMetaData.getPKColumnValue() != null) {
                    properties.put("sequence-name", valueGeneratorMetaData.getPKColumnValue());
                }
                properties.remove("table-name");
                properties.remove("column-name");
            }
            if (strategy == IdentityStrategy.SEQUENCE && sequenceMetaData != null && sequenceMetaData.getDatastoreSequence() != null) {
                properties.put("key-initial-value", "" + sequenceMetaData.getInitialValue());
                properties.put("key-cache-size", "" + sequenceMetaData.getAllocationSize());
                properties.put("sequence-name", "" + sequenceMetaData.getDatastoreSequence());
            }
            generator = this.poidManager.createPoidGenerator(om.getClassLoaderResolver(), generatorNameKeyInManager, poidGeneratorClassName, properties, this, null);
        }
        if (generator instanceof AbstractRDBMSPoidGenerator) {
            final RDBMSManager thisStoreMgr = this;
            PoidConnectionProvider connProvider = new PoidConnectionProvider(){
                ManagedConnection mconn;
                Connection conn;

                public Object retrieveConnection() {
                    try {
                        this.mconn = om.getOMFContext().getPersistenceConfiguration().getPoidTransactionAttribute().equalsIgnoreCase("UsePM") ? thisStoreMgr.getConnection(om) : thisStoreMgr.getConnection(RDBMSManager.this.omfContext.getPersistenceConfiguration().getPoidTransactionIsolationLevel());
                    }
                    catch (SQLException e) {
                        String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.POIDConnectionOpenError", e.getMessage());
                        JPOXLogger.POID.error(msg);
                        throw new JPOXDataStoreException(msg, e);
                    }
                    this.conn = (Connection)this.mconn.getConnection();
                    return this.conn;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void releaseConnection() {
                    try {
                        if (om.getOMFContext().getPersistenceConfiguration().getPoidTransactionAttribute().equalsIgnoreCase("UsePM")) {
                            this.mconn.release();
                        } else {
                            boolean success = false;
                            try {
                                if (!this.conn.getAutoCommit()) {
                                    this.conn.commit();
                                }
                                success = true;
                            }
                            finally {
                                if (!success && !this.conn.getAutoCommit()) {
                                    this.conn.rollback();
                                }
                            }
                            this.mconn.close();
                        }
                        this.mconn = null;
                        this.conn = null;
                    }
                    catch (SQLException e) {
                        String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.POIDConnectionCloseError", e);
                        JPOXLogger.POID.error(msg);
                        throw new JPOXDataStoreException(msg, e);
                    }
                }
            };
            ((AbstractRDBMSPoidGenerator)generator).setConnectionProvider(connProvider);
        }
        Object oid = generator.next();
        if (fmd != null) {
            Object convertedValue = TypeConversionHelper.convertTo(oid, fmd.getType());
            if (convertedValue == null) {
                throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.Manager.InvalidGeneratedId", fmd.getFullFieldName(), oid)).setFatal();
            }
            oid = convertedValue;
        }
        if (JPOXLogger.POID.isDebugEnabled()) {
            JPOXLogger.POID.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.StrategyValueGenerated", fieldName, strategy, generator.getClass().getName(), oid));
        }
        return oid;
    }

    public InsertRequest getInsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.INSERT, cls.getName());
        InsertRequest req = (InsertRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new InsertRequest(table, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public FetchRequest getFetchRequest(DatastoreClass table, AbstractMemberMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, fieldMetaData, RequestIdentifier.Type.FETCH, cls.getName());
        FetchRequest req = (FetchRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new FetchRequest(table, fieldMetaData, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public UpdateRequest getUpdateRequest(DatastoreClass table, AbstractMemberMetaData[] fieldMetaData, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, fieldMetaData, RequestIdentifier.Type.UPDATE, cls.getName());
        UpdateRequest req = (UpdateRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new UpdateRequest(table, fieldMetaData, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public LocateRequest getLocateRequest(DatastoreClass table, String className) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.LOCATE, className);
        LocateRequest req = (LocateRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new LocateRequest(table);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public DeleteRequest getDeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestIdentifier.Type.DELETE, cls.getName());
        DeleteRequest req = (DeleteRequest)this.requestsByID.get(reqID);
        if (req == null) {
            req = new DeleteRequest(table, cls, clr);
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    protected void removeRequestsForTable(DatastoreClass table) {
        HashSet keySet = new HashSet(this.requestsByID.keySet());
        Iterator keyIter = keySet.iterator();
        while (keyIter.hasNext()) {
            RequestIdentifier reqId = (RequestIdentifier)keyIter.next();
            if (reqId.getTable() != table) continue;
            this.requestsByID.remove(reqId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnInfo getColumnInfoForColumnName(Table table, Connection conn, DatastoreIdentifier column) throws SQLException {
        ColumnInfo colInfo = null;
        if (this.storeDataMgr.size() == 0) {
            colInfo = RDBMSStoreHelper.getColumnInfoForColumnName(this, table, conn, column);
            if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfos", table, colInfo != null ? "1" : "0"));
            }
        } else {
            RDBMSManager rDBMSManager = this;
            synchronized (rDBMSManager) {
                long now = System.currentTimeMillis();
                DatastoreIdentifier tableId = ((AbstractTable)table).getDatastoreIdentifierFullyQualified();
                List cols = null;
                if (now >= this.columnInfoReadTimestamp && now < this.columnInfoReadTimestamp + 300000L && (cols = (List)this.columnInfoByColumnName.get(tableId.getIdentifier() + column.getIdentifier())) != null) {
                    for (int i = 0; i < cols.size(); ++i) {
                        ColumnInfo ci;
                        String[] c = RDBMSStoreHelper.splitColumnIdentifierName(((RDBMSAdapter)this.getDatastoreAdapter()).getCatalogSeparator(), column.getIdentifier());
                        String columnName = column.getIdentifier();
                        if (c[3] != null) {
                            columnName = c[3];
                        }
                        if (!(ci = (ColumnInfo)cols.get(i)).getColumnName().equals(columnName)) continue;
                        colInfo = ci;
                    }
                }
                if (cols == null) {
                    colInfo = RDBMSStoreHelper.getColumnInfoForColumnName(this, table, conn, column);
                    if (colInfo == null) {
                        JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfoNotFound", column.getIdentifier(), table));
                    } else {
                        this.columnInfoByColumnName.put(tableId.getIdentifier() + column.getIdentifier(), colInfo);
                        if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                            JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfo", colInfo.getColumnName(), table));
                        }
                    }
                }
            }
        }
        return colInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getColumnInfoForTable(Table table, Connection conn) throws SQLException {
        List cols = null;
        if (this.storeDataMgr.size() == 0) {
            cols = RDBMSStoreHelper.getColumnInfoForTable(this, table, conn);
            if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfos", table, cols != null ? "" + cols.size() : "0"));
            }
        } else {
            RDBMSManager rDBMSManager = this;
            synchronized (rDBMSManager) {
                long now = System.currentTimeMillis();
                DatastoreIdentifier tableId = ((AbstractTable)table).getDatastoreIdentifierFullyQualified();
                if (now >= this.columnInfoReadTimestamp && now < this.columnInfoReadTimestamp + 300000L) {
                    cols = (List)this.columnInfoByTableName.get(tableId);
                }
                if (cols == null) {
                    this.refreshColumnInfo(table.getCatalogName(), table.getSchemaName(), conn);
                    cols = (List)this.columnInfoByTableName.get(tableId);
                    if (cols == null) {
                        cols = Collections.EMPTY_LIST;
                        JPOXLogger.RDBMS_SCHEMA.info(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfoNotFoundForTable", table));
                    } else if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                        JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfos", table, "" + cols.size()));
                    }
                }
            }
        }
        return cols;
    }

    public List getTableInfo() throws SQLException {
        return this.getTableInfo(this.schemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getTableInfo(String schemaNamePattern) throws SQLException {
        ManagedConnection mc = this.getConnection();
        try {
            Connection conn = (Connection)mc.getConnection();
            List list = RDBMSStoreHelper.getTableInfo(this, this.catalogName, schemaNamePattern, conn);
            return list;
        }
        finally {
            if (mc != null) {
                mc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getColumnInfo(String schemaNamePattern, String tableNamePattern) throws SQLException {
        ManagedConnection mc = this.getConnection();
        try {
            Connection conn = (Connection)mc.getConnection();
            ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
            ResultSet rs = ((RDBMSAdapter)this.dba).getColumns(conn, this.catalogName, schemaNamePattern, tableNamePattern);
            try {
                while (rs.next()) {
                    cols.add(((RDBMSAdapter)this.dba).newColumnInfo(rs));
                }
            }
            finally {
                rs.close();
            }
            ArrayList<ColumnInfo> arrayList = cols;
            return arrayList;
        }
        finally {
            if (mc != null) {
                mc.close();
            }
        }
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connProvider;
    }

    public Date getDatastoreDate() {
        Date serverDate;
        block14: {
            serverDate = null;
            String dateStmt = ((RDBMSAdapter)this.dba).getDatastoreDateStatement();
            ManagedConnection mc = null;
            try {
                mc = this.getConnection(0);
                Connection conn = (Connection)mc.getConnection();
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = this.getSQLController().getStatementForQuery(conn, dateStmt);
                    rs = this.getSQLController().executeStatementQuery(conn, dateStmt, ps);
                    if (rs.next()) {
                        Timestamp time = rs.getTimestamp(1, this.getOMFContext().getPersistenceConfiguration().getCalendarForDateTimezone());
                        serverDate = new Date(time.getTime());
                        break block14;
                    }
                    Date time = null;
                    return time;
                }
                catch (SQLException sqle) {
                    String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.ServerDateError", sqle.getMessage());
                    JPOXLogger.RDBMS_SQL.warn(msg, sqle);
                    throw new JPOXUserException(msg, sqle).setFatal();
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps != null) {
                        this.getSQLController().closeStatement(conn, ps);
                    }
                }
            }
            catch (SQLException sqle) {
                String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.ServerDateError", sqle.getMessage());
                JPOXLogger.RDBMS_SQL.warn(msg, sqle);
                throw new JPOXException(msg, sqle).setFatal();
            }
            finally {
                mc.close();
            }
        }
        return serverDate;
    }

    public void invalidateColumnInfoForTable(Table table) {
        DatastoreIdentifier tableId = ((AbstractTable)table).getDatastoreIdentifierFullyQualified();
        this.columnInfoByTableName.remove(tableId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshColumnInfo(String catalogName, String schemaName, Connection conn) throws SQLException {
        long now = System.currentTimeMillis();
        HashSet<DatastoreIdentifier> table_keys = new HashSet<DatastoreIdentifier>();
        Iterator i = this.storeDataMgr.getManagedStoreData().iterator();
        while (i.hasNext()) {
            RDBMSStoreData sd = (RDBMSStoreData)i.next();
            if (sd.getDatastoreContainerObject() == null) continue;
            table_keys.add(((AbstractTable)sd.getDatastoreContainerObject()).getDatastoreIdentifierFullyQualified());
        }
        HashMap<SQLIdentifier, ArrayList<ColumnInfo>> cim = new HashMap<SQLIdentifier, ArrayList<ColumnInfo>>();
        ResultSet rs = ((RDBMSAdapter)this.dba).getColumns(conn, catalogName, schemaName, null);
        try {
            while (rs.next()) {
                String tableIdentifierCatalogName = rs.getString(1);
                String tableIdentifierSchemaName = rs.getString(2);
                String tableIdentifierTableName = rs.getString(3);
                if (rs.wasNull() || tableIdentifierCatalogName != null && tableIdentifierCatalogName.length() < 1) {
                    tableIdentifierCatalogName = null;
                }
                if (rs.wasNull() || tableIdentifierSchemaName != null && tableIdentifierSchemaName.length() < 1) {
                    tableIdentifierSchemaName = null;
                }
                if (rs.wasNull() || tableIdentifierTableName != null && tableIdentifierTableName.length() < 1) {
                    tableIdentifierTableName = null;
                }
                if (tableIdentifierTableName == null) {
                    throw new JPOXDataStoreException("Invalid 'null' table name identifier returned by database. Check with your JDBC driver vendor (ref:DatabaseMetaData.getColumns).");
                }
                SQLIdentifier fullyQualifiedTableName = (SQLIdentifier)this.identifierFactory.newDatastoreContainerIdentifier(tableIdentifierTableName);
                fullyQualifiedTableName.setCatalogName(tableIdentifierCatalogName);
                fullyQualifiedTableName.setSchemaName(tableIdentifierSchemaName);
                if (!table_keys.contains(fullyQualifiedTableName)) continue;
                ArrayList<ColumnInfo> l = (ArrayList<ColumnInfo>)cim.get(fullyQualifiedTableName);
                if (l == null) {
                    l = new ArrayList<ColumnInfo>();
                    cim.put(fullyQualifiedTableName, l);
                }
                l.add(((RDBMSAdapter)this.dba).newColumnInfo(rs));
            }
        }
        finally {
            rs.close();
        }
        if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
            JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.ColumnInfoLoaded", catalogName, schemaName, "" + cim.size(), "" + (System.currentTimeMillis() - now)));
        }
        if (this.columnInfoByTableName != null && this.columnInfoByTableName != cim) {
            this.columnInfoByTableName.clear();
        }
        this.columnInfoByTableName = cim;
        this.columnInfoReadTimestamp = now;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resolveIdentifierMacro(MacroString.IdentifierMacro im, ClassLoaderResolver clr) {
        JavaTypeMapping m;
        DatastoreClass ct = this.getDatastoreClass(im.className, clr);
        if (im.fieldName == null) {
            im.value = ((Object)ct.getIdentifier()).toString();
            return;
        }
        if (im.fieldName.equals("this")) {
            if (!(ct instanceof ClassTable)) {
                throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.TableIDColumnError", im.className));
            }
            if (im.subfieldName != null) {
                throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.FieldTableError", im.className, im.fieldName, im.subfieldName));
            }
            m = ct.getIDMapping();
        } else {
            AbstractMemberMetaData fmd = this.getMetaDataManager().getMetaDataForMember(im.className, im.fieldName, clr);
            m = ct.getFieldMapping(fmd);
            DatastoreContainerObject t = this.getDatastoreContainerObject(fmd);
            if (im.subfieldName == null) {
                if (t != null) {
                    im.value = ((Object)t.getIdentifier()).toString();
                    return;
                }
            } else if (t instanceof CollectionTable) {
                CollectionTable collTable = (CollectionTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = collTable.getOwnerMapping();
                } else if (im.subfieldName.equals("element")) {
                    m = collTable.getElementMapping();
                } else {
                    if (!im.subfieldName.equals("index")) throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.InvalidPseudoFieldNameForCollection", im.subfieldName, im));
                    m = collTable.getOrderMapping();
                }
            } else {
                if (!(t instanceof MapTable)) throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.FieldTableError", im.className, im.fieldName, im.subfieldName));
                MapTable mt = (MapTable)t;
                if (im.subfieldName.equals("owner")) {
                    m = mt.getOwnerMapping();
                } else if (im.subfieldName.equals("key")) {
                    m = mt.getKeyMapping();
                } else {
                    if (!im.subfieldName.equals("value")) throw new JPOXUserException(LOCALISER_RDBMS.msg("RDBMS.Manager.InvalidPseudoFieldNameForMap", im.subfieldName, im));
                    m = mt.getValueMapping();
                }
            }
        }
        im.value = ((Object)((Column)m.getDataStoreMapping(0).getDatastoreField()).getIdentifier()).toString();
    }

    private DatastoreIdentifier getTableIdentifier(ClassMetaData cmd, ClassLoaderResolver clr) {
        RDBMSStoreData sd = (RDBMSStoreData)this.storeDataMgr.get(cmd.getFullClassName());
        if (sd != null && sd.getDatastoreIdentifier() != null) {
            return sd.getDatastoreIdentifier();
        }
        return this.identifierFactory.newDatastoreContainerIdentifier(clr, cmd);
    }

    private DatastoreIdentifier getTableIdentifier(AbstractMemberMetaData mmd, ClassLoaderResolver clr) {
        RDBMSStoreData sd = (RDBMSStoreData)this.storeDataMgr.get(mmd);
        if (sd != null && sd.getDatastoreIdentifier() != null) {
            return sd.getDatastoreIdentifier();
        }
        return this.identifierFactory.newDatastoreContainerIdentifier(clr, mmd);
    }

    public void createDatastoreColumnsForReferenceField(JavaTypeMapping m, DatastoreContainerObject table, AbstractMemberMetaData fmd, ClassLoaderResolver clr, boolean embedded) {
        ColumnCreator.createColumnsForFieldUsingReference(m, table, fmd, clr, embedded);
    }

    public void createDatastoreColumnsForFieldUsingSubclassTable(JavaTypeMapping m, DatastoreContainerObject table, AbstractMemberMetaData fmd, ClassLoaderResolver clr) {
        ColumnCreator.createColumnsForFieldUsingSubclassTable(m, table, fmd, clr);
    }

    public void outputDatastoreInformation(PrintStream ps) throws Exception {
        RDBMSAdapter dba = (RDBMSAdapter)this.getDatastoreAdapter();
        String msg = dba.toString();
        JPOXLogger.SCHEMATOOL.info(msg);
        ps.println(msg);
        ps.println();
        msg = "Database TypeInfo";
        JPOXLogger.SCHEMATOOL.info(msg);
        ps.println(msg);
        Iterator typeInfosIter = dba.iteratorTypeInfo();
        while (typeInfosIter.hasNext()) {
            DatabaseAdapter.JDBCTypeInfo jti = (DatabaseAdapter.JDBCTypeInfo)typeInfosIter.next();
            String typeStr = "JDBC Type=" + JDBCUtils.getNameForJDBCType(jti.getJdbcType()) + " datastoreTypes=" + StringUtils.objectArrayToString(jti.getTypeNames());
            JPOXLogger.SCHEMATOOL.info(typeStr);
            ps.println(typeStr);
            JPOXLogger.SCHEMATOOL.info(jti.getDefault());
            ps.println(jti.getDefault());
        }
        ps.println("");
        msg = "Database Keywords";
        JPOXLogger.SCHEMATOOL.info(msg);
        ps.println(msg);
        Iterator reservedWordsIter = dba.iteratorReservedWords();
        while (reservedWordsIter.hasNext()) {
            Object words = reservedWordsIter.next();
            JPOXLogger.SCHEMATOOL.info(words);
            ps.println(words);
        }
        ps.println("");
    }

    public void outputSchemaInformation(PrintStream ps) throws Exception {
        RDBMSAdapter dba = (RDBMSAdapter)this.getDatastoreAdapter();
        String msg = dba.toString();
        JPOXLogger.SCHEMATOOL.info(msg);
        ps.println(msg);
        ps.println();
        JPOXLogger.SCHEMATOOL.info("TABLES");
        Iterator itTables = this.getTableInfo(null).iterator();
        while (itTables.hasNext()) {
            TableInfo ti = (TableInfo)itTables.next();
            JPOXLogger.SCHEMATOOL.info(ti);
            ps.println(ti);
            Iterator itColumns = this.getColumnInfo(ti.getTableSchem(), ti.getTableName()).iterator();
            while (itColumns.hasNext()) {
                ColumnInfo ci = (ColumnInfo)itColumns.next();
                JPOXLogger.SCHEMATOOL.info(ci);
                ps.println(ci);
            }
        }
        ps.println("");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ClassAdder
    extends MgmtTransaction {
        public static final int JOIN_TABLE_COLLECTION = 1;
        public static final int JOIN_TABLE_MAP = 2;
        public static final int JOIN_TABLE_ARRAY = 3;
        private Writer ddlWriter = null;
        private HashSet schemaDataAdded = new HashSet();
        private final String[] classNames;
        private int addClassTablesRecursionCounter = 0;

        private ClassAdder(String[] classNames, Writer writer) {
            super(((RDBMSAdapter)RDBMSManager.this.dba).getTransactionIsolationForSchemaCreation());
            this.ddlWriter = writer;
            this.classNames = ClassUtils.getUnsupportedClassNames(RDBMSManager.this.getOMFContext().getTypeManager(), classNames);
        }

        public String toString() {
            return LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesToSchema", RDBMSManager.this.catalogName, RDBMSManager.this.schemaName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void run(ClassLoaderResolver clr) throws SQLException {
            if (this.classNames.length == 0) {
                return;
            }
            RDBMSManager rDBMSManager = RDBMSManager.this;
            synchronized (rDBMSManager) {
                RDBMSManager.this.classAdder = this;
                try {
                    this.addClassTablesAndValidate(this.classNames, clr);
                }
                finally {
                    RDBMSManager.this.classAdder = null;
                }
            }
        }

        private void addClasses(String[] classNames, ClassLoaderResolver clr) {
            classNames = ClassUtils.getUnsupportedClassNames(RDBMSManager.this.getOMFContext().getTypeManager(), classNames);
            if (classNames.length == 0) {
                return;
            }
            try {
                if (this.getCurrentConnection() == null) {
                    throw new IllegalStateException(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesError"));
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException("SQL exception: " + this, e);
            }
            this.addClassTables(classNames, clr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addClassTables(String[] classNames, ClassLoaderResolver clr) {
            ++this.addClassTablesRecursionCounter;
            try {
                Iterator iter = this.getReferencedClasses(classNames, clr).iterator();
                try {
                    if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && !RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.open();
                    }
                    while (iter.hasNext()) {
                        ClassMetaData cmd = (ClassMetaData)iter.next();
                        this.addClassTable(cmd, clr);
                    }
                    Iterator addedIter = new HashSet(this.schemaDataAdded).iterator();
                    while (addedIter.hasNext()) {
                        AbstractClassMetaData cmd;
                        InheritanceMetaData imd;
                        RDBMSStoreData data = (RDBMSStoreData)addedIter.next();
                        if (data.getDatastoreContainerObject() != null || !data.isFCO() || (imd = (cmd = (AbstractClassMetaData)data.getMetaData()).getInheritanceMetaData()).getStrategyValue() != InheritanceStrategy.SUPERCLASS_TABLE) continue;
                        AbstractClassMetaData[] managingCmds = RDBMSManager.this.getClassesManagingTableForClass(cmd, clr);
                        DatastoreClass superTable = null;
                        if (managingCmds == null || managingCmds.length != 1) continue;
                        RDBMSStoreData superData = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                        if (superData == null) {
                            this.addClassTables(new String[]{managingCmds[0].getFullClassName()}, clr);
                            superData = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                        }
                        if (superData == null) {
                            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.UnableToFindSuperclassTable", cmd.getFullClassName());
                            JPOXLogger.PERSISTENCE.error(msg);
                            throw new JPOXUserException(msg);
                        }
                        superTable = (DatastoreClass)superData.getDatastoreContainerObject();
                        data.setDatastoreContainerObject(superTable);
                    }
                }
                finally {
                    if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && RDBMSManager.this.starter.isOpen() && this.addClassTablesRecursionCounter <= 1) {
                        RDBMSManager.this.starter.close();
                    }
                }
            }
            finally {
                --this.addClassTablesRecursionCounter;
            }
        }

        private void addClassTable(ClassMetaData cmd, ClassLoaderResolver clr) {
            if (cmd.getPersistenceModifier() != ClassPersistenceModifier.PERSISTENCE_CAPABLE) {
                return;
            }
            if (cmd.getIdentityType() == IdentityType.NONDURABLE && cmd.hasExtension("requires-table") && cmd.getValueForExtension("requires-table") != null && cmd.getValueForExtension("requires-table").equalsIgnoreCase("false")) {
                return;
            }
            RDBMSStoreData sd = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(cmd.getFullClassName());
            if (sd == null) {
                if (cmd.getIdentityType() == IdentityType.APPLICATION && !cmd.usesSingleFieldIdentityClass()) {
                    String baseClassWithMetaData = cmd.getBaseAbstractClassMetaData().getFullClassName();
                    Collection c = RDBMSManager.this.storeDataMgr.getByPrimaryKeyClass(cmd.getObjectidClass());
                    if (c != null && c.size() > 0) {
                        boolean in_same_tree = false;
                        String sample_class_in_other_tree = null;
                        Iterator id_iter = c.iterator();
                        while (id_iter.hasNext()) {
                            RDBMSStoreData id_sd = (RDBMSStoreData)id_iter.next();
                            String otherClassBaseClass = ((AbstractClassMetaData)id_sd.getMetaData()).getBaseAbstractClassMetaData().getFullClassName();
                            if (otherClassBaseClass.equals(baseClassWithMetaData)) {
                                in_same_tree = true;
                                break;
                            }
                            sample_class_in_other_tree = id_sd.getName();
                        }
                        if (!in_same_tree) {
                            String error_msg = LOCALISER_RDBMS.msg("RDBMS.Manager.ObjectIdClassDuplicated", cmd.getFullClassName(), cmd.getObjectidClass(), sample_class_in_other_tree);
                            JPOXLogger.GENERAL.error(error_msg);
                            throw new JPOXUserException(error_msg);
                        }
                    }
                }
                if (cmd.isEmbeddedOnly()) {
                    JPOXLogger.RDBMS.info(LOCALISER.msg("StoreManager.NoTableForEmbeddedClass", cmd.getFullClassName()));
                } else {
                    InheritanceMetaData imd = cmd.getInheritanceMetaData();
                    RDBMSStoreData sdNew = null;
                    if (imd.getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSManager.this.registerStoreData(sdNew);
                    } else if (imd.getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE && cmd.isAbstractPersistenceCapable()) {
                        sdNew = new RDBMSStoreData(cmd, null, false);
                        RDBMSManager.this.registerStoreData(sdNew);
                    } else if (imd.getStrategyValue() == InheritanceStrategy.NEW_TABLE || imd.getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
                        DatastoreIdentifier tableName = RDBMSManager.this.getTableIdentifier(cmd, clr);
                        TableStoreData[] existingStoreData = RDBMSManager.this.getStoreDataForDatastoreContainerObject(tableName);
                        if (existingStoreData != null) {
                            String existingClass = null;
                            for (int j = 0; j < existingStoreData.length; ++j) {
                                if (existingStoreData[j].getName().equals(cmd.getFullClassName())) continue;
                                existingClass = existingStoreData[j].getName();
                                break;
                            }
                            if (existingClass != null) {
                                String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.TableAlreadyInUse", cmd.getFullClassName(), tableName.getIdentifier(), existingClass);
                                JPOXLogger.RDBMS.warn(msg);
                            }
                        }
                        AbstractTable t = null;
                        boolean hasViewDef = false;
                        if (RDBMSManager.this.dba.getVendorID() != null) {
                            hasViewDef = cmd.hasExtension("view-definition-" + RDBMSManager.this.dba.getVendorID());
                        }
                        if (!hasViewDef) {
                            hasViewDef = cmd.hasExtension("view-definition");
                        }
                        t = hasViewDef ? new ClassView(tableName, RDBMSManager.this, cmd) : new ClassTable(tableName, RDBMSManager.this, cmd);
                        sdNew = new RDBMSStoreData(cmd, t, true);
                        RDBMSManager.this.registerStoreData(sdNew);
                        ((Table)t).preInitialize(clr);
                    } else if (imd.getStrategyValue() == InheritanceStrategy.SUPERCLASS_TABLE) {
                        AbstractClassMetaData[] managingCmds = RDBMSManager.this.getClassesManagingTableForClass(cmd, clr);
                        DatastoreContainerObject superTable = null;
                        if (managingCmds != null && managingCmds.length == 1) {
                            RDBMSStoreData superData = (RDBMSStoreData)RDBMSManager.this.storeDataMgr.get(managingCmds[0].getFullClassName());
                            if (superData != null) {
                                superTable = superData.getDatastoreContainerObject();
                            }
                            sdNew = new RDBMSStoreData(cmd, superTable, false);
                            RDBMSManager.this.registerStoreData(sdNew);
                        } else {
                            String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.UnableToFindSuperclassTable", cmd.getFullClassName());
                            JPOXLogger.PERSISTENCE.error(msg);
                            throw new JPOXUserException(msg);
                        }
                    }
                    this.schemaDataAdded.add(sdNew);
                }
            }
        }

        private List getReferencedClasses(String[] classNames, ClassLoaderResolver clr) {
            ArrayList cmds = new ArrayList();
            for (int i = 0; i < classNames.length; ++i) {
                Class clazz = clr.classForName(classNames[i]);
                if (clazz != null && clazz.isInterface()) continue;
                AbstractClassMetaData cmd = RDBMSManager.this.getMetaDataManager().getMetaDataForClass(classNames[i], clr);
                if (cmd == null) {
                    JPOXLogger.RDBMS_SCHEMA.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesInvalidClassError", classNames[i]));
                    throw new NoPersistenceInformationException(classNames[i]);
                }
                cmds.addAll(RDBMSManager.this.getMetaDataManager().getReferencedClassMetaData(cmd, RDBMSManager.this.dba.getVendorID(), clr));
            }
            return cmds;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addClassTablesAndValidate(String[] classNames, ClassLoaderResolver clr) {
            RDBMSManager.this.storeDataMgr.begin();
            boolean completed = false;
            List tablesCreated = null;
            List tableConstraintsCreated = null;
            List viewsCreated = null;
            try {
                List[] result;
                List autoCreateErrors = new ArrayList();
                this.addClassTables(classNames, clr);
                List[] toValidate = this.initializeClassTables(classNames, clr);
                if (toValidate[0] != null && toValidate[0].size() > 0) {
                    result = this.performTablesValidation(toValidate[0], clr);
                    tablesCreated = result[0];
                    tableConstraintsCreated = result[1];
                    autoCreateErrors = result[2];
                }
                if (toValidate[1] != null && toValidate[1].size() > 0) {
                    result = this.performViewsValidation(toValidate[1]);
                    viewsCreated = result[0];
                    autoCreateErrors.addAll(result[1]);
                }
                this.verifyErrors(autoCreateErrors);
                completed = true;
                if (!completed) {
                    RDBMSManager.this.storeDataMgr.rollback();
                    this.rollbackSchemaCreation(viewsCreated, tableConstraintsCreated, tablesCreated);
                } else {
                    RDBMSManager.this.storeDataMgr.commit();
                }
                this.schemaDataAdded.clear();
                return;
            }
            catch (SQLException sqle) {
                try {
                    String msg = LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesExceptionError", sqle);
                    JPOXLogger.RDBMS_SCHEMA.error(msg);
                    throw new JPOXDataStoreException(msg, sqle);
                    catch (Exception e) {
                        if ((class$org$jpox$exceptions$JPOXException == null ? (class$org$jpox$exceptions$JPOXException = RDBMSManager.class$("org.jpox.exceptions.JPOXException")) : class$org$jpox$exceptions$JPOXException).isAssignableFrom(e.getClass())) {
                            throw (JPOXException)e;
                        }
                        JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesExceptionError", e));
                        throw new JPOXException(e.toString(), e).setFatal();
                    }
                }
                catch (Throwable throwable) {
                    if (!completed) {
                        RDBMSManager.this.storeDataMgr.rollback();
                        this.rollbackSchemaCreation(viewsCreated, tableConstraintsCreated, tablesCreated);
                    } else {
                        RDBMSManager.this.storeDataMgr.commit();
                    }
                    this.schemaDataAdded.clear();
                    throw throwable;
                }
            }
        }

        private List[] initializeClassTables(String[] classNames, ClassLoaderResolver clr) {
            boolean someNeededInitialization;
            ArrayList<Table> tablesToValidate = new ArrayList<Table>();
            ArrayList<Table> viewsToValidate = new ArrayList<Table>();
            ArrayList<Table> recentlyInitilized = new ArrayList<Table>();
            do {
                someNeededInitialization = false;
                RDBMSStoreData[] rdbmsStoreData = RDBMSManager.this.storeDataMgr.getManagedStoreData().toArray(new RDBMSStoreData[RDBMSManager.this.storeDataMgr.size()]);
                for (int i = 0; i < rdbmsStoreData.length; ++i) {
                    if (!rdbmsStoreData[i].hasTable()) continue;
                    Table t = (Table)rdbmsStoreData[i].getDatastoreContainerObject();
                    if (t instanceof DatastoreClass) {
                        RDBMSManager.this.removeRequestsForTable((DatastoreClass)((Object)t));
                    }
                    if (!t.isInitialized()) {
                        t.initialize(clr);
                        recentlyInitilized.add(t);
                        if (t instanceof ViewImpl) {
                            viewsToValidate.add(t);
                        } else {
                            tablesToValidate.add(t);
                        }
                        someNeededInitialization = true;
                    }
                    if (rdbmsStoreData[i].isTableOwner() || ((ClassTable)t).managesClass(rdbmsStoreData[i].getName())) continue;
                    ((ClassTable)t).manageClass((ClassMetaData)rdbmsStoreData[i].getMetaData(), clr);
                    if (!tablesToValidate.contains(t)) {
                        tablesToValidate.add(t);
                    }
                    someNeededInitialization = true;
                }
            } while (someNeededInitialization);
            for (int j = 0; j < recentlyInitilized.size(); ++j) {
                ((Table)recentlyInitilized.get(j)).postInitialize(clr);
            }
            return new List[]{tablesToValidate, viewsToValidate};
        }

        private List[] performTablesValidation(List tablesToValidate, ClassLoaderResolver clr) throws SQLException {
            TableImpl t;
            ArrayList autoCreateErrors = new ArrayList();
            ArrayList<TableImpl> tableConstraintsCreated = new ArrayList<TableImpl>();
            ArrayList<TableImpl> tablesCreated = new ArrayList<TableImpl>();
            if (this.ddlWriter != null) {
                tablesToValidate = this.removeDuplicateTablesFromList(tablesToValidate);
            }
            Iterator i = tablesToValidate.iterator();
            while (i.hasNext()) {
                t = (TableImpl)i.next();
                boolean columnsValidated = false;
                if (RDBMSManager.this.checkExistTablesOrViews) {
                    if (this.ddlWriter != null) {
                        try {
                            if (t instanceof ClassTable) {
                                this.ddlWriter.write("-- Table " + t.toString() + " for classes " + StringUtils.objectArrayToString(((ClassTable)t).getManagedClasses()) + "\n");
                            } else if (t instanceof JoinTable) {
                                this.ddlWriter.write("-- Table " + t.toString() + " for join relationship\n");
                            }
                        }
                        catch (IOException ioe) {
                            JPOXLogger.RDBMS_DDL.error("error writing DDL into file", ioe);
                        }
                    }
                    if (!tablesCreated.contains(t) && t.exists(this.getCurrentConnection(), RDBMSManager.this.autoCreateTables)) {
                        tablesCreated.add(t);
                        columnsValidated = true;
                    } else if (t.isInitializedModified() || RDBMSManager.this.autoCreateColumns) {
                        t.validateColumns(this.getCurrentConnection(), false, RDBMSManager.this.autoCreateColumns, autoCreateErrors);
                        columnsValidated = true;
                    }
                }
                if (RDBMSManager.this.validateTables && !columnsValidated) {
                    t.validate(this.getCurrentConnection(), RDBMSManager.this.validateColumns, false, autoCreateErrors);
                } else if (!columnsValidated) {
                    if (RDBMSManager.this.omfContext.getPersistenceConfiguration().getInitializeColumnInfo().equalsIgnoreCase("PK")) {
                        t.initializeColumnInfoForPrimaryKeyColumns(this.getCurrentConnection());
                    } else if (RDBMSManager.this.omfContext.getPersistenceConfiguration().getInitializeColumnInfo().equalsIgnoreCase("ALL")) {
                        t.initializeColumnInfoFromDatastore(this.getCurrentConnection());
                    }
                }
                RDBMSManager.this.columnInfoByTableName.remove(t.getDatastoreIdentifierFullyQualified());
            }
            i = tablesToValidate.iterator();
            while (i.hasNext()) {
                t = (TableImpl)i.next();
                if (!RDBMSManager.this.validateConstraints && !RDBMSManager.this.autoCreateConstraints) continue;
                if (this.ddlWriter != null) {
                    try {
                        if (t instanceof ClassTable) {
                            this.ddlWriter.write("-- Constraints for table " + t.toString() + " for class(es) " + StringUtils.objectArrayToString(((ClassTable)t).getManagedClasses()) + "\n");
                        } else {
                            this.ddlWriter.write("-- Constraints for table " + t.toString() + "\n");
                        }
                    }
                    catch (IOException ioe) {
                        JPOXLogger.RDBMS_DDL.error("error writing DDL into file", ioe);
                    }
                }
                if (tablesCreated.contains(t) && !this.hasDuplicateTablesFromList(tablesToValidate)) {
                    if (t.createConstraints(this.conn, autoCreateErrors, clr)) {
                        tableConstraintsCreated.add(t);
                    }
                } else if (t.validateConstraints(this.getCurrentConnection(), RDBMSManager.this.autoCreateConstraints, autoCreateErrors, clr)) {
                    tableConstraintsCreated.add(t);
                }
                if (this.ddlWriter == null) continue;
                try {
                    this.ddlWriter.write("\n");
                }
                catch (IOException ioe) {
                    JPOXLogger.RDBMS_DDL.error("error writing DDL into file", ioe);
                }
            }
            return new List[]{tablesCreated, tableConstraintsCreated, autoCreateErrors};
        }

        private List removeDuplicateTablesFromList(List newTables) {
            ArrayList result = new ArrayList();
            TreeSet uniqueTables = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    DatastoreContainerObject t1 = (DatastoreContainerObject)o1;
                    DatastoreContainerObject t2 = (DatastoreContainerObject)o2;
                    return StringUtils.toJVMIDString(t1).compareTo(StringUtils.toJVMIDString(t2));
                }
            });
            uniqueTables.addAll(newTables);
            result.addAll(uniqueTables);
            return result;
        }

        private boolean hasDuplicateTablesFromList(List newTables) {
            HashMap<String, DatastoreContainerObject> map = new HashMap<String, DatastoreContainerObject>();
            for (int i = 0; i < newTables.size(); ++i) {
                DatastoreContainerObject t1 = (DatastoreContainerObject)newTables.get(i);
                if (map.containsKey(t1.getIdentifier().getIdentifier())) {
                    return true;
                }
                map.put(t1.getIdentifier().getIdentifier(), t1);
            }
            return false;
        }

        private List[] performViewsValidation(List viewsToValidate) throws SQLException {
            ArrayList<ViewImpl> viewsCreated = new ArrayList<ViewImpl>();
            ArrayList autoCreateErrors = new ArrayList();
            Iterator i = viewsToValidate.iterator();
            while (i.hasNext()) {
                ViewImpl v = (ViewImpl)i.next();
                if (RDBMSManager.this.checkExistTablesOrViews && v.exists(this.getCurrentConnection(), RDBMSManager.this.autoCreateTables)) {
                    viewsCreated.add(v);
                }
                if (RDBMSManager.this.validateTables) {
                    v.validate(this.getCurrentConnection(), true, false, autoCreateErrors);
                }
                RDBMSManager.this.columnInfoByTableName.remove(v.getDatastoreIdentifierFullyQualified());
            }
            return new List[]{viewsCreated, autoCreateErrors};
        }

        private void verifyErrors(List autoCreateErrors) {
            if (autoCreateErrors.size() > 0) {
                Iterator errorsIter = autoCreateErrors.iterator();
                while (errorsIter.hasNext()) {
                    Throwable exc = (Throwable)errorsIter.next();
                    if (RDBMSManager.this.autoCreateWarnOnError) {
                        JPOXLogger.RDBMS.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesExceptionError", exc));
                        continue;
                    }
                    JPOXLogger.RDBMS.error(LOCALISER_RDBMS.msg("RDBMS.Manager.AddClassesExceptionError", exc));
                }
                if (!RDBMSManager.this.autoCreateWarnOnError) {
                    throw new JPOXDataStoreException(LOCALISER_RDBMS.msg("RDBMS.Manager.AutoCreateError"), autoCreateErrors.toArray(new Throwable[autoCreateErrors.size()]));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rollbackSchemaCreation(List viewsCreated, List tableConstraintsCreated, List tablesCreated) {
            if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.Manager.AddTablesRollback"));
            }
            try {
                ListIterator li;
                if (viewsCreated != null) {
                    li = viewsCreated.listIterator(viewsCreated.size());
                    while (li.hasPrevious()) {
                        ((ViewImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
                if (tableConstraintsCreated != null) {
                    li = tableConstraintsCreated.listIterator(tableConstraintsCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).dropConstraints(this.getCurrentConnection());
                    }
                }
                if (tablesCreated != null) {
                    li = tablesCreated.listIterator(tablesCreated.size());
                    while (li.hasPrevious()) {
                        ((TableImpl)li.previous()).drop(this.getCurrentConnection());
                    }
                }
            }
            catch (Exception e) {
                JPOXLogger.RDBMS_SCHEMA.warn(LOCALISER_RDBMS.msg("RDBMS.Manager.AddTablesRollbackError", e));
            }
            if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised) {
                try {
                    if (!RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.open();
                    }
                    Iterator schema_added_iter = this.schemaDataAdded.iterator();
                    while (schema_added_iter.hasNext()) {
                        RDBMSStoreData sd = (RDBMSStoreData)schema_added_iter.next();
                        RDBMSManager.this.starter.deleteClass(sd.getName());
                    }
                }
                finally {
                    if (RDBMSManager.this.starter.isOpen()) {
                        RDBMSManager.this.starter.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private DatastoreContainerObject addJoinTableForContainer(AbstractMemberMetaData fmd, ClassLoaderResolver clr, int type) {
            RDBMSStoreData data;
            DatastoreIdentifier tableName = RDBMSManager.this.getTableIdentifier(fmd, clr);
            JoinTable join = null;
            if (type == 1) {
                join = new CollectionTable(tableName, fmd, RDBMSManager.this);
            } else if (type == 2) {
                join = new MapTable(tableName, fmd, RDBMSManager.this);
            } else if (type == 3) {
                join = new ArrayTable(tableName, fmd, RDBMSManager.this);
            }
            try {
                if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && !RDBMSManager.this.starter.isOpen()) {
                    RDBMSManager.this.starter.open();
                }
                data = new RDBMSStoreData(fmd, join);
                RDBMSManager.this.registerStoreData(data);
            }
            finally {
                if (RDBMSManager.this.starter != null && RDBMSManager.this.starterInitialised && RDBMSManager.this.starter.isOpen()) {
                    RDBMSManager.this.starter.close();
                }
            }
            this.schemaDataAdded.add(data);
            return join;
        }
    }

    private abstract class MgmtTransaction {
        protected final int isolationLevel;
        protected final int maxRetries;
        protected ManagedConnection mconn;
        protected Connection conn;

        private MgmtTransaction(int isolationLevel) {
            this.isolationLevel = isolationLevel;
            this.maxRetries = RDBMSManager.this.omfContext.getPersistenceConfiguration().getDatastoreClassAdditionMaxRetries();
        }

        public abstract String toString();

        protected abstract void run(ClassLoaderResolver var1) throws SQLException;

        protected Connection getCurrentConnection() throws SQLException {
            if (this.conn == null) {
                this.mconn = RDBMSManager.this.getConnection(this.isolationLevel);
                this.conn = (Connection)this.mconn.getConnection();
            }
            return this.conn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void execute(ClassLoaderResolver clr) {
            int attempts = 0;
            while (true) {
                try {
                    try {
                        boolean succeeded = false;
                        try {
                            this.run(clr);
                            succeeded = true;
                        }
                        finally {
                            if (this.conn != null && this.isolationLevel != 0 && !this.conn.getAutoCommit()) {
                                if (succeeded) {
                                    this.conn.commit();
                                } else {
                                    this.conn.rollback();
                                }
                            }
                        }
                    }
                    finally {
                        if (this.conn != null) {
                            this.mconn.close();
                            this.conn = null;
                        }
                    }
                }
                catch (SQLException e) {
                    if (++attempts < this.maxRetries) continue;
                    throw new JPOXDataStoreException("SQL exception: " + this, e);
                }
                break;
            }
        }
    }
}

