/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.Transaction;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.ClassMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.metadata.InheritanceStrategy;
import org.jpox.state.StateManagerFactory;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.StoreData;
import org.jpox.store.TableStoreData;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.MetaDataStringLiteral;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.RDBMSStoreData;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.TableInfo;
import org.jpox.store.rdbms.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.query.RDBMSQueryUtils;
import org.jpox.store.rdbms.query.StatementText;
import org.jpox.store.rdbms.table.ClassTable;
import org.jpox.store.rdbms.table.Table;
import org.jpox.store.rdbms.typeinfo.ForeignKeyInfo;
import org.jpox.util.JPOXLogger;
import org.jpox.util.StringUtils;

public class RDBMSStoreHelper {
    private static final int TABLE_IDENTIFIER_CATALOG = 0;
    private static final int TABLE_IDENTIFIER_SCHEMA = 1;
    private static final int TABLE_IDENTIFIER_TABLE = 2;
    public static final int TABLE_IDENTIFIER_COLUMN = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTableType(RDBMSManager storeMgr, Table table, Connection conn) throws SQLException {
        String tableType = null;
        String[] c = RDBMSStoreHelper.splitTableIdentifierName(((RDBMSAdapter)storeMgr.getDatastoreAdapter()).getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (c[0] != null) {
            catalogName = c[0];
        }
        if (c[1] != null) {
            schemaName = c[1];
        }
        if (c[2] != null) {
            tableName = c[2];
        }
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        catalogName = JDBCUtils.getIdentifierNameStripped(catalogName, dba);
        schemaName = JDBCUtils.getIdentifierNameStripped(schemaName, dba);
        tableName = JDBCUtils.getIdentifierNameStripped(tableName, dba);
        ResultSet rs = conn.getMetaData().getTables(catalogName, schemaName, tableName, null);
        try {
            while (rs.next()) {
                if (!tableName.equalsIgnoreCase(rs.getString(3))) continue;
                tableType = rs.getString(4).toUpperCase();
                break;
            }
        }
        finally {
            rs.close();
        }
        if (tableType == null) {
            return -1;
        }
        if (tableType.equals("TABLE")) {
            return 1;
        }
        if (tableType.equals("VIEW")) {
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getColumnInfoForTable(RDBMSManager storeMgr, Table table, Connection conn) throws SQLException {
        ArrayList<ColumnInfo> cols = new ArrayList<ColumnInfo>();
        String[] c = RDBMSStoreHelper.splitTableIdentifierName(((RDBMSAdapter)storeMgr.getDatastoreAdapter()).getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (c[0] != null) {
            catalogName = c[0];
        }
        if (c[1] != null) {
            schemaName = c[1];
        }
        if (c[2] != null) {
            tableName = c[2];
        }
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        catalogName = JDBCUtils.getIdentifierNameStripped(catalogName, dba);
        schemaName = JDBCUtils.getIdentifierNameStripped(schemaName, dba);
        tableName = JDBCUtils.getIdentifierNameStripped(tableName, dba);
        ResultSet rs = dba.getColumns(conn, catalogName, schemaName, tableName);
        try {
            while (rs.next()) {
                cols.add(((RDBMSAdapter)storeMgr.getDatastoreAdapter()).newColumnInfo(rs));
            }
        }
        finally {
            rs.close();
        }
        return cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTableInfo(RDBMSManager storeMgr, String catalogName, String schemaName, Connection conn) throws SQLException {
        ArrayList<TableInfo> tables = new ArrayList<TableInfo>();
        ResultSet rs = ((RDBMSAdapter)storeMgr.getDatastoreAdapter()).getTables(conn, catalogName, schemaName);
        try {
            while (rs.next()) {
                tables.add(new TableInfo(rs));
            }
        }
        finally {
            rs.close();
        }
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColumnInfo getColumnInfoForColumnName(RDBMSManager storeMgr, Table table, Connection conn, DatastoreIdentifier column) throws SQLException {
        ColumnInfo colInfo = null;
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        String[] t = RDBMSStoreHelper.splitTableIdentifierName(dba.getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (t[0] != null) {
            catalogName = t[0];
        }
        if (t[1] != null) {
            schemaName = t[1];
        }
        if (t[2] != null) {
            tableName = t[2];
        }
        String[] c = RDBMSStoreHelper.splitColumnIdentifierName(dba.getCatalogSeparator(), column.getIdentifier());
        String columnName = column.getIdentifier();
        if (c[3] != null) {
            columnName = c[3];
        }
        if (schemaName != null) {
            if (storeMgr.getIdentifierFactory().getIdentifierCase() == 2 || storeMgr.getIdentifierFactory().getIdentifierCase() == 3) {
                schemaName = schemaName.toLowerCase();
            } else if (storeMgr.getIdentifierFactory().getIdentifierCase() == 0 || storeMgr.getIdentifierFactory().getIdentifierCase() == 1) {
                schemaName = schemaName.toUpperCase();
            }
        }
        ResultSet rs = dba.getColumns(conn, catalogName, schemaName, tableName, columnName);
        try {
            if (rs.next()) {
                colInfo = ((RDBMSAdapter)storeMgr.getDatastoreAdapter()).newColumnInfo(rs);
            }
            if (rs.next()) {
                throw new JPOXException("Should not have returned more than one column info.").setFatal();
            }
        }
        finally {
            rs.close();
        }
        return colInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getForeignKeyInfoForTable(RDBMSManager storeMgr, Table table, Connection conn) throws SQLException {
        ArrayList<ForeignKeyInfo> fk_cols = new ArrayList<ForeignKeyInfo>();
        String[] c = RDBMSStoreHelper.splitTableIdentifierName(((RDBMSAdapter)storeMgr.getDatastoreAdapter()).getCatalogSeparator(), table.getIdentifier().getIdentifier());
        String catalogName = table.getCatalogName();
        String schemaName = table.getSchemaName();
        String tableName = table.getIdentifier().getIdentifier();
        if (c[0] != null) {
            catalogName = c[0];
        }
        if (c[1] != null) {
            schemaName = c[1];
        }
        if (c[2] != null) {
            tableName = c[2];
        }
        RDBMSAdapter dba = (RDBMSAdapter)storeMgr.getDatastoreAdapter();
        catalogName = JDBCUtils.getIdentifierNameStripped(catalogName, dba);
        schemaName = JDBCUtils.getIdentifierNameStripped(schemaName, dba);
        tableName = JDBCUtils.getIdentifierNameStripped(tableName, dba);
        ResultSet rs = conn.getMetaData().getImportedKeys(catalogName, schemaName, tableName);
        try {
            while (rs.next()) {
                ForeignKeyInfo fki = dba.newForeignKeyInfo(rs);
                if (fk_cols.contains(fki)) continue;
                fk_cols.add(fki);
            }
        }
        finally {
            rs.close();
        }
        return fk_cols;
    }

    public static String[] splitTableIdentifierName(String separator, String name) {
        String[] result = new String[3];
        int p = name.indexOf(separator);
        if (p < 0) {
            result[2] = name;
        } else {
            int p1 = name.indexOf(separator, p + separator.length());
            if (p1 < 0) {
                result[1] = name.substring(0, p);
                result[2] = name.substring(p + separator.length());
            } else {
                result[0] = name.substring(0, p);
                result[1] = name.substring(p + separator.length(), p1);
                result[2] = name.substring(p1 + separator.length());
            }
        }
        if (result[1] != null && result[1].length() < 1) {
            result[1] = null;
        }
        if (result[0] != null && result[0].length() < 1) {
            result[0] = null;
        }
        return result;
    }

    public static String[] splitColumnIdentifierName(String separator, String name) {
        String[] result = new String[4];
        int p = name.indexOf(separator);
        if (p < 0) {
            result[3] = name;
        } else {
            int p1 = name.indexOf(separator, p + separator.length());
            if (p1 < 0) {
                result[2] = name.substring(0, p);
                result[3] = name.substring(p + separator.length());
            } else {
                int p2 = name.indexOf(separator, p1 + separator.length());
                if (p2 < 0) {
                    result[1] = name.substring(0, p);
                    result[2] = name.substring(p + separator.length(), p1);
                    result[3] = name.substring(p1 + separator.length());
                } else {
                    result[0] = name.substring(0, p);
                    result[1] = name.substring(p + separator.length(), p1);
                    result[2] = name.substring(p1 + separator.length(), p2);
                    result[3] = name.substring(p2 + separator.length());
                }
            }
        }
        if (result[1] != null && result[1].length() < 1) {
            result[1] = null;
        }
        if (result[0] != null && result[0].length() < 1) {
            result[0] = null;
        }
        if (result[2] != null && result[2].length() < 1) {
            result[2] = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdKeyUsingUnion(ObjectManager om, RDBMSManager storeMgr, Object id, List schemaDataOptions) {
        String className = null;
        if (schemaDataOptions == null || id == null || schemaDataOptions.size() == 0) {
            return null;
        }
        int metadata_id_len = 0;
        Iterator optionsIter = schemaDataOptions.iterator();
        while (optionsIter.hasNext()) {
            RDBMSStoreData schemaDataOption = (RDBMSStoreData)optionsIter.next();
            metadata_id_len = Math.max(schemaDataOption.getName().length(), metadata_id_len);
        }
        QueryExpression qs_base = null;
        optionsIter = schemaDataOptions.iterator();
        while (optionsIter.hasNext()) {
            RDBMSStoreData schemaDataOption = (RDBMSStoreData)optionsIter.next();
            ClassMetaData cmd = (ClassMetaData)schemaDataOption.getMetaData();
            QueryExpression qs = storeMgr.getDatastoreAdapter().newQueryStatement(schemaDataOption.getDatastoreContainerObject(), om.getClassLoaderResolver());
            String classname = StringUtils.leftAlignedPaddedString(schemaDataOption.getName(), metadata_id_len);
            qs.selectScalarExpression(new MetaDataStringLiteral(qs, classname));
            Iterator subclass_iter = storeMgr.getSubClassesForClass(schemaDataOption.getName(), false, om.getClassLoaderResolver()).iterator();
            int subclasses_seq_id = 0;
            while (subclass_iter.hasNext()) {
                String subclass = (String)subclass_iter.next();
                DatastoreClass subclassTable = storeMgr.getDatastoreClass(subclass, om.getClassLoaderResolver());
                if (subclassTable == null || subclassTable.getIdentifier().equals(schemaDataOption.getDatastoreContainerObject().getIdentifier())) continue;
                DatastoreIdentifier subclassTableIdentifier = storeMgr.getIdentifierFactory().newIdentifier(0, "SUBCLASS" + subclasses_seq_id++);
                QueryExpression st = storeMgr.getDatastoreAdapter().newQueryStatement(subclassTable, subclassTableIdentifier, om.getClassLoaderResolver());
                LogicSetExpression table_expr_sub = st.newTableExpression(subclassTable, subclassTableIdentifier);
                JavaTypeMapping subMapping = subclassTable.getIDMapping();
                st.select(subclassTableIdentifier, subMapping);
                ScalarExpression subExpr = subMapping.newScalarExpression(qs, table_expr_sub);
                ScalarExpression schExpr = ((DatastoreClass)schemaDataOption.getDatastoreContainerObject()).getIDMapping().newScalarExpression(qs, qs.getDefaultTableExpression());
                qs.leftOuterJoin(subExpr, schExpr, table_expr_sub, true);
                qs.andCondition(new NullLiteral(qs).eq(subExpr));
            }
            JavaTypeMapping idMapping = ((DatastoreClass)schemaDataOption.getDatastoreContainerObject()).getIDMapping();
            Class pc_class = om.getClassLoaderResolver().classForName(schemaDataOption.getName());
            StateManager sm = StateManagerFactory.newStateManagerForHollow(om, pc_class, id);
            ScalarExpression fieldExpr = idMapping.newScalarExpression(qs, qs.getDefaultTableExpression());
            ScalarExpression fieldValue = idMapping.newLiteral(qs, sm.getObject());
            qs.andCondition(fieldExpr.eq(fieldValue), true);
            JavaTypeMapping discrimMapping = schemaDataOption.getDatastoreContainerObject().getDiscriminatorMapping();
            DiscriminatorMetaData discrimMetaData = cmd.getInheritanceMetaData().getDiscriminatorMetaData();
            if (discrimMapping != null) {
                ScalarExpression discrimExpr = discrimMapping.newScalarExpression(qs, qs.getDefaultTableExpression());
                String value = null;
                if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                    value = schemaDataOption.getName();
                } else if (cmd.getDiscriminatorStrategy() == DiscriminatorStrategy.VALUE_MAP) {
                    value = discrimMetaData.getValue();
                }
                ScalarExpression discrimValue = discrimMapping.newLiteral(qs, value);
                qs.andCondition(discrimExpr.eq(discrimValue), true);
            }
            if (qs_base == null) {
                qs_base = qs;
                continue;
            }
            qs_base.union(qs);
        }
        try {
            Transaction tx = om.getTransaction();
            ManagedConnection mconn = storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                StatementText stmtText = qs_base.toStatementText((Boolean)tx.getOptions().get("transaction.serializeReadObjects"));
                PreparedStatement ps = stmtText.prepareStatement(om, conn);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(conn, stmtText.toString(), ps);
                    try {
                        if (rs != null) {
                            while (rs.next()) {
                                className = RDBMSQueryUtils.getClassNameFromJPOXMetaDataResultSetRow(rs);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqe) {
            JPOXLogger.RDBMS.error(sqe);
            throw new JPOXDataStoreException(sqe.toString());
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getClassNameForIdKeyUsingDiscriminator(ObjectManager om, RDBMSManager storeMgr, Object id, List schemaDataOptions) {
        Class primaryClass;
        String className = null;
        if (schemaDataOptions == null || schemaDataOptions.size() == 0 || id == null) {
            return null;
        }
        ClassLoaderResolver clr = om.getClassLoaderResolver();
        Class objectClass = primaryClass = clr.classForName(((RDBMSStoreData)schemaDataOptions.get(0)).getName());
        if (Modifier.isAbstract(primaryClass.getModifiers())) {
            Iterator optionsIter = schemaDataOptions.iterator();
            while (optionsIter.hasNext()) {
                RDBMSStoreData data = (RDBMSStoreData)optionsIter.next();
                Class dataClass = clr.classForName(data.getName());
                if (Modifier.isAbstract(dataClass.getModifiers())) continue;
                objectClass = dataClass;
                break;
            }
        }
        if (Modifier.isAbstract(objectClass.getModifiers())) {
            throw new JPOXException("Class " + objectClass.getName() + " is abstract, and a non abstract was expected.").setFatal();
        }
        DiscriminatorIteratorStatement discrimStmt = new DiscriminatorIteratorStatement(clr, new Class[]{primaryClass}, true, storeMgr, true);
        DatastoreClass primaryTable = storeMgr.getDatastoreClass(primaryClass.getName(), clr);
        TableStoreData[] storeData = storeMgr.getStoreDataForDatastoreContainerObject(primaryTable.getIdentifier());
        boolean haveAllCandidates = true;
        for (int i = 0; i < storeData.length; ++i) {
            if (!(storeData[i] instanceof TableStoreData)) continue;
            ClassTable tbl = (ClassTable)storeData[i].getDatastoreContainerObject();
            String[] managedClasses = tbl.getManagedClasses();
            for (int j = 0; j < managedClasses.length; ++j) {
                boolean managedClassFound = false;
                Iterator optionsIter = schemaDataOptions.iterator();
                while (optionsIter.hasNext()) {
                    StoreData optionData = (StoreData)optionsIter.next();
                    if (!optionData.getName().equals(managedClasses[j])) continue;
                    managedClassFound = true;
                    break;
                }
                if (managedClassFound) continue;
                haveAllCandidates = false;
                break;
            }
            if (!haveAllCandidates) break;
        }
        if (haveAllCandidates) {
            discrimStmt.setRestrictDiscriminator(false);
        }
        QueryExpression stmt = discrimStmt.getQueryStatement();
        StateManager sm = StateManagerFactory.newStateManagerForHollow(om, objectClass, id);
        JavaTypeMapping idMapping = primaryTable.getIDMapping();
        ScalarExpression fieldExpr = idMapping.newScalarExpression(stmt, stmt.getDefaultTableExpression());
        ScalarExpression fieldValue = idMapping.newLiteral(stmt, sm.getObject());
        stmt.andCondition(fieldExpr.eq(fieldValue), true);
        try {
            Transaction tx = om.getTransaction();
            ManagedConnection mconn = storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                StatementText stmtText = stmt.toStatementText((Boolean)tx.getOptions().get("transaction.serializeReadObjects"));
                String statement = stmtText.toString();
                PreparedStatement ps = stmtText.prepareStatement(om, conn);
                try {
                    ResultSet rs = sqlControl.executeStatementQuery(conn, statement, ps);
                    try {
                        if (rs != null) {
                            while (rs.next()) {
                                className = RDBMSQueryUtils.getClassNameFromDiscriminatorResultSetRow(primaryTable, rs, om);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException sqe) {
            JPOXLogger.RDBMS.error(sqe);
            throw new JPOXDataStoreException(sqe.toString());
        }
        return className;
    }

    public static AbstractClassMetaData getClassMetaDataManagingTableForClass(AbstractClassMetaData cmd) {
        if (cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.NEW_TABLE || cmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.COMPLETE_TABLE) {
            return cmd;
        }
        AbstractClassMetaData superCmd = cmd.getSuperAbstractClassMetaData();
        if (superCmd != null) {
            if (superCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.NEW_TABLE) {
                return superCmd;
            }
            if (superCmd.getInheritanceMetaData().getStrategyValue() == InheritanceStrategy.SUBCLASS_TABLE) {
                return null;
            }
            return RDBMSStoreHelper.getClassMetaDataManagingTableForClass(superCmd);
        }
        return null;
    }
}

