/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.util.Arrays;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.store.DatastoreClass;

class RequestIdentifier {
    private final DatastoreClass table;
    private final int[] fields;
    private final Type type;
    private final int hashCode;
    private final String className;

    public RequestIdentifier(DatastoreClass table, AbstractMemberMetaData[] fields, Type type, String className) {
        this.table = table;
        this.type = type;
        if (fields == null) {
            this.fields = null;
        } else {
            this.fields = new int[fields.length];
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i] = fields[i].getAbsoluteFieldNumber();
            }
            Arrays.sort(this.fields);
        }
        this.className = className;
        int h = table.hashCode() ^ type.hashCode() ^ className.hashCode();
        if (this.fields != null) {
            for (int i = 0; i < this.fields.length; ++i) {
                h ^= this.fields[i];
            }
        }
        this.hashCode = h;
    }

    public DatastoreClass getTable() {
        return this.table;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestIdentifier)) {
            return false;
        }
        RequestIdentifier ri = (RequestIdentifier)o;
        if (this.hashCode != ri.hashCode) {
            return false;
        }
        return this.table.equals(ri.table) && this.type.equals(ri.type) && Arrays.equals(this.fields, ri.fields) && this.className.equals(ri.className);
    }

    public static class Type {
        private int typeId;
        public static final Type INSERT = new Type(0);
        public static final Type FETCH = new Type(1);
        public static final Type UPDATE = new Type(2);
        public static final Type DELETE = new Type(3);
        public static final Type LOCATE = new Type(4);
        private static final String[] TYPE_NAMES = new String[]{"Insert", "Fetch", "Update", "Delete", "Locate"};

        private Type(int typeId) {
            this.typeId = typeId;
        }

        public String toString() {
            return TYPE_NAMES[this.typeId];
        }
    }
}

