/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class SQLWarnings {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");

    public static void log(SQLWarning warning) {
        while (warning != null) {
            JPOXLogger.RDBMS_SQL.warn(LOCALISER.msg("SQLWarning.Message", warning));
            warning = warning.getNextWarning();
        }
    }

    public static void log(Connection conn) {
        try {
            SQLWarnings.log(conn.getWarnings());
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("SQLWarnings.ErrorObtainingWarningsFromConnection", conn), e);
        }
    }

    public static void log(Statement stmt) {
        try {
            SQLWarnings.log(stmt.getWarnings());
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("SQLWarnings.ErrorObtainingWarningsFromStatement", stmt), e);
        }
    }

    public static void log(ResultSet rs) {
        try {
            SQLWarnings.log(rs.getWarnings());
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("SQLWarnings.ErrorObtainingWarningsFromResultSet", rs), e);
        }
    }
}

