/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.store.AbstractAutoStartMechanism;
import org.jpox.store.StoreData;
import org.jpox.store.StoreManager;
import org.jpox.store.TableStoreData;
import org.jpox.store.exceptions.DatastoreInitialisationException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.exceptions.MissingTableException;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.store.rdbms.table.AbstractTable;
import org.jpox.store.rdbms.table.SchemaTableOld;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public class SchemaAutoStarterOld
extends AbstractAutoStartMechanism {
    private static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected SchemaTableOld schemaTable = null;
    protected RDBMSManager storeMgr = null;
    protected Connection conn;
    protected ManagedConnection mconn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaAutoStarterOld(StoreManager store_mgr, ClassLoaderResolver clr) {
        this.storeMgr = (RDBMSManager)store_mgr;
        SQLIdentifier identifier = (SQLIdentifier)this.storeMgr.getIdentifierFactory().newDatastoreContainerIdentifier("JPOX_TABLES");
        if (((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsCatalogsInTableDefinitions() && this.storeMgr.getCatalogName() != null) {
            identifier.setCatalogName(this.storeMgr.getCatalogName());
        }
        if (((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsSchemasInTableDefinitions() && this.storeMgr.getSchemaName() != null) {
            identifier.setSchemaName(this.storeMgr.getSchemaName());
        }
        this.schemaTable = new SchemaTableOld(this.storeMgr);
        this.schemaTable.initialize(clr);
        try {
            ManagedConnection mconn = this.storeMgr.getConnection(0);
            Connection conn = (Connection)mconn.getConnection();
            try {
                this.schemaTable.exists(conn, true);
                if (AbstractTable.isOutputtingDDL()) {
                    try {
                        this.schemaTable.validate(conn, true, false, null);
                    }
                    catch (MissingTableException mte) {}
                } else {
                    this.schemaTable.validate(conn, true, false, null);
                }
            }
            catch (Exception e) {
                JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.ValidationError", this.storeMgr.getSchemaName(), e));
                try {
                    if (JPOXLogger.RDBMS_SCHEMA.isDebugEnabled()) {
                        JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.DropAndCreate", this.schemaTable.toString()));
                    }
                    try {
                        this.schemaTable.drop(conn);
                    }
                    catch (SQLException sqe) {
                        // empty catch block
                    }
                    this.schemaTable.exists(conn, true);
                    this.schemaTable.validate(conn, true, false, null);
                }
                catch (Exception e2) {
                    JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.ValidationError", this.storeMgr.getSchemaName(), e2));
                }
            }
            finally {
                mconn.close();
            }
        }
        catch (SQLException sqe) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError", sqe));
        }
    }

    public Collection getAllClassData() throws DatastoreInitialisationException {
        try {
            this.assertIsOpen();
            HashSet data = null;
            try {
                data = this.schemaTable.getAllClasses(this.conn);
            }
            catch (SQLException sqe2) {
                JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.ClassesReadError", sqe2));
            }
            return data;
        }
        catch (Exception e) {
            throw new DatastoreInitialisationException(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.DatastoreInitialisationException", e), e);
        }
    }

    private void assertIsOpen() {
        if (this.conn == null) {
            throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.AssertIsOpen")).setFatal();
        }
    }

    private void assertIsClosed() {
        if (this.conn != null) {
            throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.AssertIsClosed")).setFatal();
        }
    }

    public void open() {
        this.assertIsClosed();
        try {
            this.mconn = this.storeMgr.getConnection(0);
            this.conn = (Connection)this.mconn.getConnection();
        }
        catch (SQLException sqe2) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError", sqe2));
            throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError", sqe2), sqe2).setFatal();
        }
    }

    public void close() {
        this.assertIsOpen();
        try {
            this.mconn.close();
            this.conn = null;
        }
        catch (JPOXException sqe2) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.Manager.DatabaseConnectionError", sqe2));
        }
    }

    public boolean isOpen() {
        return this.conn != null;
    }

    public void addClass(StoreData data) {
        TableStoreData tableData = (TableStoreData)data;
        this.assertIsOpen();
        try {
            this.schemaTable.addClass(tableData, this.conn);
        }
        catch (SQLException sqe2) {
            String msg = LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.AddClassError", data.getName(), sqe2);
            JPOXLogger.RDBMS_SCHEMA.error(msg);
            throw new JPOXDataStoreException(msg, sqe2);
        }
    }

    public void deleteClass(String class_name) {
        this.assertIsOpen();
        try {
            this.schemaTable.deleteClass(class_name, this.conn);
        }
        catch (SQLException sqe2) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.DeleteClassError", class_name, sqe2));
        }
    }

    public void deleteAllClasses() {
        this.assertIsOpen();
        try {
            this.schemaTable.deleteAllClasses(this.conn);
        }
        catch (SQLException sqe2) {
            JPOXLogger.RDBMS_SCHEMA.error(LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.DeleteClassesError", sqe2));
        }
    }

    public String getStorageDescription() {
        return LOCALISER_RDBMS.msg("RDBMS.SchemaAutoStarter.StorageDescription", this.schemaTable.toString());
    }
}

