/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.StringExpression;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.typeinfo.FirebirdTypeInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class FirebirdAdapter
extends DatabaseAdapter {
    static /* synthetic */ Class class$java$math$BigInteger;

    public FirebirdAdapter(DatabaseMetaData metadata) {
        super(metadata);
    }

    public String getVendorID() {
        return "firebird";
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        return "DROP TABLE " + table.toString();
    }

    public boolean supportsDeferredConstraints() {
        return false;
    }

    public boolean createIndexesBeforeForeignKeys() {
        return true;
    }

    public boolean supportsBooleanComparison() {
        return false;
    }

    public boolean supportsNullsInCandidateKeys() {
        return false;
    }

    public boolean supportsNullsKeywordInColumnOptions() {
        return false;
    }

    public boolean includeOrderByColumnsInSelect() {
        return false;
    }

    public boolean supportsAlterTableDropForeignKeyConstraint() {
        return true;
    }

    public boolean supportsLockWithSelectForUpdate() {
        return true;
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public NumericExpression lengthMethod(StringExpression str) {
        ArrayList<StringExpression> args = new ArrayList<StringExpression>();
        args.add(str);
        return new NumericExpression("STRLEN", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = FirebirdAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        return new StringExpression("SUBSTR", args);
    }

    public StringExpression substringMethod(StringExpression str, NumericExpression begin, NumericExpression end) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(str);
        args.add(begin.add(this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = FirebirdAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, str).newLiteral(str.getQueryExpression(), BigInteger.ONE)));
        args.add(end);
        return new StringExpression("SUBSTR", args);
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        FirebirdTypeInfo ti = new FirebirdTypeInfo(rs);
        return ti;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("CREATE GENERATOR ");
        stmt.append(sequence_name);
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new UnsupportedOperationException("Adapter.SequenceNameNullNotSupported");
        }
        StringBuffer stmt = new StringBuffer("SELECT GEN_ID(");
        stmt.append(sequence_name);
        stmt.append(",1) FROM RDB$DATABASE");
        return stmt.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

