/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.adapter;

import java.math.BigInteger;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Hashtable;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NumericExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.SqlTemporalExpression;
import org.jpox.store.expression.TableExprAsJoins;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.JDBCUtils;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.columninfo.ColumnInfo;
import org.jpox.store.rdbms.columninfo.PostgreSQLColumnInfo;
import org.jpox.store.rdbms.key.PrimaryKey;
import org.jpox.store.rdbms.table.Table;
import org.jpox.store.rdbms.typeinfo.ForeignKeyInfo;
import org.jpox.store.rdbms.typeinfo.PostgreSQLForeignKeyInfo;
import org.jpox.store.rdbms.typeinfo.PostgreSQLTypeInfo;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.JPOXLogger;

public class PostgreSQLAdapter
extends DatabaseAdapter {
    public static final String POSTGRESQL_RESERVED_WORDS = "ALL,ANALYSE,ANALYZE,DO,FREEZE,ILIKE,ISNULL,OFFSET,PLACING,VERBOSE";
    protected Hashtable psqlTypes;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$String;

    public PostgreSQLAdapter(DatabaseMetaData metadata) {
        super(metadata);
        if (this.datastoreMajorVersion < 7) {
            throw new JPOXDataStoreException("PostgreSQL version is " + this.datastoreMajorVersion + '.' + this.datastoreMinorVersion + ", 7.0 or later required");
        }
        if (this.datastoreMajorVersion == 7 && this.datastoreMinorVersion <= 2) {
            --this.maxTableNameLength;
            --this.maxConstraintNameLength;
            --this.maxIndexNameLength;
        }
        this.reservedKeywords.addAll(this.parseKeywordList(POSTGRESQL_RESERVED_WORDS));
        TypeInfo ti = new TypeInfo("char", 1, 65000, null, null, null, 0, false, 3, false, false, false, "char", 0, 0, 10);
        this.addTypeInfo((short)1, ti, true);
        ti = new TypeInfo("text", 2005, 9, null, null, null, 0, false, 3, false, false, false, null, 0, 0, 10);
        this.addTypeInfo((short)2005, ti, true);
    }

    public String getVendorID() {
        return "postgresql";
    }

    public boolean supportsTransactionIsolationLevel(int isolationLevel) {
        return isolationLevel != 0;
    }

    public boolean isBitReallyBoolean() {
        return true;
    }

    public LogicSetExpression newTableExpression(QueryExpression qs, DatastoreContainerObject table, DatastoreIdentifier rangeVar) {
        return new TableExprAsJoins(qs, table, rangeVar);
    }

    public TypeInfo newTypeInfo(ResultSet rs) {
        String psql_type_name;
        Object obj;
        PostgreSQLTypeInfo ti = new PostgreSQLTypeInfo(rs);
        if (this.psqlTypes == null) {
            this.psqlTypes = new Hashtable();
            this.psqlTypes.put("-7", "bool");
            this.psqlTypes.put("93", "timestamptz");
            this.psqlTypes.put("-5", "int8");
            this.psqlTypes.put("1", "char");
            this.psqlTypes.put("91", "date");
            this.psqlTypes.put("8", "float8");
            this.psqlTypes.put("4", "int4");
            this.psqlTypes.put("-1", "text");
            this.psqlTypes.put("2005", "text");
            this.psqlTypes.put("2", "numeric");
            this.psqlTypes.put("7", "float4");
            this.psqlTypes.put("5", "int2");
            this.psqlTypes.put("92", "time");
            this.psqlTypes.put("12", "varchar");
            this.psqlTypes.put("1111", "***TOTALRUBBISH***");
        }
        if ((obj = this.psqlTypes.get("" + ti.dataType)) != null && !ti.typeName.equalsIgnoreCase(psql_type_name = (String)obj)) {
            JPOXLogger.RDBMS_SCHEMA.debug(LOCALISER.msg("RDBMS.Adapter.SQLTypeDiscardedForJDBCType", ti.typeName, JDBCUtils.getNameForJDBCType(ti.dataType)));
            return null;
        }
        return ti;
    }

    public ColumnInfo newColumnInfo(ResultSet rs) {
        return new PostgreSQLColumnInfo(rs);
    }

    public ForeignKeyInfo newForeignKeyInfo(ResultSet rs) {
        return new PostgreSQLForeignKeyInfo(rs);
    }

    public String getAddColumnStatement(DatastoreContainerObject table, Column col) {
        return "ALTER TABLE " + table.toString() + " ADD COLUMN " + col.getSQLDefinition();
    }

    public String getInsertStatementForNoColumns(Table table) {
        return "INSERT INTO " + table.toString() + " VALUES (DEFAULT)";
    }

    public String getRangeByLimitWhereClause(long offset, long count) {
        String str = "";
        if (count > 0L) {
            str = str + " LIMIT " + count;
        }
        if (offset >= 0L) {
            str = str + " OFFSET " + offset;
        }
        return str;
    }

    public boolean supportsLockWithSelectForUpdate() {
        return true;
    }

    public boolean supportsDistinctWithSelectForUpdate() {
        return false;
    }

    public boolean supportsAlterTableDropConstraint() {
        return this.datastoreMajorVersion >= 7 && (this.datastoreMajorVersion != 7 || this.datastoreMinorVersion >= 2);
    }

    public boolean includeOrderByColumnsInSelectUsingAlias() {
        return true;
    }

    public String getAddPrimaryKeyStatement(PrimaryKey pk, IdentifierFactory factory) {
        return null;
    }

    public boolean supportsPrimaryKeyInCreateStatements() {
        return true;
    }

    public String getDropTableStatement(DatastoreContainerObject table) {
        if (this.datastoreMajorVersion < 7 || this.datastoreMajorVersion == 7 && this.datastoreMinorVersion < 3) {
            return "DROP TABLE " + table.toString();
        }
        return "DROP TABLE " + table.toString() + " CASCADE";
    }

    public boolean supportsAnalysisMethods() {
        return false;
    }

    public boolean supportsAutoIncrementFields() {
        return true;
    }

    public String getAutoIncrementStmt(String tableName, String columnName) {
        StringBuffer stmt = new StringBuffer("SELECT currval('");
        boolean quoted = tableName.startsWith(this.getIdentifierQuoteString());
        if (quoted) {
            stmt.append(this.getIdentifierQuoteString());
        }
        stmt.append(JDBCUtils.getIdentifierNameStripped(tableName, this));
        stmt.append("_");
        stmt.append(JDBCUtils.getIdentifierNameStripped(columnName, this));
        stmt.append("_seq");
        if (quoted) {
            stmt.append(this.getIdentifierQuoteString());
        }
        stmt.append("')");
        return stmt.toString();
    }

    public String getAutoIncrementKeyword() {
        return "SERIAL";
    }

    public boolean supportsAutoIncrementKeysNullSpecification() {
        return false;
    }

    public boolean supportsAutoIncrementColumnTypeSpecification() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceCreateStmt(String sequence_name, String min, String max, String start, String increment, String cache_size) {
        if (sequence_name == null) {
            throw new JPOXUserException(LOCALISER.msg("Adapter.SequenceNameNullNotSupported"));
        }
        StringBuffer stmt = new StringBuffer("CREATE SEQUENCE ");
        stmt.append(sequence_name);
        if (min != null && min.length() > 0) {
            stmt.append(" MINVALUE " + min);
        }
        if (max != null && max.length() > 0) {
            stmt.append(" MAXVALUE " + max);
        }
        if (start != null && start.length() > 0) {
            stmt.append(" START WITH " + start);
        }
        if (increment != null && increment.length() > 0) {
            stmt.append(" INCREMENT BY " + increment);
        }
        if (cache_size != null && cache_size.length() > 0) {
            stmt.append(" CACHE " + cache_size);
        } else {
            stmt.append(" CACHE 1");
        }
        return stmt.toString();
    }

    public String getSequenceNextStmt(String sequence_name) {
        if (sequence_name == null) {
            throw new JPOXUserException(LOCALISER.msg("Adapter.SequenceNameNullNotSupported"));
        }
        StringBuffer stmt = new StringBuffer("SELECT nextval('");
        stmt.append(sequence_name);
        stmt.append("')");
        return stmt.toString();
    }

    public String getEscapePatternExpression() {
        return "ESCAPE '\\\\'";
    }

    public NumericExpression indexOfMethod(ScalarExpression source, ScalarExpression str, NumericExpression from) {
        ScalarExpression integerLiteral = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = PostgreSQLAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, source).newLiteral(source.getQueryExpression(), BigInteger.ONE);
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        args.add(source);
        args.add(str);
        if (from != null) {
            throw new JPOXUserException("PostgreSQL doesnt currently provide a function for providing indexOf(str, from). Your workaround is to miss off the 'from' position");
        }
        NumericExpression locateExpr = new NumericExpression("STRPOS", args);
        return new NumericExpression(locateExpr, ScalarExpression.OP_SUB, integerLiteral);
    }

    public NumericExpression getDayMethod(SqlTemporalExpression date) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = PostgreSQLAdapter.class$("java.lang.String")) : class$java$lang$String, date);
        ScalarExpression submethodLiteral = m.newLiteral(date.getQueryExpression(), "day");
        args.add(submethodLiteral);
        args.add(date);
        return new NumericExpression("date_part", args);
    }

    public NumericExpression getMonthMethod(SqlTemporalExpression date) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = PostgreSQLAdapter.class$("java.lang.String")) : class$java$lang$String, date);
        ScalarExpression submethodLiteral = m.newLiteral(date.getQueryExpression(), "month");
        args.add(submethodLiteral);
        args.add(date);
        JavaTypeMapping m2 = this.getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = PostgreSQLAdapter.class$("java.math.BigInteger")) : class$java$math$BigInteger, date);
        ScalarExpression integerLiteral = m2.newLiteral(date.getQueryExpression(), BigInteger.ONE);
        NumericExpression expr = new NumericExpression(new NumericExpression("date_part", args), ScalarExpression.OP_SUB, integerLiteral);
        expr.encloseWithInParentheses();
        return expr;
    }

    public NumericExpression getYearMethod(SqlTemporalExpression date) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = PostgreSQLAdapter.class$("java.lang.String")) : class$java$lang$String, date);
        ScalarExpression submethodLiteral = m.newLiteral(date.getQueryExpression(), "year");
        args.add(submethodLiteral);
        args.add(date);
        return new NumericExpression("date_part", args);
    }

    public NumericExpression getHourMethod(SqlTemporalExpression time) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = PostgreSQLAdapter.class$("java.lang.String")) : class$java$lang$String, time);
        ScalarExpression submethodLiteral = m.newLiteral(time.getQueryExpression(), "hour");
        args.add(submethodLiteral);
        args.add(time);
        return new NumericExpression("date_part", args);
    }

    public NumericExpression getMinuteMethod(SqlTemporalExpression time) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = PostgreSQLAdapter.class$("java.lang.String")) : class$java$lang$String, time);
        ScalarExpression submethodLiteral = m.newLiteral(time.getQueryExpression(), "minute");
        args.add(submethodLiteral);
        args.add(time);
        return new NumericExpression("date_part", args);
    }

    public NumericExpression getSecondMethod(SqlTemporalExpression time) {
        ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
        JavaTypeMapping m = this.getMapping(class$java$lang$String == null ? (class$java$lang$String = PostgreSQLAdapter.class$("java.lang.String")) : class$java$lang$String, time);
        ScalarExpression submethodLiteral = m.newLiteral(time.getQueryExpression(), "second");
        args.add(submethodLiteral);
        args.add(time);
        return new NumericExpression("date_part", args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

