/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.fieldmanager;

import java.sql.PreparedStatement;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.NullValue;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.exceptions.NotYetFlushedException;
import org.jpox.store.fieldmanager.AbstractFieldManager;
import org.jpox.store.mapping.EmbeddedPCMapping;
import org.jpox.store.mapping.InterfaceMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.mapping.SerialisedPCMapping;
import org.jpox.store.mapping.SerialisedReferenceMapping;
import org.jpox.util.Localiser;

public class ParameterSetter
extends AbstractFieldManager {
    private static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    private final StateManager sm;
    private final ObjectManager om;
    private final PreparedStatement ps;
    private final StatementExpressionIndex[] statementExpressionIndex;
    private final boolean checkNonNullable;

    public ParameterSetter(StateManager sm, PreparedStatement ps, StatementExpressionIndex[] statementExpressionIndex, boolean checkNonNullable) {
        this.sm = sm;
        this.om = sm.getObjectManager();
        this.ps = ps;
        this.statementExpressionIndex = statementExpressionIndex;
        this.checkNonNullable = checkNonNullable;
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        this.statementExpressionIndex[fieldNumber].getMapping().setBoolean(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeCharField(int fieldNumber, char value) {
        this.statementExpressionIndex[fieldNumber].getMapping().setChar(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeByteField(int fieldNumber, byte value) {
        this.statementExpressionIndex[fieldNumber].getMapping().setByte(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeShortField(int fieldNumber, short value) {
        this.statementExpressionIndex[fieldNumber].getMapping().setShort(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeIntField(int fieldNumber, int value) {
        this.statementExpressionIndex[fieldNumber].getMapping().setInt(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeLongField(int fieldNumber, long value) {
        this.statementExpressionIndex[fieldNumber].getMapping().setLong(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        this.statementExpressionIndex[fieldNumber].getMapping().setFloat(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeDoubleField(int fieldNumber, double value) {
        this.statementExpressionIndex[fieldNumber].getMapping().setDouble(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeStringField(int fieldNumber, String value) {
        if (this.checkNonNullable && value == null && this.statementExpressionIndex[fieldNumber].getMapping().getFieldMetaData().getNullValue() == NullValue.EXCEPTION) {
            throw new JPOXUserException(LOCALISER.msg("ParameterSetter.FieldCannotBeNull", this.statementExpressionIndex[fieldNumber].getMapping().getFieldMetaData().getFullFieldName()));
        }
        this.statementExpressionIndex[fieldNumber].getMapping().setString(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (this.checkNonNullable && value == null && this.statementExpressionIndex[fieldNumber].getMapping().getFieldMetaData().getNullValue() == NullValue.EXCEPTION) {
            throw new JPOXUserException(LOCALISER.msg("ParameterSetter.FieldCannotBeNull", this.statementExpressionIndex[fieldNumber].getMapping().getFieldMetaData().getFullFieldName()));
        }
        try {
            JavaTypeMapping mapping = this.statementExpressionIndex[fieldNumber].getMapping();
            if (mapping instanceof EmbeddedPCMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping || mapping instanceof PersistenceCapableMapping || mapping instanceof InterfaceMapping) {
                mapping.setObject(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value, this.sm, fieldNumber);
            } else {
                mapping.setObject(this.om, this.ps, this.statementExpressionIndex[fieldNumber].getParameterIndex(), value);
            }
            this.sm.getSCOWrapperForField(fieldNumber, value, false, true, true);
        }
        catch (NotYetFlushedException e) {
            if (this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber).getNullValue() == NullValue.EXCEPTION) {
                throw e;
            }
            this.sm.updateFieldAfterInsert(e.getPersistable(), fieldNumber);
        }
    }
}

