/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.BitSet;
import javax.imageio.ImageIO;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.datatype.BlobImpl;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.TypeConversionHelper;

public abstract class AbstractLargeBinaryRDBMSMapping
extends ColumnMapping {
    static /* synthetic */ Class array$Ljava$math$BigDecimal;
    static /* synthetic */ Class array$Ljava$math$BigInteger;
    static /* synthetic */ Class class$java$util$BitSet;
    static /* synthetic */ Class class$java$awt$image$BufferedImage;

    protected AbstractLargeBinaryRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public AbstractLargeBinaryRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    protected void initialize() {
        this.initTypeInfo();
    }

    public abstract TypeInfo getTypeInfo();

    public void setObject(Object ps, int param, Object value) {
        if (value == null) {
            try {
                ((PreparedStatement)ps).setBytes(param, null);
            }
            catch (SQLException sqle) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + param, this.column, sqle.getMessage()), sqle);
            }
        }
        try {
            if (this.getJavaTypeMapping().isSerialised()) {
                if (!(value instanceof Serializable)) {
                    throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.ObjectNotSerializable", value.getClass().getName()));
                }
                BlobImpl b = new BlobImpl(value);
                ((PreparedStatement)ps).setBytes(param, b.getBytes(0L, (int)b.length()));
            } else if (value instanceof boolean[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromBooleanArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof char[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromCharArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof double[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromDoubleArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof float[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromFloatArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof int[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromIntArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof long[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromLongArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof short[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromShortArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Boolean[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromBooleanObjectArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Byte[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromByteObjectArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Character[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromCharObjectArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Double[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromDoubleObjectArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Float[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromFloatObjectArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Integer[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromIntObjectArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Long[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromLongObjectArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof Short[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromShortObjectArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof BigDecimal[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromBigDecimalArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof BigInteger[]) {
                byte[] data = TypeConversionHelper.getByteArrayFromBigIntegerArray(value);
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof byte[]) {
                ((PreparedStatement)ps).setBytes(param, (byte[])value);
            } else if (value instanceof BitSet) {
                byte[] data = TypeConversionHelper.getByteArrayFromBooleanArray(TypeConversionHelper.getBooleanArrayFromBitSet((BitSet)value));
                ((PreparedStatement)ps).setBytes(param, data);
            } else if (value instanceof BufferedImage) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                ImageIO.write((RenderedImage)((BufferedImage)value), "jpg", baos);
                byte[] buffer = baos.toByteArray();
                baos.close();
                ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
                ((PreparedStatement)ps).setBytes(param, buffer);
                bais.close();
            } else {
                if (!(value instanceof Serializable)) {
                    throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.ObjectNotSerializable", value.getClass().getName()));
                }
                BlobImpl b = new BlobImpl(value);
                ((PreparedStatement)ps).setBytes(param, b.getBytes(0L, (int)b.length()));
            }
        }
        catch (Exception e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), e);
        }
    }

    public Object getObject(Object rs, int param) {
        byte[] bytes = null;
        try {
            bytes = ((ResultSet)rs).getBytes(param);
        }
        catch (SQLException sqle) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, sqle.getMessage()), sqle);
        }
        if (bytes == null) {
            return null;
        }
        if (this.getJavaTypeMapping().isSerialised()) {
            try {
                BlobImpl blob = new BlobImpl(bytes);
                return blob.getObject();
            }
            catch (SQLException sqle) {
                return null;
            }
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.BOOLEAN_ARRAY)) {
            return TypeConversionHelper.getBooleanArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.BYTE_ARRAY)) {
            return bytes;
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.CHAR_ARRAY)) {
            return TypeConversionHelper.getCharArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.DOUBLE_ARRAY)) {
            return TypeConversionHelper.getDoubleArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.FLOAT_ARRAY)) {
            return TypeConversionHelper.getFloatArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.INT_ARRAY)) {
            return TypeConversionHelper.getIntArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.LONG_ARRAY)) {
            return TypeConversionHelper.getLongArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.SHORT_ARRAY)) {
            return TypeConversionHelper.getShortArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_BOOLEAN_ARRAY)) {
            return TypeConversionHelper.getBooleanObjectArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_BYTE_ARRAY)) {
            return TypeConversionHelper.getByteObjectArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_CHARACTER_ARRAY)) {
            return TypeConversionHelper.getCharObjectArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_DOUBLE_ARRAY)) {
            return TypeConversionHelper.getDoubleObjectArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_FLOAT_ARRAY)) {
            return TypeConversionHelper.getFloatObjectArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_INTEGER_ARRAY)) {
            return TypeConversionHelper.getIntObjectArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_LONG_ARRAY)) {
            return TypeConversionHelper.getLongObjectArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals(ClassNameConstants.JAVA_LANG_SHORT_ARRAY)) {
            return TypeConversionHelper.getShortObjectArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals((array$Ljava$math$BigDecimal == null ? (array$Ljava$math$BigDecimal = AbstractLargeBinaryRDBMSMapping.class$("[Ljava.math.BigDecimal;")) : array$Ljava$math$BigDecimal).getName())) {
            return TypeConversionHelper.getBigDecimalArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getType().equals((array$Ljava$math$BigInteger == null ? (array$Ljava$math$BigInteger = AbstractLargeBinaryRDBMSMapping.class$("[Ljava.math.BigInteger;")) : array$Ljava$math$BigInteger).getName())) {
            return TypeConversionHelper.getBigIntegerArrayFromByteArray(bytes);
        }
        if (this.getJavaTypeMapping().getJavaType() != null && this.getJavaTypeMapping().getJavaType().getName().equals((class$java$util$BitSet == null ? (class$java$util$BitSet = AbstractLargeBinaryRDBMSMapping.class$("java.util.BitSet")) : class$java$util$BitSet).getName())) {
            return TypeConversionHelper.getBitSetFromBooleanArray((boolean[])TypeConversionHelper.getBooleanArrayFromByteArray(bytes));
        }
        if (this.getJavaTypeMapping().getJavaType() != null && this.getJavaTypeMapping().getJavaType().getName().equals((class$java$awt$image$BufferedImage == null ? (class$java$awt$image$BufferedImage = AbstractLargeBinaryRDBMSMapping.class$("java.awt.image.BufferedImage")) : class$java$awt$image$BufferedImage).getName())) {
            try {
                return ImageIO.read(new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
            }
        }
        try {
            BlobImpl blob = new BlobImpl(bytes);
            return blob.getObject();
        }
        catch (SQLException sqle) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

