/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.StringUtils;

public class BigIntRDBMSMapping
extends ColumnMapping {
    protected BigIntRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public BigIntRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            ScalarExpression[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
        }
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(-5);
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "int", "" + value), e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = (int)((ResultSet)rs).getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "int", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "long", "" + value, this.column, e.getMessage()), e);
        }
    }

    public long getLong(Object rs, int param) {
        long value;
        try {
            value = ((ResultSet)rs).getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "long", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace(this.column.getDefaultValue().toString())) {
                    ((PreparedStatement)ps).setLong(param, Long.valueOf(this.column.getDefaultValue().toString().trim()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                }
            } else if (value instanceof Date) {
                ((PreparedStatement)ps).setLong(param, ((Date)value).getTime());
            } else {
                ((PreparedStatement)ps).setLong(param, ((Number)value).longValue());
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Long", "" + value, this.column, e.getMessage()), e);
        }
    }

    public Object getObject(Object rs, int param) {
        Comparable<Long> value;
        block6: {
            try {
                String str = ((ResultSet)rs).getString(param);
                if (((ResultSet)rs).wasNull()) {
                    value = null;
                    break block6;
                }
                try {
                    value = new Long(str);
                }
                catch (NumberFormatException nfe) {
                    value = new Long(new Double(str).longValue());
                }
                if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
                    value = new Date((long)value);
                }
            }
            catch (SQLException e) {
                String msg = LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Long", "" + param, this.column, e.getMessage());
                throw new JPOXDataStoreException(msg, e);
            }
        }
        return value;
    }
}

