/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class BooleanRDBMSMapping
extends ColumnMapping {
    protected BooleanRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public BooleanRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(16);
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setBoolean(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "boolean", "" + value, this.column, e.getMessage()), e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        try {
            value = ((ResultSet)rs).getBoolean(param);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Boolean", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else {
                ((PreparedStatement)ps).setBoolean(param, value.equals("Y"));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "String", "" + value, this.column, e.getMessage()), e);
        }
    }

    public String getString(Object rs, int param) {
        String value;
        try {
            value = ((ResultSet)rs).getBoolean(param) ? "Y" : "N";
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "String", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        block5: {
            try {
                if (value == null) {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                    break block5;
                }
                if (value instanceof String) {
                    ((PreparedStatement)ps).setBoolean(param, value.equals("Y"));
                    break block5;
                }
                if (value instanceof Boolean) {
                    ((PreparedStatement)ps).setBoolean(param, (Boolean)value);
                    break block5;
                }
                throw new JPOXUserException(LOCALISER.msg("RDBMS.Mapping.IllegalValueInColumn", value, this.column));
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), e);
            }
        }
    }

    public Object getObject(Object rs, int param) {
        Object value;
        try {
            boolean b = ((ResultSet)rs).getBoolean(param);
            value = ((ResultSet)rs).wasNull() ? null : (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_STRING) ? (b ? "Y" : "N") : (b ? Boolean.TRUE : Boolean.FALSE));
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }
}

