/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.JPOXLogger;
import org.jpox.util.TypeConversionHelper;

public class CharRDBMSMapping
extends ColumnMapping {
    protected CharRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
        JPOXLogger.JDO.info(">> CharRDBMSMapping mapping=" + mapping);
    }

    public CharRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    protected void initialize() {
        if (this.column != null) {
            ScalarExpression[] validValues;
            SingleFieldMapping m;
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && this.column.getColumnMetaData().getLength() == null && (m = (SingleFieldMapping)this.getJavaTypeMapping()).getDefaultLength(0) > 0) {
                this.column.getColumnMetaData().setLength(m.getDefaultLength(0));
            }
            this.column.getColumnMetaData().setJdbcType("CHAR");
            this.column.checkString();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN)) {
                this.column.getColumnMetaData().setLength(1);
                StringBuffer constraints = new StringBuffer("CHECK (" + this.column.getIdentifier() + " IN ('Y','N')");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
            }
            int maxlength = this.getTypeInfo().precision;
            if ((this.column.getColumnMetaData().getLength() <= 0 || this.column.getColumnMetaData().getLength() > maxlength) && this.getTypeInfo().allowsPrecisionSpec) {
                throw new JPOXUserException("String max length of " + this.column.getColumnMetaData().getLength() + " is outside the acceptable range [0, " + maxlength + "] for column \"" + this.column.getIdentifier() + "\"");
            }
        }
        this.initTypeInfo();
    }

    public boolean isDecimalBased() {
        return false;
    }

    public boolean isIntegerBased() {
        return false;
    }

    public boolean isStringBased() {
        return true;
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(1);
    }

    public void setChar(Object ps, int param, char value) {
        try {
            ((PreparedStatement)ps).setString(param, new Character(value).toString());
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "char", "" + value, this.column, e.getMessage()), e);
        }
    }

    public char getChar(Object rs, int param) {
        char value;
        try {
            value = ((ResultSet)rs).getString(param).charAt(0);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "char", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setString(Object ps, int param, String value) {
        try {
            if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setString(param, this.column.getDefaultValue().toString().trim());
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                }
            } else if (this.getDatabaseAdapter().isNullEqualsEmptyStrings()) {
                if (value != null && value.length() == 0) {
                    value = this.getDatabaseAdapter().getSurrogateForEmptyStrings();
                }
                ((PreparedStatement)ps).setString(param, value);
            } else {
                Integer colLength;
                if (this.column != null && (colLength = this.column.getColumnMetaData().getLength()) != null && colLength < value.length()) {
                    throw new JPOXUserException(LOCALISER.msg("RDBMS.Mapping.DataLongerThanColumn", value, ((Object)this.column.getIdentifier()).toString(), "" + colLength)).setFatal();
                }
                ((PreparedStatement)ps).setString(param, value);
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "String", "" + value, this.column, e.getMessage()), e);
        }
    }

    public String getString(Object rs, int param) {
        String value;
        try {
            value = ((ResultSet)rs).getString(param);
            if (this.getDatabaseAdapter().isNullEqualsEmptyStrings() && value != null && value.equals(this.getDatabaseAdapter().getSurrogateForEmptyStrings())) {
                value = "";
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Manager.UnableToGetParam", "String", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setString(param, value ? "Y" : "N");
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "boolean", "" + value, this.column, e.getMessage()), e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        block6: {
            try {
                String s = ((ResultSet)rs).getString(param);
                if (s == null) {
                    if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                        throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
                    }
                    return false;
                }
                if (s.equals("Y")) {
                    value = true;
                    break block6;
                }
                if (s.equals("N")) {
                    value = false;
                    break block6;
                }
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "boolean", "" + param, this.column, e.getMessage()), e);
            }
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else if (value instanceof Boolean) {
                ((PreparedStatement)ps).setString(param, (Boolean)value != false ? "Y" : "N");
            } else if (value instanceof Time) {
                ((PreparedStatement)ps).setString(param, ((Time)value).toString());
            } else if (value instanceof Date) {
                ((PreparedStatement)ps).setString(param, ((Date)value).toString());
            } else if (value instanceof java.util.Date) {
                ((PreparedStatement)ps).setString(param, DateFormat.getInstance().format((java.util.Date)value));
            } else if (value instanceof Timestamp) {
                Calendar cal = this.storeMgr.getOMFContext().getPersistenceConfiguration().getCalendarForDateTimezone();
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value, cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value);
                }
            } else if (value instanceof String) {
                ((PreparedStatement)ps).setString(param, (String)value);
            } else {
                ((PreparedStatement)ps).setString(param, value.toString());
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getObject(Object rs, int param) {
        try {
            String s = ((ResultSet)rs).getString(param);
            if (s == null) {
                return null;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_BOOLEAN)) {
                if (s.equals("Y")) {
                    return Boolean.TRUE;
                }
                if (!s.equals("N")) throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
                return Boolean.FALSE;
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_CHARACTER)) {
                return new Character(s.charAt(0));
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
                return Time.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
                return Date.valueOf(s);
            }
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
                return DateFormat.getInstance().parse(s);
            }
            if (!this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIMESTAMP)) return s;
            Calendar cal = this.storeMgr.getOMFContext().getPersistenceConfiguration().getCalendarForDateTimezone();
            return TypeConversionHelper.stringToTimestamp(s, cal);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
        }
        catch (ParseException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
        }
    }
}

