/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class DecimalRDBMSMapping
extends ColumnMapping {
    private static final int INT_MAX_DECIMAL_DIGITS = 10;
    private static final int LONG_MAX_DECIMAL_DIGITS = 19;

    protected DecimalRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public DecimalRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null && this.column.getColumnMetaData().getLength() == null) {
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                this.column.getColumnMetaData().setLength(10);
                this.column.checkDecimal();
            } else {
                this.column.getColumnMetaData().setLength(Math.min(this.getTypeInfo().precision, 19));
                this.column.checkDecimal();
            }
        }
        this.initTypeInfo();
    }

    public boolean isDecimalBased() {
        return true;
    }

    public boolean isIntegerBased() {
        return false;
    }

    public boolean isStringBased() {
        return false;
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(3);
    }

    public void setDouble(Object ps, int param, double value) {
        try {
            ((PreparedStatement)ps).setDouble(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "double", "" + value, this.column, e.getMessage()), e);
        }
    }

    public void setFloat(Object ps, int param, float value) {
        try {
            ((PreparedStatement)ps).setDouble(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "float", "" + value, this.column, e.getMessage()), e);
        }
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "int", "" + value, this.column, e.getMessage()), e);
        }
    }

    public double getDouble(Object rs, int param) {
        double value;
        try {
            value = ((ResultSet)rs).getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "double", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public float getFloat(Object rs, int param) {
        float value;
        try {
            value = (float)((ResultSet)rs).getDouble(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "float", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "int", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setLong(Object ps, int param, long value) {
        try {
            ((PreparedStatement)ps).setLong(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "long", "" + value, this.column, e.getMessage()), e);
        }
    }

    public long getLong(Object rs, int param) {
        long value;
        try {
            value = ((ResultSet)rs).getLong(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "long", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null) {
                    ((PreparedStatement)ps).setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                }
            } else if (value instanceof Integer) {
                ((PreparedStatement)ps).setBigDecimal(param, new BigDecimal((Integer)value));
            } else if (value instanceof Long) {
                ((PreparedStatement)ps).setBigDecimal(param, new BigDecimal((Long)value));
            } else if (value instanceof BigDecimal) {
                ((PreparedStatement)ps).setBigDecimal(param, (BigDecimal)value);
            } else if (value instanceof Float) {
                ((PreparedStatement)ps).setDouble(param, ((Float)value).doubleValue());
            } else if (value instanceof Double) {
                ((PreparedStatement)ps).setDouble(param, (Double)value);
            } else if (value instanceof BigInteger) {
                ((PreparedStatement)ps).setBigDecimal(param, new BigDecimal((BigInteger)value));
            } else {
                ((PreparedStatement)ps).setInt(param, (Integer)value);
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), e);
        }
    }

    public Object getObject(Object rs, int param) {
        Number value;
        try {
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                value = ((ResultSet)rs).getBigDecimal(param);
                value = value == null ? null : new Integer(((BigDecimal)value).toBigInteger().intValue());
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_LONG)) {
                value = ((ResultSet)rs).getBigDecimal(param);
                value = value == null ? null : new Long(((BigDecimal)value).toBigInteger().longValue());
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_MATH_BIGINTEGER)) {
                value = ((ResultSet)rs).getBigDecimal(param);
                value = value == null ? null : ((BigDecimal)value).toBigInteger();
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_MATH_BIGDECIMAL)) {
                value = ((ResultSet)rs).getBigDecimal(param);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_FLOAT)) {
                double d = ((ResultSet)rs).getDouble(param);
                value = ((ResultSet)rs).wasNull() ? null : new Float(d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_DOUBLE)) {
                double d = ((ResultSet)rs).getDouble(param);
                value = ((ResultSet)rs).wasNull() ? null : new Double(d);
            } else {
                int i = ((ResultSet)rs).getInt(param);
                value = ((ResultSet)rs).wasNull() ? null : new Integer(i);
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }
}

