/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.DoubleRDBMSMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class FloatRDBMSMapping
extends DoubleRDBMSMapping {
    protected FloatRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public FloatRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(6);
    }

    public float getFloat(Object rs, int param) {
        float value;
        try {
            value = ((ResultSet)rs).getFloat(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "float", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setFloat(Object ps, int param, float value) {
        try {
            ((PreparedStatement)ps).setFloat(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "float", "" + value, this.column, e.getMessage()), e);
        }
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else if (value instanceof Integer) {
                ((PreparedStatement)ps).setFloat(param, ((Integer)value).floatValue());
            } else if (value instanceof Long) {
                ((PreparedStatement)ps).setFloat(param, ((Long)value).floatValue());
            } else if (value instanceof Float) {
                ((PreparedStatement)ps).setFloat(param, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                ((PreparedStatement)ps).setDouble(param, (Double)value);
            } else {
                ((PreparedStatement)ps).setFloat(param, ((Double)value).floatValue());
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), e);
        }
    }

    public Object getObject(Object rs, int param) {
        Number value;
        try {
            float d = ((ResultSet)rs).getFloat(param);
            if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_INTEGER)) {
                value = ((ResultSet)rs).wasNull() ? null : new Integer((int)d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_LONG)) {
                value = ((ResultSet)rs).wasNull() ? null : new Long((long)d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_FLOAT)) {
                value = ((ResultSet)rs).wasNull() ? null : new Float(d);
            } else if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_LANG_DOUBLE)) {
                double dbl = ((ResultSet)rs).getDouble(param);
                value = ((ResultSet)rs).wasNull() ? null : new Double(dbl);
            } else {
                value = ((ResultSet)rs).wasNull() ? null : new Double(d);
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }
}

