/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import org.jpox.exceptions.JPOXException;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.Localiser;

public abstract class RDBMSMapping
implements DatastoreMapping {
    protected static final Localiser LOCALISER_STORE = Localiser.getInstance("org.jpox.store.Localisation");
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected final StoreManager storeMgr;
    protected final JavaTypeMapping mapping;

    protected RDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        this.storeMgr = storeMgr;
        this.mapping = mapping;
        if (mapping != null) {
            mapping.addDataStoreMapping(this);
        }
    }

    protected RDBMSAdapter getDatabaseAdapter() {
        return (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
    }

    public JavaTypeMapping getJavaTypeMapping() {
        return this.mapping;
    }

    public abstract TypeInfo getTypeInfo();

    public abstract boolean isNullable();

    public abstract boolean includeInFetchStatement();

    public boolean insertValuesOnInsert() {
        return this.getInsertionInputParameter().indexOf(63) > -1;
    }

    public abstract String getInsertionInputParameter();

    public abstract String getUpdateInputParameter();

    protected String failureMessage(String method) {
        return LOCALISER_STORE.msg("Mapping.FailureMessageForField", this.getClass().getName(), method, this.mapping.getFieldMetaData().getFullFieldName());
    }

    public void setBoolean(Object preparedStatement, int exprIndex, boolean value) {
        throw new JPOXException(this.failureMessage("setBoolean")).setFatal();
    }

    public boolean getBoolean(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getBoolean")).setFatal();
    }

    public void setChar(Object preparedStatement, int exprIndex, char value) {
        throw new JPOXException(this.failureMessage("setChar")).setFatal();
    }

    public char getChar(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getChar")).setFatal();
    }

    public void setByte(Object preparedStatement, int exprIndex, byte value) {
        throw new JPOXException(this.failureMessage("setByte")).setFatal();
    }

    public byte getByte(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getByte")).setFatal();
    }

    public void setShort(Object preparedStatement, int exprIndex, short value) {
        throw new JPOXException(this.failureMessage("setShort")).setFatal();
    }

    public short getShort(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getShort")).setFatal();
    }

    public void setInt(Object preparedStatement, int exprIndex, int value) {
        throw new JPOXException(this.failureMessage("setInt")).setFatal();
    }

    public int getInt(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getInt")).setFatal();
    }

    public void setLong(Object preparedStatement, int exprIndex, long value) {
        throw new JPOXException(this.failureMessage("setLong")).setFatal();
    }

    public long getLong(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getLong")).setFatal();
    }

    public void setFloat(Object preparedStatement, int exprIndex, float value) {
        throw new JPOXException(this.failureMessage("setFloat")).setFatal();
    }

    public float getFloat(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getFloat")).setFatal();
    }

    public void setDouble(Object preparedStatement, int exprIndex, double value) {
        throw new JPOXException(this.failureMessage("setDouble")).setFatal();
    }

    public double getDouble(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getDouble")).setFatal();
    }

    public void setString(Object preparedStatement, int exprIndex, String value) {
        throw new JPOXException(this.failureMessage("setString")).setFatal();
    }

    public String getString(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getString")).setFatal();
    }

    public void setObject(Object preparedStatement, int exprIndex, Object value) {
        throw new JPOXException(this.failureMessage("setObject")).setFatal();
    }

    public Object getObject(Object resultSet, int exprIndex) {
        throw new JPOXException(this.failureMessage("getObject")).setFatal();
    }
}

