/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jpox.ClassLoaderResolver;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXException;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.ColumnMetaData;
import org.jpox.metadata.MetaData;
import org.jpox.metadata.NullValue;
import org.jpox.plugin.ConfigurationElement;
import org.jpox.plugin.ExtensionPoint;
import org.jpox.plugin.PluginManager;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.IdentifierFactory;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.AbstractMappingManager;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.DatastoreMappingFactory;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.util.ClassUtils;
import org.jpox.util.JPOXLogger;
import org.jpox.util.JavaUtils;
import org.jpox.util.Localiser;
import org.jpox.util.MultiMap;
import org.jpox.util.StringUtils;

public class RDBMSMappingManager
extends AbstractMappingManager {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    MultiMap datastoreMappingsByJavaType;
    MultiMap datastoreMappingsByJDBCType;
    MultiMap datastoreMappingsBySQLType;

    public void loadDatastoreMapping(PluginManager mgr, ClassLoaderResolver clr, String vendorId) {
        if (this.datastoreMappingsByJavaType != null) {
            return;
        }
        this.datastoreMappingsByJDBCType = new MultiMap();
        this.datastoreMappingsBySQLType = new MultiMap();
        this.datastoreMappingsByJavaType = new MultiMap();
        ExtensionPoint exPoint = mgr.getExtensionPoint("org.jpox.store_datastoremapping");
        for (int i = 0; i < exPoint.getExtensions().length; ++i) {
            ConfigurationElement[] elms = exPoint.getExtensions()[i].getConfigurationElements();
            for (int e = 0; e < elms.length; ++e) {
                String javaName = elms[e].getAttribute("java-type").trim();
                String rdbmsMappingClassName = elms[e].getAttribute("rdbms-mapping-class");
                String jdbcType = elms[e].getAttribute("jdbc-type");
                String sqlType = elms[e].getAttribute("sql-type");
                String defaultJava = elms[e].getAttribute("default");
                String javaVersion = elms[e].getAttribute("java-version");
                String javaVersionRestricted = elms[e].getAttribute("java-version-restricted");
                boolean defaultForJavaType = false;
                if (defaultJava != null && defaultJava.equalsIgnoreCase("true")) {
                    defaultForJavaType = Boolean.TRUE;
                }
                boolean javaRestricted = false;
                if (javaVersionRestricted != null && javaVersionRestricted.equalsIgnoreCase("true")) {
                    javaRestricted = Boolean.TRUE;
                }
                if (javaVersion == null || javaVersion.length() < 1) {
                    javaVersion = "1.3";
                }
                if ((!JavaUtils.isGreaterEqualsThan(javaVersion) || javaRestricted) && (!JavaUtils.isEqualsThan(javaVersion) || !javaRestricted)) continue;
                Class mappingType = null;
                if (StringUtils.isWhitespace(rdbmsMappingClassName)) continue;
                try {
                    mappingType = mgr.loadClass(elms[e].getExtension().getPlugin().getSymbolicName(), rdbmsMappingClassName);
                }
                catch (JPOXException jpe) {
                    JPOXLogger.METADATA.error(LOCALISER.msg("Mapping.DatastoreMappingClassNotFound", rdbmsMappingClassName));
                }
                HashSet<String> includes = new HashSet<String>();
                HashSet<String> excludes = new HashSet<String>();
                ConfigurationElement[] childElm = elms[e].getChildren();
                for (int j = 0; j < childElm.length; ++j) {
                    if (childElm[j].getName().equals("includes")) {
                        includes.add(childElm[j].getAttribute("vendor-id"));
                        continue;
                    }
                    if (!childElm[j].getName().equals("excludes")) continue;
                    excludes.add(childElm[j].getAttribute("vendor-id"));
                }
                if (excludes.contains(vendorId) || !includes.isEmpty() && !includes.contains(vendorId)) continue;
                this.registerDatastoreMapping(javaName, mappingType, jdbcType, sqlType, defaultForJavaType);
            }
        }
    }

    public void registerDatastoreMapping(String javaTypeName, Class datastoreMappingType, String jdbcType, String sqlType, boolean dflt) {
        boolean mappingRequired = true;
        Collection coll = (Collection)this.datastoreMappingsByJavaType.get(javaTypeName);
        if (coll != null && coll.size() > 0) {
            Iterator collIter = coll.iterator();
            while (collIter.hasNext()) {
                RDBMSTypeMapping typeMapping = (RDBMSTypeMapping)collIter.next();
                if (typeMapping.getJdbcType().equals(jdbcType) && typeMapping.getSqlType().equals(sqlType)) {
                    mappingRequired = false;
                    if (typeMapping.isDefault() == dflt) continue;
                    typeMapping.setDefault(dflt);
                    continue;
                }
                if (!dflt) continue;
                typeMapping.setDefault(false);
            }
        }
        if (mappingRequired) {
            RDBMSTypeMapping mapping = new RDBMSTypeMapping(datastoreMappingType, dflt, javaTypeName, jdbcType, sqlType);
            this.datastoreMappingsByJDBCType.put(jdbcType, mapping);
            this.datastoreMappingsBySQLType.put(sqlType, mapping);
            this.datastoreMappingsByJavaType.put(javaTypeName, mapping);
            if (JPOXLogger.RDBMS.isDebugEnabled()) {
                JPOXLogger.RDBMS.debug(LOCALISER_RDBMS.msg("RDBMS.MappingManager.AddMapping", javaTypeName, jdbcType, sqlType, datastoreMappingType.getName(), "" + dflt));
            }
        }
    }

    public void deregisterDatastoreMappingsForJDBCType(String jdbcTypeName) {
        Collection coll = (Collection)this.datastoreMappingsByJDBCType.get(jdbcTypeName);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet mappings = new HashSet(coll);
        Iterator iter = mappings.iterator();
        while (iter.hasNext()) {
            RDBMSTypeMapping mapping = (RDBMSTypeMapping)iter.next();
            this.datastoreMappingsByJavaType.remove(mapping.getJavaType(), mapping);
            this.datastoreMappingsBySQLType.remove(mapping.getSqlType(), mapping);
            this.datastoreMappingsByJDBCType.remove(mapping.getJdbcType(), mapping);
            if (!JPOXLogger.RDBMS.isDebugEnabled()) continue;
            JPOXLogger.RDBMS.debug(LOCALISER_RDBMS.msg("RDBMS.MappingManager.RemoveMapping", mapping.getJavaType(), mapping.getJdbcType(), mapping.getSqlType()));
        }
    }

    protected Class getDatastoreMappingClass(String fieldName, String javaType, String jdbcType, String sqlType, ClassLoaderResolver clr) {
        AbstractMappingManager.TypeMapping datastoreMapping = null;
        if (javaType == null) {
            return null;
        }
        javaType = ClassUtils.getWrapperTypeNameForPrimitiveTypeName(javaType);
        if (sqlType != null) {
            if (this.datastoreMappingsBySQLType.get(sqlType.toUpperCase()) == null) {
                if (fieldName != null) {
                    throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnknownSQLTypeForJavaTypeForField", javaType, sqlType, fieldName)).setFatal();
                }
                throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnknownSQLTypeForJavaType", javaType, sqlType)).setFatal();
            }
            Iterator sqlTypeIter = ((Collection)this.datastoreMappingsBySQLType.get(sqlType.toUpperCase())).iterator();
            while (sqlTypeIter.hasNext()) {
                RDBMSTypeMapping sqlTypeMapping = (RDBMSTypeMapping)sqlTypeIter.next();
                if (!sqlTypeMapping.getJavaType().equals(javaType)) continue;
                datastoreMapping = sqlTypeMapping;
                break;
            }
        } else if (jdbcType != null) {
            if (this.datastoreMappingsByJDBCType.get(jdbcType.toUpperCase()) == null) {
                if (fieldName != null) {
                    throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnknownJDBCTypeForJavaTypeForField", javaType, jdbcType, fieldName)).setFatal();
                }
                throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnknownJDBCTypeForJavaType", javaType, jdbcType)).setFatal();
            }
            Iterator jdbcTypeIter = ((Collection)this.datastoreMappingsByJDBCType.get(jdbcType.toUpperCase())).iterator();
            while (jdbcTypeIter.hasNext()) {
                RDBMSTypeMapping jdbcTypeMapping = (RDBMSTypeMapping)jdbcTypeIter.next();
                if (!jdbcTypeMapping.getJavaType().equals(javaType)) continue;
                datastoreMapping = jdbcTypeMapping;
                break;
            }
            if (datastoreMapping == null) {
                if (fieldName != null) {
                    throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnknownJDBCTypeForJavaTypeForField", javaType, jdbcType, fieldName)).setFatal();
                }
                throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnknownJDBCTypeForJavaType", javaType, jdbcType)).setFatal();
            }
        }
        if (datastoreMapping == null) {
            String type = ClassUtils.getWrapperTypeNameForPrimitiveTypeName(javaType);
            Collection mappings = (Collection)this.datastoreMappingsByJavaType.get(type);
            if (mappings == null) {
                Class javaTypeClass = clr.classForName(type);
                for (Class superClass = javaTypeClass.getSuperclass(); superClass != null && !superClass.getName().equals(ClassNameConstants.Object) && mappings == null; superClass = superClass.getSuperclass()) {
                    mappings = (Collection)this.datastoreMappingsByJavaType.get(superClass.getName());
                }
            }
            if (mappings != null) {
                if (mappings.size() == 1) {
                    datastoreMapping = (RDBMSTypeMapping)mappings.iterator().next();
                } else {
                    Iterator mappingsIter = mappings.iterator();
                    while (mappingsIter.hasNext()) {
                        RDBMSTypeMapping rdbmsMapping = (RDBMSTypeMapping)mappingsIter.next();
                        if (!rdbmsMapping.isDefault()) continue;
                        datastoreMapping = rdbmsMapping;
                        break;
                    }
                    if (datastoreMapping == null && mappings.size() > 0) {
                        datastoreMapping = (RDBMSTypeMapping)mappings.iterator().next();
                    }
                }
            }
        }
        if (datastoreMapping == null) {
            if (fieldName != null) {
                throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnsupportedJavaTypeForField", javaType, jdbcType, sqlType, fieldName)).setFatal();
            }
            throw new JPOXException(LOCALISER_RDBMS.msg("RDBMS.MappingManager.UnsupportedJavaType", javaType, jdbcType, sqlType)).setFatal();
        }
        return datastoreMapping.getMappingType();
    }

    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, AbstractMemberMetaData fmd, int index, StoreManager storeMgr, DatastoreField column) {
        Class datastoreMappingClass = null;
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        if (fmd.getColumnMetaData().length > 0 && fmd.getColumnMetaData()[index].hasExtension("datastore-mapping-class")) {
            datastoreMappingClass = clr.classForName(fmd.getColumnMetaData()[index].getValueForExtension("datastore-mapping-class"));
        }
        if (datastoreMappingClass == null) {
            String javaType = mapping.getJavaTypeForDatastoreMapping(index);
            String jdbcType = null;
            String sqlType = null;
            if (mapping.getRoleForField() == 2 || mapping.getRoleForField() == 1) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = fmd.getElementMetaData() != null ? fmd.getElementMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (fmd.getCollection() != null && fmd.getCollection().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
                if (fmd.getArray() != null && fmd.getArray().isSerializedElement()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForField() == 3) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = fmd.getKeyMetaData() != null ? fmd.getKeyMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (fmd.getMap().isSerializedKey()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForField() == 4) {
                ColumnMetaData[] colmds;
                ColumnMetaData[] columnMetaDataArray = colmds = fmd.getValueMetaData() != null ? fmd.getValueMetaData().getColumnMetaData() : null;
                if (colmds != null && colmds.length > 0) {
                    jdbcType = colmds[index].getJdbcType();
                    sqlType = colmds[index].getSqlType();
                }
                if (fmd.getMap().isSerializedValue()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            } else if (mapping.getRoleForField() == 0) {
                if (fmd.getColumnMetaData().length > 0) {
                    jdbcType = fmd.getColumnMetaData()[index].getJdbcType();
                    sqlType = fmd.getColumnMetaData()[index].getSqlType();
                }
                if (fmd.isSerialized()) {
                    javaType = ClassNameConstants.JAVA_IO_SERIALIZABLE;
                }
            }
            datastoreMappingClass = this.getDatastoreMappingClass(fmd.getFullFieldName(), javaType, jdbcType, sqlType, clr);
        }
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping(datastoreMappingClass, mapping, storeMgr, column);
        if (column != null) {
            column.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    public DatastoreMapping createDatastoreMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField column, String javaType) {
        ClassLoaderResolver clr = storeMgr.getOMFContext().getClassLoaderResolver(null);
        Column col = (Column)column;
        String jdbcType = null;
        String sqlType = null;
        if (col != null && col.getColumnMetaData() != null) {
            jdbcType = col.getColumnMetaData().getJdbcType();
            sqlType = col.getColumnMetaData().getSqlType();
        }
        Class datastoreMappingClass = this.getDatastoreMappingClass(null, javaType, jdbcType, sqlType, clr);
        DatastoreMapping datastoreMapping = DatastoreMappingFactory.createMapping(datastoreMappingClass, mapping, storeMgr, column);
        if (column != null) {
            column.setDatastoreMapping(datastoreMapping);
        }
        return datastoreMapping;
    }

    public DatastoreField createDatastoreField(JavaTypeMapping mapping, String javaType, int datastoreFieldIndex) {
        ColumnMetaData[] colmds;
        AbstractMemberMetaData fmd = mapping.getFieldMetaData();
        int roleForField = mapping.getRoleForField();
        DatastoreContainerObject datastoreContainer = mapping.getDatastoreContainer();
        ColumnMetaData colmd = null;
        MetaData columnContainer = fmd;
        if (roleForField == 1 || roleForField == 2) {
            columnContainer = fmd.getElementMetaData();
        } else if (roleForField == 3) {
            columnContainer = fmd.getKeyMetaData();
        } else if (roleForField == 4) {
            columnContainer = fmd.getValueMetaData();
        }
        if (columnContainer != null && columnContainer.getColumnMetaData().length > datastoreFieldIndex) {
            colmd = columnContainer.getColumnMetaData()[datastoreFieldIndex];
            colmds = columnContainer.getColumnMetaData();
        } else {
            colmd = new ColumnMetaData((MetaData)fmd, fmd.getColumn());
            if (columnContainer != null) {
                columnContainer.addColumn(colmd);
                colmds = columnContainer.getColumnMetaData();
            } else {
                colmds = new ColumnMetaData[]{colmd};
            }
        }
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            if (roleForField == 0) {
                identifier = idFactory.newIdentifier(1, fmd.getName());
                int i = 0;
                while (datastoreContainer.hasDatastoreField(identifier)) {
                    identifier = idFactory.newIdentifier(1, fmd.getName() + "_" + i);
                    ++i;
                }
            } else if (roleForField == 1) {
                identifier = ((RDBMSIdentifierFactory)idFactory).newJoinTableFieldIdentifier(fmd, null, null, true, 3);
            } else if (roleForField == 2) {
                identifier = ((RDBMSIdentifierFactory)idFactory).newJoinTableFieldIdentifier(fmd, null, null, true, 4);
            } else if (roleForField == 3) {
                identifier = ((RDBMSIdentifierFactory)idFactory).newJoinTableFieldIdentifier(fmd, null, null, true, 5);
            } else if (roleForField == 4) {
                identifier = ((RDBMSIdentifierFactory)idFactory).newJoinTableFieldIdentifier(fmd, null, null, true, 6);
            }
            colmd.setName(identifier.getIdentifier());
        } else {
            identifier = idFactory.newDatastoreFieldIdentifier(colmds[datastoreFieldIndex].getName(), datastoreContainer.getStoreManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1);
        }
        Column col = (Column)datastoreContainer.addDatastoreField(javaType, identifier, mapping, colmd);
        if (fmd.isPrimaryKey()) {
            col.setAsPrimaryKey();
        }
        if (datastoreContainer.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false) && datastoreContainer instanceof DatastoreClass && (fmd.isPrimaryKey() && ((DatastoreClass)datastoreContainer).isBaseDatastoreClass() || !fmd.isPrimaryKey())) {
            col.setAutoIncrement(true);
        }
        if (fmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("select-function"), 0);
        }
        if (fmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("insert-function"), 1);
        }
        if (fmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("update-function"), 2);
        }
        this.setDatastoreFieldNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    public DatastoreField createDatastoreField(JavaTypeMapping mapping, String javaType, ColumnMetaData colmd) {
        Column col;
        AbstractMemberMetaData fmd = mapping.getFieldMetaData();
        DatastoreContainerObject datastoreContainer = mapping.getDatastoreContainer();
        if (colmd == null) {
            colmd = new ColumnMetaData((MetaData)fmd, fmd.getColumn());
            fmd.addColumn(colmd);
        }
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        if (colmd.getName() == null) {
            DatastoreIdentifier identifier = idFactory.newIdentifier(1, fmd.getName());
            int i = 0;
            while (datastoreContainer.hasDatastoreField(identifier)) {
                identifier = idFactory.newIdentifier(1, fmd.getName() + "_" + i);
                ++i;
            }
            colmd.setName(identifier.getIdentifier());
            col = (Column)datastoreContainer.addDatastoreField(javaType, identifier, mapping, colmd);
        } else {
            col = (Column)datastoreContainer.addDatastoreField(javaType, idFactory.newDatastoreFieldIdentifier(colmd.getName(), datastoreContainer.getStoreManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), -1), mapping, colmd);
        }
        this.setDatastoreFieldNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    public DatastoreField createDatastoreField(AbstractMemberMetaData fmd, DatastoreContainerObject datastoreContainer, JavaTypeMapping mapping, ColumnMetaData colmd, DatastoreField reference, ClassLoaderResolver clr) {
        IdentifierFactory idFactory = datastoreContainer.getStoreManager().getIdentifierFactory();
        DatastoreIdentifier identifier = null;
        if (colmd.getName() == null) {
            AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
            identifier = ((RDBMSIdentifierFactory)idFactory).newForeignKeyFieldIdentifier(relatedMmds != null ? relatedMmds[0] : null, fmd, reference.getIdentifier(), datastoreContainer.getStoreManager().getOMFContext().getTypeManager().isDefaultEmbeddedType(fmd.getType()), 1);
            colmd.setName(identifier.getIdentifier());
        } else {
            identifier = idFactory.newDatastoreFieldIdentifier(colmd.getName(), false, -1);
        }
        Column col = (Column)datastoreContainer.addDatastoreField(fmd.getType().getName(), identifier, mapping, colmd);
        reference.copyConfigurationTo(col);
        if (fmd.isPrimaryKey()) {
            col.setAsPrimaryKey();
        }
        if (datastoreContainer.getStoreManager().isStrategyDatastoreAttributed(fmd.getValueStrategy(), false) && (fmd.isPrimaryKey() && ((DatastoreClass)datastoreContainer).isBaseDatastoreClass() || !fmd.isPrimaryKey())) {
            col.setAutoIncrement(true);
        }
        if (fmd.getValueForExtension("select-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("select-function"), 0);
        }
        if (fmd.getValueForExtension("insert-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("insert-function"), 1);
        }
        if (fmd.getValueForExtension("update-function") != null) {
            col.setWrapperFunction(fmd.getValueForExtension("update-function"), 2);
        }
        this.setDatastoreFieldNullability(fmd, colmd, col);
        if (fmd.getNullValue() == NullValue.DEFAULT) {
            col.setDefaultable();
            if (colmd.getDefaultValue() != null) {
                col.setDefaultValue(colmd.getDefaultValue());
            }
        }
        return col;
    }

    private void setDatastoreFieldNullability(AbstractMemberMetaData mmd, ColumnMetaData colmd, DatastoreField field) {
        if (colmd != null && !colmd.isAllowsNullSet()) {
            if (mmd.isPrimaryKey()) {
                colmd.setAllowsNull(new Boolean(false));
            } else if (!mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
                colmd.setAllowsNull(new Boolean(true));
            } else {
                colmd.setAllowsNull(new Boolean(false));
            }
            if (colmd.isAllowsNull()) {
                field.setNullable();
            }
        } else if (colmd != null && colmd.isAllowsNullSet()) {
            if (colmd.isAllowsNull()) {
                field.setNullable();
            }
        } else if (!mmd.isPrimaryKey() && !mmd.getType().isPrimitive() && mmd.getNullValue() != NullValue.EXCEPTION) {
            field.setNullable();
        }
    }

    protected class RDBMSTypeMapping
    extends AbstractMappingManager.TypeMapping {
        private String javaType;
        private String jdbcType;
        private String sqlType;

        public RDBMSTypeMapping(Class mappingType, boolean isDefault, String javaType, String jdbcType, String sqlType) {
            super(mappingType, isDefault);
            this.javaType = javaType;
            this.jdbcType = jdbcType;
            this.sqlType = sqlType;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public String getJdbcType() {
            return this.jdbcType;
        }

        public String getSqlType() {
            return this.sqlType;
        }
    }
}

