/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;

public class RealRDBMSMapping
extends ColumnMapping {
    protected RealRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public RealRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    public boolean isDecimalBased() {
        return true;
    }

    public boolean isIntegerBased() {
        return false;
    }

    public boolean isStringBased() {
        return false;
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(7);
    }

    public void setFloat(Object ps, int param, float value) {
        try {
            ((PreparedStatement)ps).setFloat(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "float", "" + value, this.column, e.getMessage()), e);
        }
    }

    public float getFloat(Object rs, int param) {
        float value;
        try {
            value = ((ResultSet)rs).getFloat(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            try {
                value = Float.parseFloat(((ResultSet)rs).getString(param));
                if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                    throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
                }
            }
            catch (SQLException e1) {
                try {
                    throw new JPOXDataStoreException("Can't get float result: param = " + param + " - " + ((ResultSet)rs).getString(param), e);
                }
                catch (SQLException e2) {
                    throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "float", "" + param, this.column, e.getMessage()), e);
                }
            }
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else {
                ((PreparedStatement)ps).setFloat(param, ((Float)value).floatValue());
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.column, e.getMessage()), e);
        }
    }

    public Object getObject(Object rs, int param) {
        Float value;
        try {
            float f = ((ResultSet)rs).getFloat(param);
            value = ((ResultSet)rs).wasNull() ? null : new Float(f);
        }
        catch (SQLException e) {
            try {
                value = new Float(Float.parseFloat(((ResultSet)rs).getString(param)));
                if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                    throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
                }
            }
            catch (SQLException e1) {
                try {
                    throw new JPOXDataStoreException("Can't get float result: param = " + param + " - " + ((ResultSet)rs).getString(param), e);
                }
                catch (SQLException e2) {
                    throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Object", "" + param, this.column, e.getMessage()), e);
                }
            }
        }
        return value;
    }
}

