/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.jpox.ClassNameConstants;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.TypeConversionHelper;

public class TimestampRDBMSMapping
extends ColumnMapping {
    protected TimestampRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public TimestampRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            this.column.checkPrimitive();
        }
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(93);
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            Calendar cal = this.storeMgr.getOMFContext().getPersistenceConfiguration().getCalendarForDateTimezone();
            if (value == null) {
                ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
            } else if (value instanceof Date) {
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Date)value).getTime()), cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Date)value).getTime()));
                }
            } else if (value instanceof Time) {
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Time)value).getTime()), cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((Time)value).getTime()));
                }
            } else if (value instanceof java.sql.Date) {
                if (cal != null) {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((java.sql.Date)value).getTime()), cal);
                } else {
                    ((PreparedStatement)ps).setTimestamp(param, new Timestamp(((java.sql.Date)value).getTime()));
                }
            } else if (cal != null) {
                ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value, cal);
            } else {
                ((PreparedStatement)ps).setTimestamp(param, (Timestamp)value);
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Timestamp", "" + value, this.column, e.getMessage()), e);
        }
    }

    protected Timestamp getTimestamp(Object rs, int param) {
        Timestamp value;
        Calendar cal = this.storeMgr.getOMFContext().getPersistenceConfiguration().getCalendarForDateTimezone();
        try {
            value = cal != null ? ((ResultSet)rs).getTimestamp(param, cal) : ((ResultSet)rs).getTimestamp(param);
        }
        catch (SQLException e) {
            try {
                String s = ((ResultSet)rs).getString(param);
                value = ((ResultSet)rs).wasNull() ? null : (s == null ? null : TypeConversionHelper.stringToTimestamp(s, cal));
            }
            catch (SQLException nestedEx) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Timestamp", "" + param, this.column, e.getMessage()), nestedEx);
            }
        }
        return value;
    }

    public Object getObject(Object rs, int param) {
        Timestamp value = this.getTimestamp(rs, param);
        if (value == null) {
            return null;
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_UTIL_DATE)) {
            return new Date(this.getDatabaseAdapter().getAdapterTime(value));
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_DATE)) {
            return new java.sql.Date(this.getDatabaseAdapter().getAdapterTime(value));
        }
        if (this.getJavaTypeMapping().getJavaType().getName().equals(ClassNameConstants.JAVA_SQL_TIME)) {
            return new Time(this.getDatabaseAdapter().getAdapterTime(value));
        }
        return new Timestamp(this.getDatabaseAdapter().getAdapterTime(value));
    }
}

