/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.NullValueException;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.mapping.ColumnMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.StringUtils;

public class TinyIntRDBMSMapping
extends ColumnMapping {
    protected TinyIntRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public TinyIntRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            ScalarExpression[] validValues;
            this.column.checkPrimitive();
            if (this.getJavaTypeMapping() instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)this.getJavaTypeMapping()).getValidValues(0)) != null) {
                String constraints = ((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
        }
        this.initTypeInfo();
    }

    public boolean isDecimalBased() {
        return false;
    }

    public boolean isIntegerBased() {
        return true;
    }

    public boolean isStringBased() {
        return false;
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(-6);
    }

    public void setBoolean(Object ps, int param, boolean value) {
        try {
            ((PreparedStatement)ps).setInt(param, value ? 1 : 0);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "boolean", "" + value, this.column, e.getMessage()), e);
        }
    }

    public boolean getBoolean(Object rs, int param) {
        boolean value;
        block4: {
            try {
                int intValue = ((ResultSet)rs).getInt(param);
                if (intValue == 0) {
                    value = false;
                    break block4;
                }
                if (intValue == 1) {
                    value = true;
                    break block4;
                }
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.IllegalValueForBooleanInColumn", "Types.TINYINT", "" + intValue));
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Boolean", "" + param, this.column, e.getMessage()), e);
            }
        }
        return value;
    }

    public void setInt(Object ps, int param, int value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "int", "" + value, this.column, e.getMessage()), e);
        }
    }

    public int getInt(Object rs, int param) {
        int value;
        try {
            value = ((ResultSet)rs).getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "int", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setByte(Object ps, int param, byte value) {
        try {
            ((PreparedStatement)ps).setInt(param, value);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "byte", "" + value, this.column, e.getMessage()), e);
        }
    }

    public byte getByte(Object rs, int param) {
        byte value;
        try {
            value = ((ResultSet)rs).getByte(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && ((ResultSet)rs).wasNull()) {
                throw new NullValueException(LOCALISER.msg("RDBMS.Mapping.IllegalNullValueInColumn", this.column));
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "byte", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }

    public void setObject(Object ps, int param, Object value) {
        try {
            if (value == null) {
                if (this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace(this.column.getDefaultValue().toString())) {
                    ((PreparedStatement)ps).setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                } else {
                    ((PreparedStatement)ps).setNull(param, this.getTypeInfo().dataType);
                }
            } else if (value instanceof Byte) {
                ((PreparedStatement)ps).setInt(param, ((Byte)value).shortValue());
            } else if (value instanceof BigInteger) {
                ((PreparedStatement)ps).setInt(param, ((BigInteger)value).shortValue());
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Byte", "" + value, this.column, e.getMessage()), e);
        }
    }

    public Object getObject(Object rs, int param) {
        Byte value;
        try {
            byte b = ((ResultSet)rs).getByte(param);
            value = ((ResultSet)rs).wasNull() ? null : new Byte(b);
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToGetParam", "Byte", "" + param, this.column, e.getMessage()), e);
        }
        return value;
    }
}

