/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping.oracle;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.store.mapping.BitSetMapping;
import org.jpox.store.mapping.MappingCallbacks;
import org.jpox.store.rdbms.datatype.BlobImpl;
import org.jpox.store.rdbms.mapping.oracle.OracleBlobRDBMSMapping;
import org.jpox.util.TypeConversionHelper;

public class OracleBitSetMapping
extends BitSetMapping
implements MappingCallbacks {
    public void postInsert(StateManager sm) {
        Object value = sm.provideField(this.fmd.getAbsoluteFieldNumber());
        if (value == null) {
            return;
        }
        byte[] bytes = new byte[]{};
        try {
            if (this.fmd.isSerialized()) {
                if (!(value instanceof Serializable)) {
                    throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.ObjectNotSerializable", value.getClass().getName()));
                }
                BlobImpl b = new BlobImpl(value);
                bytes = b.getBytes(0L, (int)b.length());
            } else if (value instanceof BitSet) {
                bytes = TypeConversionHelper.getByteArrayFromBooleanArray(TypeConversionHelper.getBooleanArrayFromBitSet((BitSet)value));
            } else {
                if (!(value instanceof Serializable)) {
                    throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.ObjectNotSerializable", value.getClass().getName()));
                }
                BlobImpl b = new BlobImpl(value);
                bytes = b.getBytes(0L, (int)b.length());
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException(LOCALISER.msg("RDBMS.Mapping.UnableToSetParam", "Object", "" + value, this.fmd, e.getMessage()), e);
        }
        catch (IOException e1) {
            // empty catch block
        }
        OracleBlobRDBMSMapping.updateBlobColumn(sm, this.getDatastoreContainer(), this.getDataStoreMapping(0), bytes);
    }

    public void postUpdate(StateManager sm) {
        this.postInsert(sm);
    }

    public void deleteDependent(StateManager sm) {
    }

    public void postFetch(StateManager sm) {
    }

    public void preDelete(StateManager sm) {
    }
}

