/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.mapping.oracle;

import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import javax.jdo.spi.PersistenceCapable;
import oracle.sql.CLOB;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXObjectNotFoundException;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreField;
import org.jpox.store.StoreManager;
import org.jpox.store.exceptions.DatastoreFieldDefinitionException;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.rdbms.Column;
import org.jpox.store.rdbms.RDBMSFetchStatement;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.adapter.DatabaseAdapter;
import org.jpox.store.rdbms.mapping.ClobRDBMSMapping;
import org.jpox.store.rdbms.typeinfo.TypeInfo;
import org.jpox.util.Localiser;

public class OracleClobRDBMSMapping
extends ClobRDBMSMapping {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");

    protected OracleClobRDBMSMapping(StoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public OracleClobRDBMSMapping(JavaTypeMapping mapping, StoreManager storeMgr, DatastoreField field) {
        super(storeMgr, mapping);
        this.column = (Column)field;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null && !this.column.isUnlimitedLength()) {
            throw new DatastoreFieldDefinitionException("Invalid length specified for CLOB column " + this.column + ", must be 'unlimited'");
        }
        this.initTypeInfo();
    }

    public TypeInfo getTypeInfo() {
        return this.getDatabaseAdapter().getTypeInfo(2005);
    }

    public String getInsertionInputParameter() {
        return "EMPTY_CLOB()";
    }

    public boolean includeInFetchStatement() {
        return true;
    }

    public String getUpdateInputParameter() {
        return "EMPTY_CLOB()";
    }

    public boolean insertValuesOnInsert() {
        return false;
    }

    public String getString(Object rs, int param) {
        String value;
        block8: {
            value = null;
            try {
                char[] cbuf = null;
                Clob clob = ((ResultSet)rs).getClob(param);
                if (clob == null) break block8;
                StringBuffer sbuf = new StringBuffer();
                InputStreamReader reader = new InputStreamReader(clob.getAsciiStream());
                try {
                    int BUFF_SIZE = 4096;
                    cbuf = new char[4096];
                    int charsRead = reader.read(cbuf);
                    while (-1 != charsRead) {
                        sbuf.append(cbuf, 0, charsRead);
                        Arrays.fill(cbuf, '\u0000');
                        charsRead = reader.read(cbuf);
                    }
                }
                catch (IOException e) {
                    throw new JPOXDataStoreException("Error reading Oracle CLOB object: param = " + param, e);
                }
                value = sbuf.toString();
                if (value.length() == 0) {
                    value = null;
                } else if (value.equals(this.getDatabaseAdapter().getSurrogateForEmptyStrings())) {
                    value = "";
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER.msg("RDBMSMapping.UnableToGetParam", "String", "" + param), e);
            }
        }
        return value;
    }

    public Object getObject(Object rs, int param) {
        return this.getString(rs, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateClobColumn(StateManager sm, DatastoreContainerObject datastoreContainer, DatastoreMapping mapping, String value) {
        StateManager[] embeddedOwners;
        RDBMSFetchStatement fetchStmt = new RDBMSFetchStatement(datastoreContainer);
        fetchStmt.select(mapping.getDatastoreField());
        JavaTypeMapping idMapping = datastoreContainer.getIDMapping();
        for (int i = 0; i < idMapping.getNumberOfDatastoreFields(); ++i) {
            fetchStmt.andCondition(fetchStmt.referenceDatastoreField(idMapping.getDataStoreMapping(i).getDatastoreField()) + " = ?");
        }
        String textStmt = fetchStmt.toString(true);
        if (sm.getPcObjectType() != 0 && (embeddedOwners = sm.getEmbeddedOwners()) != null) {
            sm = embeddedOwners[0];
        }
        try {
            ObjectManager om = sm.getObjectManager();
            RDBMSManager storeMgr = (RDBMSManager)om.getStoreManager();
            ManagedConnection mconn = storeMgr.getConnection(om);
            Connection conn = (Connection)mconn.getConnection();
            SQLController sqlControl = storeMgr.getSQLController();
            try {
                PreparedStatement ps = sqlControl.getStatementForQuery(conn, textStmt);
                try {
                    PersistenceCapable pcObject = sm.getObject();
                    idMapping.setObject(om, ps, Mappings.getParametersIndex(1, idMapping), pcObject);
                    ResultSet rs = sqlControl.executeStatementQuery(conn, textStmt, ps);
                    try {
                        if (!rs.next()) {
                            throw new JPOXObjectNotFoundException("No such database row", sm.getInternalObjectId());
                        }
                        int jdbcMajorVersion = ((DatabaseAdapter)datastoreContainer.getStoreManager().getDatastoreAdapter()).getDriverMajorVersion();
                        if (jdbcMajorVersion < 10) {
                            CLOB clob = (CLOB)rs.getClob(1);
                            if (clob != null) {
                                clob.putString(1L, value);
                            }
                        } else {
                            Clob clob = rs.getClob(1);
                            if (clob != null) {
                                clob.setString(1L, value);
                            }
                        }
                    }
                    finally {
                        rs.close();
                    }
                }
                finally {
                    sqlControl.closeStatement(conn, ps);
                }
            }
            finally {
                mconn.release();
            }
        }
        catch (SQLException e) {
            throw new JPOXDataStoreException("Update of CLOB value failed: " + textStmt, e);
        }
    }
}

