/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.poid;

import java.sql.Connection;
import java.util.Properties;
import org.jpox.store.poid.AbstractDatastorePoidGenerator;
import org.jpox.store.poid.PoidBlock;
import org.jpox.store.poid.PoidException;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public abstract class AbstractRDBMSPoidGenerator
extends AbstractDatastorePoidGenerator {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected Connection connection;

    public AbstractRDBMSPoidGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 1;
    }

    public boolean requiresConnection() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PoidBlock obtainPoidBlock(int number) {
        boolean repository_exists;
        PoidBlock block;
        block17: {
            block = null;
            repository_exists = true;
            try {
                if (this.requiresConnection()) {
                    this.connection = (Connection)this.connectionProvider.retrieveConnection();
                }
                try {
                    block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
                }
                catch (PoidException poidex) {
                    JPOXLogger.POID.info(LOCALISER.msg("PoidGenerator.BlockAllocationError", poidex.getMessage()));
                    if (this.requiresRepository()) {
                        repository_exists = false;
                        break block17;
                    }
                    throw poidex;
                }
                catch (RuntimeException ex) {
                    JPOXLogger.POID.info(LOCALISER.msg("PoidGenerator.BlockAllocationError", ex.getMessage()));
                    if (this.requiresRepository()) {
                        repository_exists = false;
                        break block17;
                    }
                    throw ex;
                }
            }
            finally {
                if (this.connection != null && this.requiresConnection()) {
                    this.connectionProvider.releaseConnection();
                    this.connection = null;
                }
            }
        }
        if (!repository_exists) {
            try {
                if (this.requiresConnection()) {
                    this.connection = (Connection)this.connectionProvider.retrieveConnection();
                }
                JPOXLogger.POID.info(LOCALISER.msg("PoidGenerator.CreatingRepository"));
                if (!this.createRepository()) {
                    throw new PoidException(LOCALISER.msg("PoidGenerator.RepositoryOfIdsInvalid"));
                }
                block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
            }
            finally {
                if (this.requiresConnection()) {
                    this.connectionProvider.releaseConnection();
                    this.connection = null;
                }
            }
        }
        return block;
    }
}

