/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.poid;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.jpox.store.poid.PoidBlock;
import org.jpox.store.poid.PoidException;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.poid.AbstractRDBMSPoidGenerator;
import org.jpox.store.rdbms.sqlidentifier.RDBMSIdentifierFactory;
import org.jpox.store.rdbms.sqlidentifier.SQLIdentifier;
import org.jpox.util.JPOXLogger;

public final class SequencePoidGenerator
extends AbstractRDBMSPoidGenerator {
    protected String sequenceName = null;

    public SequencePoidGenerator(String name, Properties props) {
        super(name, props);
        this.allocationSize = 1;
        if (this.properties != null && this.properties.get("key-cache-size") != null) {
            try {
                this.allocationSize = Integer.parseInt((String)this.properties.get("key-cache-size"));
            }
            catch (Exception e) {
                throw new PoidException(LOCALISER.msg("PoidGenerator.InvalidKeyCacheSize", this.properties.get("key-cache-size")));
            }
        }
        if (this.properties != null && this.properties.get("sequence-name") == null) {
            throw new PoidException(LOCALISER.msg("PoidGenerator.InvalidSequenceName", this.properties.get("sequence-name")));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized PoidBlock reserveBlock(long size) {
        PoidBlock poidBlock;
        if (size < 1L) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Long> oid = new ArrayList<Long>();
        SQLController sqlControl = ((RDBMSManager)this.storeMgr).getSQLController();
        try {
            RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
            String stmt = dba.getSequenceNextStmt(this.getSequenceName());
            ps = sqlControl.getStatementForQuery(this.connection, stmt);
            rs = sqlControl.executeStatementQuery(this.connection, stmt, ps);
            Long nextId = new Long(0L);
            if (rs.next()) {
                nextId = new Long(rs.getLong(1));
                oid.add(nextId);
            }
            int i = 1;
            while ((long)i < size) {
                nextId = new Long(nextId + 1L);
                oid.add(nextId);
                ++i;
            }
            poidBlock = new PoidBlock(oid);
        }
        catch (SQLException e) {
            try {
                throw new PoidException(LOCALISER_RDBMS.msg("SequencePoidGenerator.CantObtainSequenceId", e.getMessage()));
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (ps == null) throw throwable;
                    sqlControl.closeStatement(this.connection, ps);
                    throw throwable;
                }
                catch (SQLException e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (rs != null) {
                rs.close();
            }
            if (ps == null) return poidBlock;
            sqlControl.closeStatement(this.connection, ps);
            return poidBlock;
        }
        catch (SQLException e) {
            // empty catch block
        }
        return poidBlock;
    }

    protected String getSequenceName() {
        if (this.sequenceName == null) {
            String sequenceSchemaName;
            String sequenceCatalogName = this.properties.getProperty("sequence-catalog-name");
            if (sequenceCatalogName == null) {
                sequenceCatalogName = this.properties.getProperty("catalog-name");
            }
            if ((sequenceSchemaName = this.properties.getProperty("sequence-schema-name")) == null) {
                sequenceSchemaName = this.properties.getProperty("schema-name");
            }
            String sequenceName = this.properties.getProperty("sequence-name");
            RDBMSIdentifierFactory idFactory = (RDBMSIdentifierFactory)this.storeMgr.getIdentifierFactory();
            SQLIdentifier identifier = (SQLIdentifier)idFactory.newSequenceIdentifier(sequenceName);
            if (((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsCatalogsInTableDefinitions() && sequenceCatalogName != null) {
                identifier.setCatalogName(sequenceCatalogName);
            }
            if (((RDBMSAdapter)this.storeMgr.getDatastoreAdapter()).supportsSchemasInTableDefinitions() && sequenceSchemaName != null) {
                identifier.setSchemaName(sequenceSchemaName);
            }
            this.sequenceName = identifier.getFullyQualifiedName(true);
        }
        return this.sequenceName;
    }

    protected boolean requiresRepository() {
        return true;
    }

    protected boolean createRepository() {
        PreparedStatement ps = null;
        RDBMSAdapter dba = (RDBMSAdapter)this.storeMgr.getDatastoreAdapter();
        SQLController sqlControl = ((RDBMSManager)this.storeMgr).getSQLController();
        String stmt = dba.getSequenceCreateStmt(this.getSequenceName(), (String)this.properties.get("key-min-value"), (String)this.properties.get("key-max-value"), (String)this.properties.get("key-start-with"), (String)this.properties.get("key-increment-by"), (String)this.properties.get("key-database-cache-size"));
        try {
            ps = sqlControl.getStatementForUpdate(this.connection, stmt, false);
            sqlControl.executeStatementUpdate(this.connection, stmt, ps, true);
        }
        catch (SQLException e) {
            JPOXLogger.RDBMS_SQL.error(e);
            throw new PoidException(LOCALISER_RDBMS.msg("SequencePoidGenerator.CantCreateSequence", e.getMessage()) + stmt);
        }
        finally {
            try {
                if (ps != null) {
                    sqlControl.closeStatement(this.connection, ps);
                }
            }
            catch (SQLException e) {}
        }
        return true;
    }
}

