/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.util.Collection;
import java.util.Map;
import org.jpox.ObjectManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.Extent;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.query.Query;
import org.jpox.util.JPOXLogger;
import org.jpox.util.Localiser;

public abstract class BaseSQLQuery
extends Query {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    protected final transient String sqlText;
    protected transient String jdbcSqlText = null;
    protected transient StatementExpressionIndex[] statementExpressionIndex;

    public BaseSQLQuery(ObjectManager om, BaseSQLQuery query) {
        this(om, query.sqlText);
    }

    public BaseSQLQuery(ObjectManager om, String sql_text) {
        super(om);
        this.candidateClass = null;
        this.filter = null;
        this.imports = null;
        this.variables = null;
        this.parameters = null;
        this.ordering = null;
        if (sql_text == null) {
            throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.StatementNullError"));
        }
        this.sqlText = sql_text.trim();
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.jdbcSqlText = null;
        this.statementExpressionIndex = null;
    }

    protected boolean shouldReturnSingleRow() {
        return this.unique;
    }

    public void setCandidates(Extent pcs) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.CandidateExtentsInapplicableError"));
    }

    public void setCandidates(Collection pcs) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.CandidateCollectionsInapplicableError"));
    }

    public void setResult(String result) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.ResultInapplicableError"));
    }

    public void setRange(int fromIncl, int toExcl) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.RangeInapplicableError"));
    }

    public void setSubclasses(boolean subclasses) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.CandidateExtentsInapplicableError"));
    }

    public void setFilter(String filter) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.FilterStringsInapplicableError"));
    }

    public void declareVariables(String variables) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.VariablesInapplicableError"));
    }

    public void setGrouping(String grouping) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.GroupingNotExplicitError"));
    }

    public void setOrdering(String ordering) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.OrderingNotExplicitError"));
    }

    public void compile() {
        if (!this.isCompiled) {
            super.compile();
            this.generateQueryStatement();
            if (JPOXLogger.QUERY.isDebugEnabled()) {
                JPOXLogger.QUERY.debug(LOCALISER_RDBMS.msg("SQL.Statement.Summary", this.jdbcSqlText));
            }
            this.isCompiled = true;
        }
    }

    protected abstract void generateQueryStatement();

    public abstract Collection performExecute(Map var1);

    protected long performDeletePersistentAll(Map parameters) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.DeletePersistent.NotSupported"));
    }
}

