/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOUserException;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.SQLWarnings;
import org.jpox.store.rdbms.query.AbstractQueryResult;
import org.jpox.util.JPOXLogger;

public final class ForwardQueryResult
extends AbstractQueryResult
implements QueryResult,
Serializable {
    protected boolean moreResultSetRows;
    protected List resultObjs = new ArrayList();
    private Collection candidates;

    public ForwardQueryResult(QueryExpression qs, Query query, ResultObjectFactory rof, ResultSet rs, Collection candidates) throws SQLException {
        super(qs, query, rof, rs);
        if (candidates != null) {
            this.candidates = new ArrayList(candidates);
        }
        int fetchSize = query.getFetchPlan().getFetchSize();
        this.moreResultSetRows = rs.next();
        if (!this.moreResultSetRows) {
            this.closeResultSet();
        } else if (!query.getObjectManager().getTransaction().isActive() || query.getObjectManager().getTransaction().getOptimistic() || fetchSize == -1) {
            this.advanceToEndOfResultSet();
        } else if (fetchSize > 0) {
            Iterator it = this.iterator();
            for (int i = 0; i < fetchSize; ++i) {
                if (!it.hasNext()) continue;
                it.next();
            }
        }
    }

    private void advanceToEndOfResultSet() {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            it.next();
        }
    }

    protected Object nextResultSetElement() {
        Object nextElement = this.rof.getObject(this.query.getObjectManager(), this.rs);
        SQLWarnings.log(this.rs);
        this.resultObjs.add(nextElement);
        try {
            this.moreResultSetRows = this.rs.next();
            if (!this.moreResultSetRows) {
                this.closeResultSet();
            }
        }
        catch (SQLException e) {
            throw new JDODataStoreException(LOCALISER.msg("QueryResult.ReadError", e));
        }
        return nextElement;
    }

    public synchronized void close() {
        this.moreResultSetRows = false;
        this.resultObjs.clear();
        super.close();
    }

    public void closingConnection() {
        boolean loadAllResults = true;
        Object value = this.query.getExtension("org.jpox.query.loadResultsAtCommit");
        if (value != null && ((String)value).equalsIgnoreCase("false")) {
            loadAllResults = false;
        }
        if (loadAllResults && this.isOpen() && this.moreResultSetRows) {
            try {
                this.advanceToEndOfResultSet();
            }
            catch (JDOUserException ue) {
                JPOXLogger.QUERY.warn("Exception thrown while loading remaining rows of query : " + ue.getMessage());
            }
        }
    }

    public Iterator iterator() {
        return new QueryResultIterator();
    }

    public ListIterator listIterator() {
        return new QueryResultIterator();
    }

    public synchronized boolean contains(Object o) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.contains(o);
    }

    public synchronized boolean containsAll(Collection c) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.containsAll(c);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ForwardQueryResult)) {
            return false;
        }
        ForwardQueryResult other = (ForwardQueryResult)o;
        if (this.qs != null) {
            return other.qs == this.qs;
        }
        return other.query == this.query;
    }

    public synchronized Object get(int index) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.get(index);
    }

    public synchronized boolean isEmpty() {
        this.assertIsOpen();
        return this.resultObjs.isEmpty() && !this.moreResultSetRows;
    }

    public synchronized int size() {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.size();
    }

    public synchronized Object[] toArray() {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        this.assertIsOpen();
        this.advanceToEndOfResultSet();
        return this.resultObjs.toArray(a);
    }

    private class QueryResultIterator
    implements ListIterator {
        private int nextRowNum = 0;
        Object nextElement = null;

        public void add(Object obj) {
            throw new UnsupportedOperationException(AbstractQueryResult.LOCALISER.msg("QueryResult.NotModifiable"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                if (!ForwardQueryResult.this.isOpen()) {
                    return false;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    return true;
                }
                if (ForwardQueryResult.this.candidates != null && this.nextElement != null && !ForwardQueryResult.this.moreResultSetRows) {
                    return ForwardQueryResult.this.candidates.contains(this.nextElement);
                }
                return ForwardQueryResult.this.moreResultSetRows;
            }
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object next() {
            ForwardQueryResult forwardQueryResult = ForwardQueryResult.this;
            synchronized (forwardQueryResult) {
                if (!ForwardQueryResult.this.isOpen()) {
                    throw new NoSuchElementException(AbstractQueryResult.LOCALISER.msg("QueryResult.Closed"));
                }
                if (ForwardQueryResult.this.candidates != null && this.nextElement != null && ForwardQueryResult.this.candidates.remove(this.nextElement)) {
                    ForwardQueryResult.this.resultObjs.add(this.nextElement);
                    return this.nextElement;
                }
                if (this.nextRowNum < ForwardQueryResult.this.resultObjs.size()) {
                    this.nextElement = ForwardQueryResult.this.resultObjs.get(this.nextRowNum);
                    ++this.nextRowNum;
                    return this.nextElement;
                }
                if (ForwardQueryResult.this.moreResultSetRows) {
                    this.nextElement = ForwardQueryResult.this.nextResultSetElement();
                    ++this.nextRowNum;
                    if (ForwardQueryResult.this.candidates != null) {
                        ForwardQueryResult.this.candidates.remove(this.nextElement);
                    }
                    return this.nextElement;
                }
                throw new NoSuchElementException(AbstractQueryResult.LOCALISER.msg("QueryResult.NoMoreElements"));
            }
        }

        public int nextIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public Object previous() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public int previousIndex() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        public void remove() {
            throw new UnsupportedOperationException(AbstractQueryResult.LOCALISER.msg("QueryResult.NotModifiable"));
        }

        public void set(Object obj) {
            throw new UnsupportedOperationException(AbstractQueryResult.LOCALISER.msg("QueryResult.NotModifiable"));
        }
    }
}

