/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.jdo.exceptions.ClassNotPersistenceCapableException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.IdentityType;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.AbstractContainerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.Mappings;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.exceptions.PersistentSuperclassNotAllowedException;
import org.jpox.store.rdbms.query.AbstractQueryResult;
import org.jpox.store.rdbms.query.BaseSQLQuery;
import org.jpox.store.rdbms.query.ForwardQueryResult;
import org.jpox.store.rdbms.query.InsensitiveQueryResult;
import org.jpox.store.rdbms.query.ResultClassROF;
import org.jpox.store.rdbms.query.SQLEvaluator;
import org.jpox.store.rdbms.query.TransientIDROF;
import org.jpox.util.MacroString;

public class JPOXSQLQuery
extends BaseSQLQuery {
    protected transient List parameterOccurrences = null;
    protected transient List fieldColumnNames = null;
    protected transient int[] fieldNumbers = null;

    public JPOXSQLQuery(ObjectManager om, JPOXSQLQuery query) {
        super(om, query);
    }

    public JPOXSQLQuery(ObjectManager om) {
        super(om, (String)null);
    }

    public JPOXSQLQuery(ObjectManager om, String sql_text) {
        super(om, sql_text);
    }

    protected void discardCompiled() {
        super.discardCompiled();
        this.parameterOccurrences = null;
        this.fieldColumnNames = null;
        this.fieldNumbers = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JPOXSQLQuery) || !super.equals(obj)) {
            return false;
        }
        return this.sqlText.equals(((JPOXSQLQuery)obj).sqlText);
    }

    protected void generateQueryStatement() {
        AbstractClassMetaData candidateCmd;
        if (this.candidateClass == null) {
            this.fieldColumnNames = new ArrayList();
            candidateCmd = null;
        } else {
            candidateCmd = this.om.getMetaDataManager().getMetaDataForClass(this.candidateClass, this.om.getClassLoaderResolver());
            if (candidateCmd == null) {
                throw new ClassNotPersistenceCapableException(this.candidateClass.getName());
            }
            if (candidateCmd.getPersistenceCapableSuperclass() != null) {
                throw new PersistentSuperclassNotAllowedException(this.candidateClass.getName());
            }
            if (candidateCmd.isRequiresExtent()) {
                throw new JPOXUserException(LOCALISER_RDBMS.msg("JPOXSQL.InvalidCandidateClassExtentError", this.candidateClass.getName()));
            }
            if (candidateCmd.getIdentityType() != IdentityType.NONDURABLE) {
                throw new JPOXUserException(LOCALISER_RDBMS.msg("JPOXSQL.InvalidCandidateClassNondurableError", this.candidateClass.getName()));
            }
            int fieldCount = candidateCmd.getNoOfManagedMembers();
            int[] fn = new int[fieldCount];
            this.statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            this.fieldColumnNames = new ArrayList(fieldCount);
            int n = 0;
            for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                this.statementExpressionIndex[fieldNumber] = new StatementExpressionIndex();
                AbstractMemberMetaData fmd = candidateCmd.getMetaDataForManagedMemberAtPosition(fieldNumber);
                String fieldName = fmd.getName();
                Class fieldType = fmd.getType();
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.PERSISTENT) {
                    JavaTypeMapping m = this.dba.getMapping(fieldType, this.getStoreManager(), this.om.getClassLoaderResolver());
                    if (m.includeInFetchStatement()) {
                        this.statementExpressionIndex[fieldNumber].setMapping(m);
                        fn[n++] = fieldNumber;
                        String columnName = null;
                        columnName = fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0 ? fmd.getColumnMetaData()[0].getName() : this.om.getStoreManager().getIdentifierFactory().newDatastoreFieldIdentifier(fieldName, this.om.getOMFContext().getTypeManager().isDefaultEmbeddedType(fieldType), 0).getIdentifier();
                        this.fieldColumnNames.add(columnName);
                    }
                    if (!(m instanceof AbstractContainerMapping)) continue;
                    throw new JPOXUserException("Mapping " + m + " not suitable for a JPOXSQL result column, field = " + fieldName).setFatal();
                }
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.TRANSACTIONAL) continue;
                throw new JPOXException("Invalid persistence modifier on field " + fieldName).setFatal();
            }
            if (n == 0) {
                throw new JPOXUserException("View class has no persistent fields: " + this.candidateClass.getName()).setFatal();
            }
            this.fieldNumbers = new int[n];
            System.arraycopy(fn, 0, this.fieldNumbers, 0, n);
        }
        this.parameterOccurrences = new ArrayList();
        MacroString ms = new MacroString(this.candidateClass != null ? this.candidateClass.getName() : null, this.candidateClass != null ? this.imports : null, this.sqlText);
        this.jdbcSqlText = ms.substituteMacros(new MacroString.MacroHandler(){

            public void onIdentifierMacro(MacroString.IdentifierMacro im) {
                if (JPOXSQLQuery.this.candidateClass != null) {
                    if (im.className.equals(JPOXSQLQuery.this.candidateClass.getName())) {
                        if (im.fieldName == null) {
                            throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.ResultClassesHaveNoTableError", im));
                        }
                        if (im.subfieldName != null) {
                            throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.NoSuchFieldInResultClassError", im.className, im));
                        }
                        int fieldNumber = candidateCmd.getRelativePositionOfMember(im.fieldName);
                        if (fieldNumber < 0) {
                            throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.NoSuchFieldInResultClassError", im.className, im));
                        }
                        im.value = (String)JPOXSQLQuery.this.fieldColumnNames.get(fieldNumber);
                    } else {
                        JPOXSQLQuery.this.getStoreManager().resolveIdentifierMacro(im, JPOXSQLQuery.this.om.getClassLoaderResolver());
                    }
                }
            }

            public void onParameterMacro(MacroString.ParameterMacro pm) {
                JPOXSQLQuery.this.parameterOccurrences.add(pm.parameterName);
            }
        }, this.om.getClassLoaderResolver());
    }

    public Collection performExecute(Map parameters) {
        this.compile();
        if (parameters.size() != this.parameterNames.size()) {
            throw new JPOXUserException(LOCALISER_RDBMS.msg("JPOXSQL.IncorrectNumberOfParametersError", "" + this.parameterNames.size(), "" + parameters.size()));
        }
        JPOXSQLQueryEvaluator eval = new JPOXSQLQueryEvaluator(this.om, this.extensions, this.toExclNo, this, parameters);
        QueryResult qr = eval.evaluate(null);
        this.queryResults.add(qr);
        return qr;
    }

    class JPOXSQLQueryEvaluator
    extends SQLEvaluator {
        Map parameters;

        public JPOXSQLQueryEvaluator(ObjectManager om, Map extensions, long toExclNo, Query query, Map parameters) {
            super(om, extensions, toExclNo, false, query, null, null);
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueryResult evaluate(QueryExpression queryStmt) {
            AbstractQueryResult qr = null;
            try {
                RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = conn.prepareStatement(JPOXSQLQuery.this.jdbcSqlText);
                    try {
                        Iterator iter = JPOXSQLQuery.this.parameterOccurrences.iterator();
                        int stmtParamNum = 1;
                        while (iter.hasNext()) {
                            String paramName = (String)iter.next();
                            Class paramType = (Class)JPOXSQLQuery.this.parameterTypesByName.get(paramName);
                            if (!this.parameters.containsKey(paramName)) {
                                throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.ParameterNotProvidedError", paramName));
                            }
                            if (paramType == null) {
                                throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.UndeclaredParameterError", paramName));
                            }
                            JavaTypeMapping mapping = JPOXSQLQuery.this.dba.getMapping(paramType, JPOXSQLQuery.this.getStoreManager(), this.om.getClassLoaderResolver());
                            Object paramValue = this.parameters.get(paramName);
                            mapping.setObject(this.om, ps, Mappings.getParametersIndex(stmtParamNum, mapping), paramValue);
                            if (mapping.getNumberOfDatastoreFields() == 0) {
                                ++stmtParamNum;
                                continue;
                            }
                            stmtParamNum += mapping.getNumberOfDatastoreFields();
                        }
                        this.prepareStatementForExecution(ps);
                        ResultSet rs = sqlControl.executeStatementQuery(conn, JPOXSQLQuery.this.jdbcSqlText, ps);
                        try {
                            ResultObjectFactory rof = null;
                            if (JPOXSQLQuery.this.candidateClass != null) {
                                ResultSetMetaData rsmd = rs.getMetaData();
                                HashSet remainingColumnNames = new HashSet(JPOXSQLQuery.this.fieldColumnNames);
                                int colCount = rsmd.getColumnCount();
                                for (int colNum = 1; colNum <= colCount; ++colNum) {
                                    String colName = rsmd.getColumnName(colNum);
                                    int fieldNumber = JPOXSQLQuery.this.fieldColumnNames.indexOf(colName);
                                    if (fieldNumber < 0) continue;
                                    JPOXSQLQuery.this.statementExpressionIndex[fieldNumber].setExpressionIndex(new int[]{colNum});
                                    remainingColumnNames.remove(colName);
                                }
                                if (!remainingColumnNames.isEmpty()) {
                                    throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.ResultSetMissingColumnsError", remainingColumnNames));
                                }
                                rof = JPOXSQLQuery.this.resultClass != null ? new ResultClassROF(JPOXSQLQuery.this.resultClass, JPOXSQLQuery.this.statementExpressionIndex) : new TransientIDROF(JPOXSQLQuery.this.candidateClass, JPOXSQLQuery.this.fieldNumbers, JPOXSQLQuery.this.statementExpressionIndex);
                            } else {
                                rof = this.getResultObjectFactoryForNoCandidateClass(rs, JPOXSQLQuery.this.resultClass);
                            }
                            qr = this.getResultSetType().equals("scroll-insensitive") ? new InsensitiveQueryResult(null, this.query, rof, rs, null) : new ForwardQueryResult(null, this.query, rof, rs, null);
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (qr == null) {
                            sqlControl.closeStatement(conn, ps);
                        }
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(BaseSQLQuery.LOCALISER_RDBMS.msg("JPOXSQL.ExecutionError", JPOXSQLQuery.this.jdbcSqlText), e);
            }
            return qr;
        }
    }
}

