/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpox.ObjectManager;
import org.jpox.ObjectManagerHelper;
import org.jpox.api.ApiAdapter;
import org.jpox.exceptions.JPOXException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.store.DatastoreClass;
import org.jpox.store.Extent;
import org.jpox.store.exceptions.NoSuchPersistentFieldException;
import org.jpox.store.expression.AggregateExpression;
import org.jpox.store.expression.ArrayExpression;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.ClassExpression;
import org.jpox.store.expression.CollectionExpression;
import org.jpox.store.expression.IntegerLiteral;
import org.jpox.store.expression.JoinExpression;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.MapExpression;
import org.jpox.store.expression.MathExpression;
import org.jpox.store.expression.NewObjectExpression;
import org.jpox.store.expression.NullLiteral;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.expression.UnboundVariable;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.AbstractJPQLQuery;
import org.jpox.store.query.CollectionCandidates;
import org.jpox.store.query.Evaluator;
import org.jpox.store.query.JDOQLResultSetMetaData;
import org.jpox.store.query.JPOXQueryInvalidParametersException;
import org.jpox.store.query.JPQLParser;
import org.jpox.store.query.JPQLSingleStringParser;
import org.jpox.store.query.Parser;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.QueryUtils;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.query.PersistentIDROF;
import org.jpox.store.rdbms.query.ResultExpressionsQueryable;
import org.jpox.store.rdbms.query.SQLEvaluator;
import org.jpox.util.ClassUtils;
import org.jpox.util.Imports;
import org.jpox.util.JPOXLogger;

public class JPQLQuery
extends AbstractJPQLQuery {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$jpox$store$expression$QueryExpression;

    public JPQLQuery(ObjectManager om) {
        this(om, (JPQLQuery)null);
    }

    public JPQLQuery(ObjectManager om, JPQLQuery q) {
        super(om);
        if (q == null) {
            this.candidateClass = null;
            this.candidateClassName = null;
            this.filter = null;
            this.imports = null;
            this.variables = null;
            this.parameters = null;
            this.grouping = null;
            this.ordering = null;
            this.result = null;
            this.resultClass = null;
            this.resultClassName = null;
            this.range = null;
            this.fromInclNo = 0L;
            this.toExclNo = Long.MAX_VALUE;
        } else {
            this.candidateClass = q.candidateClass;
            this.candidateClassName = q.candidateClassName;
            this.filter = q.filter;
            this.imports = q.imports;
            this.variables = q.variables;
            this.parameters = q.parameters;
            this.grouping = q.grouping;
            this.ordering = q.ordering;
            this.result = q.result;
            this.resultClass = q.resultClass;
            this.resultClassName = q.resultClassName;
            this.range = q.range;
            this.fromInclNo = q.fromInclNo;
            this.toExclNo = q.toExclNo;
            this.ignoreCache = q.ignoreCache;
        }
    }

    public JPQLQuery(ObjectManager om, String query) {
        super(om);
        new JPQLSingleStringParser(this, query).parse();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof JPQLQuery && super.equals(obj);
    }

    public void compile() {
        if (JPOXLogger.QUERY.isDebugEnabled()) {
            JPOXLogger.QUERY.debug(LOCALISER.msg("Query.Statement.Precompile", "JPQL", this.getSingleStringQuery()));
        }
        super.compile();
        Iterator it = userDefinedScalarExpressions.keySet().iterator();
        while (it.hasNext()) {
            this.parsedImports.importPackage((String)it.next());
        }
        if (this.isPreCompile) {
            new Compiler(null).preCompile();
        }
        this.isCompiled = true;
    }

    protected boolean shouldReturnSingleRow() {
        if (this.unique) {
            return true;
        }
        if (this.grouping != null) {
            return false;
        }
        if (this.candidates instanceof ResultExpressionsQueryable) {
            return ((ResultExpressionsQueryable)this.candidates).hasAggregatedExpressionsOnly();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection performExecute(Map parameters) {
        this.isPreCompile = false;
        this.discardCompiled();
        this.prepareDatastore();
        try {
            if (JPOXLogger.QUERY.isDebugEnabled()) {
                JPOXLogger.QUERY.debug(LOCALISER.msg("Query.Statement.Summary", "JPQL", this.getSingleStringQuery()));
            }
            long startTime = System.currentTimeMillis();
            AbstractJPQLQuery.ExecutedCompileCache cache = (AbstractJPQLQuery.ExecutedCompileCache)compiledCache.get(this.getSingleStringQuery());
            if (cache == null || this.candidateCollection != null) {
                super.compile();
                Iterator it = userDefinedScalarExpressions.keySet().iterator();
                while (it.hasNext()) {
                    this.parsedImports.importPackage((String)it.next());
                }
                Compiler c = new Compiler(parameters);
                this.queryStmt = c.executionCompile();
                if (this.candidateCollection != null) {
                    // empty if block
                }
            } else {
                this.candidates = cache.getCandidates();
                this.queryStmt = cache.getQueryExpression();
                this.parameterNames = cache.getParameterNames();
                this.queryStmt.reset();
            }
            if (this.candidates instanceof CollectionCandidates) {
                ((CollectionCandidates)this.candidates).getFetchPlan().setGroups(this.fetchPlan.getGroups());
            } else if (this.candidates instanceof Extent) {
                ((Extent)((Object)this.candidates)).getFetchPlan().setGroups(this.fetchPlan.getGroups());
            }
            boolean useFetchPlan = this.om.getOMFContext().getPersistenceConfiguration().getQueryUseFetchPlan();
            if (this.extensions != null && this.extensions.containsKey("org.jpox.query.useFetchPlan")) {
                useFetchPlan = Boolean.valueOf((String)this.extensions.get("org.jpox.query.useFetchPlan"));
            }
            this.rof = this.candidates.newResultObjectFactory(this.queryStmt, this.getIgnoreCache(), this.resultClass, useFetchPlan);
            if (this.rof instanceof PersistentIDROF) {
                ((PersistentIDROF)this.rof).setPersistentClass(this.candidateClass);
            }
            if (JPOXLogger.QUERY.isDebugEnabled()) {
                JPOXLogger.QUERY.debug(LOCALISER.msg("Query.Statement.CompileTime", "JPQL", "" + (System.currentTimeMillis() - startTime), this.rof));
            }
            this.isCompiled = true;
        }
        finally {
            if (!this.isCompiled) {
                this.discardCompiled();
            }
        }
        if (this.candidates.isEmpty()) {
            return new ArrayList();
        }
        this.isPreCompile = true;
        Evaluator eval = this.getEvaluator(this.om, this.extensions, this.toExclNo, this.distinct, this, this.rof, this.candidateCollection);
        QueryResult qr = eval.evaluate(this.queryStmt);
        this.om.addQueryRun(this.toString());
        this.queryResults.add(qr);
        return qr;
    }

    protected Evaluator getEvaluator(ObjectManager om, Map extensions, long toExclNo, boolean distinct, Query query, ResultObjectFactory rof, Collection candidateCollection) {
        return new SQLEvaluator(om, extensions, toExclNo, distinct, this, rof, candidateCollection);
    }

    static /* synthetic */ ScalarExpression[] access$11102(JPQLQuery x0, ScalarExpression[] x1) {
        x0.candidateExprs = x1;
        return x1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Compiler
    implements UnboundVariable.VariableBinder {
        private final Map parameters;
        private final Map expressionsByVariableName = new HashMap();
        private QueryExpression qs = null;
        private Parser p = null;
        private boolean explicitParameters = false;
        private int implicitParamNo = 0;
        private boolean explicitVariables = false;
        private List fieldExpressions = new ArrayList();

        public Compiler(Map parameters) {
            if (JPQLQuery.this.variables != null && JPQLQuery.this.variables.length() > 0) {
                this.explicitVariables = true;
            }
            if (JPQLQuery.this.parameters != null && JPQLQuery.this.parameters.length() > 0) {
                this.explicitParameters = true;
                if (parameters != null) {
                    ApiAdapter api = JPQLQuery.this.om.getApiAdapter();
                    if (parameters.size() != JPQLQuery.this.parameterNames.size()) {
                        throw new JPOXQueryInvalidParametersException(LOCALISER.msg("Query.IncorrectNumberOfParametersError", "JPQL", "" + JPQLQuery.this.parameterNames.size(), "" + parameters.size()));
                    }
                    Iterator it = JPQLQuery.this.parameterTypesByName.entrySet().iterator();
                    while (it.hasNext()) {
                        ObjectManager valueOM;
                        Map.Entry entry = it.next();
                        Object key = entry.getKey();
                        Object value = parameters.get(key);
                        if (value == null) {
                            if (!((Class)entry.getValue()).isPrimitive()) continue;
                            throw new JPOXQueryInvalidParametersException(LOCALISER.msg("Query.InvalidNullArgumentForPrimitiveParameter", entry.getKey(), ((Class)entry.getValue()).getName()));
                        }
                        if (!api.isPersistable(value) || (valueOM = ObjectManagerHelper.getObjectManager(value)) == null || JPQLQuery.this.om == valueOM) continue;
                        throw new JPOXUserException(LOCALISER.msg("Query.ParameterBoundToDifferentManager", key));
                    }
                }
            } else if (parameters != null) {
                ApiAdapter api = JPQLQuery.this.om.getApiAdapter();
                Iterator parameterEntryIter = parameters.entrySet().iterator();
                while (parameterEntryIter.hasNext()) {
                    ObjectManager valueOM;
                    Map.Entry entry = parameterEntryIter.next();
                    Object value = entry.getValue();
                    if (!api.isPersistable(value) || (valueOM = ObjectManagerHelper.getObjectManager(value)) == null || JPQLQuery.this.om == valueOM) continue;
                    throw new JPOXUserException(LOCALISER.msg("Query.ParameterBoundToDifferentManager", value));
                }
            }
            this.parameters = parameters;
        }

        public void preCompile() {
            this.compileCandidates();
            this.qs = JPQLQuery.this.candidates.newQueryStatement(JPQLQuery.this.candidateClass);
            this.performCompile(this.qs);
        }

        public QueryExpression executionCompile() {
            this.compileCandidates();
            this.qs = JPQLQuery.this.candidates.newQueryStatement(JPQLQuery.this.candidateClass);
            boolean useInner = JPQLQuery.this.om.getOMFContext().getPersistenceConfiguration().getQueryUseInnerJoinsOnly();
            if (JPQLQuery.this.extensions != null && JPQLQuery.this.extensions.containsKey("org.jpox.jdoql.useInnerJoinsOnly")) {
                useInner = Boolean.valueOf((String)JPQLQuery.this.extensions.get("org.jpox.jdoql.useInnerJoinsOnly"));
            }
            if (useInner) {
                this.qs.setUseInnerJoinsOnly(true);
            }
            this.performCompile(this.qs);
            return this.qs;
        }

        private void performCompile(QueryExpression qs) {
            this.fieldExpressions.clear();
            this.compileResult(qs);
            ScalarExpression[] resultFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
            for (int i = 0; i < resultFieldExprs.length; ++i) {
                if (resultFieldExprs[i].getLogicSetExpression() == null && resultFieldExprs[i] instanceof UnboundVariable) {
                    throw new JPOXUserException(LOCALISER.msg("Query.SpecifiedFieldNotFound", ((UnboundVariable)resultFieldExprs[i]).getVariableName()));
                }
                qs.crossJoin(resultFieldExprs[i].getLogicSetExpression(), true);
            }
            this.compileFilter(qs);
            ScalarExpression[] groupingFieldExprs = null;
            if (JPQLQuery.this.grouping != null && JPQLQuery.this.grouping.length() > 0) {
                this.fieldExpressions.clear();
                this.compileGrouping(qs, JPQLQuery.this.grouping);
                groupingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
            }
            this.fieldExpressions.clear();
            this.compileOrdering(qs);
            ScalarExpression[] orderingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
            if (JPQLQuery.this.having != null && JPQLQuery.this.having.length() > 0) {
                this.compileHaving(qs, JPQLQuery.this.having);
            }
            if (groupingFieldExprs != null) {
                this.checkExpressionsAgainstGrouping(orderingFieldExprs, groupingFieldExprs, "Query.FieldInOrderingNotSpecifiedInGrouping");
                this.checkExpressionsAgainstGrouping(resultFieldExprs, groupingFieldExprs, "Query.FieldInResultNotSpecifiedInGrouping");
            }
            groupingFieldExprs = this.fieldExpressions.toArray(new ScalarExpression[this.fieldExpressions.size()]);
            this.compileRange(qs);
            this.checkVariableBinding();
        }

        private void checkExpressionsAgainstGrouping(ScalarExpression[] exprs, ScalarExpression[] groupExprs, String localiserErrorString) {
            if (exprs == null) {
                return;
            }
            for (int i = 0; i < exprs.length; ++i) {
                boolean exists = false;
                for (int j = 0; j < groupExprs.length; ++j) {
                    if (!exprs[i].equals(groupExprs[j])) continue;
                    exists = true;
                    break;
                }
                if (exprs[i] instanceof AggregateExpression || exists) continue;
                throw new JPOXUserException(LOCALISER.msg(localiserErrorString, exprs[i]));
            }
        }

        public void bindVariable(String name, ScalarExpression expr) {
            ScalarExpression previousExpr = this.expressionsByVariableName.put(name, expr);
            if (previousExpr != null) {
                throw new JPOXException(LOCALISER.msg("Query.VariableBindError", name, expr, previousExpr)).setFatal();
            }
        }

        private void checkVariableBinding() {
            for (int i = 0; i < JPQLQuery.this.variableNames.size(); ++i) {
                String variableName = (String)JPQLQuery.this.variableNames.get(i);
                if (this.expressionsByVariableName.get(variableName) != null) continue;
                boolean foundInResult = false;
                if (JPQLQuery.this.candidates instanceof ResultExpressionsQueryable) {
                    ScalarExpression[] exprs = ((ResultExpressionsQueryable)JPQLQuery.this.candidates).getResultExpressions();
                    for (int j = 0; j < exprs.length; ++j) {
                        if (!(exprs[j] instanceof UnboundVariable) || !((UnboundVariable)exprs[j]).getVariableName().equals(variableName)) continue;
                        foundInResult = true;
                    }
                }
                if (foundInResult) continue;
                throw new JPOXUserException(LOCALISER.msg("Query.VariableNotBoundError", variableName));
            }
        }

        private void compileCandidates() {
            this.compileFrom(this.qs);
            if (JPQLQuery.this.candidateClass == null && JPQLQuery.this.candidateClassName != null) {
                try {
                    JPQLQuery.this.candidateClass = JPQLQuery.this.om.getClassLoaderResolver().classForName(JPQLQuery.this.candidateClassName, true);
                }
                catch (JPOXException jpe) {
                    JPQLQuery.this.candidateClass = JPQLQuery.this.resolveClassDeclaration(JPQLQuery.this.candidateClassName);
                }
            }
            if (JPQLQuery.this.candidateExtent != null) {
                JPQLQuery.this.candidates = (Queryable)((Object)JPQLQuery.this.candidateExtent);
            } else if (JPQLQuery.this.candidateCollection != null) {
                JPQLQuery.this.candidates = new CollectionCandidates(JPQLQuery.this.om, JPQLQuery.this.candidateClass, JPQLQuery.this.candidateCollection);
            } else {
                if (JPQLQuery.this.candidateClass == null) {
                    throw new JPOXUserException(LOCALISER.msg("Query.NoCandidateClassError", "JPQL"));
                }
                JPQLQuery.this.candidates = (Queryable)((Object)JPQLQuery.this.om.getExtent(JPQLQuery.this.candidateClass, JPQLQuery.this.subclasses));
            }
            JPQLQuery.this.distinct = false;
            if (JPQLQuery.this.result != null) {
                if (JPQLQuery.this.candidateCollection != null) {
                    JPQLQuery.this.candidates = new ResultExpressionsQueryable(JPQLQuery.this.om, JPQLQuery.this.candidateClass, ((CollectionCandidates)JPQLQuery.this.candidates).getUserCandidates(), JPQLQuery.this.subclasses);
                } else {
                    JPQLQuery.this.candidates = new ResultExpressionsQueryable(JPQLQuery.this.om, JPQLQuery.this.candidateClass, JPQLQuery.this.subclasses);
                }
                if (JPQLQuery.this.result != null && JPQLQuery.this.result.toLowerCase().startsWith("distinct")) {
                    JPQLQuery.this.distinct = true;
                }
            }
        }

        private void compileResult(QueryExpression qs) {
            int i;
            ScalarExpression[] resultExprs = null;
            JPQLQuery.this.distinct = false;
            if (JPQLQuery.this.result != null) {
                String resultDefinition = JPQLQuery.this.result;
                if (JPQLQuery.this.result != null && JPQLQuery.this.result.toLowerCase().startsWith("distinct")) {
                    if (qs != null) {
                        qs.setDistinctResults(true);
                    }
                    resultDefinition = JPQLQuery.this.result.substring(8);
                    JPQLQuery.this.distinct = true;
                }
                resultExprs = this.compileExpressionsFromString(resultDefinition, JPQLQuery.this.parsedImports);
                Class[] resultTypes = new Class[resultExprs.length];
                for (i = 0; i < resultExprs.length; ++i) {
                    if (resultExprs[i] instanceof CollectionExpression) {
                        throw new JPOXUserException(resultExprs[i].toStatementText(ScalarExpression.PROJECTION) + " is of type java.util.Collection and cannot be in the result.");
                    }
                    if (resultExprs[i] instanceof MapExpression) {
                        throw new JPOXUserException(resultExprs[i].toStatementText(ScalarExpression.PROJECTION) + " is of type java.util.Map and cannot be in the result.");
                    }
                    if (resultExprs[i].getMapping() == null) continue;
                    resultTypes[i] = resultExprs[i].getMapping().getType() != null ? JPQLQuery.this.resolveClassDeclaration(resultExprs[i].getMapping().getType()) : resultExprs[i].getMapping().getJavaType();
                }
                ((ResultExpressionsQueryable)JPQLQuery.this.candidates).setResultExpressions(resultExprs);
                JPQLQuery.this.resultMetaData = new JDOQLResultSetMetaData(resultTypes);
            } else {
                JPQLQuery.this.resultMetaData = new JDOQLResultSetMetaData(new Class[]{JPQLQuery.this.candidateClass});
            }
            if (JPQLQuery.this.resultClass == null && JPQLQuery.this.resultClassName != null) {
                ScalarExpression expr = this.compileExpressionFromString(JPQLQuery.this.resultClassName, JPQLQuery.this.parsedImports);
                JPQLQuery.this.resultClass = ((ClassExpression)expr).getCls();
            }
            if (JPQLQuery.this.resultClass != null && resultExprs != null) {
                if (QueryUtils.resultClassIsSimple(JPQLQuery.this.resultClass.getName())) {
                    Class resultClassPrimitive;
                    if (resultExprs.length > 1) {
                        throw new JPOXUserException(LOCALISER.msg("Query.ResultClassSimpleButMultipleFields", JPQLQuery.this.resultClass.getName()));
                    }
                    Class exprType = resultExprs[0].getMapping().getJavaType();
                    boolean typeConsistent = false;
                    if (exprType == JPQLQuery.this.resultClass) {
                        typeConsistent = true;
                    } else if (exprType.isPrimitive() && (resultClassPrimitive = ClassUtils.getPrimitiveTypeForType(JPQLQuery.this.resultClass)) == exprType) {
                        typeConsistent = true;
                    }
                    if (!typeConsistent) {
                        throw new JPOXUserException(LOCALISER.msg("Query.ResultClassSimpleButWrongType", JPQLQuery.this.resultClass.getName(), exprType));
                    }
                } else if (QueryUtils.resultClassIsUserType(JPQLQuery.this.resultClass.getName())) {
                    Class[] ctrTypes = new Class[resultExprs.length];
                    for (int i2 = 0; i2 < ctrTypes.length; ++i2) {
                        ctrTypes[i2] = resultExprs[i2].getMapping().getJavaType();
                    }
                    Constructor ctr = ClassUtils.getConstructorWithArguments(JPQLQuery.this.resultClass, ctrTypes);
                    if (ctr == null && !ClassUtils.hasDefaultConstructor(JPQLQuery.this.resultClass)) {
                        throw new JPOXUserException(LOCALISER.msg("Query.ResultClassNotCreatable", JPQLQuery.this.resultClass.getName()));
                    }
                    if (ctr == null) {
                        for (i = 0; i < resultExprs.length; ++i) {
                            Method putMethod;
                            Method setMethod;
                            String fieldName = resultExprs[i].getAlias();
                            Class fieldType = resultExprs[i].getMapping().getJavaType();
                            if (fieldName == null && resultExprs[i].getMapping().getFieldMetaData() != null) {
                                fieldName = resultExprs[i].getMapping().getFieldMetaData().getName();
                            }
                            if (fieldName == null) continue;
                            Class<?> resultFieldType = null;
                            boolean publicField = true;
                            try {
                                Field fld = JPQLQuery.this.resultClass.getDeclaredField(fieldName);
                                resultFieldType = fld.getType();
                                if (!ClassUtils.typesAreCompatible(fieldType, resultFieldType) && !ClassUtils.typesAreCompatible(resultFieldType, fieldType)) {
                                    throw new JPOXUserException(LOCALISER.msg("Query.ResultClassFieldTypeMismatch", "JPQL", fieldName, fieldType.getName(), resultFieldType.getName()));
                                }
                                if (!Modifier.isPublic(fld.getModifiers())) {
                                    publicField = false;
                                }
                            }
                            catch (NoSuchFieldException nsfe) {
                                publicField = false;
                            }
                            if (publicField || (setMethod = QueryUtils.getPublicSetMethodForFieldOfResultClass(JPQLQuery.this.resultClass, fieldName, resultFieldType)) != null || (putMethod = QueryUtils.getPublicPutMethodForResultClass(JPQLQuery.this.resultClass)) != null) continue;
                            throw new JPOXUserException(LOCALISER.msg("Query.ResultClassFieldSetterNotFound", "JPQL", JPQLQuery.this.resultClass.getName(), fieldName));
                        }
                    }
                }
            }
        }

        private void compileFrom(QueryExpression qs) {
            JPQLQuery.this.distinct = false;
            if (JPQLQuery.this.from != null) {
                JPQLQuery.access$11102(JPQLQuery.this, this.compileExpressionsFromString(JPQLQuery.this.from, JPQLQuery.this.parsedImports));
                for (int i = 0; i < JPQLQuery.this.candidateExprs.length; ++i) {
                    JPQLQuery.this.aliases.put(((ClassExpression)JPQLQuery.this.candidateExprs[i]).getAlias(), ((ClassExpression)JPQLQuery.this.candidateExprs[i]).getCls());
                }
                JPQLQuery.this.candidateClass = ((ClassExpression)JPQLQuery.this.candidateExprs[0]).getCls();
                JPQLQuery.this.candidateAlias = ((ClassExpression)JPQLQuery.this.candidateExprs[0]).getAlias();
            }
        }

        private void compileFilter(QueryExpression qs) {
            if (JPQLQuery.this.filter != null && JPQLQuery.this.filter.length() > 0) {
                ScalarExpression expr = this.compileExpressionFromString(JPQLQuery.this.filter, JPQLQuery.this.parsedImports);
                if (!(expr instanceof BooleanExpression)) {
                    throw new JPOXUserException(LOCALISER.msg("Query.FilterExpressionNotBoolean", JPQLQuery.this.filter));
                }
                if (qs != null) {
                    qs.andCondition((BooleanExpression)expr, true);
                }
            }
        }

        private void compileOrdering(QueryExpression qs) {
            if (JPQLQuery.this.ordering != null && JPQLQuery.this.ordering.length() > 0) {
                StringTokenizer t1 = new StringTokenizer(JPQLQuery.this.ordering, ",");
                int n = t1.countTokens();
                ScalarExpression[] orderExprs = new ScalarExpression[n];
                boolean[] descending = new boolean[n];
                n = 0;
                while (t1.hasMoreTokens()) {
                    String orderExpression = t1.nextToken().trim();
                    if (orderExpression.endsWith("ascending") || orderExpression.endsWith("ASCENDING")) {
                        descending[n] = false;
                        orderExpression = orderExpression.substring(0, orderExpression.length() - "ascending".length());
                    } else if (orderExpression.endsWith("asc") || orderExpression.endsWith("ASC")) {
                        descending[n] = false;
                        orderExpression = orderExpression.substring(0, orderExpression.length() - "asc".length());
                    } else if (orderExpression.endsWith("descending") || orderExpression.endsWith("DESCENDING")) {
                        descending[n] = true;
                        orderExpression = orderExpression.substring(0, orderExpression.length() - "descending".length());
                    } else if (orderExpression.endsWith("desc") || orderExpression.endsWith("DESC")) {
                        descending[n] = true;
                        orderExpression = orderExpression.substring(0, orderExpression.length() - "desc".length());
                    } else {
                        descending[n] = false;
                    }
                    orderExprs[n] = this.compileExpressionFromString(orderExpression, JPQLQuery.this.parsedImports);
                    ++n;
                }
                if (qs != null) {
                    qs.setOrdering(orderExprs, descending);
                }
            }
        }

        private void compileGrouping(QueryExpression qs, String groupingClause) {
            ScalarExpression[] groupExprs;
            if (groupingClause != null && (groupExprs = this.compileExpressionsFromString(groupingClause, JPQLQuery.this.parsedImports)) != null && qs != null) {
                for (int i = 0; i < groupExprs.length; ++i) {
                    qs.addGroupingExpression(groupExprs[i]);
                }
            }
        }

        private void compileHaving(QueryExpression qs, String havingClause) {
            if (havingClause != null) {
                ScalarExpression havingExpr = this.compileExpressionFromString(havingClause, JPQLQuery.this.parsedImports);
                if (qs != null) {
                    if (!(havingExpr instanceof BooleanExpression)) {
                        throw new JPOXUserException(LOCALISER.msg("Query.HavingExpressionNotBoolean", havingExpr));
                    }
                    qs.setHaving((BooleanExpression)havingExpr);
                }
            }
        }

        private void compileRange(QueryExpression qs) {
            if (JPQLQuery.this.range != null) {
                ScalarExpression[] exprs = this.compileExpressionsFromString(JPQLQuery.this.range, JPQLQuery.this.parsedImports);
                if (exprs.length > 0) {
                    if (!(exprs[0] instanceof Literal)) {
                        throw new JPOXUserException(LOCALISER.msg("Query.RangeNeedsLiteralExpression", "FROM", exprs[0]));
                    }
                    if (!(((Literal)((Object)exprs[0])).getValue() instanceof Number)) {
                        throw new JPOXUserException(LOCALISER.msg("Query.RangeLiteralExpressionNumberOnly", "FROM", exprs[0]));
                    }
                    JPQLQuery.this.fromInclNo = ((Number)((Literal)((Object)exprs[0])).getValue()).longValue();
                }
                if (exprs.length > 1) {
                    if (!(exprs[1] instanceof Literal)) {
                        throw new JPOXUserException(LOCALISER.msg("Query.RangeNeedsLiteralExpression", "TO", exprs[1]));
                    }
                    if (!(((Literal)((Object)exprs[1])).getValue() instanceof Number)) {
                        throw new JPOXUserException(LOCALISER.msg("Query.RangeLiteralExpressionNumberOnly", "TO", exprs[1]));
                    }
                    JPQLQuery.this.toExclNo = ((Number)((Literal)((Object)exprs[1])).getValue()).longValue();
                }
            }
            if (qs != null && JPQLQuery.this.fromInclNo > 0L || JPQLQuery.this.toExclNo != Long.MAX_VALUE) {
                qs.setRangeConstraint(JPQLQuery.this.fromInclNo, JPQLQuery.this.toExclNo != Long.MAX_VALUE ? JPQLQuery.this.toExclNo - JPQLQuery.this.fromInclNo : -1L);
            }
        }

        private ScalarExpression compileExpressionFromString(String str, Imports imports) {
            this.p = new JPQLParser(str, imports);
            ScalarExpression expr = this.compileExpression();
            if (!this.p.parseEOS()) {
                throw new ExpressionSyntaxException(LOCALISER.msg("Query.InvalidExpressionError", "JPQL"));
            }
            return expr;
        }

        private ScalarExpression[] compileExpressionsFromString(String str, Imports imports) {
            String[] exprList = QueryUtils.getExpressionsFromString(str);
            if (exprList != null && exprList.length > 0) {
                ScalarExpression[] exprs = new ScalarExpression[exprList.length];
                for (int i = 0; i < exprs.length; ++i) {
                    exprs[i] = this.compileExpressionFromString(exprList[i], imports);
                }
                return exprs;
            }
            return null;
        }

        private ScalarExpression compileExpression() {
            return this.compileJoinExpression();
        }

        private ScalarExpression compileJoinExpression() {
            String alias;
            ScalarExpression leftExpr = this.compileOrExpression();
            boolean leftJoin = false;
            boolean innerJoin = false;
            if (this.p.parseStringIgnoreCase("inner")) {
                innerJoin = true;
            } else if (this.p.parseStringIgnoreCase("left")) {
                this.p.parseStringIgnoreCase("outer");
                leftJoin = true;
            }
            if (!this.p.parseStringIgnoreCase("join")) {
                if (innerJoin || leftJoin) {
                    throw new JPOXUserException("Expected JOIN after INNER/LEFT keyword at" + this.p.remaining());
                }
                return leftExpr;
            }
            boolean fetch = false;
            if (this.p.parseStringIgnoreCase("fetch")) {
                fetch = true;
            }
            String name = this.p.parseIdentifier();
            if (this.p.nextIsDot()) {
                this.p.parseChar('.');
                name = name + ".";
                name = name + this.p.parseName();
            }
            if ((alias = this.p.parseIdentifier()) != null && alias.equalsIgnoreCase("AS")) {
                alias = this.p.parseIdentifier();
            }
            return ((ClassExpression)leftExpr).join(new JoinExpression(this.qs, name, alias, leftJoin, fetch));
        }

        private ScalarExpression compileOrExpression() {
            ScalarExpression expr = this.compileAndExpression();
            while (this.p.parseStringIgnoreCase("OR")) {
                expr = expr.ior(this.compileAndExpression());
            }
            return expr;
        }

        private ScalarExpression compileAndExpression() {
            ScalarExpression expr = this.compileNotExpression();
            while (this.p.parseStringIgnoreCase("AND")) {
                expr = expr.and(this.compileNotExpression());
            }
            return expr;
        }

        private ScalarExpression compileNotExpression() {
            ScalarExpression expr = null;
            expr = this.p.parseStringIgnoreCase("NOT") ? this.compileEqualityExpression().not() : this.compileEqualityExpression();
            return expr;
        }

        private ScalarExpression compileEqualityExpression() {
            ScalarExpression expr;
            block12: {
                block13: {
                    expr = this.compileRelationalExpression();
                    while (true) {
                        ArrayList args;
                        ArrayList<ScalarExpression> list;
                        ScalarExpression leftexpr;
                        if (this.p.parseString("=")) {
                            expr = expr.eq(this.compileRelationalExpression());
                            continue;
                        }
                        if (this.p.parseStringIgnoreCase("NOT")) {
                            if (this.p.parseStringIgnoreCase("BETWEEN")) {
                                leftexpr = this.compileAdditiveExpression();
                                ScalarExpression rightexpr = null;
                                if (!this.p.parseStringIgnoreCase("AND")) {
                                    throw new ExpressionSyntaxException("Expected: 'AND' but got " + this.p.remaining());
                                }
                                rightexpr = this.compileAdditiveExpression();
                                return expr.lt(leftexpr).ior(expr.gt(rightexpr));
                            }
                            if (this.p.parseStringIgnoreCase("LIKE")) {
                                list = new ArrayList<ScalarExpression>();
                                list.add(this.compileAdditiveExpression());
                                return expr.callMethod("like", list).not();
                            }
                            throw new ExpressionSyntaxException("Expected: 'BETWEEN' or 'LIKE' but got " + this.p.remaining());
                        }
                        if (this.p.parseStringIgnoreCase("BETWEEN")) {
                            leftexpr = this.compileAdditiveExpression();
                            ScalarExpression rightexpr = null;
                            if (!this.p.parseStringIgnoreCase("AND")) {
                                throw new ExpressionSyntaxException("Expected: 'AND' but got " + this.p.remaining());
                            }
                            rightexpr = this.compileAdditiveExpression();
                            return expr.gteq(leftexpr).and(expr.lteq(rightexpr));
                        }
                        if (this.p.parseStringIgnoreCase("LIKE")) {
                            list = new ArrayList();
                            list.add(this.compileAdditiveExpression());
                            return expr.callMethod("like", list);
                        }
                        if (!this.p.parseStringIgnoreCase("is")) break block12;
                        if (this.p.parseStringIgnoreCase("null")) {
                            expr = expr.eq(new NullLiteral(this.qs));
                            continue;
                        }
                        if (this.p.parseStringIgnoreCase("empty")) {
                            args = new ArrayList();
                            expr = expr.callMethod("isEmpty", args);
                            continue;
                        }
                        if (!this.p.parseStringIgnoreCase("not")) break block13;
                        if (this.p.parseStringIgnoreCase("null")) {
                            expr = expr.noteq(new NullLiteral(this.qs));
                            continue;
                        }
                        if (!this.p.parseStringIgnoreCase("empty")) break;
                        args = new ArrayList();
                        expr = expr.callMethod("isEmpty", args).not();
                    }
                    throw new ExpressionSyntaxException("Expected: 'null' or 'empty' but got " + this.p.remaining());
                }
                throw new ExpressionSyntaxException("Expected: 'null', 'empty' or 'not' but got " + this.p.remaining());
            }
            return expr;
        }

        private ScalarExpression compileRelationalExpression() {
            ScalarExpression expr = this.compileAdditiveExpression();
            while (true) {
                if (this.p.parseString("<=")) {
                    expr = expr.lteq(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseString(">=")) {
                    expr = expr.gteq(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseString("<>")) {
                    expr = expr.noteq(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseChar('<')) {
                    expr = expr.lt(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseChar('>')) {
                    expr = expr.gt(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseString("instanceof")) {
                    expr = expr.instanceOf(this.compileAdditiveExpression());
                    continue;
                }
                if (this.p.parseStringIgnoreCase("like")) {
                    ArrayList<ScalarExpression> list = new ArrayList<ScalarExpression>();
                    list.add(this.compileAdditiveExpression());
                    expr = expr.callMethod("like", list);
                    continue;
                }
                if (!this.p.parseStringIgnoreCase("AS")) break;
                String asName = this.p.parseName();
                expr = expr.as(asName);
            }
            return expr;
        }

        private ScalarExpression compileAdditiveExpression() {
            ScalarExpression expr = this.compileMultiplicativeExpression();
            while (true) {
                if (this.p.parseChar('+')) {
                    expr = expr.add(this.compileMultiplicativeExpression());
                    continue;
                }
                if (!this.p.parseChar('-')) break;
                expr = expr.sub(this.compileMultiplicativeExpression());
            }
            return expr;
        }

        private ScalarExpression compileMultiplicativeExpression() {
            ScalarExpression expr = this.compileUnaryExpression();
            while (true) {
                if (this.p.parseChar('*')) {
                    expr = expr.mul(this.compileUnaryExpression());
                    continue;
                }
                if (this.p.parseChar('/')) {
                    expr = expr.div(this.compileUnaryExpression());
                    continue;
                }
                if (!this.p.parseChar('%')) break;
                expr = expr.mod(this.compileUnaryExpression());
            }
            return expr;
        }

        private ScalarExpression compileUnaryExpression() {
            if (this.p.parseString("++")) {
                throw new JPOXUserException("Unsupported operator '++'");
            }
            if (this.p.parseString("--")) {
                throw new JPOXUserException("Unsupported operator '--'");
            }
            ScalarExpression expr = this.p.parseChar('+') ? this.compileUnaryExpression() : (this.p.parseChar('-') ? this.compileUnaryExpression().neg() : this.compileUnaryExpressionNotPlusMinus());
            return expr;
        }

        private ScalarExpression compileUnaryExpressionNotPlusMinus() {
            ScalarExpression expr;
            if (this.p.parseChar('~')) {
                expr = this.compileUnaryExpression().com();
            } else if (this.p.parseChar('!')) {
                expr = this.compileUnaryExpression().not();
            } else {
                expr = this.compileCastExpression();
                if (expr == null) {
                    expr = this.compilePrimary();
                }
            }
            return expr;
        }

        private ScalarExpression compileCastExpression() {
            Class type = this.p.parseCast(this.qs == null ? JPQLQuery.this.om.getClassLoaderResolver() : this.qs.getClassLoaderResolver(), JPQLQuery.this.getCandidateLoader());
            if (type == null) {
                return null;
            }
            return this.compileUnaryExpression().cast(type);
        }

        private ScalarExpression compilePrimary() {
            ArrayList<ScalarExpression> args;
            ScalarExpression expr;
            block35: {
                expr = this.compileLiteral();
                if (expr == null) {
                    if (this.p.parseChar('(')) {
                        expr = this.compileExpression();
                        if (!this.p.parseChar(')')) {
                            throw new ExpressionSyntaxException("')' expected");
                        }
                        expr.encloseWithInParentheses();
                    } else if (this.p.parseChar('{')) {
                        ArrayList<ScalarExpression> exprs = new ArrayList<ScalarExpression>();
                        while (!this.p.parseChar('}')) {
                            exprs.add(this.compileExpression());
                            if (this.p.parseChar('}')) break;
                            if (this.p.parseChar(',')) continue;
                            throw new ExpressionSyntaxException("',' or '}' expected");
                        }
                        expr = new ArrayExpression(this.qs, exprs.toArray(new ScalarExpression[exprs.size()]));
                    } else {
                        String methodId = this.p.parseMethod();
                        if (methodId == null) {
                            expr = this.compileIdentifier();
                        } else if (this.p.parseChar('(')) {
                            ArrayList<ScalarExpression> argscall;
                            args = new ArrayList();
                            boolean isDistinct = false;
                            if (!this.p.parseChar(')')) {
                                isDistinct = this.p.parseString("DISTINCT");
                                if (!isDistinct) {
                                    isDistinct = this.p.parseString("distinct");
                                }
                                do {
                                    ScalarExpression argExpr = this.compileExpression();
                                    args.add(argExpr);
                                    this.fieldExpressions.remove(argExpr);
                                } while (this.p.parseChar(','));
                                if (!this.p.parseChar(')')) {
                                    throw new ExpressionSyntaxException("')' expected");
                                }
                            }
                            if (methodId.equalsIgnoreCase("ABS")) {
                                return new MathExpression(this.qs).absMethod((ScalarExpression)args.get(0));
                            }
                            if (methodId.equalsIgnoreCase("SQRT")) {
                                return new MathExpression(this.qs).sqrtMethod((ScalarExpression)args.get(0));
                            }
                            if (methodId.equalsIgnoreCase("CONCAT")) {
                                return ((ScalarExpression)args.get(0)).add((ScalarExpression)args.get(1));
                            }
                            if (methodId.equalsIgnoreCase("MOD")) {
                                return ((ScalarExpression)args.get(0)).mod((ScalarExpression)args.get(1));
                            }
                            if (methodId.equalsIgnoreCase("LENGTH")) {
                                return ((ScalarExpression)args.get(0)).callMethod(methodId.toLowerCase(), Collections.EMPTY_LIST);
                            }
                            if (methodId.equalsIgnoreCase("SUBSTRING")) {
                                argscall = new ArrayList<ScalarExpression>();
                                JavaTypeMapping mapping = JPQLQuery.this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = JPQLQuery.class$("java.lang.String")) : class$java$lang$String, this.qs.getStoreManager());
                                IntegerLiteral one = new IntegerLiteral(this.qs, mapping, BigInteger.ONE, false);
                                argscall.add(((ScalarExpression)args.get(1)).sub(one));
                                if (args.size() > 2) {
                                    argscall.add(((ScalarExpression)args.get(2)).add(one));
                                }
                                return ((ScalarExpression)args.get(0)).callMethod(methodId.toLowerCase(), argscall);
                            }
                            if (methodId.equalsIgnoreCase("LOWER")) {
                                return ((ScalarExpression)args.get(0)).callMethod("toLowerCase", Collections.EMPTY_LIST);
                            }
                            if (methodId.equalsIgnoreCase("UPPER")) {
                                return ((ScalarExpression)args.get(0)).callMethod("toUpperCase", Collections.EMPTY_LIST);
                            }
                            if (methodId.equalsIgnoreCase("SIZE")) {
                                return ((ScalarExpression)args.get(0)).callMethod(methodId.toLowerCase(), Collections.EMPTY_LIST);
                            }
                            if (methodId.equalsIgnoreCase("LOCATE")) {
                                argscall = new ArrayList();
                                argscall.add((ScalarExpression)args.get(0));
                                JavaTypeMapping mapping = JPQLQuery.this.dba.getMapping(class$java$lang$String == null ? (class$java$lang$String = JPQLQuery.class$("java.lang.String")) : class$java$lang$String, this.qs.getStoreManager());
                                IntegerLiteral one = new IntegerLiteral(this.qs, mapping, BigInteger.ONE, false);
                                if (args.size() > 2) {
                                    argscall.add(((ScalarExpression)args.get(2)).sub(one));
                                }
                                return ((ScalarExpression)args.get(1)).callMethod("indexOf", argscall).add(one);
                            }
                            expr = new AggregateExpression(this.qs);
                            if (isDistinct) {
                                ((AggregateExpression)expr).setDistinct();
                            }
                            try {
                                expr = expr.callMethod(methodId.toLowerCase(), args);
                                this.fieldExpressions.add(expr);
                            }
                            catch (ScalarExpression.MethodInvocationException ex) {
                                if (!methodId.equalsIgnoreCase("Object")) break block35;
                                expr = (ScalarExpression)args.get(0);
                            }
                        }
                    }
                }
            }
            while (this.p.parseChar('.')) {
                String id = this.p.parseIdentifier();
                if (id == null) {
                    throw new ExpressionSyntaxException("Identifier expected");
                }
                if (this.p.parseChar('(')) {
                    args = new ArrayList<ScalarExpression>();
                    if (!this.p.parseChar(')')) {
                        do {
                            args.add(this.compileExpression());
                        } while (this.p.parseChar(','));
                        if (!this.p.parseChar(')')) {
                            throw new ExpressionSyntaxException("')' expected");
                        }
                    }
                    expr = expr.callMethod(id, args);
                    continue;
                }
                expr = expr.accessField(id, false);
            }
            return expr;
        }

        private ScalarExpression compileLiteral() {
            Object litValue;
            Class litType;
            boolean single_quote_next = this.p.nextIsSingleQuote();
            String sLiteral = this.p.parseStringLiteral();
            if (sLiteral != null) {
                if (sLiteral.length() == 1 && single_quote_next) {
                    litType = class$java$lang$Character == null ? (class$java$lang$Character = JPQLQuery.class$("java.lang.Character")) : class$java$lang$Character;
                    litValue = new Character(sLiteral.charAt(0));
                } else {
                    litType = class$java$lang$String == null ? (class$java$lang$String = JPQLQuery.class$("java.lang.String")) : class$java$lang$String;
                    litValue = sLiteral;
                }
            } else {
                BigDecimal fLiteral = this.p.parseFloatingPointLiteral();
                if (fLiteral != null) {
                    litType = class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JPQLQuery.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
                    litValue = fLiteral;
                } else {
                    BigInteger iLiteral = this.p.parseIntegerLiteral();
                    if (iLiteral != null) {
                        litType = class$java$lang$Long == null ? (class$java$lang$Long = JPQLQuery.class$("java.lang.Long")) : class$java$lang$Long;
                        litValue = new Long(iLiteral.longValue());
                    } else {
                        Boolean bLiteral = this.p.parseBooleanLiteral();
                        if (bLiteral != null) {
                            litType = class$java$lang$Boolean == null ? (class$java$lang$Boolean = JPQLQuery.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                            litValue = bLiteral;
                        } else {
                            if (this.p.parseNullLiteral()) {
                                return new NullLiteral(this.qs);
                            }
                            return null;
                        }
                    }
                }
            }
            JavaTypeMapping m = JPQLQuery.this.dba.getMapping(litType, this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
            return m.newLiteral(this.qs, litValue);
        }

        private ScalarExpression compileIdentifier() {
            ScalarExpression expr;
            block60: {
                String id = this.p.parseIdentifier();
                if (id == null) {
                    throw new ExpressionSyntaxException("Identifier expected");
                }
                for (int i = 0; i < AbstractJPQLQuery.SINGLE_STRING_KEYWORDS.length; ++i) {
                    if (!id.equalsIgnoreCase(AbstractJPQLQuery.SINGLE_STRING_KEYWORDS[i])) continue;
                    throw new ExpressionSyntaxException(LOCALISER.msg("Query.IdentifierIsKeyword", "JPQL", id));
                }
                if (id.equalsIgnoreCase("false")) {
                    JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JPQLQuery.class$("java.lang.Boolean")) : class$java$lang$Boolean, this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                    return m.newLiteral(this.qs, Boolean.FALSE);
                }
                if (id.equalsIgnoreCase("true")) {
                    JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(class$java$lang$Boolean == null ? (class$java$lang$Boolean = JPQLQuery.class$("java.lang.Boolean")) : class$java$lang$Boolean, this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                    return m.newLiteral(this.qs, Boolean.TRUE);
                }
                if (id.startsWith(":")) {
                    id = id.substring(1);
                    if (this.explicitParameters) {
                        throw new JPOXQueryInvalidParametersException(LOCALISER.msg("Query.MixedParametersInvalid", this.parameters, id));
                    }
                    if (this.parameters != null && this.parameters.size() > 0) {
                        if (this.parameters.containsKey(id)) {
                            Object paramValue = this.parameters.get(id);
                            if (paramValue != null) {
                                JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(paramValue.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                                return m.newLiteral(this.qs, paramValue);
                            }
                            return new NullLiteral(this.qs);
                        }
                        if (this.parameters.size() < this.implicitParamNo + 1) {
                            throw new JPOXQueryInvalidParametersException(LOCALISER.msg("Query.ImplicitParameterWithNoValue", "" + id, "" + this.implicitParamNo));
                        }
                        if (!this.parameters.containsKey("JPOX_" + this.implicitParamNo)) {
                            throw new JPOXQueryInvalidParametersException(LOCALISER.msg("Query.ImplicitParameterWithNoValue", "" + id, "" + this.implicitParamNo));
                        }
                        Object paramValue = this.parameters.get("JPOX_" + this.implicitParamNo);
                        this.parameters.put(id, paramValue);
                        this.parameters.remove("JPOX_" + this.implicitParamNo);
                        ++this.implicitParamNo;
                        if (paramValue != null) {
                            JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(paramValue.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                            return m.newLiteral(this.qs, paramValue);
                        }
                        return new NullLiteral(this.qs);
                    }
                    if (JPQLQuery.this.isPreCompile) {
                        return new NullLiteral(this.qs);
                    }
                    throw new JPOXQueryInvalidParametersException(LOCALISER.msg("Query.ImplicitParameterWithNoValue", "" + id, "" + this.implicitParamNo));
                }
                if (id.startsWith("?")) {
                    id = id.substring(1);
                    Integer position = new Integer(id);
                    if (this.parameters != null && this.parameters.size() > 0) {
                        if (this.parameters.containsKey(position)) {
                            Object paramValue = this.parameters.get(position);
                            if (paramValue != null) {
                                JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(paramValue.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                                return m.newLiteral(this.qs, paramValue);
                            }
                            return new NullLiteral(this.qs);
                        }
                        if (this.parameters.size() < this.implicitParamNo + 1) {
                            throw new JPOXUserException(LOCALISER.msg("Query.ImplicitParameterWithNoValue", "" + position, "" + this.implicitParamNo));
                        }
                        if (!this.parameters.containsKey("JPOX_" + this.implicitParamNo)) {
                            throw new JPOXQueryInvalidParametersException(LOCALISER.msg("Query.ImplicitParameterWithNoValue", "" + position, "" + this.implicitParamNo));
                        }
                        Object paramValue = this.parameters.get("JPOX_" + this.implicitParamNo);
                        this.parameters.put(position, paramValue);
                        this.parameters.remove("JPOX_" + this.implicitParamNo);
                        ++this.implicitParamNo;
                        if (paramValue != null) {
                            JavaTypeMapping m = this.qs.getStoreManager().getDatastoreAdapter().getMapping(paramValue.getClass(), this.qs.getStoreManager(), this.qs.getClassLoaderResolver());
                            return m.newLiteral(this.qs, paramValue);
                        }
                        return new NullLiteral(this.qs);
                    }
                    if (JPQLQuery.this.isPreCompile) {
                        return new NullLiteral(this.qs);
                    }
                    throw new JPOXQueryInvalidParametersException(LOCALISER.msg("Query.ImplicitParameterWithNoValue", "" + position, "" + this.implicitParamNo));
                }
                if (id.equalsIgnoreCase("new")) {
                    String newClsName = this.p.parseName();
                    Class newCls = null;
                    try {
                        newCls = JPQLQuery.this.resolveClassDeclaration(newClsName);
                    }
                    catch (JPOXUserException jdoe) {
                        throw new JPOXUserException(LOCALISER.msg("Query.NewObject.ClassNotFound", "JPQL", newClsName));
                    }
                    ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
                    if (this.p.parseChar('(')) {
                        if (!this.p.parseChar(')')) {
                            do {
                                ScalarExpression argExpr = this.compileExpression();
                                args.add(argExpr);
                                this.fieldExpressions.add(argExpr);
                            } while (this.p.parseChar(','));
                            if (!this.p.parseChar(')')) {
                                throw new ExpressionSyntaxException("')' expected");
                            }
                        }
                    } else {
                        throw new JPOXUserException(LOCALISER.msg("Query.NewObject.InvalidSyntax", "JPQL", JPQLQuery.this.getSingleStringQuery()));
                    }
                    expr = new NewObjectExpression(this.qs, newCls, args);
                } else if (JPQLQuery.this.parameterNames.contains(id)) {
                    Class parameterClass = (Class)JPQLQuery.this.parameterTypesByName.get(id);
                    boolean serialised = false;
                    if (parameterClass == (class$java$lang$Object == null ? (class$java$lang$Object = JPQLQuery.class$("java.lang.Object")) : class$java$lang$Object)) {
                        serialised = true;
                    }
                    JavaTypeMapping m = JPQLQuery.this.dba.getMapping(parameterClass, this.qs.getStoreManager(), this.qs.getClassLoaderResolver(), serialised, false);
                    if (JPQLQuery.this.isPreCompile) {
                        expr = m.newLiteral(this.qs, m.getSampleValue(this.qs.getClassLoaderResolver()));
                    } else {
                        if (this.parameters == null || !this.parameters.containsKey(id)) {
                            throw new JPOXUserException(LOCALISER.msg("Query.RequiredParameterNotProvidedError", "JPQL", id));
                        }
                        Object parameterValue = this.parameters.get(id);
                        expr = parameterValue == null ? new NullLiteral(this.qs) : m.newLiteral(this.qs, parameterValue);
                    }
                } else if (JPQLQuery.this.variableNames.contains(id)) {
                    expr = (ScalarExpression)this.expressionsByVariableName.get(id);
                    if (expr == null) {
                        expr = new UnboundVariable(this.qs, id, (Class)JPQLQuery.this.variableTypesByName.get(id), this);
                    }
                    this.fieldExpressions.add(expr);
                } else if (this.qs == null) {
                    String name = id;
                    if (this.p.nextIsDot()) {
                        this.p.parseChar('.');
                        name = name + ".";
                        name = name + this.p.parseName();
                    }
                    Class cls = null;
                    cls = JPQLQuery.this.resolveClassDeclaration(name);
                    expr = new ClassExpression(this.qs, cls);
                    id = this.p.parseIdentifier();
                    if (id.equalsIgnoreCase("as")) {
                        id = this.p.parseIdentifier();
                    }
                    if (id != null) {
                        ((ClassExpression)expr).as(id);
                    }
                } else {
                    try {
                        expr = this.qs.getDefaultTableExpression().newFieldExpression(id);
                        if (!id.equals(JPQLQuery.this.candidateAlias)) {
                            if (JPQLQuery.this.candidateCmd == null) {
                                JPQLQuery.this.candidateCmd = JPQLQuery.this.om.getMetaDataManager().getMetaDataForClass(JPQLQuery.this.candidateClass, JPQLQuery.this.om.getClassLoaderResolver());
                            }
                            if (JPQLQuery.this.candidateCmd.getMetaDataForMember(id) == null) {
                                throw new JPOXUserException(LOCALISER.msg("Query.SpecifiedFieldNotFound", id));
                            }
                        }
                        this.fieldExpressions.add(expr);
                    }
                    catch (NoSuchPersistentFieldException nspfe) {
                        if (JPQLQuery.this.aliases.get(id) != null) {
                            Class cls = (Class)JPQLQuery.this.aliases.get(id);
                            DatastoreClass datastoreClass = this.qs.getStoreManager().getDatastoreClass(cls.getName(), this.qs.getClassLoaderResolver());
                            expr = id.equals(JPQLQuery.this.candidateAlias) ? datastoreClass.getIDMapping().newScalarExpression(this.qs, this.qs.getDefaultTableExpression()) : datastoreClass.getIDMapping().newScalarExpression(this.qs, this.qs.getTableExpression(datastoreClass.getIdentifier()));
                        }
                        String name = id;
                        if (this.p.nextIsDot()) {
                            this.p.parseChar('.');
                            name = name + ".";
                            name = name + this.p.parseName();
                        }
                        Class cls = null;
                        try {
                            cls = JPQLQuery.this.resolveClassDeclaration(name);
                            expr = new ClassExpression(this.qs, cls);
                        }
                        catch (JPOXUserException jdoe) {
                            if (name.indexOf(46) > 0) {
                                String partialName = name.substring(0, name.lastIndexOf(46));
                                String finalNamePart = name.substring(name.lastIndexOf(46) + 1);
                                try {
                                    expr = this.callUserDefinedScalarExpression(name);
                                    if (expr == null) {
                                        cls = JPQLQuery.this.resolveClassDeclaration(partialName);
                                        expr = new ClassExpression(this.qs, cls);
                                        expr = expr.accessField(finalNamePart, true);
                                    }
                                    break block60;
                                }
                                catch (JPOXUserException jdoe2) {
                                    throw new JPOXUserException(LOCALISER.msg("Query.SpecifiedClassNotFound", partialName), jdoe2);
                                }
                            }
                            try {
                                expr = new ClassExpression(this.qs, JPQLQuery.this.candidateClass);
                                expr = expr.accessField(name, true);
                            }
                            catch (JPOXUserException jdoe2) {
                                if (this.explicitVariables) {
                                    throw new JPOXUserException(LOCALISER.msg("Query.MixedVariablesInvalid", JPQLQuery.this.variables, name));
                                }
                                expr = (ScalarExpression)this.expressionsByVariableName.get(name);
                                if (expr != null) break block60;
                                expr = new UnboundVariable(this.qs, name, (Class)JPQLQuery.this.variableTypesByName.get(name), this);
                                JPQLQuery.this.variableNames.add(name);
                                this.fieldExpressions.add(expr);
                            }
                        }
                    }
                }
            }
            return expr;
        }

        private ScalarExpression callUserDefinedScalarExpression(String method) {
            String className = method.substring(0, method.lastIndexOf(46));
            String methodName = method.substring(method.lastIndexOf(46) + 1);
            if (!userDefinedScalarExpressions.containsKey(className)) {
                Class cls = JPQLQuery.this.resolveClassDeclaration(className);
                className = cls.getName();
            }
            if (userDefinedScalarExpressions.containsKey(className)) {
                ScalarExpression expr = this.newScalarExpression((Class)userDefinedScalarExpressions.get(className));
                if (this.p.parseChar('(')) {
                    ArrayList<ScalarExpression> args = new ArrayList<ScalarExpression>();
                    if (!this.p.parseChar(')')) {
                        do {
                            args.add(this.compileExpression());
                        } while (this.p.parseChar(','));
                        if (!this.p.parseChar(')')) {
                            throw new ExpressionSyntaxException("')' expected");
                        }
                    }
                    return expr.callMethod(methodName, args);
                }
            }
            return null;
        }

        private ScalarExpression newScalarExpression(Class cls) {
            try {
                return (ScalarExpression)cls.getConstructor(class$org$jpox$store$expression$QueryExpression == null ? (class$org$jpox$store$expression$QueryExpression = JPQLQuery.class$("org.jpox.store.expression.QueryExpression")) : class$org$jpox$store$expression$QueryExpression).newInstance(this.qs);
            }
            catch (IllegalArgumentException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (SecurityException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (InstantiationException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (IllegalAccessException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (InvocationTargetException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
            catch (NoSuchMethodException e) {
                throw new JPOXException("Cannot create ScalarExpression for class " + cls.getName() + " due to " + e.getMessage(), e).setFatal();
            }
        }

        private class ExpressionSyntaxException
        extends JPOXUserException {
            public ExpressionSyntaxException(String msg) {
                super(msg + " at character " + (Compiler.this.p.getIndex() + 1) + " in \"" + Compiler.this.p.getInput() + '\"');
            }
        }
    }
}

