/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import org.jpox.ClassLoaderResolver;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.DatastoreIdentifier;
import org.jpox.store.expression.CharacterExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.rdbms.adapter.RDBMSAdapter;
import org.jpox.store.rdbms.query.QueryStatement;
import org.jpox.store.rdbms.query.StatementText;
import org.jpox.util.Localiser;

public class Oracle99QueryStatement
extends QueryStatement {
    protected static final Localiser LOCALISER_RDBMS = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    private String nlsSortOrder = "LATIN";

    public Oracle99QueryStatement(DatastoreContainerObject initialTable, ClassLoaderResolver clr) {
        super(initialTable, clr);
        this.nlsSortOrder = initialTable.getStoreManager().getOMFContext().getPersistenceConfiguration().getOracleNlsSortOrder().toUpperCase();
    }

    public Oracle99QueryStatement(DatastoreContainerObject initialTable, DatastoreIdentifier initialRangeVar, ClassLoaderResolver clr) {
        super(initialTable, initialRangeVar, clr);
        this.nlsSortOrder = initialTable.getStoreManager().getOMFContext().getPersistenceConfiguration().getOracleNlsSortOrder().toUpperCase();
    }

    protected StatementText generateOrderingStatement() {
        StatementText orderByStmt = null;
        if (this.orderingExpressions != null && this.orderingExpressions.length > 0) {
            orderByStmt = new StatementText();
            boolean needsSelect = ((RDBMSAdapter)this.dba).includeOrderByColumnsInSelect();
            for (int i = 0; i < this.orderingExpressions.length; ++i) {
                String orderExpr = "JPOXORDER" + i;
                if (i > 0) {
                    orderByStmt.append(',');
                }
                if (needsSelect && !this.hasAggregateExpression) {
                    if (this.orderingExpressions[i] instanceof CharacterExpression && !this.nlsSortOrder.equals("BINARY")) {
                        orderByStmt.append("NLSSORT(").append(orderExpr).append(", 'NLS_SORT = ").append(this.nlsSortOrder).append("')");
                    } else {
                        orderByStmt.append(orderExpr);
                    }
                } else if (this.orderingExpressions[i] instanceof CharacterExpression && !this.nlsSortOrder.equals("BINARY")) {
                    orderByStmt.append("NLSSORT(").append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION)).append(", 'NLS_SORT = ").append(this.nlsSortOrder).append("')");
                } else {
                    orderByStmt.append(this.orderingExpressions[i].toStatementText(ScalarExpression.PROJECTION).toStatementString(ScalarExpression.PROJECTION));
                }
                if (!this.orderingDirections[i]) continue;
                orderByStmt.append(" DESC");
            }
        }
        return orderByStmt;
    }
}

