/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import org.jpox.ObjectManager;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.DiscriminatorMetaData;
import org.jpox.metadata.DiscriminatorStrategy;
import org.jpox.store.DatastoreClass;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.query.QueryUtils;

public class RDBMSQueryUtils
extends QueryUtils {
    public static String getClassNameFromDiscriminatorResultSetRow(DatastoreClass table, ResultSet rs, ObjectManager om) {
        String rowClassName;
        block6: {
            rowClassName = null;
            JavaTypeMapping discriminatorMapping = table.getDiscriminatorMapping();
            DiscriminatorMetaData dismd = table.getDiscriminatorMetaData();
            if (discriminatorMapping != null && dismd.getStrategy() != DiscriminatorStrategy.NONE) {
                try {
                    String discriminatorColName = discriminatorMapping.getDataStoreMapping(0).getDatastoreField().getIdentifier().getIdentifier();
                    String discriminatorValue = rs.getString(discriminatorColName);
                    if (dismd.getStrategy() == DiscriminatorStrategy.CLASS_NAME) {
                        rowClassName = discriminatorValue;
                        break block6;
                    }
                    if (dismd.getStrategy() != DiscriminatorStrategy.VALUE_MAP) break block6;
                    String className = table.getType();
                    if (dismd.getValue().equals(discriminatorValue)) {
                        rowClassName = className;
                        break block6;
                    }
                    Iterator iterator = om.getStoreManager().getSubClassesForClass(table.getType(), true, om.getClassLoaderResolver()).iterator();
                    while (iterator.hasNext()) {
                        className = (String)iterator.next();
                        AbstractClassMetaData classCmd = om.getMetaDataManager().getMetaDataForClass(className, om.getClassLoaderResolver());
                        if (!discriminatorValue.equals(classCmd.getInheritanceMetaData().getDiscriminatorMetaData().getValue())) continue;
                        rowClassName = className;
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return rowClassName;
    }

    public static String getClassNameFromJPOXMetaDataResultSetRow(ResultSet rs) {
        try {
            return rs.getString("JPOXMETADATA").trim();
        }
        catch (SQLException sqle) {
            return null;
        }
    }
}

