/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jpox.ClassLoaderResolver;
import org.jpox.ObjectManager;
import org.jpox.StateManager;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.IdentityType;
import org.jpox.store.DatastoreClass;
import org.jpox.store.DatastoreContainerObject;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.StoreManager;
import org.jpox.store.expression.AggregateExpression;
import org.jpox.store.expression.BooleanExpression;
import org.jpox.store.expression.Literal;
import org.jpox.store.expression.LogicSetExpression;
import org.jpox.store.expression.NewObjectExpression;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.expression.ScalarExpression;
import org.jpox.store.mapping.AbstractContainerMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.SingleFieldMapping;
import org.jpox.store.query.Queryable;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.query.DiscriminatorIteratorStatement;
import org.jpox.store.rdbms.query.ResultClassROF;
import org.jpox.store.rdbms.query.UnionIteratorStatement;
import org.jpox.util.Localiser;

public class ResultExpressionsQueryable
implements Queryable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.jpox.store.rdbms.Localisation");
    private final Class candidateClass;
    private final Collection userCandidates;
    private ScalarExpression[] expressions;
    private final StoreManager storeMgr;
    private final boolean subclasses;
    private final ClassLoaderResolver clr;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$Ljava$lang$Object;

    public ResultExpressionsQueryable(ObjectManager om, Class candidateClass, boolean subclasses) {
        this.candidateClass = candidateClass;
        this.storeMgr = om.getStoreManager();
        this.clr = om.getClassLoaderResolver();
        this.subclasses = subclasses;
        this.userCandidates = null;
    }

    public ResultExpressionsQueryable(ObjectManager om, Class candidateClass, Collection userCandidates, boolean subclasses) {
        this.userCandidates = userCandidates;
        this.candidateClass = candidateClass;
        this.storeMgr = om.getStoreManager();
        this.clr = om.getClassLoaderResolver();
        this.subclasses = subclasses;
    }

    public QueryExpression newQueryStatement() {
        return this.newQueryStatement(this.candidateClass);
    }

    public void setResultExpressions(ScalarExpression[] expressions) {
        this.expressions = expressions;
    }

    public ScalarExpression[] getResultExpressions() {
        return this.expressions;
    }

    public boolean hasAggregatedExpressionsOnly() {
        boolean aggregatedOnly = true;
        if (this.expressions == null) {
            return false;
        }
        for (int i = 0; this.expressions != null && i < this.expressions.length; ++i) {
            if (this.expressions[i] instanceof AggregateExpression) continue;
            aggregatedOnly = false;
        }
        return aggregatedOnly;
    }

    private boolean queryUsingDiscriminator(DatastoreClass table) {
        if (table.getDiscriminatorMetaData() == null || table.getDiscriminatorMapping() == null) {
            return false;
        }
        if (this.subclasses) {
            Iterator iterator = this.storeMgr.getSubClassesForClass(this.candidateClass.getName(), true, this.clr).iterator();
            while (iterator.hasNext()) {
                String subCandidateName = (String)iterator.next();
                if (table.managesClass(subCandidateName)) continue;
                return false;
            }
        }
        return true;
    }

    public QueryExpression newQueryStatement(Class candidateClass) {
        DatastoreClass datastoreClass = this.storeMgr.getDatastoreClass(candidateClass.getName(), this.clr);
        JavaTypeMapping m = datastoreClass.getIDMapping();
        Class type = candidateClass;
        boolean subclasses = this.subclasses;
        QueryExpression stmt = null;
        stmt = !this.queryUsingDiscriminator(datastoreClass) && !subclasses && this.hasAggregatedExpressionsOnly() ? new DiscriminatorIteratorStatement(this.clr, new Class[]{type}, subclasses, this.storeMgr, false).getQueryStatement() : (this.queryUsingDiscriminator(datastoreClass) || this.hasAggregatedExpressionsOnly() ? new DiscriminatorIteratorStatement(this.clr, new Class[]{type}, subclasses, this.storeMgr, false).getQueryStatement() : new UnionIteratorStatement(this.clr, candidateClass, subclasses, this.storeMgr, type, m, datastoreClass, false, Boolean.FALSE, true, false).getQueryStatement());
        if (this.userCandidates != null) {
            BooleanExpression elementsExpr = null;
            Iterator it = this.userCandidates.iterator();
            while (it.hasNext()) {
                Object candidateValue = it.next();
                ScalarExpression expr = m.newScalarExpression(stmt, stmt.getDefaultTableExpression());
                BooleanExpression keyExpr = expr.eq(m.newLiteral(stmt, candidateValue));
                if (elementsExpr == null) {
                    elementsExpr = keyExpr;
                    continue;
                }
                elementsExpr = elementsExpr.ior(keyExpr);
            }
            if (elementsExpr != null) {
                stmt.andCondition(elementsExpr, true);
            }
        }
        return stmt;
    }

    private void selectNewObjectExpression(QueryExpression stmt, List stmtExprIndexList, ScalarExpression expr1) {
        List argExprs = ((NewObjectExpression)expr1).getArgumentExpressions();
        for (int j = 0; j < argExprs.size(); ++j) {
            ScalarExpression argExpr = (ScalarExpression)argExprs.get(j);
            this.selectScalarExpression(stmt, stmtExprIndexList, argExpr);
        }
    }

    private void selectLiteralExpression(QueryExpression stmt, List stmtExprIndexList, ScalarExpression expr1) {
        StatementExpressionIndex stmtExprIndex = new StatementExpressionIndex();
        AbstractClassMetaData cmd = this.storeMgr.getMetaDataManager().getMetaDataForClass(this.candidateClass, stmt.getClassLoaderResolver());
        if (cmd.getIdentityType() == IdentityType.DATASTORE) {
            stmt.select(this.storeMgr.getDatastoreClass(this.candidateClass.getName(), this.clr).getDataStoreObjectIdMapping(), true);
            stmtExprIndex.setMapping(expr1.getMapping());
        } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
            int[] prefetchFieldNumbers = new int[cmd.getPKMemberPositions().length];
            for (int j = 0; j < prefetchFieldNumbers.length; ++j) {
                prefetchFieldNumbers[j] = cmd.getPKMemberPositions()[j];
                JavaTypeMapping m = this.storeMgr.getDatastoreClass(this.candidateClass.getName(), this.clr).getFieldMapping(cmd.getMetaDataForManagedMemberAtAbsolutePosition(prefetchFieldNumbers[j]));
                if (m == null || !m.includeInFetchStatement() || m instanceof AbstractContainerMapping) continue;
                stmt.select(m, true);
            }
            stmtExprIndex.setMapping(expr1.getMapping());
        }
        if (expr1.getMapping() instanceof SingleFieldMapping && expr1 instanceof Literal) {
            stmtExprIndex.setMapping(new ResultLiteralJavaTypeMapping(expr1.getMapping(), ((Literal)((Object)expr1)).getValue()));
        }
        stmtExprIndexList.add(stmtExprIndex);
    }

    private void selectScalarExpression(QueryExpression stmt, List stmtExprIndexList, ScalarExpression expr1) {
        if (expr1 instanceof Literal) {
            this.selectLiteralExpression(stmt, stmtExprIndexList, expr1);
        } else if (expr1 instanceof NewObjectExpression) {
            this.selectNewObjectExpression(stmt, stmtExprIndexList, expr1);
        } else {
            StatementExpressionIndex stmtExprIndex = new StatementExpressionIndex();
            int[] exprIndex = null;
            ScalarExpression[] expr = expr1.getExpressionList().toArray();
            if (expr.length > 0) {
                exprIndex = new int[expr.length];
                for (int j = 0; j < expr.length; ++j) {
                    exprIndex[j] = stmt.selectScalarExpression(expr[j], true);
                }
            } else {
                exprIndex = new int[]{stmt.selectScalarExpression(expr1, true)};
            }
            stmtExprIndex.setExpressionIndex(exprIndex);
            stmtExprIndex.setMapping(expr1.getMapping());
            if (expr1.getAlias() != null) {
                stmtExprIndex.setColumnName(expr1.getAlias());
            }
            stmtExprIndexList.add(stmtExprIndex);
        }
    }

    public ResultObjectFactory newResultObjectFactory(QueryExpression stmt, boolean ignoreCache, Class resultClass, boolean useFetchPlan) {
        ArrayList stmtExprIndex = new ArrayList();
        for (int i = 0; i < this.expressions.length; ++i) {
            if (!(this.expressions[i] instanceof NewObjectExpression) && this.expressions[i].getMapping() == null) {
                throw new JPOXUserException(LOCALISER.msg("QueryResultExpressions.UnsupportedExpressionInResult", this.expressions[i]));
            }
            this.selectScalarExpression(stmt, stmtExprIndex, this.expressions[i]);
        }
        if (stmt.getNumberOfScalarExpressions() < 1) {
            JavaTypeMapping mapping = this.storeMgr.getDatastoreAdapter().getMapping(class$java$math$BigInteger == null ? (class$java$math$BigInteger = ResultExpressionsQueryable.class$("java.math.BigInteger")) : class$java$math$BigInteger, this.storeMgr);
            stmt.selectScalarExpression(mapping.newLiteral(stmt, BigInteger.ONE));
        }
        StatementExpressionIndex[] statementExpressionIndex = stmtExprIndex.toArray(new StatementExpressionIndex[stmtExprIndex.size()]);
        if (resultClass != null) {
            return new ResultClassROF(resultClass, statementExpressionIndex, this.expressions);
        }
        if (this.expressions.length == 1) {
            return new ResultClassROF(class$java$lang$Object == null ? (class$java$lang$Object = ResultExpressionsQueryable.class$("java.lang.Object")) : class$java$lang$Object, statementExpressionIndex, this.expressions);
        }
        return new ResultClassROF(array$Ljava$lang$Object == null ? (array$Ljava$lang$Object = ResultExpressionsQueryable.class$("[Ljava.lang.Object;")) : array$Ljava$lang$Object, statementExpressionIndex, this.expressions);
    }

    public boolean isEmpty() {
        if (this.userCandidates != null) {
            return this.userCandidates.isEmpty();
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ResultLiteralJavaTypeMapping
    extends JavaTypeMapping {
        final JavaTypeMapping mapping;
        final Object literal;

        public ResultLiteralJavaTypeMapping(JavaTypeMapping mapping, Object literal) {
            super(null, mapping.getType(), mapping.getFieldMetaData(), null);
            this.mapping = mapping;
            this.literal = literal;
        }

        public DatastoreContainerObject getDatastoreContainer() {
            return this.mapping.getDatastoreContainer();
        }

        public Class getJavaType() {
            return this.mapping.getJavaType();
        }

        public Object getSampleValue(ClassLoaderResolver clr) {
            return this.mapping.getSampleValue(clr);
        }

        public boolean includeInFetchStatement() {
            return this.mapping.includeInFetchStatement();
        }

        public boolean includeInUpdateStatement() {
            return this.mapping.includeInUpdateStatement();
        }

        public boolean includeInInsertStatement() {
            return this.mapping.includeInInsertStatement();
        }

        public ScalarExpression newLiteral(QueryExpression qs, Object value) {
            return this.mapping.newLiteral(qs, value);
        }

        public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te) {
            return this.mapping.newScalarExpression(qs, te);
        }

        public boolean getBoolean(ObjectManager om, Object resultSet, int[] exprIndex) {
            return (Boolean)this.literal;
        }

        public byte getByte(ObjectManager om, Object resultSet, int[] exprIndex) {
            return (Byte)this.literal;
        }

        public char getChar(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Character)this.literal).charValue();
        }

        public double getDouble(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).doubleValue();
        }

        public float getFloat(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).floatValue();
        }

        public int getInt(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).intValue();
        }

        public long getLong(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).longValue();
        }

        public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex) {
            return this.literal;
        }

        public Object getObject(ObjectManager om, Object resultSet, int[] exprIndex, StateManager ownerSM, int ownerFieldNumber) {
            return this.literal;
        }

        public short getShort(ObjectManager om, Object resultSet, int[] exprIndex) {
            return ((Number)this.literal).shortValue();
        }

        public String getString(ObjectManager om, Object resultSet, int[] exprIndex) {
            return (String)this.literal;
        }
    }
}

