/*
 * Decompiled with CFR 0.152.
 */
package org.jpox.store.rdbms.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpox.ClassLoaderResolver;
import org.jpox.ManagedConnection;
import org.jpox.ObjectManager;
import org.jpox.exceptions.JPOXDataStoreException;
import org.jpox.exceptions.JPOXUserException;
import org.jpox.jdo.exceptions.ClassNotPersistenceCapableException;
import org.jpox.metadata.AbstractClassMetaData;
import org.jpox.metadata.AbstractMemberMetaData;
import org.jpox.metadata.FieldPersistenceModifier;
import org.jpox.metadata.IdentityType;
import org.jpox.metadata.QueryResultMetaData;
import org.jpox.store.DatastoreClass;
import org.jpox.store.StatementExpressionIndex;
import org.jpox.store.expression.QueryExpression;
import org.jpox.store.mapping.DatastoreMapping;
import org.jpox.store.mapping.JavaTypeMapping;
import org.jpox.store.mapping.PersistenceCapableMapping;
import org.jpox.store.query.Query;
import org.jpox.store.query.QueryResult;
import org.jpox.store.query.ResultObjectFactory;
import org.jpox.store.rdbms.RDBMSManager;
import org.jpox.store.rdbms.SQLController;
import org.jpox.store.rdbms.query.AbstractQueryResult;
import org.jpox.store.rdbms.query.BaseSQLQuery;
import org.jpox.store.rdbms.query.ForwardQueryResult;
import org.jpox.store.rdbms.query.InsensitiveQueryResult;
import org.jpox.store.rdbms.query.PersistentIDROF;
import org.jpox.store.rdbms.query.ResultMetaDataROF;
import org.jpox.store.rdbms.query.SQLEvaluator;
import org.jpox.util.StringUtils;

public final class SQLQuery
extends BaseSQLQuery {
    protected QueryResultMetaData resultMetaData = null;

    public SQLQuery(ObjectManager om, SQLQuery query) {
        super(om, query);
    }

    public SQLQuery(ObjectManager om) {
        super(om, (String)null);
    }

    public SQLQuery(ObjectManager om, String sql_text) {
        super(om, sql_text);
        String firstToken = new StringTokenizer(sql_text, " ").nextToken();
        if (firstToken.equalsIgnoreCase("INSERT") || firstToken.equalsIgnoreCase("UPDATE") || firstToken.equalsIgnoreCase("DELETE") || firstToken.equalsIgnoreCase("MERGE")) {
            this.isUpdate = true;
            this.unique = true;
        }
        if (!(om.getOMFContext().getPersistenceConfiguration().isQueryAllowAllSQLStatements() || firstToken.equals("SELECT") || firstToken.startsWith("select"))) {
            throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.StatementNotSelectError", this.sqlText));
        }
    }

    public void setResultMetaData(QueryResultMetaData qrmd) {
        this.resultMetaData = qrmd;
        super.setResultClass(null);
    }

    public void setResultClass(Class result_cls) {
        super.setResultClass(result_cls);
        this.resultMetaData = null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SQLQuery) || !super.equals(obj)) {
            return false;
        }
        return this.sqlText.equals(((SQLQuery)obj).sqlText);
    }

    public void declareParameters(String parameters) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.ParametersInapplicableError"));
    }

    public void declareImports(String imports) {
        throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.ImportInapplicableError"));
    }

    protected void generateQueryStatement() {
        this.jdbcSqlText = this.sqlText;
        if (this.candidateClass != null && !this.isUpdate) {
            ClassLoaderResolver clr = this.om.getClassLoaderResolver();
            AbstractClassMetaData cmd = this.om.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
            if (cmd == null) {
                throw new ClassNotPersistenceCapableException(this.candidateClass.getName());
            }
            if (cmd.getPersistenceCapableSuperclass() != null) {
                // empty if block
            }
            if (this.resultClass == null) {
                int i;
                String[] selectedColumns;
                String selections = this.sqlText.trim().substring(7);
                int fromStart = selections.indexOf("FROM");
                if (fromStart == -1) {
                    fromStart = selections.indexOf("from");
                }
                if ((selectedColumns = StringUtils.split(selections = selections.substring(0, fromStart).trim(), ",")) == null || selectedColumns.length == 0) {
                    throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.NoSelectionsError", this.sqlText));
                }
                if (selectedColumns.length == 1 && selectedColumns[0].trim().equals("*")) {
                    return;
                }
                DatastoreClass table = this.om.getStoreManager().getDatastoreClass(this.candidateClass.getName(), clr);
                PersistenceCapableMapping idMapping = (PersistenceCapableMapping)table.getIDMapping();
                String[] idColNames = new String[idMapping.getNumberOfDatastoreFields()];
                boolean[] idColMissing = new boolean[idMapping.getNumberOfDatastoreFields()];
                for (int i2 = 0; i2 < idMapping.getNumberOfDatastoreFields(); ++i2) {
                    DatastoreMapping m = idMapping.getDataStoreMapping(i2);
                    idColNames[i2] = ((Object)m.getDatastoreField().getIdentifier()).toString();
                    idColMissing[i2] = true;
                }
                String discriminatorColName = table.getDiscriminatorMapping() != null ? ((Object)table.getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
                String versionColName = table.getVersionMapping() != null ? ((Object)table.getVersionMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
                boolean discrimMissing = discriminatorColName != null;
                boolean versionMissing = true;
                if (versionColName == null) {
                    versionMissing = false;
                }
                AbstractClassMetaData candidateCmd = this.om.getMetaDataManager().getMetaDataForClass(this.candidateClass, clr);
                for (i = 0; i < selectedColumns.length; ++i) {
                    String colName = selectedColumns[i].trim();
                    if (colName.indexOf(" AS ") > 0) {
                        colName = colName.substring(colName.indexOf(" AS ") + 4).trim();
                    } else if (colName.indexOf(" as ") > 0) {
                        colName = colName.substring(colName.indexOf(" as ") + 4).trim();
                    }
                    if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
                        if (this.columnNamesAreTheSame(idColNames[0], colName)) {
                            idColMissing[0] = false;
                        }
                    } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
                        for (int j = 0; j < idColNames.length; ++j) {
                            if (!this.columnNamesAreTheSame(idColNames[j], colName)) continue;
                            idColMissing[j] = false;
                        }
                    }
                    if (discrimMissing && this.columnNamesAreTheSame(discriminatorColName, colName)) {
                        discrimMissing = false;
                        continue;
                    }
                    if (!versionMissing || !this.columnNamesAreTheSame(versionColName, colName)) continue;
                    versionMissing = false;
                }
                if (discrimMissing) {
                    throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.Candidate.DiscriminatorColumnNotSelected", this.sqlText, this.candidateClass.getName(), discriminatorColName));
                }
                if (versionMissing) {
                    throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.Candidate.VersionColumnNotSelected", this.sqlText, this.candidateClass.getName(), versionColName));
                }
                for (i = 0; i < idColMissing.length; ++i) {
                    if (!idColMissing[i]) continue;
                    throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.Candidate.IdColumnNotSelected", this.sqlText, this.candidateClass.getName(), idColNames[i]));
                }
            }
        }
    }

    private boolean columnNamesAreTheSame(String name1, String name2) {
        return name1.equalsIgnoreCase(name2) || name1.equalsIgnoreCase(this.dba.getIdentifierQuoteString() + name2 + this.dba.getIdentifierQuoteString());
    }

    public Object executeWithArray(Object[] parameters) {
        HashMap<Integer, Object> parameterMap = new HashMap<Integer, Object>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                parameterMap.put(new Integer(i + 1), parameters[i]);
            }
        }
        return this.executeWithMap(parameterMap);
    }

    public Object executeWithMap(Map parameterMap) {
        this.isPreCompile = false;
        this.compile();
        this.prepareDatastore();
        this.parameterNames.clear();
        ArrayList<Object> expectedParams = new ArrayList<Object>();
        boolean complete = false;
        int charPos = 0;
        char[] statement = this.jdbcSqlText.toCharArray();
        StringBuffer paramName = null;
        int paramPos = 0;
        boolean colonParam = true;
        StringBuffer runtimeJdbcText = new StringBuffer();
        while (!complete) {
            char c = statement[charPos];
            boolean endOfParam = false;
            if (c == '?') {
                colonParam = false;
                ++paramPos;
                paramName = new StringBuffer();
            } else if (c == ':') {
                if (charPos > 0) {
                    char prev = statement[charPos - 1];
                    if (!Character.isLetterOrDigit(prev)) {
                        colonParam = true;
                        ++paramPos;
                        paramName = new StringBuffer();
                    }
                } else {
                    colonParam = true;
                    ++paramPos;
                    paramName = new StringBuffer();
                }
            } else if (paramName != null) {
                if (Character.isLetterOrDigit(c)) {
                    paramName.append(c);
                } else {
                    endOfParam = true;
                }
            }
            if (paramName != null) {
                if (endOfParam) {
                    runtimeJdbcText.append('?');
                    runtimeJdbcText.append(c);
                }
            } else {
                runtimeJdbcText.append(c);
            }
            boolean bl = complete = ++charPos == this.jdbcSqlText.length();
            if (complete && paramName != null && !endOfParam) {
                runtimeJdbcText.append('?');
            }
            if (paramName == null || !complete && !endOfParam) continue;
            if (paramName.length() > 0) {
                if (colonParam) {
                    expectedParams.add(paramName.toString());
                } else {
                    try {
                        Integer num = new Integer(paramName.toString());
                        expectedParams.add(num);
                    }
                    catch (NumberFormatException nfe) {
                        throw new JPOXUserException("SQL query " + this.sqlText + " contains an invalid parameter specification " + paramName.toString());
                    }
                }
            } else if (!colonParam) {
                expectedParams.add(new Integer(paramPos));
            }
            paramName = null;
        }
        this.jdbcSqlText = runtimeJdbcText.toString();
        if (expectedParams.size() > 0 && parameterMap == null) {
            throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.ParametersRequiredButNoneSupplied", this.sqlText, "" + expectedParams.size()));
        }
        HashMap executeMap = new HashMap();
        if (parameterMap != null) {
            paramPos = 1;
            Iterator expectedParamIter = expectedParams.iterator();
            while (expectedParamIter.hasNext()) {
                Object key = expectedParamIter.next();
                if (!parameterMap.containsKey(key)) {
                    throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.ParameterWithNameNotSupplied", this.sqlText, "" + key));
                }
                executeMap.put(new Integer(paramPos), parameterMap.get(key));
                this.parameterNames.add("" + paramPos);
                ++paramPos;
            }
        }
        Object theReturn = super.executeWithMap(executeMap);
        this.isPreCompile = true;
        return theReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection performExecute(Map parameters) {
        if (parameters.size() != this.parameterNames.size()) {
            throw new JPOXUserException(LOCALISER_RDBMS.msg("SQL.IncorrectNumberOfParametersError", "" + this.parameterNames.size(), "" + parameters.size()));
        }
        if (this.isUpdate) {
            ArrayList<Long> qr = null;
            try {
                RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = sqlControl.getStatementForUpdate(conn, this.jdbcSqlText, false);
                    try {
                        if (parameters != null) {
                            for (int i = 0; i < parameters.size(); ++i) {
                                Object obj = parameters.get(new Integer(i + 1));
                                ps.setObject(i + 1, obj);
                            }
                        }
                        int[] rcs = sqlControl.executeStatementUpdate(conn, this.jdbcSqlText, ps, true);
                        qr = new ArrayList<Long>();
                        qr.add(new Long(rcs[0]));
                    }
                    finally {
                        sqlControl.closeStatement(conn, ps);
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(LOCALISER_RDBMS.msg("SQL.ExecutionError", this.jdbcSqlText), e);
            }
            return qr;
        }
        SQLQueryEvaluator eval = new SQLQueryEvaluator(this.om, this.extensions, this.toExclNo, this, parameters);
        QueryResult qr = eval.evaluate(null);
        this.queryResults.add(qr);
        return qr;
    }

    class SQLQueryEvaluator
    extends SQLEvaluator {
        Map parameters;

        public SQLQueryEvaluator(ObjectManager om, Map extensions, long toExclNo, Query query, Map parameters) {
            super(om, extensions, toExclNo, false, query, null, null);
            this.parameters = parameters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueryResult evaluate(QueryExpression queryStmt) {
            AbstractQueryResult qr = null;
            try {
                RDBMSManager storeMgr = (RDBMSManager)this.om.getStoreManager();
                ManagedConnection mconn = storeMgr.getConnection(this.om);
                Connection conn = (Connection)mconn.getConnection();
                SQLController sqlControl = storeMgr.getSQLController();
                try {
                    PreparedStatement ps = this.getStatement(conn, SQLQuery.this.jdbcSqlText);
                    try {
                        if (this.parameters != null) {
                            for (int i = 0; i < this.parameters.size(); ++i) {
                                Object obj = this.parameters.get(new Integer(i + 1));
                                ps.setObject(i + 1, obj);
                            }
                        }
                        this.prepareStatementForExecution(ps);
                        ResultSet rs = sqlControl.executeStatementQuery(conn, SQLQuery.this.jdbcSqlText, ps);
                        try {
                            this.rof = SQLQuery.this.resultMetaData != null ? new ResultMetaDataROF(SQLQuery.this.resultMetaData) : (SQLQuery.this.resultClass != null || SQLQuery.this.candidateClass == null ? this.getResultObjectFactoryForNoCandidateClass(rs, SQLQuery.this.resultClass) : this.getResultObjectFactoryForCandidateClass(rs));
                            qr = this.getResultSetType().equals("scroll-insensitive") ? new InsensitiveQueryResult(null, this.query, this.rof, rs, null) : new ForwardQueryResult(null, this.query, this.rof, rs, null);
                        }
                        finally {
                            if (qr == null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (qr == null) {
                            sqlControl.closeStatement(conn, ps);
                        }
                    }
                }
                finally {
                    mconn.release();
                }
            }
            catch (SQLException e) {
                throw new JPOXDataStoreException(BaseSQLQuery.LOCALISER_RDBMS.msg("SQL.ExecutionError", SQLQuery.this.jdbcSqlText), e);
            }
            return qr;
        }

        private ResultObjectFactory getResultObjectFactoryForCandidateClass(ResultSet rs) throws SQLException {
            int i;
            ClassLoaderResolver clr = this.om.getClassLoaderResolver();
            AbstractClassMetaData candidateCmd = this.om.getMetaDataManager().getMetaDataForClass(SQLQuery.this.candidateClass, clr);
            int fieldCount = candidateCmd.getNoOfManagedMembers() + candidateCmd.getNoOfInheritedManagedMembers();
            HashMap<String, Integer> columnFieldNumberMap = new HashMap<String, Integer>();
            SQLQuery.this.statementExpressionIndex = new StatementExpressionIndex[fieldCount];
            DatastoreClass tbl = SQLQuery.this.getStoreManager().getDatastoreClass(SQLQuery.this.candidateClass.getName(), clr);
            for (int fieldNumber = 0; fieldNumber < fieldCount; ++fieldNumber) {
                SQLQuery.this.statementExpressionIndex[fieldNumber] = new StatementExpressionIndex();
                AbstractMemberMetaData fmd = candidateCmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
                String fieldName = fmd.getName();
                Class fieldType = fmd.getType();
                if (fmd.getPersistenceModifier() == FieldPersistenceModifier.NONE) continue;
                JavaTypeMapping m = null;
                m = tbl != null ? tbl.getFieldMapping(fmd) : SQLQuery.this.dba.getMapping(fieldType, SQLQuery.this.getStoreManager(), clr);
                if (!m.includeInFetchStatement()) continue;
                SQLQuery.this.statementExpressionIndex[fieldNumber].setMapping(m);
                String columnName = null;
                if (fmd.getColumnMetaData() != null && fmd.getColumnMetaData().length > 0) {
                    for (int colNum = 0; colNum < fmd.getColumnMetaData().length; ++colNum) {
                        columnName = fmd.getColumnMetaData()[colNum].getName();
                        columnFieldNumberMap.put(columnName, new Integer(fieldNumber));
                    }
                    continue;
                }
                columnName = this.om.getStoreManager().getIdentifierFactory().newDatastoreFieldIdentifier(fieldName, this.om.getOMFContext().getTypeManager().isDefaultEmbeddedType(fieldType), 0).getIdentifier();
                columnFieldNumberMap.put(columnName, new Integer(fieldNumber));
            }
            if (columnFieldNumberMap.size() == 0) {
                throw new JPOXUserException("SQL query class has no persistent fields in the SELECT : " + SQLQuery.this.candidateClass.getName()).setFatal();
            }
            DatastoreClass table = this.om.getStoreManager().getDatastoreClass(SQLQuery.this.candidateClass.getName(), clr);
            PersistenceCapableMapping idMapping = (PersistenceCapableMapping)table.getIDMapping();
            String[] idColNames = new String[idMapping.getNumberOfDatastoreFields()];
            boolean[] idColMissing = new boolean[idMapping.getNumberOfDatastoreFields()];
            for (int i2 = 0; i2 < idMapping.getNumberOfDatastoreFields(); ++i2) {
                DatastoreMapping m = idMapping.getDataStoreMapping(i2);
                idColNames[i2] = ((Object)m.getDatastoreField().getIdentifier()).toString();
                idColMissing[i2] = true;
            }
            String discriminatorColName = table.getDiscriminatorMapping() != null ? ((Object)table.getDiscriminatorMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
            String versionColName = table.getVersionMapping() != null ? ((Object)table.getVersionMapping().getDataStoreMapping(0).getDatastoreField().getIdentifier()).toString() : null;
            boolean discrimMissing = discriminatorColName != null;
            boolean versionMissing = true;
            if (versionColName == null) {
                versionMissing = false;
            }
            ResultSetMetaData rsmd = rs.getMetaData();
            HashSet remainingColumnNames = new HashSet(columnFieldNumberMap.size());
            int colCount = rsmd.getColumnCount();
            int[] datastoreIndex = null;
            int[] versionIndex = null;
            int[] matchedFieldNumbers = new int[colCount];
            int fieldNumberPosition = 0;
            for (int colNum = 1; colNum <= colCount; ++colNum) {
                String colName = rsmd.getColumnName(colNum);
                int fieldNumber = -1;
                Integer fieldNum = (Integer)columnFieldNumberMap.get(colName);
                if (fieldNum != null) {
                    fieldNumber = fieldNum;
                }
                if (fieldNumber >= 0) {
                    int[] exprIndices = null;
                    if (SQLQuery.this.statementExpressionIndex[fieldNumber].getExpressionIndex() != null) {
                        exprIndices = new int[SQLQuery.this.statementExpressionIndex[fieldNumber].getExpressionIndex().length + 1];
                        for (int i3 = 0; i3 < SQLQuery.this.statementExpressionIndex[fieldNumber].getExpressionIndex().length; ++i3) {
                            exprIndices[i3] = SQLQuery.this.statementExpressionIndex[fieldNumber].getExpressionIndex()[i3];
                        }
                        exprIndices[exprIndices.length - 1] = colNum;
                    } else {
                        exprIndices = new int[]{colNum};
                    }
                    SQLQuery.this.statementExpressionIndex[fieldNumber].setExpressionIndex(exprIndices);
                    remainingColumnNames.remove(colName);
                    matchedFieldNumbers[fieldNumberPosition++] = fieldNumber;
                }
                if (versionColName != null && colName.equals(versionColName)) {
                    versionIndex = new int[]{colNum};
                    versionMissing = false;
                }
                if (candidateCmd.getIdentityType() == IdentityType.DATASTORE) {
                    if (SQLQuery.this.columnNamesAreTheSame(idColNames[0], colName)) {
                        datastoreIndex = new int[]{colNum};
                        idColMissing[0] = false;
                    }
                } else if (candidateCmd.getIdentityType() == IdentityType.APPLICATION) {
                    for (int j = 0; j < idColNames.length; ++j) {
                        if (!SQLQuery.this.columnNamesAreTheSame(idColNames[j], colName)) continue;
                        idColMissing[j] = false;
                    }
                }
                if (discrimMissing && SQLQuery.this.columnNamesAreTheSame(discriminatorColName, colName)) {
                    discrimMissing = false;
                    continue;
                }
                if (!versionMissing || !SQLQuery.this.columnNamesAreTheSame(versionColName, colName)) continue;
                versionMissing = false;
            }
            int[] fieldNumbers = new int[fieldNumberPosition];
            for (i = 0; i < fieldNumberPosition; ++i) {
                fieldNumbers[i] = matchedFieldNumbers[i];
            }
            if (discrimMissing) {
                throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("SQL.Candidate.DiscriminatorColumnNotSelected", SQLQuery.this.sqlText, SQLQuery.this.candidateClass.getName(), discriminatorColName));
            }
            if (versionMissing) {
                throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("SQL.Candidate.VersionColumnNotSelected", SQLQuery.this.sqlText, SQLQuery.this.candidateClass.getName(), versionColName));
            }
            for (i = 0; i < idColMissing.length; ++i) {
                if (!idColMissing[i]) continue;
                throw new JPOXUserException(BaseSQLQuery.LOCALISER_RDBMS.msg("SQL.Candidate.IdColumnNotSelected", SQLQuery.this.sqlText, SQLQuery.this.candidateClass.getName(), idColNames[i]));
            }
            return new PersistentIDROF(table, fieldNumbers, candidateCmd, SQLQuery.this.statementExpressionIndex, datastoreIndex, versionIndex, SQLQuery.this.ignoreCache, false, false, SQLQuery.this.fetchPlan, this.query.getCandidateClass());
        }
    }
}

